

-- GovWay Runtime

-- **** Repository Buste ****

CREATE TABLE REPOSITORY_BUSTE
(
	ID_MESSAGGIO VARCHAR(255) NOT NULL,
	TIPO VARCHAR(255) NOT NULL,
	MITTENTE VARCHAR(255),
	IDPORTA_MITTENTE VARCHAR(255),
	TIPO_MITTENTE VARCHAR(255),
	IND_TELEMATICO_MITT VARCHAR(255),
	DESTINATARIO VARCHAR(255),
	IDPORTA_DESTINATARIO VARCHAR(255),
	TIPO_DESTINATARIO VARCHAR(255),
	IND_TELEMATICO_DEST VARCHAR(255),
	VERSIONE_SERVIZIO VARCHAR(255),
	SERVIZIO VARCHAR(255),
	TIPO_SERVIZIO VARCHAR(255),
	AZIONE VARCHAR(255),
	PROFILO_DI_COLLABORAZIONE VARCHAR(255),
	SERVIZIO_CORRELATO VARCHAR(255),
	TIPO_SERVIZIO_CORRELATO VARCHAR(255),
	COLLABORAZIONE VARCHAR(255),
	SEQUENZA INT,
	INOLTRO_SENZA_DUPLICATI INT NOT NULL,
	CONFERMA_RICEZIONE INT NOT NULL,
	ORA_REGISTRAZIONE DATETIME2,
	TIPO_ORA_REGISTRAZIONE VARCHAR(255),
	RIFERIMENTO_MESSAGGIO VARCHAR(255),
	SCADENZA_BUSTA DATETIME2 NOT NULL,
	DUPLICATI INT NOT NULL,
	-- Dati di integrazione
	LOCATION_PD VARCHAR(255),
	SERVIZIO_APPLICATIVO VARCHAR(255),
	MODULO_IN_ATTESA VARCHAR(255),
	SCENARIO VARCHAR(255),
	PROTOCOLLO VARCHAR(255) NOT NULL,
	-- Booleani che indicano l'attuali modalita' di utilizzo del repository:
	--  HISTORY: Busta usata per funzionalita di confermaRicezione(OUTBOX)/FiltroDuplicati(INBOX)
	--  PROFILI: Busta usata per funzionalita di profili di collaborazione
	--  PDD:     Busta usata eventualmente da un PdD
	--  
	--  DEFAULT CONTROLLER: 3 interi con semantica booleana (1->true, 0->false)
	HISTORY INT NOT NULL DEFAULT 0,
	PROFILO INT NOT NULL DEFAULT 0,
	PDD INT NOT NULL DEFAULT 0,
	REPOSITORY_ACCESS INT NOT NULL DEFAULT 0,
	DATA_REGISTRAZIONE DATETIME2 NOT NULL,
	-- fk/pk columns
	-- check constraints
	CONSTRAINT chk_REPOSITORY_BUSTE_1 CHECK (TIPO IN ('INBOX','OUTBOX')),
	-- fk/pk keys constraints
	CONSTRAINT pk_REPOSITORY_BUSTE PRIMARY KEY (ID_MESSAGGIO,TIPO)
);

-- index
CREATE INDEX REP_BUSTE_SEARCH ON REPOSITORY_BUSTE (SCADENZA_BUSTA,TIPO,HISTORY,PROFILO,PDD);
CREATE INDEX REP_BUSTE_SEARCH_RA ON REPOSITORY_BUSTE (SCADENZA_BUSTA,TIPO,REPOSITORY_ACCESS);
CREATE INDEX REP_BUSTE_SEARCH_TIPO ON REPOSITORY_BUSTE (TIPO,HISTORY,PROFILO,PDD);
CREATE INDEX REP_BUSTE_SEARCH_TIPO_RA ON REPOSITORY_BUSTE (TIPO,REPOSITORY_ACCESS);
CREATE INDEX REP_BUSTE_DATAREG ON REPOSITORY_BUSTE (DATA_REGISTRAZIONE,TIPO,HISTORY,PROFILO,PDD);
CREATE INDEX REP_BUSTE_DATAREG_RA ON REPOSITORY_BUSTE (DATA_REGISTRAZIONE,TIPO,REPOSITORY_ACCESS);

CREATE TABLE LISTA_RISCONTRI
(
	ID_MESSAGGIO VARCHAR(255) NOT NULL,
	TIPO VARCHAR(255) NOT NULL,
	ID_RISCONTRO VARCHAR(255),
	RICEVUTA VARCHAR(max),
	ORA_REGISTRAZIONE DATETIME2,
	TIPO_ORA_REGISTRAZIONE VARCHAR(255),
	DATA_REGISTRAZIONE DATETIME2 NOT NULL,
	-- fk/pk columns
	id BIGINT IDENTITY,
	-- check constraints
	CONSTRAINT chk_LISTA_RISCONTRI_1 CHECK (TIPO IN ('INBOX','OUTBOX')),
	-- fk/pk keys constraints
	CONSTRAINT fk_LISTA_RISCONTRI_1 FOREIGN KEY (ID_MESSAGGIO,TIPO) REFERENCES REPOSITORY_BUSTE(ID_MESSAGGIO,TIPO) ON DELETE CASCADE,
	CONSTRAINT pk_LISTA_RISCONTRI PRIMARY KEY (id)
);

-- index
CREATE INDEX LISTA_RISC_ID ON LISTA_RISCONTRI (ID_MESSAGGIO,TIPO);



CREATE TABLE LISTA_TRASMISSIONI
(
	ID_MESSAGGIO VARCHAR(255) NOT NULL,
	TIPO VARCHAR(255) NOT NULL,
	ORIGINE VARCHAR(255),
	TIPO_ORIGINE VARCHAR(255),
	DESTINAZIONE VARCHAR(255),
	TIPO_DESTINAZIONE VARCHAR(255),
	ORA_REGISTRAZIONE DATETIME2,
	TIPO_ORA_REGISTRAZIONE VARCHAR(255),
	DATA_REGISTRAZIONE DATETIME2 NOT NULL,
	-- fk/pk columns
	id BIGINT IDENTITY,
	-- check constraints
	CONSTRAINT chk_LISTA_TRASMISSIONI_1 CHECK (TIPO IN ('INBOX','OUTBOX')),
	-- fk/pk keys constraints
	CONSTRAINT fk_LISTA_TRASMISSIONI_1 FOREIGN KEY (ID_MESSAGGIO,TIPO) REFERENCES REPOSITORY_BUSTE(ID_MESSAGGIO,TIPO) ON DELETE CASCADE,
	CONSTRAINT pk_LISTA_TRASMISSIONI PRIMARY KEY (id)
);

-- index
CREATE INDEX LISTA_TRASM_ID ON LISTA_TRASMISSIONI (ID_MESSAGGIO,TIPO);



CREATE TABLE LISTA_ECCEZIONI
(
	ID_MESSAGGIO VARCHAR(255) NOT NULL,
	TIPO VARCHAR(255) NOT NULL,
	VALIDAZIONE INT,
	CONTESTO VARCHAR(255),
	CODICE VARCHAR(255),
	RILEVANZA VARCHAR(255),
	POSIZIONE VARCHAR(max),
	DATA_REGISTRAZIONE DATETIME2 NOT NULL,
	-- fk/pk columns
	id BIGINT IDENTITY,
	-- check constraints
	CONSTRAINT chk_LISTA_ECCEZIONI_1 CHECK (TIPO IN ('INBOX','OUTBOX')),
	-- fk/pk keys constraints
	CONSTRAINT fk_LISTA_ECCEZIONI_1 FOREIGN KEY (ID_MESSAGGIO,TIPO) REFERENCES REPOSITORY_BUSTE(ID_MESSAGGIO,TIPO) ON DELETE CASCADE,
	CONSTRAINT pk_LISTA_ECCEZIONI PRIMARY KEY (id)
);

-- index
CREATE INDEX LISTA_ECC_ID ON LISTA_ECCEZIONI (ID_MESSAGGIO,TIPO);
CREATE INDEX LISTA_ECC_VALIDAZIONE ON LISTA_ECCEZIONI (ID_MESSAGGIO,TIPO,VALIDAZIONE);



CREATE TABLE LISTA_EXT_PROTOCOL_INFO
(
	ID_MESSAGGIO VARCHAR(255) NOT NULL,
	TIPO VARCHAR(255) NOT NULL,
	NOME VARCHAR(255) NOT NULL,
	VALORE VARCHAR(max) NOT NULL,
	DATA_REGISTRAZIONE DATETIME2 NOT NULL,
	-- fk/pk columns
	id BIGINT IDENTITY,
	-- check constraints
	CONSTRAINT chk_LISTA_EXT_PROTOCOL_INFO_1 CHECK (TIPO IN ('INBOX','OUTBOX')),
	-- fk/pk keys constraints
	CONSTRAINT fk_LISTA_EXT_PROTOCOL_INFO_1 FOREIGN KEY (ID_MESSAGGIO,TIPO) REFERENCES REPOSITORY_BUSTE(ID_MESSAGGIO,TIPO) ON DELETE CASCADE,
	CONSTRAINT pk_LISTA_EXT_PROTOCOL_INFO PRIMARY KEY (id)
);

-- index
CREATE INDEX LISTA_EXT_ID ON LISTA_EXT_PROTOCOL_INFO (ID_MESSAGGIO,TIPO);



-- **** Riscontri ****

CREATE TABLE RISCONTRI_DA_RICEVERE
(
	ID_MESSAGGIO VARCHAR(255) NOT NULL,
	DATA_INVIO DATETIME2 NOT NULL,
	-- fk/pk columns
	-- fk/pk keys constraints
	CONSTRAINT pk_RISCONTRI_DA_RICEVERE PRIMARY KEY (ID_MESSAGGIO)
);

-- index
CREATE INDEX RISCONTRI_NON_RICEVUTI ON RISCONTRI_DA_RICEVERE (DATA_INVIO);

-- **** Sequenze ****

CREATE TABLE SEQUENZA_DA_INVIARE
(
	MITTENTE VARCHAR(255) NOT NULL,
	TIPO_MITTENTE VARCHAR(255) NOT NULL,
	DESTINATARIO VARCHAR(255) NOT NULL,
	TIPO_DESTINATARIO VARCHAR(255) NOT NULL,
	SERVIZIO VARCHAR(255) NOT NULL,
	TIPO_SERVIZIO VARCHAR(255) NOT NULL,
	AZIONE VARCHAR(255) NOT NULL DEFAULT '',
	PROSSIMA_SEQUENZA INT NOT NULL,
	ID_COLLABORAZIONE VARCHAR(255) NOT NULL,
	DATA_REGISTRAZIONE DATETIME2 NOT NULL,
	-- fk/pk columns
	-- fk/pk keys constraints
	CONSTRAINT pk_SEQUENZA_DA_INVIARE PRIMARY KEY (MITTENTE,TIPO_MITTENTE,DESTINATARIO,TIPO_DESTINATARIO,SERVIZIO,TIPO_SERVIZIO,AZIONE)
);


CREATE TABLE SEQUENZA_DA_RICEVERE
(
	ID_COLLABORAZIONE VARCHAR(255) NOT NULL,
	SEQUENZA_ATTESA INT NOT NULL,
	-- le informazioni su mitt/dest/servizio/azione servono per un controllo di validazione sulla collaborazione
	MITTENTE VARCHAR(255) NOT NULL,
	TIPO_MITTENTE VARCHAR(255) NOT NULL,
	DESTINATARIO VARCHAR(255) NOT NULL,
	TIPO_DESTINATARIO VARCHAR(255) NOT NULL,
	SERVIZIO VARCHAR(255) NOT NULL,
	TIPO_SERVIZIO VARCHAR(255) NOT NULL,
	AZIONE VARCHAR(255),
	DATA_REGISTRAZIONE DATETIME2 NOT NULL,
	-- fk/pk columns
	-- fk/pk keys constraints
	CONSTRAINT pk_SEQUENZA_DA_RICEVERE PRIMARY KEY (ID_COLLABORAZIONE)
);


-- **** Asincroni ****

CREATE TABLE ASINCRONO
(
	ID_MESSAGGIO VARCHAR(255) NOT NULL,
	TIPO VARCHAR(255) NOT NULL,
	ORA_REGISTRAZIONE DATETIME2 NOT NULL,
	RICEVUTA_ASINCRONA INT NOT NULL,
	TIPO_SERVIZIO_CORRELATO VARCHAR(255),
	SERVIZIO_CORRELATO VARCHAR(255),
	VERSIONE_SERVIZIO_CORRELATO INT,
	-- per diversificare il flusso di richiesta/ricevuta da risposta(richiestaStato)/ricevuta(Risposta)
	IS_RICHIESTA INT NOT NULL,
	ID_ASINCRONO VARCHAR(255) NOT NULL,
	ID_COLLABORAZIONE VARCHAR(255),
	-- 1 se la ricevuta applicativa e' abilitata, 0 se non lo e'
	RICEVUTA_APPLICATIVA INT NOT NULL,
	-- serve per la re-spedizione di una risposta asincrona
	BACKUP_ID_RICHIESTA VARCHAR(255),
	-- fk/pk columns
	-- check constraints
	CONSTRAINT chk_ASINCRONO_1 CHECK (TIPO IN ('INBOX','OUTBOX')),
	-- fk/pk keys constraints
	CONSTRAINT pk_ASINCRONO PRIMARY KEY (ID_MESSAGGIO,TIPO)
);

-- index
CREATE INDEX ASINCRONO_BACKUP_ID ON ASINCRONO (BACKUP_ID_RICHIESTA);
CREATE INDEX ASINCRONO_IS_RICEVUTA ON ASINCRONO (ID_MESSAGGIO,TIPO,RICEVUTA_ASINCRONA);
CREATE INDEX ASINCRONO_NON_RICEVUTE ON ASINCRONO (ORA_REGISTRAZIONE,TIPO,RICEVUTA_ASINCRONA,RICEVUTA_APPLICATIVA);


-- govway
		  		
-- **** Serial for ID ****

CREATE TABLE ID_MESSAGGIO
(
	COUNTER BIGINT NOT NULL,
	PROTOCOLLO VARCHAR(255) NOT NULL,
	ora_registrazione DATETIME2 DEFAULT CURRENT_TIMESTAMP,
	-- fk/pk columns
	-- fk/pk keys constraints
	CONSTRAINT pk_ID_MESSAGGIO PRIMARY KEY (PROTOCOLLO)
);


CREATE TABLE ID_MESSAGGIO_RELATIVO
(
	COUNTER BIGINT NOT NULL,
	PROTOCOLLO VARCHAR(255) NOT NULL,
	INFO_ASSOCIATA VARCHAR(255) NOT NULL,
	ora_registrazione DATETIME2 DEFAULT CURRENT_TIMESTAMP,
	-- fk/pk columns
	-- fk/pk keys constraints
	CONSTRAINT pk_ID_MESSAGGIO_RELATIVO PRIMARY KEY (PROTOCOLLO,INFO_ASSOCIATA)
);


CREATE TABLE ID_MESSAGGIO_PRG
(
	PROGRESSIVO VARCHAR(255) NOT NULL,
	PROTOCOLLO VARCHAR(255) NOT NULL,
	ora_registrazione DATETIME2 DEFAULT CURRENT_TIMESTAMP,
	-- fk/pk columns
	-- fk/pk keys constraints
	CONSTRAINT pk_ID_MESSAGGIO_PRG PRIMARY KEY (PROTOCOLLO)
);


CREATE TABLE ID_MESSAGGIO_RELATIVO_PRG
(
	PROGRESSIVO VARCHAR(255) NOT NULL,
	PROTOCOLLO VARCHAR(255) NOT NULL,
	INFO_ASSOCIATA VARCHAR(255) NOT NULL,
	ora_registrazione DATETIME2 DEFAULT CURRENT_TIMESTAMP,
	-- fk/pk columns
	-- fk/pk keys constraints
	CONSTRAINT pk_ID_MESSAGGIO_RELATIVO_PRG PRIMARY KEY (PROTOCOLLO,INFO_ASSOCIATA)
);



-- govway
		  		
-- **** Messaggi ****

CREATE TABLE MESSAGGI
(
	ID_MESSAGGIO VARCHAR(255) NOT NULL,
	TIPO VARCHAR(255) NOT NULL,
	RIFERIMENTO_MSG VARCHAR(255),
	ERRORE_PROCESSAMENTO VARCHAR(max),
	-- data dalla quale il msg puo' essere rispedito in caso di errori
	RISPEDIZIONE DATETIME2 NOT NULL,
	ORA_REGISTRAZIONE DATETIME2 NOT NULL,
	PROPRIETARIO VARCHAR(255),
	-- le colonne seguenti servono per il servizio di TransactionManager
	MOD_RICEZ_CONT_APPLICATIVI VARCHAR(255),
	MOD_RICEZ_BUSTE VARCHAR(255),
	MOD_INOLTRO_BUSTE VARCHAR(255),
	MOD_INOLTRO_RISPOSTE VARCHAR(255),
	MOD_IMBUSTAMENTO VARCHAR(255),
	MOD_IMBUSTAMENTO_RISPOSTE VARCHAR(255),
	MOD_SBUSTAMENTO VARCHAR(255),
	MOD_SBUSTAMENTO_RISPOSTE VARCHAR(255),
	-- Thread Pool:impedisce la gestione di messaggi gia schedulati
	SCHEDULING INT DEFAULT 0,
	-- permette la riconsegna del messaggio dopo tot tempo
	REDELIVERY_DELAY DATETIME2 NOT NULL,
	-- numero di riconsegne effettuate
	REDELIVERY_COUNT INT DEFAULT 0,
	-- id del nodo del cluster che deve gestire questo messaggio.
	CLUSTER_ID VARCHAR(255),
	-- memorizza l'ora in cui il messaggio e stato schedulato la prima volta
	SCHEDULING_TIME DATETIME2,
	-- contiene un messaggio serializzato
	MSG_BYTES VARBINARY(MAX),
	CORRELAZIONE_APPLICATIVA VARCHAR(255),
	CORRELAZIONE_RISPOSTA VARCHAR(255),
	PROTOCOLLO VARCHAR(255) NOT NULL,
	id_transazione VARCHAR(255) NOT NULL,
	-- fk/pk columns
	-- check constraints
	CONSTRAINT chk_MESSAGGI_1 CHECK (TIPO IN ('INBOX','OUTBOX')),
	-- fk/pk keys constraints
	CONSTRAINT pk_MESSAGGI PRIMARY KEY (ID_MESSAGGIO,TIPO)
);

-- index
CREATE INDEX MESSAGGI_TRANS ON MESSAGGI (id_transazione,TIPO);
CREATE INDEX MESSAGGI_SEARCH ON MESSAGGI (ORA_REGISTRAZIONE,RIFERIMENTO_MSG,TIPO,PROPRIETARIO);
CREATE INDEX MESSAGGI_ACQUIRE_SEND ON MESSAGGI (ORA_REGISTRAZIONE,PROPRIETARIO,TIPO,ID_MESSAGGIO);
CREATE INDEX MESSAGGI_RIFMSG ON MESSAGGI (RIFERIMENTO_MSG);
CREATE INDEX MESSAGGI_TESTSUITE ON MESSAGGI (PROPRIETARIO,ID_MESSAGGIO,RIFERIMENTO_MSG);

CREATE TABLE MSG_SERVIZI_APPLICATIVI
(
	ID_MESSAGGIO VARCHAR(255) NOT NULL,
	TIPO VARCHAR(255) NOT NULL DEFAULT 'INBOX',
	SERVIZIO_APPLICATIVO VARCHAR(2000) NOT NULL,
	SBUSTAMENTO_SOAP INT NOT NULL,
	SBUSTAMENTO_INFO_PROTOCOL INT NOT NULL,
	INTEGRATION_MANAGER INT NOT NULL,
	MOD_CONSEGNA_CONT_APPLICATIVI VARCHAR(255),
	-- Assume il valore 'Connettore' se la consegna avviente tramite un connettore,
	-- 'ConnectionReply' se viene ritornato tramite connectionReply,
	-- 'IntegrationManager' se e' solo ottenibile tramite IntegrationManager
	TIPO_CONSEGNA VARCHAR(40) NOT NULL,
	ERRORE_PROCESSAMENTO_COMPACT VARCHAR(255),
	ERRORE_PROCESSAMENTO VARCHAR(max),
	-- data dalla quale il msg puo' essere rispedito in caso di errori
	RISPEDIZIONE DATETIME2 NOT NULL,
	-- Informazioni relative alla consegna con threads
	NOME_PORTA VARCHAR(255),
	LOCK_CONSEGNA DATETIME2,
	CLUSTER_ID VARCHAR(255),
	ATTESA_ESITO INT NOT NULL DEFAULT 0,
	ORA_REGISTRAZIONE DATETIME2 NOT NULL,
	CODA VARCHAR(10) DEFAULT 'UNSET',
	PRIORITA VARCHAR(10) DEFAULT 'UNSET',
	-- fk/pk columns
	-- check constraints
	CONSTRAINT chk_MSG_SERVIZI_APPLICATIVI_1 CHECK (TIPO IN ('INBOX','OUTBOX')),
	CONSTRAINT chk_MSG_SERVIZI_APPLICATIVI_2 CHECK (TIPO_CONSEGNA IN ('Connettore','ConnectionReply','IntegrationManager')),
	-- fk/pk keys constraints
	CONSTRAINT fk_MSG_SERVIZI_APPLICATIVI_1 FOREIGN KEY (ID_MESSAGGIO,TIPO) REFERENCES MESSAGGI(ID_MESSAGGIO,TIPO) ON DELETE CASCADE,
	CONSTRAINT pk_MSG_SERVIZI_APPLICATIVI PRIMARY KEY (ID_MESSAGGIO,SERVIZIO_APPLICATIVO)
);

-- index
CREATE INDEX MSG_SERV_APPL_LIST ON MSG_SERVIZI_APPLICATIVI (SERVIZIO_APPLICATIVO,INTEGRATION_MANAGER);
CREATE INDEX MSG_SERV_APPL_GET_IM_MSG_ID ON MSG_SERVIZI_APPLICATIVI (ID_MESSAGGIO,SERVIZIO_APPLICATIVO,INTEGRATION_MANAGER);
CREATE INDEX MSG_SERV_APPL_TIMEOUT ON MSG_SERVIZI_APPLICATIVI (ID_MESSAGGIO,TIPO_CONSEGNA,INTEGRATION_MANAGER);
CREATE INDEX MSG_SERV_APPL_ACQUIRE_SEND ON MSG_SERVIZI_APPLICATIVI (ID_MESSAGGIO,TIPO_CONSEGNA,ATTESA_ESITO,CODA,PRIORITA,SERVIZIO_APPLICATIVO,ERRORE_PROCESSAMENTO_COMPACT,RISPEDIZIONE,LOCK_CONSEGNA);
CREATE INDEX MSG_SERV_APPL_RELEASE_SEND ON MSG_SERVIZI_APPLICATIVI (CLUSTER_ID,CODA,LOCK_CONSEGNA);

CREATE TABLE DEFINIZIONE_MESSAGGI
(
	ID_MESSAGGIO VARCHAR(255) NOT NULL,
	TIPO VARCHAR(255) NOT NULL,
	CONTENT_TYPE VARCHAR(255) NOT NULL,
	MSG_BYTES VARBINARY(MAX),
	MSG_CONTEXT VARBINARY(MAX),
	RESPONSE_CONTENT_TYPE VARCHAR(255),
	RESPONSE_MSG_BYTES VARBINARY(MAX),
	RESPONSE_MSG_CONTEXT VARBINARY(MAX),
	TRANSACTION_CONTEXT VARBINARY(MAX),
	ORA_REGISTRAZIONE DATETIME2 NOT NULL,
	-- fk/pk columns
	-- check constraints
	CONSTRAINT chk_DEFINIZIONE_MESSAGGI_1 CHECK (TIPO IN ('INBOX','OUTBOX')),
	-- fk/pk keys constraints
	CONSTRAINT fk_DEFINIZIONE_MESSAGGI_1 FOREIGN KEY (ID_MESSAGGIO,TIPO) REFERENCES MESSAGGI(ID_MESSAGGIO,TIPO) ON DELETE CASCADE,
	CONSTRAINT pk_DEFINIZIONE_MESSAGGI PRIMARY KEY (ID_MESSAGGIO,TIPO)
);


-- **** Correlazione Applicativa ****

CREATE TABLE CORRELAZIONE_APPLICATIVA
(
	ID_MESSAGGIO VARCHAR(255) NOT NULL,
	ID_APPLICATIVO VARCHAR(255) NOT NULL,
	SERVIZIO_APPLICATIVO VARCHAR(255) NOT NULL,
	TIPO_MITTENTE VARCHAR(255) NOT NULL,
	MITTENTE VARCHAR(255) NOT NULL,
	TIPO_DESTINATARIO VARCHAR(255) NOT NULL,
	DESTINATARIO VARCHAR(255) NOT NULL,
	TIPO_SERVIZIO VARCHAR(255),
	SERVIZIO VARCHAR(255),
	VERSIONE_SERVIZIO INT NOT NULL,
	AZIONE VARCHAR(255),
	SCADENZA DATETIME2,
	ORA_REGISTRAZIONE DATETIME2 NOT NULL DEFAULT CURRENT_TIMESTAMP,
	-- fk/pk columns
	id BIGINT IDENTITY,
	-- fk/pk keys constraints
	CONSTRAINT pk_CORRELAZIONE_APPLICATIVA PRIMARY KEY (id)
);

-- index
CREATE INDEX CORR_APPL_SCADUTE ON CORRELAZIONE_APPLICATIVA (SCADENZA);
CREATE INDEX CORR_APPL_OLD ON CORRELAZIONE_APPLICATIVA (ORA_REGISTRAZIONE);



-- **** Controllo Traffico ****

CREATE TABLE ct_map
(
	map_key VARCHAR(300) NOT NULL,
	map_update_time DATETIME2 NOT NULL,
	map_value VARBINARY(MAX) NOT NULL,
	-- fk/pk columns
	id BIGINT IDENTITY,
	-- unique constraints
	CONSTRAINT unique_ct_map_1 UNIQUE (map_key),
	-- fk/pk keys constraints
	CONSTRAINT pk_ct_map PRIMARY KEY (id)
);

-- index
CREATE UNIQUE INDEX index_ct_map_1 ON ct_map (map_key);




-- govway
		  		
-- **** Semaphore ****

CREATE TABLE OP2_SEMAPHORE
(
	node_id VARCHAR(255),
	creation_time DATETIME2,
	update_time DATETIME2,
	details VARCHAR(max),
	applicative_id VARCHAR(255) NOT NULL,
	-- fk/pk columns
	id BIGINT IDENTITY,
	-- unique constraints
	CONSTRAINT uniq_semaphore_1 UNIQUE (applicative_id),
	-- fk/pk keys constraints
	CONSTRAINT pk_OP2_SEMAPHORE PRIMARY KEY (id)
);

-- index
CREATE UNIQUE INDEX idx_semaphore_1 ON OP2_SEMAPHORE (applicative_id);




-- govway
		  		
CREATE TABLE db_info
(
	major_version INT NOT NULL,
	minor_version INT NOT NULL,
	notes VARCHAR(255) NOT NULL,
	-- fk/pk columns
	id BIGINT IDENTITY,
	-- fk/pk keys constraints
	CONSTRAINT pk_db_info PRIMARY KEY (id)
);





-- govway
		  		
INSERT INTO OP2_SEMAPHORE (applicative_id) VALUES ('RepositoryMessaggi');
INSERT INTO OP2_SEMAPHORE (applicative_id) VALUES ('PuliziaRepositoryMessaggi');
INSERT INTO OP2_SEMAPHORE (applicative_id) VALUES ('PuliziaRepositoryBuste');
INSERT INTO OP2_SEMAPHORE (applicative_id) VALUES ('CorrelazioneApplicativa');
INSERT INTO OP2_SEMAPHORE (applicative_id) VALUES ('BusteNonRiscontrate');
INSERT INTO OP2_SEMAPHORE (applicative_id) VALUES ('PuliziaMessaggiAnomali');
INSERT INTO OP2_SEMAPHORE (applicative_id) VALUES ('StartupGateway');


-- govway
			  		


INSERT INTO db_info (major_version,minor_version,notes) VALUES (3,4,'[3.4.1] Database di GovWay');

