-- DROP INDEX index_config_protocolli_1;
-- DROP TABLE config_protocolli_init_seq;
-- DROP TABLE config_protocolli;
-- DROP SEQUENCE seq_config_protocolli;


CREATE SEQUENCE seq_config_url_invocazione AS BIGINT START WITH 1 INCREMENT BY 1 ; -- (Scommentare in hsql 2.x) NO CYCLE;

CREATE TABLE config_url_invocazione
(
	base_url VARCHAR(255) NOT NULL,
	base_url_fruizione VARCHAR(255),
	-- fk/pk columns
	id BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 1),
	-- fk/pk keys constraints
	CONSTRAINT pk_config_url_invocazione PRIMARY KEY (id)
);

CREATE TABLE config_url_invocazione_init_seq (id BIGINT);
INSERT INTO config_url_invocazione_init_seq VALUES (NEXT VALUE FOR seq_config_url_invocazione);



CREATE SEQUENCE seq_config_url_regole AS BIGINT START WITH 1 INCREMENT BY 1 ; -- (Scommentare in hsql 2.x) NO CYCLE;

CREATE TABLE config_url_regole
(
	nome VARCHAR(255) NOT NULL,
	posizione INT NOT NULL,
	stato VARCHAR(255),
	descrizione VARCHAR(65535),
	regexpr INT NOT NULL,
	regola VARCHAR(255) NOT NULL,
	contesto_esterno VARCHAR(255) NOT NULL,
	base_url VARCHAR(255),
	protocollo VARCHAR(255),
	ruolo VARCHAR(255),
	service_binding VARCHAR(255),
	tipo_soggetto VARCHAR(255),
	nome_soggetto VARCHAR(255),
	-- fk/pk columns
	id BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 1),
	-- unique constraints
	CONSTRAINT unique_config_url_regole_1 UNIQUE (nome),
	-- fk/pk keys constraints
	CONSTRAINT pk_config_url_regole PRIMARY KEY (id)
);

-- index
CREATE UNIQUE INDEX index_config_url_regole_1 ON config_url_regole (nome);
CREATE TABLE config_url_regole_init_seq (id BIGINT);
INSERT INTO config_url_regole_init_seq VALUES (NEXT VALUE FOR seq_config_url_regole);


-- Init Configurazione URL Invocazione
INSERT INTO config_url_invocazione (base_url) VALUES ('http://localhost:8080/govway/');

-- Regola per eDelivery
-- INSERT INTO config_url_regole (nome, posizione, stato, descrizione, regexpr, regola, contesto_esterno, base_url, protocollo, ruolo) VALUES ('Domibus',1,'abilitato','Servizio di ricezione dei messaggi AS4 dell''Access Point Domibus', 1, '^(.+)$', 'domibus-wildfly/services/msh', 'http://localhost:8080/','as4','portaApplicativa');




