/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.schema;

import javax.naming.NamingException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.springframework.ldap.core.LdapAttributes;
import org.springframework.ldap.schema.Specification;
import org.springframework.ldap.support.LdapEncoder;

public class BasicSchemaSpecification
implements Specification<LdapAttributes> {
    @Override
    public boolean isSatisfiedBy(LdapAttributes record) throws NamingException {
        if (record == null) {
            return false;
        }
        LdapName dn = record.getName();
        if (dn == null) {
            return false;
        }
        if (record.get("objectClass") == null) {
            return false;
        }
        Rdn rdn = dn.getRdn(dn.size() - 1);
        if (record.get(rdn.getType()) == null) {
            return false;
        }
        Object object = record.get(rdn.getType()).get();
        if (object instanceof String) {
            String value = (String)object;
            return ((String)rdn.getValue()).equalsIgnoreCase(value);
        }
        if (object instanceof byte[]) {
            String rdnValue = LdapEncoder.printBase64Binary((byte[])((String)rdn.getValue()).getBytes());
            String attributeValue = LdapEncoder.printBase64Binary((byte[])((byte[])object));
            return rdnValue.equals(attributeValue);
        }
        return false;
    }
}

