/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.status;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.utils.resources.MapReader;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.status.ISondaPdd;
import org.slf4j.Logger;

public class SondaPddManager {
    public static final int STATO_OK = 0;
    public static final int STATO_WARN = 1;
    public static final int STATO_ERR = 2;
    private static SondaPddManager instance = null;
    private Logger log = null;
    private List<String> listaSonde;
    private MapReader<String, ISondaPdd> sondePdd = null;
    private boolean enable;

    private void logDebug(String msg) {
        if (this.log != null) {
            this.log.debug(msg);
        }
    }

    private void logError(String msg, Exception e) {
        if (this.log != null) {
            this.log.error(msg, (Throwable)e);
        }
    }

    private static synchronized void init(Logger log) throws Exception {
        if (instance == null) {
            instance = new SondaPddManager(log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SondaPddManager getInstance(Logger log) throws Exception {
        if (instance != null) return instance;
        Class<SondaPddManager> clazz = SondaPddManager.class;
        synchronized (SondaPddManager.class) {
            SondaPddManager.init(log);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private SondaPddManager(Logger log) throws Exception {
        this.log = log;
        HashMap<String, ISondaPdd> tmpModules = new HashMap<String, ISondaPdd>();
        try {
            this.logDebug("Inizializzazione Sonda Pdd Manager in corso...");
            this.listaSonde = new ArrayList<String>();
            this.enable = PddMonitorProperties.getInstance(log).isStatusPdDEnabled();
            this.logDebug("Stato Monitoraggio: [" + (this.enable ? "attivo" : "non attivo") + "]");
            if (this.enable) {
                this.listaSonde = PddMonitorProperties.getInstance(log).getListaSondePdd();
                for (String nomeSondaPdd : this.listaSonde) {
                    this.logDebug("Caricamento sonda [" + nomeSondaPdd + "] in corso...");
                    Properties propSonda = PddMonitorProperties.getInstance(this.log).getPropertiesSonda(nomeSondaPdd);
                    String classeSonda = propSonda.getProperty("class");
                    ISondaPdd moduleChecker = this.loadSondaPdd(nomeSondaPdd, classeSonda, propSonda);
                    this.logDebug("Caricamento sonda [" + nomeSondaPdd + "] completato.");
                    tmpModules.put(nomeSondaPdd, moduleChecker);
                }
                if (tmpModules.size() <= 0) {
                    this.logDebug("Non sono stati trovati moduli da controllare.");
                }
                this.sondePdd = new MapReader(tmpModules, true);
            }
            this.logDebug("Inizializzazione Sonda Pdd Manager completata.");
        }
        catch (Exception e) {
            this.sondePdd = new MapReader(tmpModules, true);
            this.logError("Si e' verificato un errore durante l'inizializzazione Status Checker Manager:" + e.getMessage(), e);
            throw e;
        }
    }

    public List<ISondaPdd> getSondePdd() throws CoreException {
        ArrayList<ISondaPdd> lista = new ArrayList<ISondaPdd>();
        if (this.listaSonde != null && !this.listaSonde.isEmpty()) {
            for (String sonda : this.listaSonde) {
                lista.add(this.getSondaByName(sonda));
            }
        }
        return lista;
    }

    public ISondaPdd loadSondaPdd(String nomeSonda, String sondaClass, Properties propSonda) throws CoreException {
        try {
            Class<?> c = Class.forName(sondaClass);
            Constructor<?> constructor = c.getConstructor(String.class, Logger.class, Properties.class);
            return (ISondaPdd)constructor.newInstance(nomeSonda, this.log, propSonda);
        }
        catch (Exception e) {
            throw new CoreException("Impossibile caricare la sonda indicata [" + sondaClass + "] " + String.valueOf(e), (Throwable)e);
        }
    }

    public ISondaPdd getSondaByName(String sondaPddName) throws CoreException {
        if (this.sondePdd.containsKey((Object)sondaPddName)) {
            return (ISondaPdd)this.sondePdd.get((Object)sondaPddName);
        }
        throw new CoreException("Check with name [" + sondaPddName + "] not found");
    }
}

