/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.status;

import java.util.List;
import java.util.Properties;
import org.openspcoop2.monitor.engine.constants.SondaStatus;
import org.openspcoop2.monitor.engine.status.IStatus;
import org.openspcoop2.web.monitor.core.status.ISondaPdd;
import org.slf4j.Logger;

public abstract class BaseSondaPdd
implements ISondaPdd {
    private static final long serialVersionUID = 1L;
    protected transient Logger log = null;
    protected String name = null;
    protected String identificativo = null;
    protected Properties propertiesSonda = null;
    protected List<IStatus> listaStatus = null;

    protected void logError(String msg, Exception e) {
        if (this.log != null) {
            this.log.error(msg, (Throwable)e);
        }
    }

    protected abstract void init() throws Exception;

    protected BaseSondaPdd(String identificativo, Logger log, Properties prop) throws Exception {
        try {
            this.log = log;
            this.propertiesSonda = prop;
            this.name = this.identificativo = identificativo;
            String nameTmp = this.propertiesSonda.getProperty("name");
            if (nameTmp != null) {
                this.name = nameTmp;
            }
            this.init();
        }
        catch (Exception e) {
            this.logError("Si e' verificato un errore durante l'Init Sonda " + identificativo + ": " + e.getMessage(), e);
            throw e;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getIdentificativo() {
        return this.identificativo;
    }

    @Override
    public void reset() throws Exception {
        for (IStatus pddBean : this.listaStatus) {
            pddBean.setStato(SondaStatus.UNDEFINED);
            pddBean.setDescrizione("Verifica stato non effettuata");
        }
    }

    @Override
    public List<IStatus> getStato() throws Exception {
        return this.listaStatus;
    }

    @Override
    public String getLinkDettaglio() throws Exception {
        return null;
    }
}

