/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.filters;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Properties;
import org.openspcoop2.utils.SortedMap;
import org.openspcoop2.utils.transport.IFilter;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.slf4j.Logger;

public class GestoreFilter
implements Filter {
    private Logger log = LoggerManager.getPddMonitorCoreLogger();
    private SortedMap<IFilter> filterChain = null;
    private boolean gestioneFiltriAbilitata = false;
    private boolean last = false;
    public static final String PARAMETER_LAST = "last";
    private String myName = "Gestore Filtri";

    public void init(FilterConfig config) throws ServletException {
        this.filterChain = new SortedMap();
        try {
            String lastS = config.getInitParameter(PARAMETER_LAST);
            if (lastS != null && lastS.length() > 0) {
                this.last = Boolean.parseBoolean(lastS);
            }
            this.myName = this.last ? "Gestore Filtri Last" : "Gestore Filtri First";
            this.gestioneFiltriAbilitata = PddMonitorProperties.getInstance(this.log).isGestoreFiltriEnabled();
        }
        catch (Exception e) {
            this.log.error("Errore durante la init del GestoreFilter: " + e.getMessage(), (Throwable)e);
            this.gestioneFiltriAbilitata = false;
        }
        try {
            if (this.gestioneFiltriAbilitata) {
                String tipo = this.last ? PARAMETER_LAST : "first";
                List<String> listaNomiFiltri = PddMonitorProperties.getInstance(this.log).getListaFiltri(tipo);
                this.log.debug(this.myName + " init dei filtri: [" + String.valueOf(listaNomiFiltri) + "]");
                for (String nomeFiltro : listaNomiFiltri) {
                    String className = PddMonitorProperties.getInstance(this.log).getClassNameFiltro(tipo, nomeFiltro);
                    Properties propertiesFiltro = PddMonitorProperties.getInstance(this.log).getPropertiesFiltro(tipo, nomeFiltro);
                    IFilter filtro = this.initFiltro(this.log, className);
                    filtro.init(new Object[]{propertiesFiltro});
                    this.filterChain.add(nomeFiltro, (Object)filtro);
                }
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante la init del Gestore Filtri: " + e.getMessage(), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        this.log.debug("DISTRUZIONE FILTRO: " + this.myName);
        List nomiFiltri = this.filterChain.keys();
        if (this.gestioneFiltriAbilitata && nomiFiltri.size() > 0) {
            for (int i = 0; i < nomiFiltri.size(); ++i) {
                ((IFilter)this.filterChain.get(i)).destroy();
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String nomeFiltro;
        int i;
        List nomiFiltri = this.filterChain.keys();
        if (this.gestioneFiltriAbilitata && nomiFiltri.size() > 0) {
            this.log.debug(this.myName + " invocazione metodo doInput per i filtri indicati in corso...");
            for (i = 0; i < nomiFiltri.size(); ++i) {
                nomeFiltro = (String)nomiFiltri.get(i);
                try {
                    this.log.debug(this.myName + " esecuzione del metodo [" + nomeFiltro + ".doInput] in corso...");
                    ((IFilter)this.filterChain.get(i)).doInput(request, response, filterChain);
                    this.log.debug(this.myName + " esecuzione del metodo [" + nomeFiltro + ".doInput] completata.");
                    continue;
                }
                catch (IOException e) {
                    this.log.error(this.myName + " errore durante l'esecuzione del metodo [" + nomeFiltro + ".doInput]: " + e.getMessage(), (Throwable)e);
                    throw e;
                }
                catch (ServletException e) {
                    this.log.error(this.myName + " errore durante l'esecuzione del metodo [" + nomeFiltro + ".doInput]: " + e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
            this.log.debug(this.myName + " invocazione metodo doInput per i filtri indicati completata.");
        }
        filterChain.doFilter(request, response);
        if (this.gestioneFiltriAbilitata && nomiFiltri.size() > 0) {
            this.log.debug(this.myName + " invocazione metodo doOutput per i filtri indicati in corso...");
            for (i = nomiFiltri.size() - 1; i >= 0; --i) {
                nomeFiltro = (String)nomiFiltri.get(i);
                try {
                    this.log.debug(this.myName + " esecuzione del metodo [" + nomeFiltro + ".doOutput] in corso...");
                    ((IFilter)this.filterChain.get(i)).doOutput(request, response, filterChain);
                    this.log.debug(this.myName + " esecuzione del metodo [" + nomeFiltro + ".doOutput] completata.");
                    continue;
                }
                catch (IOException e) {
                    this.log.error(this.myName + " errore durante l'esecuzione del metodo [" + nomeFiltro + ".doOutput]: " + e.getMessage(), (Throwable)e);
                    throw e;
                }
                catch (ServletException e) {
                    this.log.error(this.myName + " errore durante l'esecuzione del metodo [" + nomeFiltro + ".doOutput]: " + e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
            this.log.debug(this.myName + " invocazione metodo doOutput per i filtri indicati completata.");
        }
    }

    private IFilter initFiltro(Logger log, String className) throws Exception {
        log.debug("Caricamento classe [" + className + "] in corso...");
        try {
            Class<?> c = Class.forName(className);
            Constructor<?> constructor = c.getConstructor(Logger.class);
            IFilter p = (IFilter)constructor.newInstance(log);
            return p;
        }
        catch (Exception e) {
            throw new Exception("Impossibile caricare la classe indicata [" + className + "] " + e.getMessage(), e);
        }
    }
}

