/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.filters;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.UUID;
import javax.faces.application.ViewExpiredException;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.slf4j.Logger;
import org.springframework.http.HttpStatus;

public class CsrfFilter
implements Filter {
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private FilterConfig filterConfig = null;
    private static final String JSP_ERRORE = "/commons/pages/welcome.jsf";
    private static final String MSG_ERRORE_KEY = "acclim";
    private static final String ACCLIM_KEY = "acclimflag";
    private Integer validitaTokenCsrf = null;

    public void destroy() {
        log.debug("DISTRUIZIONE FILTRO: CsrfFilter");
        this.filterConfig = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        HttpSession session = request.getSession();
        try {
            String sessionTokenCSRF = CsrfFilter.leggiTokenCSRF(session);
            log.debug("Letto Token CSRF in sessione: [{}]", (Object)sessionTokenCSRF);
            try {
                if (this.isRichiestaScrittura(request)) {
                    String tokenCSRF = request.getParameter("_csrf");
                    log.debug("Ricevuto Token CSRF: [{}]", (Object)tokenCSRF);
                    boolean verificaTokenCSRF = ServletUtils.verificaTokenCSRF((String)tokenCSRF, (String)sessionTokenCSRF, (Integer)this.validitaTokenCsrf);
                    sessionTokenCSRF = null;
                    if (!verificaTokenCSRF) {
                        log.debug("Il Token CSRF ricevuto non e' valido.");
                        if (session != null) {
                            session.setAttribute(MSG_ERRORE_KEY, (Object)"Controllo validit\u00e0 CSRF non superato, l'operazione non verr\u00e0 eseguita.");
                            session.setAttribute(ACCLIM_KEY, (Object)true);
                        }
                        response.sendRedirect(request.getContextPath() + JSP_ERRORE);
                    }
                }
            }
            finally {
                if (sessionTokenCSRF == null) {
                    String nuovoTokenCSRF = CsrfFilter.generaESalvaTokenCSRF(session);
                    log.debug("Generato Nuovo Token CSRF: [{}]", (Object)nuovoTokenCSRF);
                }
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            Throwable rootCause = e.getRootCause();
            if (rootCause != null) {
                if (rootCause instanceof ViewExpiredException) {
                    Utility.setLoginBeanErrorMessage(session, CsrfFilter.class.getName(), null, HttpStatus.BAD_REQUEST.value());
                    log.debug("Rilevata ViewExpiredException: [{}]", (Object)rootCause.getMessage());
                    String redirPageUrl = request.getContextPath() + "/public/timeoutPage.jsf";
                    response.sendRedirect(redirPageUrl);
                }
                if (rootCause instanceof RuntimeException) {
                    RuntimeException runtimeException = (RuntimeException)rootCause;
                    throw runtimeException;
                }
                throw e;
            }
            throw e;
        }
    }

    public void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
        try {
            PddMonitorProperties pddMonitorProperties = PddMonitorProperties.getInstance(log);
            this.validitaTokenCsrf = pddMonitorProperties.getValiditaTokenCsrf();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static String generaESalvaTokenCSRF(HttpSession session) {
        String uuId = UUID.randomUUID().toString();
        String nuovoToken = ServletUtils.generaTokenCSRF((String)uuId);
        if (session != null) {
            session.setAttribute("csrf", (Object)nuovoToken);
        }
        return nuovoToken;
    }

    public static String leggiTokenCSRF(HttpSession session) {
        if (session == null) {
            return null;
        }
        return (String)session.getAttribute("csrf");
    }

    private boolean isRichiestaScrittura(HttpServletRequest request) {
        return request.getParameter("salvaProfiloBtn") != null || request.getParameter("modificaPwd") != null;
    }
}

