/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.dynamic.components;

import java.util.ArrayList;
import javax.faces.event.ActionEvent;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.monitor.engine.dynamic.IDynamicLoader;
import org.openspcoop2.monitor.sdk.condition.Context;
import org.openspcoop2.monitor.sdk.exceptions.ParameterException;
import org.openspcoop2.monitor.sdk.parameters.Parameter;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.slf4j.Logger;

public abstract class BaseComponent<T>
extends Parameter<T> {
    protected static final String CONTANER_SUFFIX = "-ctr";
    private static Logger log = LoggerWrapperFactory.getLogger(BaseComponent.class);
    private Context context;
    private IDynamicLoader loader;
    private Parameter<T> sdkParameter;
    private boolean initialized = false;
    private Boolean render = null;

    public BaseComponent(Parameter<T> parameter, IDynamicLoader loader) {
        super(parameter);
        this.sdkParameter = parameter;
        this.loader = loader;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void setValueAsString(String value) throws ParameterException {
        this.sdkParameter.setValueAsString(value);
        this.setValue(this.sdkParameter.getValue());
    }

    public String getValueAsString() throws ParameterException {
        return this.sdkParameter.getValueAsString();
    }

    public T getValue() {
        if (super.getValue() == null) {
            if (this.initialized) {
                return null;
            }
            this.initialized = true;
            Object defaultValue = this.getRendering().getDefaultValue();
            this.setValue(defaultValue);
            return (T)defaultValue;
        }
        return (T)super.getValue();
    }

    public void setValue(T val) {
        if (val instanceof String && ("--".equals(val) || "".equals(val))) {
            val = null;
        }
        super.setValue(val);
        this.sdkParameter.setValue(val);
    }

    public boolean getRendered() {
        if (this.render != null) {
            return this.render;
        }
        if (this.getLoader() == null) {
            this.render = true;
        } else {
            try {
                this.getLoader().updateRendering((Parameter)this, this.context);
                this.render = !this.getRendering().isHidden();
            }
            catch (Exception e) {
                log.error("Impossibile recuperare le informazioni di rendering dal Loader: " + e.getMessage());
                this.render = true;
            }
        }
        return this.render;
    }

    public IDynamicLoader getLoader() {
        return this.loader;
    }

    public void setLoader(IDynamicLoader loader) {
        this.loader = loader;
    }

    public String getContainerId() {
        String cid = this.buildContainerId(this.getId());
        return cid;
    }

    public String getContainersIdToRefresh() {
        if (this.getRefreshParamIds() != null) {
            ArrayList<String> res = new ArrayList<String>();
            for (String pid : this.getRefreshParamIds()) {
                res.add(this.buildContainerId(pid));
            }
            return StringUtils.join(res, (String)",");
        }
        return this.buildContainerId(this.getId());
    }

    public void valueSelectedListener(ActionEvent ae) {
        this.getLoader().valueSelectedListener((Parameter)this, this.getContext());
    }

    private String buildContainerId(String id) {
        if (id != null) {
            String tmp = id.trim();
            if (tmp.endsWith("-ctr-standard")) {
                return tmp.substring(0, tmp.length() - "-ctr-standard".length());
            }
            return tmp + CONTANER_SUFFIX;
        }
        return null;
    }
}

