/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.search.Soggetto;
import org.openspcoop2.core.commons.search.dao.ISoggettoServiceSearch;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.plugins.ConfigurazioneServizio;
import org.openspcoop2.core.plugins.ConfigurazioneServizioAzione;
import org.openspcoop2.core.plugins.dao.IConfigurazioneServizioAzioneServiceSearch;
import org.openspcoop2.core.plugins.dao.IConfigurazioneServizioServiceSearch;
import org.openspcoop2.core.plugins.dao.IServiceManager;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.monitor.engine.config.transazioni.ConfigurazioneTransazione;
import org.openspcoop2.monitor.engine.config.transazioni.ConfigurazioneTransazioneRisorsaContenuto;
import org.openspcoop2.monitor.engine.config.transazioni.ConfigurazioneTransazioneStato;
import org.openspcoop2.monitor.engine.config.transazioni.dao.IConfigurazioneTransazioneServiceSearch;
import org.openspcoop2.web.lib.users.DriverUsersDB;
import org.openspcoop2.web.lib.users.DriverUsersDBException;
import org.openspcoop2.web.lib.users.ProjectInfo;
import org.openspcoop2.web.lib.users.dao.Stato;
import org.openspcoop2.web.lib.users.dao.User;
import org.openspcoop2.web.monitor.core.constants.NomiTabelle;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.dao.IGenericService;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.slf4j.Logger;

public class GenericService
implements IGenericService {
    private int LIMIT_SEARCH = 10000;
    private static Logger log = LoggerManager.getPddMonitorSqlLogger();
    private DriverUsersDB utenteDAO;
    private IServiceManager basePluginsServiceManager;
    private org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager transazioniPluginsServiceManager;
    private IConfigurazioneServizioAzioneServiceSearch confSerAzSearchDAO;
    private IConfigurazioneServizioServiceSearch confSerSearchDAO;
    private IConfigurazioneTransazioneServiceSearch transazioneSearchDAO;
    private org.openspcoop2.core.commons.search.dao.IServiceManager utilsServiceManager;
    private ISoggettoServiceSearch soggettoDAO;

    public GenericService() {
        try {
            this.utenteDAO = (DriverUsersDB)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)ProjectInfo.getInstance());
            this.basePluginsServiceManager = (IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)org.openspcoop2.core.plugins.utils.ProjectInfo.getInstance(), log);
            this.confSerAzSearchDAO = this.basePluginsServiceManager.getConfigurazioneServizioAzioneServiceSearch();
            this.confSerSearchDAO = this.basePluginsServiceManager.getConfigurazioneServizioServiceSearch();
            this.transazioniPluginsServiceManager = (org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)org.openspcoop2.monitor.engine.config.transazioni.utils.ProjectInfo.getInstance(), log);
            this.transazioneSearchDAO = this.transazioniPluginsServiceManager.getConfigurazioneTransazioneServiceSearch();
            this.utilsServiceManager = (org.openspcoop2.core.commons.search.dao.IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance(), log);
            this.soggettoDAO = this.utilsServiceManager.getSoggettoServiceSearch();
            PddMonitorProperties monitorProperties = PddMonitorProperties.getInstance(log);
            this.LIMIT_SEARCH = monitorProperties.getSearchFormLimit();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean existServizioAzioneConfigByName(IDAccordo idAccordo, String nomeServizio, String nomeAzione) {
        try {
            ConfigurazioneServizioAzione c;
            IExpression espr = this.confSerAzSearchDAO.newExpression();
            espr.equals(ConfigurazioneServizioAzione.model().ID_CONFIGURAZIONE_SERVIZIO.SERVIZIO, (Object)nomeServizio);
            espr.and();
            espr.equals(ConfigurazioneServizioAzione.model().ID_CONFIGURAZIONE_SERVIZIO.ACCORDO, (Object)idAccordo.getNome());
            espr.and().equals(ConfigurazioneServizioAzione.model().AZIONE, (Object)nomeAzione);
            if (idAccordo.getSoggettoReferente() != null) {
                if (idAccordo.getSoggettoReferente().getTipo() != null) {
                    espr.and().equals(ConfigurazioneServizioAzione.model().ID_CONFIGURAZIONE_SERVIZIO.TIPO_SOGGETTO_REFERENTE, (Object)idAccordo.getSoggettoReferente().getTipo());
                }
                if (idAccordo.getSoggettoReferente().getNome() != null) {
                    espr.and().equals(ConfigurazioneServizioAzione.model().ID_CONFIGURAZIONE_SERVIZIO.NOME_SOGGETTO_REFERENTE, (Object)idAccordo.getSoggettoReferente().getNome());
                }
            }
            if (idAccordo.getVersione() != null) {
                espr.and().equals(ConfigurazioneServizioAzione.model().ID_CONFIGURAZIONE_SERVIZIO.VERSIONE, (Object)idAccordo.getVersione());
            }
            return (c = (ConfigurazioneServizioAzione)this.confSerAzSearchDAO.find(espr)) != null;
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public List<ConfigurazioneServizio> findServiziByIDAccordo(IDAccordo accordo) {
        try {
            IExpression expr = this.confSerSearchDAO.newExpression();
            if (accordo != null) {
                expr.equals(ConfigurazioneServizio.model().ACCORDO, (Object)accordo.getNome());
                if (accordo.getSoggettoReferente() != null) {
                    expr.and().equals(ConfigurazioneServizio.model().NOME_SOGGETTO_REFERENTE, (Object)accordo.getSoggettoReferente().getNome());
                    expr.and().equals(ConfigurazioneServizio.model().TIPO_SOGGETTO_REFERENTE, (Object)accordo.getSoggettoReferente().getTipo());
                }
                if (accordo.getVersione() != null) {
                    expr.and().equals(ConfigurazioneServizio.model().VERSIONE, (Object)accordo.getVersione());
                }
            }
            IPaginatedExpression pagExpr = this.confSerSearchDAO.toPaginatedExpression(expr);
            return this.confSerSearchDAO.findAll(pagExpr);
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList<ConfigurazioneServizio>();
    }

    @Override
    public List<ConfigurazioneTransazioneStato> findStatiByAzione(IDAccordo idAccordo, String nomeServizio, String azione) {
        try {
            if (idAccordo == null || nomeServizio == null || azione == null) {
                log.error("Impossibile recuperare gli stati: idAccordo, nomeServizio e/o azione non forniti.");
                return new ArrayList<ConfigurazioneTransazioneStato>();
            }
            IExpression espr = this.confSerAzSearchDAO.newExpression();
            espr.equals(ConfigurazioneServizioAzione.model().ID_CONFIGURAZIONE_SERVIZIO.SERVIZIO, (Object)nomeServizio);
            espr.and();
            espr.equals(ConfigurazioneServizioAzione.model().ID_CONFIGURAZIONE_SERVIZIO.ACCORDO, (Object)idAccordo.getNome());
            if (azione.equals("*")) {
                espr.and().equals(ConfigurazioneServizioAzione.model().AZIONE, (Object)azione);
            } else {
                espr.and().or(espr.equals(ConfigurazioneServizioAzione.model().AZIONE, (Object)"*"), espr.equals(ConfigurazioneServizioAzione.model().AZIONE, (Object)azione));
            }
            if (idAccordo.getSoggettoReferente() != null) {
                if (idAccordo.getSoggettoReferente().getTipo() != null) {
                    espr.and().equals(ConfigurazioneServizioAzione.model().ID_CONFIGURAZIONE_SERVIZIO.TIPO_SOGGETTO_REFERENTE, (Object)idAccordo.getSoggettoReferente().getTipo());
                }
                if (idAccordo.getSoggettoReferente().getNome() != null) {
                    espr.and().equals(ConfigurazioneServizioAzione.model().ID_CONFIGURAZIONE_SERVIZIO.NOME_SOGGETTO_REFERENTE, (Object)idAccordo.getSoggettoReferente().getNome());
                }
            }
            if (idAccordo.getVersione() != null) {
                espr.and().equals(ConfigurazioneServizioAzione.model().ID_CONFIGURAZIONE_SERVIZIO.VERSIONE, (Object)idAccordo.getVersione());
            }
            IPaginatedExpression pagExpr = this.confSerAzSearchDAO.toPaginatedExpression(espr);
            List lst = this.confSerAzSearchDAO.findAll(pagExpr);
            TreeMap<Long, ConfigurazioneTransazione> mappa = null;
            if (lst != null && lst.size() > 0) {
                IExpression expr = null;
                mappa = new TreeMap<Long, ConfigurazioneTransazione>();
                for (ConfigurazioneServizioAzione conf : lst) {
                    expr = this.transazioneSearchDAO.newExpression();
                    expr.equals(ConfigurazioneTransazione.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.ACCORDO, (Object)conf.getIdConfigurazioneServizio().getAccordo());
                    expr.and().equals(ConfigurazioneTransazione.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.NOME_SOGGETTO_REFERENTE, (Object)conf.getIdConfigurazioneServizio().getNomeSoggettoReferente());
                    expr.and().equals(ConfigurazioneTransazione.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.TIPO_SOGGETTO_REFERENTE, (Object)conf.getIdConfigurazioneServizio().getTipoSoggettoReferente());
                    expr.and().equals(ConfigurazioneTransazione.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.SERVIZIO, (Object)conf.getIdConfigurazioneServizio().getServizio());
                    expr.and().equals(ConfigurazioneTransazione.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.VERSIONE, (Object)conf.getIdConfigurazioneServizio().getVersione());
                    ConfigurazioneTransazione t = (ConfigurazioneTransazione)this.transazioneSearchDAO.find(expr);
                    if (t == null || mappa.containsKey(t.getId())) continue;
                    mappa.put(t.getId(), t);
                }
                if (mappa != null && mappa.size() > 0) {
                    ArrayList<ConfigurazioneTransazioneStato> ts = new ArrayList<ConfigurazioneTransazioneStato>();
                    for (ConfigurazioneTransazione tr : mappa.values()) {
                        ts.addAll(tr.getConfigurazioneTransazioneStatoList());
                    }
                    return ts;
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList<ConfigurazioneTransazioneStato>();
    }

    @Override
    public List<ConfigurazioneTransazioneRisorsaContenuto> getRisorseByValues(IDAccordo idAccordo, String nomeServizio, String nomeAzione, String nomeStato) {
        if (idAccordo == null || nomeServizio == null || nomeAzione == null) {
            log.error("Impossibile recuperare gli stati: idAccordo , nomeServizio e/o azione non forniti.");
            return null;
        }
        try {
            IExpression espr = this.confSerAzSearchDAO.newExpression();
            espr.equals(ConfigurazioneServizioAzione.model().ID_CONFIGURAZIONE_SERVIZIO.SERVIZIO, (Object)nomeServizio);
            espr.and();
            espr.equals(ConfigurazioneServizioAzione.model().ID_CONFIGURAZIONE_SERVIZIO.ACCORDO, (Object)idAccordo.getNome());
            if (nomeAzione.equals("*")) {
                espr.and().equals(ConfigurazioneServizioAzione.model().AZIONE, (Object)nomeAzione);
            } else {
                espr.and().or(espr.equals(ConfigurazioneServizioAzione.model().AZIONE, (Object)"*"), espr.equals(ConfigurazioneServizioAzione.model().AZIONE, (Object)nomeAzione));
            }
            if (idAccordo.getSoggettoReferente() != null) {
                if (idAccordo.getSoggettoReferente().getTipo() != null) {
                    espr.and().equals(ConfigurazioneServizioAzione.model().ID_CONFIGURAZIONE_SERVIZIO.TIPO_SOGGETTO_REFERENTE, (Object)idAccordo.getSoggettoReferente().getTipo());
                }
                if (idAccordo.getSoggettoReferente().getNome() != null) {
                    espr.and().equals(ConfigurazioneServizioAzione.model().ID_CONFIGURAZIONE_SERVIZIO.NOME_SOGGETTO_REFERENTE, (Object)idAccordo.getSoggettoReferente().getNome());
                }
            }
            if (idAccordo.getVersione() != null) {
                espr.and().equals(ConfigurazioneServizioAzione.model().ID_CONFIGURAZIONE_SERVIZIO.VERSIONE, (Object)idAccordo.getVersione());
            }
            IPaginatedExpression pagExpr = this.confSerAzSearchDAO.toPaginatedExpression(espr);
            List lst = this.confSerAzSearchDAO.findAll(pagExpr);
            TreeMap<Long, ConfigurazioneTransazione> mappa = null;
            if (lst != null && lst.size() > 0) {
                IExpression expr = null;
                mappa = new TreeMap<Long, ConfigurazioneTransazione>();
                for (ConfigurazioneServizioAzione conf : lst) {
                    ConfigurazioneTransazione t;
                    expr = this.transazioneSearchDAO.newExpression();
                    expr.equals(ConfigurazioneTransazione.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.ACCORDO, (Object)conf.getIdConfigurazioneServizio().getAccordo());
                    expr.and().equals(ConfigurazioneTransazione.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.NOME_SOGGETTO_REFERENTE, (Object)conf.getIdConfigurazioneServizio().getNomeSoggettoReferente());
                    expr.and().equals(ConfigurazioneTransazione.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.TIPO_SOGGETTO_REFERENTE, (Object)conf.getIdConfigurazioneServizio().getTipoSoggettoReferente());
                    expr.and().equals(ConfigurazioneTransazione.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.SERVIZIO, (Object)conf.getIdConfigurazioneServizio().getServizio());
                    expr.and().equals(ConfigurazioneTransazione.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.VERSIONE, (Object)conf.getIdConfigurazioneServizio().getVersione());
                    if (nomeStato != null && !"*".equals(nomeStato)) {
                        expr.and().equals(ConfigurazioneTransazione.model().CONFIGURAZIONE_TRANSAZIONE_STATO.NOME, (Object)nomeStato);
                    }
                    if ((t = (ConfigurazioneTransazione)this.transazioneSearchDAO.find(expr)) == null || mappa.containsKey(t.getId())) continue;
                    mappa.put(t.getId(), t);
                }
                if (mappa != null && mappa.size() > 0) {
                    ArrayList<ConfigurazioneTransazioneRisorsaContenuto> toRet = new ArrayList<ConfigurazioneTransazioneRisorsaContenuto>();
                    for (ConfigurazioneTransazione tr : mappa.values()) {
                        toRet.addAll(tr.getConfigurazioneTransazioneRisorsaContenutoList());
                    }
                    return toRet;
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList<ConfigurazioneTransazioneRisorsaContenuto>();
    }

    @Override
    public Stato getTableState(User utente, NomiTabelle nomeTabella) {
        Stato state = null;
        try {
            state = this.utenteDAO.getStato(utente.getLogin(), nomeTabella.toString());
            if (state == null) {
                state = new Stato();
                state.setOggetto(nomeTabella.toString());
                state.setStato(null);
            }
            return state;
        }
        catch (DriverUsersDBException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void saveTableState(User user, Stato stato) {
        try {
            this.utenteDAO.saveStato(user.getLogin(), stato.getOggetto(), stato.getStato());
        }
        catch (DriverUsersDBException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<Soggetto> soggettiAutoComplete(String input) {
        try {
            IExpression expr = this.soggettoDAO.newExpression();
            expr.ilike(Soggetto.model().NOME_SOGGETTO, "%" + input.toLowerCase() + "%");
            expr.sortOrder(SortOrder.ASC).addOrder(Soggetto.model().NOME_SOGGETTO);
            IPaginatedExpression pagExpr = this.soggettoDAO.toPaginatedExpression(expr);
            pagExpr.offset(0).limit(this.LIMIT_SEARCH);
            return this.soggettoDAO.findAll(pagExpr);
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList<Soggetto>();
    }
}

