/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.dao;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.search.AccordoServizioParteComune;
import org.openspcoop2.core.commons.search.AccordoServizioParteSpecifica;
import org.openspcoop2.core.commons.search.IdAccordoServizioParteComune;
import org.openspcoop2.core.commons.search.IdAccordoServizioParteComuneGruppo;
import org.openspcoop2.core.commons.search.PortType;
import org.openspcoop2.core.commons.search.PortaApplicativa;
import org.openspcoop2.core.commons.search.PortaDelegata;
import org.openspcoop2.core.commons.search.Soggetto;
import org.openspcoop2.core.commons.search.constants.TipoPdD;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.plugins.IdPlugin;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.dao.IServiceManager;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.web.monitor.core.core.PermessiUtenteOperatore;
import org.openspcoop2.web.monitor.core.dao.DynamicUtilsServiceCache;
import org.openspcoop2.web.monitor.core.dao.DynamicUtilsServiceEngine;
import org.openspcoop2.web.monitor.core.dao.IDynamicUtilsService;
import org.openspcoop2.web.monitor.core.listener.AbstractConsoleStartupListener;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.slf4j.Logger;

public class DynamicUtilsService
implements IDynamicUtilsService {
    private DynamicUtilsServiceEngine driver;
    private static Logger log = LoggerManager.getPddMonitorSqlLogger();

    public DynamicUtilsService() {
        this(null, null, null, null);
    }

    public DynamicUtilsService(org.openspcoop2.core.commons.search.dao.IServiceManager serviceManager, IServiceManager pluginsServiceManager, DriverRegistroServiziDB driverRegistroServiziDB, DriverConfigurazioneDB driverConfigurazioneDB) {
        this.driver = new DynamicUtilsServiceEngine(serviceManager, pluginsServiceManager, driverRegistroServiziDB, driverConfigurazioneDB);
    }

    public DynamicUtilsService(Connection con, boolean autoCommit) {
        this(con, autoCommit, null, log);
    }

    public DynamicUtilsService(Connection con, boolean autoCommit, Logger log) {
        this(con, autoCommit, null, log);
    }

    public DynamicUtilsService(Connection con, boolean autoCommit, ServiceManagerProperties serviceManagerProperties) {
        this(con, autoCommit, serviceManagerProperties, log);
    }

    public DynamicUtilsService(Connection con, boolean autoCommit, ServiceManagerProperties serviceManagerProperties, Logger log) {
        this.driver = new DynamicUtilsServiceEngine(con, autoCommit, serviceManagerProperties, log);
    }

    public org.openspcoop2.core.commons.search.dao.IServiceManager getUtilsServiceManager() {
        return this.driver.getUtilsServiceManager();
    }

    public static String buildKey(Object ... params) {
        StringBuilder sb = new StringBuilder();
        if (params != null && params.length > 0) {
            for (Object object : params) {
                if (sb.length() > 0) {
                    sb.append("_");
                }
                if (object != null) {
                    sb.append(object.toString());
                    continue;
                }
                sb.append("-");
            }
        }
        return sb.toString();
    }

    @Override
    public int countPdD(String protocollo) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(protocollo);
            String methodName = "countPdD";
            try {
                return (Integer)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class}, new Object[]{protocollo});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return 0;
            }
        }
        return this.driver.countPdD(protocollo);
    }

    @Override
    public List<Soggetto> soggettiAutoComplete(String tipoProtocollo, String input) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione != null) {
            String key = DynamicUtilsService.buildKey("_noSearchTipo", tipoProtocollo, input);
            String methodName = "soggettiAutoComplete";
            try {
                return (List)AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_ricercheConfigurazione, key, methodName, new Class[]{String.class, String.class}, new Object[]{tipoProtocollo, input});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.soggettiAutoComplete(tipoProtocollo, input);
    }

    @Override
    public List<Soggetto> soggettiAutoComplete(String tipoProtocollo, String input, Boolean searchTipo) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione != null) {
            String key = DynamicUtilsService.buildKey("_searchTipo", tipoProtocollo, input, searchTipo);
            String methodName = "soggettiAutoComplete";
            try {
                return (List)AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_ricercheConfigurazione, key, methodName, new Class[]{String.class, String.class, Boolean.class}, new Object[]{tipoProtocollo, input, searchTipo});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.soggettiAutoComplete(tipoProtocollo, input, searchTipo);
    }

    @Override
    public List<Soggetto> findElencoSoggetti(String tipoProtocollo, String idPorta) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, idPorta);
            String methodName = "findElencoSoggetti";
            try {
                return (List)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class, String.class}, new Object[]{tipoProtocollo, idPorta});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.findElencoSoggetti(tipoProtocollo, idPorta);
    }

    @Override
    public int countElencoSoggetti(String tipoProtocollo, String idPorta) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, idPorta);
            String methodName = "countElencoSoggetti";
            try {
                return (Integer)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class, String.class}, new Object[]{tipoProtocollo, idPorta});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return 0;
            }
        }
        return this.driver.countElencoSoggetti(tipoProtocollo, idPorta);
    }

    @Override
    public List<Soggetto> findElencoSoggetti(String tipoProtocollo, String idPorta, String input) {
        DynamicUtilsServiceCache cache = null;
        boolean debug = false;
        if (input == null || StringUtils.isEmpty((CharSequence)input)) {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_datiConfigurazione;
        } else {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_ricercheConfigurazione;
        }
        if (cache != null) {
            String key = DynamicUtilsService.buildKey("_noSearchTipo", tipoProtocollo, idPorta, input);
            String methodName = "findElencoSoggetti";
            try {
                return (List)cache.getObjectCache(this.driver, debug, key, methodName, new Class[]{String.class, String.class, String.class}, new Object[]{tipoProtocollo, idPorta, input});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.findElencoSoggetti(tipoProtocollo, idPorta, input);
    }

    @Override
    public int countElencoSoggetti(String tipoProtocollo, String idPorta, String input) {
        DynamicUtilsServiceCache cache = null;
        boolean debug = false;
        if (input == null || StringUtils.isEmpty((CharSequence)input)) {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_datiConfigurazione;
        } else {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_ricercheConfigurazione;
        }
        if (cache != null) {
            String key = DynamicUtilsService.buildKey("_noSearchTipo", tipoProtocollo, idPorta, input);
            String methodName = "countElencoSoggetti";
            try {
                return (Integer)cache.getObjectCache(this.driver, debug, key, methodName, new Class[]{String.class, String.class, String.class}, new Object[]{tipoProtocollo, idPorta, input});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return 0;
            }
        }
        return this.driver.countElencoSoggetti(tipoProtocollo, idPorta, input);
    }

    @Override
    public List<Soggetto> findElencoSoggetti(String tipoProtocollo, String idPorta, String input, Boolean searchTipo) {
        DynamicUtilsServiceCache cache = null;
        boolean debug = false;
        if (input == null || StringUtils.isEmpty((CharSequence)input)) {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_datiConfigurazione;
        } else {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_ricercheConfigurazione;
        }
        if (cache != null) {
            String key = DynamicUtilsService.buildKey("_searchTipo", tipoProtocollo, idPorta, input, searchTipo);
            String methodName = "findElencoSoggetti";
            try {
                return (List)cache.getObjectCache(this.driver, debug, key, methodName, new Class[]{String.class, String.class, String.class, Boolean.class}, new Object[]{tipoProtocollo, idPorta, input, searchTipo});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.findElencoSoggetti(tipoProtocollo, idPorta, input, searchTipo);
    }

    @Override
    public int countElencoSoggetti(String tipoProtocollo, String idPorta, String input, Boolean searchTipo) {
        DynamicUtilsServiceCache cache = null;
        boolean debug = false;
        if (input == null || StringUtils.isEmpty((CharSequence)input)) {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_datiConfigurazione;
        } else {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_ricercheConfigurazione;
        }
        if (cache != null) {
            String key = DynamicUtilsService.buildKey("_searchTipo", tipoProtocollo, idPorta, input, searchTipo);
            String methodName = "countElencoSoggetti";
            try {
                return (Integer)cache.getObjectCache(this.driver, debug, key, methodName, new Class[]{String.class, String.class, String.class, Boolean.class}, new Object[]{tipoProtocollo, idPorta, input, searchTipo});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return 0;
            }
        }
        return this.driver.countElencoSoggetti(tipoProtocollo, idPorta, input, searchTipo);
    }

    @Override
    public Soggetto findSoggettoByTipoNome(String tipoSoggetto, String nomeSoggetto) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoSoggetto, nomeSoggetto);
            String methodName = "findSoggettoByTipoNome";
            try {
                return (Soggetto)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class, String.class}, new Object[]{tipoSoggetto, nomeSoggetto});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.findSoggettoByTipoNome(tipoSoggetto, nomeSoggetto);
    }

    @Override
    public Soggetto findSoggettoById(Long idSoggetto) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(idSoggetto);
            String methodName = "findSoggettoById";
            try {
                return (Soggetto)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{Long.class}, new Object[]{idSoggetto});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.findSoggettoById(idSoggetto);
    }

    @Override
    public List<Soggetto> findElencoSoggettiFromTipoSoggetto(String tipoSoggetto) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoSoggetto);
            String methodName = "findElencoSoggettiFromTipoSoggetto";
            try {
                return (List)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class}, new Object[]{tipoSoggetto});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.findElencoSoggettiFromTipoSoggetto(tipoSoggetto);
    }

    @Override
    public int countElencoSoggettiFromTipoSoggetto(String tipoSoggetto) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoSoggetto);
            String methodName = "countElencoSoggettiFromTipoSoggetto";
            try {
                return (Integer)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class}, new Object[]{tipoSoggetto});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return 0;
            }
        }
        return this.driver.countElencoSoggettiFromTipoSoggetto(tipoSoggetto);
    }

    @Override
    public List<Soggetto> findElencoSoggettiFromTipoPdD(String tipoProtocollo, TipoPdD tipoPdD) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, tipoPdD);
            String methodName = "findElencoSoggettiFromTipoPdD";
            try {
                return (List)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class, TipoPdD.class}, new Object[]{tipoProtocollo, tipoPdD});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.findElencoSoggettiFromTipoPdD(tipoProtocollo, tipoPdD);
    }

    @Override
    public int countElencoSoggettiFromTipoTipoPdD(String tipoProtocollo, TipoPdD tipoPdD) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, tipoPdD);
            String methodName = "countElencoSoggettiFromTipoTipoPdD";
            try {
                return (Integer)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class, TipoPdD.class}, new Object[]{tipoProtocollo, tipoPdD});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return 0;
            }
        }
        return this.driver.countElencoSoggettiFromTipoTipoPdD(tipoProtocollo, tipoPdD);
    }

    @Override
    public boolean checkTipoPdd(String nome, TipoPdD tipoPdD) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(nome, tipoPdD);
            String methodName = "checkTipoPdd";
            try {
                return (Boolean)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class, TipoPdD.class}, new Object[]{nome, tipoPdD});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return false;
            }
        }
        return this.driver.checkTipoPdd(nome, tipoPdD);
    }

    @Override
    public List<Map<String, Object>> findElencoServizi(String tipoProtocollo, Soggetto soggetto) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, soggetto != null ? soggetto.getTipoSoggetto() + "/" + soggetto.getNomeSoggetto() : "??");
            String methodName = "findElencoServizi";
            try {
                return (List)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class, Soggetto.class}, new Object[]{tipoProtocollo, soggetto});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.findElencoServizi(tipoProtocollo, soggetto);
    }

    @Override
    public int countElencoServizi(String tipoProtocollo, Soggetto soggetto) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, soggetto != null ? soggetto.getTipoSoggetto() + "/" + soggetto.getNomeSoggetto() : "??");
            String methodName = "countElencoServizi";
            try {
                return (Integer)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class, Soggetto.class}, new Object[]{tipoProtocollo, soggetto});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return 0;
            }
        }
        return this.driver.countElencoServizi(tipoProtocollo, soggetto);
    }

    @Override
    public List<Map<String, Object>> findElencoServizi(String tipoProtocollo, Soggetto soggetto, String val) {
        DynamicUtilsServiceCache cache = null;
        boolean debug = false;
        if (val == null || StringUtils.isEmpty((CharSequence)val)) {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_datiConfigurazione;
        } else {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_ricercheConfigurazione;
        }
        if (cache != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, soggetto != null ? soggetto.getTipoSoggetto() + "/" + soggetto.getNomeSoggetto() : "??", "VAL:" + val);
            String methodName = "findElencoServizi";
            try {
                return (List)cache.getObjectCache(this.driver, debug, key, methodName, new Class[]{String.class, Soggetto.class, String.class}, new Object[]{tipoProtocollo, soggetto, val});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.findElencoServizi(tipoProtocollo, soggetto, val);
    }

    @Override
    public List<Map<String, Object>> findElencoServizi(String tipoProtocollo, Soggetto soggetto, String val, Boolean searchTipo) {
        DynamicUtilsServiceCache cache = null;
        boolean debug = false;
        if (val == null || StringUtils.isEmpty((CharSequence)val)) {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_datiConfigurazione;
        } else {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_ricercheConfigurazione;
        }
        if (cache != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, soggetto != null ? soggetto.getTipoSoggetto() + "/" + soggetto.getNomeSoggetto() : "??", "VAL:" + val, "SearchTipo:" + searchTipo);
            String methodName = "findElencoServizi";
            try {
                return (List)cache.getObjectCache(this.driver, debug, key, methodName, new Class[]{String.class, Soggetto.class, String.class, Boolean.class}, new Object[]{tipoProtocollo, soggetto, val, searchTipo});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.findElencoServizi(tipoProtocollo, soggetto, val, searchTipo);
    }

    @Override
    public AccordoServizioParteComune getAccordoServizio(String tipoProtocollo, IDSoggetto idSoggetto, String tipoServizio, String nomeServizio, Integer versioneServizio) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, idSoggetto, tipoServizio, nomeServizio, versioneServizio);
            String methodName = "getAccordoServizio";
            try {
                return (AccordoServizioParteComune)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class, IDSoggetto.class, String.class, String.class, Integer.class}, new Object[]{tipoProtocollo, idSoggetto, tipoServizio, nomeServizio, versioneServizio});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.getAccordoServizio(tipoProtocollo, idSoggetto, tipoServizio, nomeServizio, versioneServizio);
    }

    @Override
    public List<IdAccordoServizioParteComuneGruppo> getAccordoServizioGruppi(IdAccordoServizioParteComune id) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = null;
            key = id != null ? DynamicUtilsService.buildKey(id.getNome(), id.getIdSoggetto() != null ? id.getIdSoggetto().getTipo() + "/" + id.getIdSoggetto().getNome() : "??", id.getVersione()) : "??";
            String methodName = "getAccordoServizioGruppi";
            try {
                return (List)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{IdAccordoServizioParteComune.class}, new Object[]{id});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.getAccordoServizioGruppi(id);
    }

    @Override
    public List<Map<String, Object>> findElencoServizi(String tipoProtocollo) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo);
            String methodName = "findElencoServizi";
            try {
                return (List)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class}, new Object[]{tipoProtocollo});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.findElencoServizi(tipoProtocollo);
    }

    @Override
    public int countElencoServizi(String tipoProtocollo) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo);
            String methodName = "countElencoServizi";
            try {
                return (Integer)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class}, new Object[]{tipoProtocollo});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return 0;
            }
        }
        return this.driver.countElencoServizi(tipoProtocollo);
    }

    @Override
    public List<Object> findElencoServiziApplicativi(String tipoProtocollo, Soggetto soggetto, boolean trasporto, boolean token) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, soggetto != null ? soggetto.getTipoSoggetto() + "/" + soggetto.getNomeSoggetto() : "??", trasporto, token);
            String methodName = "findElencoServiziApplicativi";
            try {
                return (List)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class, Soggetto.class, Boolean.TYPE, Boolean.TYPE}, new Object[]{tipoProtocollo, soggetto, trasporto, token});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.findElencoServiziApplicativi(tipoProtocollo, soggetto, trasporto, token);
    }

    @Override
    public int countElencoServiziApplicativi(String tipoProtocollo, Soggetto soggetto, boolean trasporto, boolean token) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, soggetto != null ? soggetto.getTipoSoggetto() + "/" + soggetto.getNomeSoggetto() : "??", trasporto, token);
            String methodName = "countElencoServiziApplicativi";
            try {
                return (Integer)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class, Soggetto.class, Boolean.TYPE, Boolean.TYPE}, new Object[]{tipoProtocollo, soggetto, trasporto, token});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return 0;
            }
        }
        return this.driver.countElencoServiziApplicativi(tipoProtocollo, soggetto, trasporto, token);
    }

    @Override
    public Map<String, String> findAzioniFromServizio(String tipoProtocollo, String tipoServizio, String nomeServizio, String tipoErogatore, String nomeErogatore, Integer versioneServizio, String val) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, "VAL:" + val);
            String methodName = "findAzioniFromServizio";
            try {
                return (Map)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class, String.class, String.class, String.class, String.class, Integer.class, String.class}, new Object[]{tipoProtocollo, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, val});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.findAzioniFromServizio(tipoProtocollo, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, val);
    }

    @Override
    public int countAzioniFromServizio(String tipoProtocollo, String tipoServizio, String nomeServizio, String tipoErogatore, String nomeErogatore, Integer versioneServizio, String val) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, "VAL:" + val);
            String methodName = "countAzioniFromServizio";
            try {
                return (Integer)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class, String.class, String.class, String.class, String.class, Integer.class, String.class}, new Object[]{tipoProtocollo, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, val});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return 0;
            }
        }
        return this.driver.countAzioniFromServizio(tipoProtocollo, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, val);
    }

    @Override
    public Map<String, String> findAzioniFromAPI(String tipoProtocollo, String nome, String tipoReferente, String nomeReferente, Integer versione, String val) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, nome, tipoReferente, nomeReferente, versione, "VAL:" + val);
            String methodName = "findAzioniFromAPI";
            try {
                return (Map)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class, String.class, String.class, String.class, Integer.class, String.class}, new Object[]{tipoProtocollo, nome, tipoReferente, nomeReferente, versione, val});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.findAzioniFromAPI(tipoProtocollo, nome, tipoReferente, nomeReferente, versione, val);
    }

    @Override
    public PortType getPortTypeFromAccordoServizio(String tipoProtocollo, IDAccordo idAccordo, String nomeServizio) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, idAccordo, nomeServizio);
            String methodName = "getPortTypeFromAccordoServizio";
            try {
                return (PortType)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class, IDAccordo.class, String.class}, new Object[]{tipoProtocollo, idAccordo, nomeServizio});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.getPortTypeFromAccordoServizio(tipoProtocollo, idAccordo, nomeServizio);
    }

    @Override
    public int countPortTypeFromAccordoServizio(String tipoProtocollo, IDAccordo idAccordo, String nomeServizio) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, idAccordo, nomeServizio);
            String methodName = "countPortTypeFromAccordoServizio";
            try {
                return (Integer)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class, IDAccordo.class, String.class}, new Object[]{tipoProtocollo, idAccordo, nomeServizio});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return 0;
            }
        }
        return this.driver.countPortTypeFromAccordoServizio(tipoProtocollo, idAccordo, nomeServizio);
    }

    @Override
    public List<IDGruppo> getGruppi(String protocollo) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey("protocollo:" + protocollo);
            String methodName = "getGruppi";
            try {
                return (List)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class}, new Object[]{protocollo});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.getGruppi(protocollo);
    }

    @Override
    public int countGruppi(String protocollo) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey("protocollo:" + protocollo);
            String methodName = "countGruppi";
            try {
                return (Integer)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class}, new Object[]{protocollo});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return 0;
            }
        }
        return this.driver.countGruppi(protocollo);
    }

    @Override
    public List<AccordoServizioParteComune> getAccordiServizio(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, Boolean isReferente, Boolean isErogatore, String tag) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, tipoSoggetto, nomeSoggetto, isReferente, isErogatore, tag);
            String methodName = "getAccordiServizio";
            try {
                return (List)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class, String.class, String.class, Boolean.class, Boolean.class, String.class}, new Object[]{tipoProtocollo, tipoSoggetto, nomeSoggetto, isReferente, isErogatore, tag});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.getAccordiServizio(tipoProtocollo, tipoSoggetto, nomeSoggetto, isReferente, isErogatore, tag);
    }

    @Override
    public int countAccordiServizio(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, Boolean isReferente, Boolean isErogatore, String tag) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, tipoSoggetto, nomeSoggetto, isReferente, isErogatore, tag);
            String methodName = "countAccordiServizio";
            try {
                return (Integer)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class, String.class, String.class, Boolean.class, Boolean.class, String.class}, new Object[]{tipoProtocollo, tipoSoggetto, nomeSoggetto, isReferente, isErogatore, tag});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return 0;
            }
        }
        return this.driver.countAccordiServizio(tipoProtocollo, tipoSoggetto, nomeSoggetto, isReferente, isErogatore, tag);
    }

    @Override
    public List<AccordoServizioParteSpecifica> getServizi(String tipoProtocollo, String uriAccordoServizio, String tipoSoggetto, String nomeSoggetto) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, uriAccordoServizio, tipoSoggetto, nomeSoggetto);
            String methodName = "getServizi";
            try {
                return (List)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class, String.class, String.class, String.class}, new Object[]{tipoProtocollo, uriAccordoServizio, tipoSoggetto, nomeSoggetto});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.getServizi(tipoProtocollo, uriAccordoServizio, tipoSoggetto, nomeSoggetto);
    }

    @Override
    public List<IDServizio> getServizi(String protocolloSelezionato, List<String> protocolliSupportati, String tipoServizio, String nomeServizio, Integer versioneServizio, String tag) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(protocolloSelezionato, protocolliSupportati, tipoServizio, nomeServizio, versioneServizio, tag);
            String methodName = "getServizi";
            try {
                return (List)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class, List.class, String.class, String.class, Integer.class, String.class}, new Object[]{protocolloSelezionato, protocolliSupportati, tipoServizio, nomeServizio, versioneServizio, tag});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.getServizi(protocolloSelezionato, protocolliSupportati, tipoServizio, nomeServizio, versioneServizio, tag);
    }

    @Override
    public List<AccordoServizioParteSpecifica> getServizi(String tipoProtocollo, String uriAccordoServizio, String tipoSoggetto, String nomeSoggetto, String val) {
        DynamicUtilsServiceCache cache = null;
        boolean debug = false;
        if (val == null || StringUtils.isEmpty((CharSequence)val)) {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_datiConfigurazione;
        } else {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_ricercheConfigurazione;
        }
        if (cache != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, uriAccordoServizio, tipoSoggetto, nomeSoggetto, "VAL:" + val);
            String methodName = "getServizi";
            try {
                return (List)cache.getObjectCache(this.driver, debug, key, methodName, new Class[]{String.class, String.class, String.class, String.class, String.class}, new Object[]{tipoProtocollo, uriAccordoServizio, tipoSoggetto, nomeSoggetto, val});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.getServizi(tipoProtocollo, uriAccordoServizio, tipoSoggetto, nomeSoggetto, val);
    }

    @Override
    public List<AccordoServizioParteSpecifica> getServizi(String tipoProtocollo, String uriAccordoServizio, String tipoSoggetto, String nomeSoggetto, String val, Boolean searchTipo) {
        DynamicUtilsServiceCache cache = null;
        boolean debug = false;
        if (val == null || StringUtils.isEmpty((CharSequence)val)) {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_datiConfigurazione;
        } else {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_ricercheConfigurazione;
        }
        if (cache != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, uriAccordoServizio, tipoSoggetto, nomeSoggetto, "VAL:" + val, "searchTipo:" + searchTipo);
            String methodName = "getServizi";
            try {
                return (List)cache.getObjectCache(this.driver, debug, key, methodName, new Class[]{String.class, String.class, String.class, String.class, String.class, Boolean.class}, new Object[]{tipoProtocollo, uriAccordoServizio, tipoSoggetto, nomeSoggetto, val, searchTipo});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.getServizi(tipoProtocollo, uriAccordoServizio, tipoSoggetto, nomeSoggetto, val, searchTipo);
    }

    @Override
    public int countServizi(String tipoProtocollo, String uriAccordoServizio, String tipoSoggetto, String nomeSoggetto) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, uriAccordoServizio, tipoSoggetto, nomeSoggetto);
            String methodName = "countServizi";
            try {
                return (Integer)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class, String.class, String.class, String.class}, new Object[]{tipoProtocollo, uriAccordoServizio, tipoSoggetto, nomeSoggetto});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return 0;
            }
        }
        return this.driver.countServizi(tipoProtocollo, uriAccordoServizio, tipoSoggetto, nomeSoggetto);
    }

    @Override
    public List<Soggetto> getSoggettiErogatoreAutoComplete(String tipoProtocollo, String uriAccordoServizio, String input) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, uriAccordoServizio, "input:" + input);
            String methodName = "getSoggettiErogatoreAutoComplete";
            try {
                return (List)AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_ricercheConfigurazione, key, methodName, new Class[]{String.class, String.class, String.class}, new Object[]{tipoProtocollo, uriAccordoServizio, input});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.getSoggettiErogatoreAutoComplete(tipoProtocollo, uriAccordoServizio, input);
    }

    @Override
    public List<Soggetto> getSoggettiFruitoreAutoComplete(String tipoProtocollo, String uriAccordoServizio, String input) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, uriAccordoServizio, "input:" + input);
            String methodName = "getSoggettiFruitoreAutoComplete";
            try {
                return (List)AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_ricercheConfigurazione, key, methodName, new Class[]{String.class, String.class, String.class}, new Object[]{tipoProtocollo, uriAccordoServizio, input});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.getSoggettiFruitoreAutoComplete(tipoProtocollo, uriAccordoServizio, input);
    }

    @Override
    public AccordoServizioParteSpecifica getAspsFromValues(String tipoServizio, String nomeServizio, String tipoErogatore, String nomeErogatore, Integer versioneServizio) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio);
            String methodName = "getAspsFromValues";
            try {
                return (AccordoServizioParteSpecifica)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class, String.class, String.class, String.class, Integer.class}, new Object[]{tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.getAspsFromValues(tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio);
    }

    @Override
    public AccordoServizioParteSpecifica getAspsFromId(Long idServizio) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(idServizio);
            String methodName = "getAspsFromId";
            try {
                return (AccordoServizioParteSpecifica)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{Long.class}, new Object[]{idServizio});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.getAspsFromId(idServizio);
    }

    @Override
    public List<IDServizio> getServiziErogazione(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, String val, Boolean searchTipo, PermessiUtenteOperatore permessiUtenteOperatore, Boolean distinct) {
        DynamicUtilsServiceCache cache = null;
        boolean debug = false;
        if (val == null || StringUtils.isEmpty((CharSequence)val)) {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_datiConfigurazione;
        } else {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_ricercheConfigurazione;
        }
        if (cache != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, tipoSoggetto, nomeSoggetto, "VAL:" + val, "searchTipo:" + searchTipo, "permessi:" + String.valueOf(permessiUtenteOperatore), "distinct:" + distinct);
            String methodName = "getServiziErogazione";
            try {
                return (List)cache.getObjectCache(this.driver, debug, key, methodName, new Class[]{String.class, String.class, String.class, String.class, Boolean.class, PermessiUtenteOperatore.class, Boolean.class}, new Object[]{tipoProtocollo, tipoSoggetto, nomeSoggetto, val, searchTipo, permessiUtenteOperatore, distinct});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.getServiziErogazione(tipoProtocollo, tipoSoggetto, nomeSoggetto, val, searchTipo, permessiUtenteOperatore, distinct);
    }

    @Override
    public List<IDServizio> getServiziErogazione(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, String tipoServizio, String nomeServizio, String tipoErogatore, String nomeErogatore, Integer versioneServizio, String nomeAzione, String val, Boolean searchTipo, PermessiUtenteOperatore permessiUtenteOperatore, Boolean distinct) {
        DynamicUtilsServiceCache cache = null;
        boolean debug = false;
        if (val == null || StringUtils.isEmpty((CharSequence)val)) {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_datiConfigurazione;
        } else {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_ricercheConfigurazione;
        }
        if (cache != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, nomeAzione, "VAL:" + val, "searchTipo:" + searchTipo, "permessi:" + String.valueOf(permessiUtenteOperatore), "distinct:" + distinct);
            String methodName = "getServiziErogazione";
            try {
                return (List)cache.getObjectCache(this.driver, debug, key, methodName, new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, Integer.class, String.class, String.class, Boolean.class, PermessiUtenteOperatore.class, Boolean.class}, new Object[]{tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, nomeAzione, val, searchTipo, permessiUtenteOperatore, distinct});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.getServiziErogazione(tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, nomeAzione, val, searchTipo, permessiUtenteOperatore, distinct);
    }

    @Override
    public int countServiziErogazione(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, String val, Boolean searchTipo, PermessiUtenteOperatore permessiUtenteOperatore) {
        DynamicUtilsServiceCache cache = null;
        boolean debug = false;
        if (val == null || StringUtils.isEmpty((CharSequence)val)) {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_datiConfigurazione;
        } else {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_ricercheConfigurazione;
        }
        if (cache != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, tipoSoggetto, nomeSoggetto, "VAL:" + val, "searchTipo:" + searchTipo, "permessi:" + String.valueOf(permessiUtenteOperatore));
            String methodName = "countServiziErogazione";
            try {
                return (Integer)cache.getObjectCache(this.driver, debug, key, methodName, new Class[]{String.class, String.class, String.class, String.class, Boolean.class, PermessiUtenteOperatore.class}, new Object[]{tipoProtocollo, tipoSoggetto, nomeSoggetto, val, searchTipo, permessiUtenteOperatore});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return 0;
            }
        }
        return this.driver.countServiziErogazione(tipoProtocollo, tipoSoggetto, nomeSoggetto, val, searchTipo, permessiUtenteOperatore);
    }

    @Override
    public List<IDServizio> getConfigurazioneServiziErogazione(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, String val, Boolean searchTipo, PermessiUtenteOperatore permessiUtenteOperatore, Boolean distinct) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, tipoSoggetto, nomeSoggetto, "VAL:" + val, "searchTipo:" + searchTipo, "permessi:" + String.valueOf(permessiUtenteOperatore), "distinct:" + distinct);
            String methodName = "getConfigurazioneServiziErogazione";
            try {
                return (List)AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_ricercheConfigurazione, key, methodName, new Class[]{String.class, String.class, String.class, String.class, Boolean.class, PermessiUtenteOperatore.class, Boolean.class}, new Object[]{tipoProtocollo, tipoSoggetto, nomeSoggetto, val, searchTipo, permessiUtenteOperatore, distinct});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.getConfigurazioneServiziErogazione(tipoProtocollo, tipoSoggetto, nomeSoggetto, val, searchTipo, permessiUtenteOperatore, distinct);
    }

    @Override
    public List<IDServizio> getConfigurazioneServiziErogazione(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, String tipoServizio, String nomeServizio, String tipoErogatore, String nomeErogatore, Integer versioneServizio, String nomeAzione, String val, Boolean searchTipo, PermessiUtenteOperatore permessiUtenteOperatore, Boolean distinct) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, nomeAzione, "VAL:" + val, "searchTipo:" + searchTipo, "permessi:" + String.valueOf(permessiUtenteOperatore), "distinct:" + distinct);
            String methodName = "getConfigurazioneServiziErogazione";
            try {
                return (List)AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_ricercheConfigurazione, key, methodName, new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, Integer.class, String.class, String.class, Boolean.class, PermessiUtenteOperatore.class, Boolean.class}, new Object[]{tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, nomeAzione, val, searchTipo, permessiUtenteOperatore, distinct});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.getConfigurazioneServiziErogazione(tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, nomeAzione, val, searchTipo, permessiUtenteOperatore, distinct);
    }

    @Override
    public int countConfigurazioneServiziErogazione(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, String tipoServizio, String nomeServizio, String tipoErogatore, String nomeErogatore, Integer versioneServizio, String nomeAzione, String val, Boolean searchTipo, PermessiUtenteOperatore permessiUtenteOperatore) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, nomeAzione, "VAL: " + val, "searchTipo:" + searchTipo, "permessi:" + String.valueOf(permessiUtenteOperatore));
            String methodName = "countConfigurazioneServiziErogazione";
            try {
                return (Integer)AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_ricercheConfigurazione, key, methodName, new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, Integer.class, String.class, String.class, Boolean.class, PermessiUtenteOperatore.class}, new Object[]{tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, nomeAzione, val, searchTipo, permessiUtenteOperatore});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return 0;
            }
        }
        return this.driver.countConfigurazioneServiziErogazione(tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, nomeAzione, val, searchTipo, permessiUtenteOperatore);
    }

    @Override
    public List<IDServizio> getServiziFruizione(String tipoProtocollo, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String val, Boolean searchTipo, PermessiUtenteOperatore permessiUtenteOperatore, Boolean distinct) {
        DynamicUtilsServiceCache cache = null;
        boolean debug = false;
        if (val == null || StringUtils.isEmpty((CharSequence)val)) {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_datiConfigurazione;
        } else {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_ricercheConfigurazione;
        }
        if (cache != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, tipoSoggettoErogatore, nomeSoggettoErogatore, "VAL:" + val, "searchTipo:" + searchTipo, "permessi:" + String.valueOf(permessiUtenteOperatore), "distinct:" + distinct);
            String methodName = "getServiziFruizione";
            try {
                return (List)cache.getObjectCache(this.driver, debug, key, methodName, new Class[]{String.class, String.class, String.class, String.class, Boolean.class, PermessiUtenteOperatore.class, Boolean.class}, new Object[]{tipoProtocollo, tipoSoggettoErogatore, nomeSoggettoErogatore, val, searchTipo, permessiUtenteOperatore, distinct});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.getServiziFruizione(tipoProtocollo, tipoSoggettoErogatore, nomeSoggettoErogatore, val, searchTipo, permessiUtenteOperatore, distinct);
    }

    @Override
    public List<IDServizio> getServiziFruizione(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio, String nomeAzione, String val, Boolean searchTipo, PermessiUtenteOperatore permessiUtenteOperatore, Boolean distinct) {
        DynamicUtilsServiceCache cache = null;
        boolean debug = false;
        if (val == null || StringUtils.isEmpty((CharSequence)val)) {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_datiConfigurazione;
        } else {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_ricercheConfigurazione;
        }
        if (cache != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoSoggettoErogatore, nomeSoggettoErogatore, tipoServizio, nomeServizio, versioneServizio, nomeAzione, "VAL:" + val, "searchTipo:" + searchTipo, "permessi:" + String.valueOf(permessiUtenteOperatore), "distinct:" + distinct);
            String methodName = "getServiziFruizione";
            try {
                return (List)cache.getObjectCache(this.driver, debug, key, methodName, new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, Integer.class, String.class, String.class, Boolean.class, PermessiUtenteOperatore.class, Boolean.class}, new Object[]{tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoSoggettoErogatore, nomeSoggettoErogatore, tipoServizio, nomeServizio, versioneServizio, nomeAzione, val, searchTipo, permessiUtenteOperatore, distinct});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.getServiziFruizione(tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoSoggettoErogatore, nomeSoggettoErogatore, tipoServizio, nomeServizio, versioneServizio, nomeAzione, val, searchTipo, permessiUtenteOperatore, distinct);
    }

    @Override
    public int countServiziFruizione(String tipoProtocollo, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String val, Boolean searchTipo, PermessiUtenteOperatore permessiUtenteOperatore) {
        DynamicUtilsServiceCache cache = null;
        boolean debug = false;
        if (val == null || StringUtils.isEmpty((CharSequence)val)) {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_datiConfigurazione;
        } else {
            cache = AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione;
            debug = AbstractConsoleStartupListener.debugCache_ricercheConfigurazione;
        }
        if (cache != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, tipoSoggettoErogatore, nomeSoggettoErogatore, "VAL:" + val, "searchTipo:" + searchTipo, "permessi:" + String.valueOf(permessiUtenteOperatore));
            String methodName = "countServiziFruizione";
            try {
                return (Integer)cache.getObjectCache(this.driver, debug, key, methodName, new Class[]{String.class, String.class, String.class, String.class, Boolean.class, PermessiUtenteOperatore.class}, new Object[]{tipoProtocollo, tipoSoggettoErogatore, nomeSoggettoErogatore, val, searchTipo, permessiUtenteOperatore});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return 0;
            }
        }
        return this.driver.countServiziFruizione(tipoProtocollo, tipoSoggettoErogatore, nomeSoggettoErogatore, val, searchTipo, permessiUtenteOperatore);
    }

    @Override
    public List<IDServizio> getConfigurazioneServiziFruizione(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, String tipoServizio, String nomeServizio, String tipoErogatore, String nomeErogatore, Integer versioneServizio, String nomeAzione, String val, Boolean searchTipo, PermessiUtenteOperatore permessiUtenteOperatore, Boolean distinct) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, nomeAzione, "VAL:" + val, "searchTipo:" + searchTipo, "permessi:" + String.valueOf(permessiUtenteOperatore), "distinct:" + distinct);
            String methodName = "getConfigurazioneServiziFruizione";
            try {
                return (List)AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_ricercheConfigurazione, key, methodName, new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, Integer.class, String.class, String.class, Boolean.class, PermessiUtenteOperatore.class, Boolean.class}, new Object[]{tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, nomeAzione, val, searchTipo, permessiUtenteOperatore, distinct});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.getConfigurazioneServiziFruizione(tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, nomeAzione, val, searchTipo, permessiUtenteOperatore, distinct);
    }

    @Override
    public int countConfigurazioneServiziFruizione(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, String tipoServizio, String nomeServizio, String tipoErogatore, String nomeErogatore, Integer versioneServizio, String nomeAzione, String val, Boolean searchTipo, PermessiUtenteOperatore permessiUtenteOperatore) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione != null) {
            String key = DynamicUtilsService.buildKey(tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, nomeAzione, "VAL:" + val, "searchTipo:" + searchTipo, "permessi:" + String.valueOf(permessiUtenteOperatore));
            String methodName = "countConfigurazioneServiziFruizione";
            try {
                return (Integer)AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_ricercheConfigurazione, key, methodName, new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, Integer.class, String.class, String.class, Boolean.class, PermessiUtenteOperatore.class}, new Object[]{tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, nomeAzione, val, searchTipo, permessiUtenteOperatore});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return 0;
            }
        }
        return this.driver.countConfigurazioneServiziFruizione(tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, nomeAzione, val, searchTipo, permessiUtenteOperatore);
    }

    @Override
    public PortaDelegata getPortaDelegata(String nomePorta) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey("PD", nomePorta);
            String methodName = "getPortaDelegata";
            try {
                return (PortaDelegata)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class}, new Object[]{nomePorta});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.getPortaDelegata(nomePorta);
    }

    @Override
    public PortaApplicativa getPortaApplicativa(String nomePorta) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey("PA", nomePorta);
            String methodName = "getPortaApplicativa";
            try {
                return (PortaApplicativa)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class}, new Object[]{nomePorta});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.getPortaApplicativa(nomePorta);
    }

    @Override
    public MappingFruizionePortaDelegata getMappingFruizione(IDServizio idServizio, IDSoggetto idSoggetto, IDPortaDelegata idPortaDelegata) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey("MappingFruizionePD", "idServizio:" + String.valueOf(idServizio), "idSoggetto:" + String.valueOf(idSoggetto), "idPD:" + String.valueOf(idPortaDelegata));
            String methodName = "getMappingFruizione";
            try {
                return (MappingFruizionePortaDelegata)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{IDServizio.class, IDSoggetto.class, IDPortaDelegata.class}, new Object[]{idServizio, idSoggetto, idPortaDelegata});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.getMappingFruizione(idServizio, idSoggetto, idPortaDelegata);
    }

    @Override
    public MappingErogazionePortaApplicativa getMappingErogazione(IDServizio idServizio, IDPortaApplicativa idPortaApplicativa) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey("MappingErogazionePA", "idServizio:" + String.valueOf(idServizio), "idPA:" + String.valueOf(idPortaApplicativa));
            String methodName = "getMappingErogazione";
            try {
                return (MappingErogazionePortaApplicativa)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{IDServizio.class, IDPortaApplicativa.class}, new Object[]{idServizio, idPortaApplicativa});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.getMappingErogazione(idServizio, idPortaApplicativa);
    }

    @Override
    public Plugin getPlugin(IdPlugin idPlugin) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey("Plugin", "tipoPlugin:" + idPlugin.getTipoPlugin(), "tipo:" + idPlugin.getTipo());
            String methodName = "getPlugin";
            try {
                return (Plugin)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{IdPlugin.class}, new Object[]{idPlugin});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.driver.getPlugin(idPlugin);
    }

    @Override
    public boolean existsFaseTracciamentoDBRequestIn(boolean erogazioni, boolean fruizioni) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey("existsFaseTracciamentoDBRequestIn", "erogazioni:" + erogazioni, "fruizioni:" + fruizioni);
            String methodName = "existsFaseTracciamentoDBRequestIn";
            try {
                return (Boolean)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{Boolean.TYPE, Boolean.TYPE}, new Object[]{erogazioni, fruizioni});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return false;
            }
        }
        return this.driver.existsFaseTracciamentoDBRequestIn(erogazioni, fruizioni);
    }

    @Override
    public boolean existsFaseTracciamentoDBRequestOut(boolean erogazioni, boolean fruizioni) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey("existsFaseTracciamentoDBRequestOut", "erogazioni:" + erogazioni, "fruizioni:" + fruizioni);
            String methodName = "existsFaseTracciamentoDBRequestOut";
            try {
                return (Boolean)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{Boolean.TYPE, Boolean.TYPE}, new Object[]{erogazioni, fruizioni});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return false;
            }
        }
        return this.driver.existsFaseTracciamentoDBRequestOut(erogazioni, fruizioni);
    }

    @Override
    public boolean existsFaseTracciamentoDBResponseOut(boolean erogazioni, boolean fruizioni) {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = DynamicUtilsService.buildKey("existsFaseTracciamentoDBResponseOut", "erogazioni:" + erogazioni, "fruizioni:" + fruizioni);
            String methodName = "existsFaseTracciamentoDBResponseOut";
            try {
                return (Boolean)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this.driver, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{Boolean.TYPE, Boolean.TYPE}, new Object[]{erogazioni, fruizioni});
            }
            catch (Throwable e) {
                log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return false;
            }
        }
        return this.driver.existsFaseTracciamentoDBResponseOut(erogazioni, fruizioni);
    }
}

