/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.bean;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.search.AccordoServizioParteSpecifica;
import org.openspcoop2.core.commons.search.Soggetto;
import org.openspcoop2.core.config.constants.TipoAutenticazione;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.transazioni.utils.ProjectInfo;
import org.openspcoop2.core.transazioni.utils.TipoCredenzialeMittente;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.monitor.engine.condition.EsitoUtils;
import org.openspcoop2.monitor.engine.config.ricerche.ConfigurazioneRicerca;
import org.openspcoop2.monitor.engine.config.statistiche.ConfigurazioneStatistica;
import org.openspcoop2.monitor.sdk.condition.IFilter;
import org.openspcoop2.monitor.sdk.transaction.FaseTracciamento;
import org.openspcoop2.pdd.config.ConfigurazioneNodiRuntime;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.utils.EsitiConfigUtils;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.certificate.CertificateUtils;
import org.openspcoop2.utils.certificate.PrincipalType;
import org.openspcoop2.utils.resources.MapReader;
import org.openspcoop2.web.lib.users.dao.User;
import org.openspcoop2.web.monitor.core.bean.AbstractDateSearchForm;
import org.openspcoop2.web.monitor.core.bean.LoginBean;
import org.openspcoop2.web.monitor.core.bean.UserDetailsBean;
import org.openspcoop2.web.monitor.core.constants.CaseSensitiveMatch;
import org.openspcoop2.web.monitor.core.constants.TipoMatch;
import org.openspcoop2.web.monitor.core.constants.TipoMessaggio;
import org.openspcoop2.web.monitor.core.constants.TipologiaRicerca;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.PermessiUtenteOperatore;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.dynamic.Ricerche;
import org.openspcoop2.web.monitor.core.dynamic.Statistiche;
import org.openspcoop2.web.monitor.core.exception.UserInvalidException;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.utils.DynamicPdDBeanUtils;
import org.openspcoop2.web.monitor.core.utils.MessageManager;
import org.openspcoop2.web.monitor.core.utils.MessageUtils;
import org.richfaces.model.Ordering;
import org.slf4j.Logger;

public abstract class BaseSearchForm
extends AbstractDateSearchForm {
    private boolean visualizzaIdCluster = false;
    private boolean visualizzaIdClusterAsSelectList = false;
    private List<String> listIdCluster;
    private List<String> listLabelIdCluster;
    protected String clusterId;
    private boolean visualizzaCanali = false;
    private List<String> listCanali;
    private Map<String, List<String>> mapCanaleToNodi;
    protected String canale;
    private String nomeAzione;
    private String nomeServizio;
    private TipologiaRicerca tipologiaRicerca;
    private TipologiaRicerca defaultTipologiaRicerca;
    private boolean _tipologiaRicercaEntrambiEnabled;
    private Integer esitoGruppo;
    private Integer esitoDettaglio;
    private Integer[] esitoDettaglioPersonalizzato;
    private String esitoContesto;
    private boolean escludiRichiesteScartate;
    private boolean attivoIntegrationManagerMessageBox;
    private String servizioApplicativo;
    private String idCorrelazioneApplicativa;
    private String idEgov;
    private String tipoIdMessaggio = TipoMessaggio.Richiesta.name();
    private String idTransazione;
    private String purposeId;
    private String idToken;
    private String tipoNomeMittente;
    private String tipoNomeDestinatario;
    private String tipoNomeTrafficoPerSoggetto;
    private String tipoNomeSoggettoLocale;
    private String labelTipoNomeMittente;
    private String labelTipoNomeDestinatario;
    private String labelTipoNomeTrafficoPerSoggetto;
    private String labelTipoNomeSoggettoLocale;
    private String labelApi;
    private String labelNomeServizio;
    private String labelNomeAzione;
    private String gruppo;
    private String api;
    private String nomeRicercaPersonalizzata;
    private Ricerche ricerchePersonalizzate;
    private ConfigurazioneRicerca ricercaSelezionata;
    private String nomeStatisticaPersonalizzata;
    private Statistiche statistichePersonalizzate;
    private ConfigurazioneStatistica statisticaSelezionata;
    private boolean ricerchePersonalizzateAttive = false;
    private boolean statistichePersonalizzateAttive = false;
    private String protocollo;
    protected List<SelectItem> protocolli = null;
    private String modalita = null;
    private String soggettoPddMonitor = null;
    private boolean checkSoggettoPddMonitor = true;
    private IFilter filtro;
    private String tipoRicercaSPCoop;
    private String intervalloRefresh = null;
    private int tempoMassimoRefreshLive = 0;
    private User user;
    private SortOrder sortOrder = SortOrder.DESC;
    private String sortField = null;
    private Map<String, Ordering> sortOrders = null;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private TipiDatabase tipoDatabase = null;
    private String riconoscimento = null;
    private String autenticazione = null;
    private String identificazione = null;
    private String tokenClaim = null;
    private String valoreRiconoscimento = null;
    private TipoMatch mittenteMatchingType = TipoMatch.EQUALS;
    private CaseSensitiveMatch mittenteCaseSensitiveType = CaseSensitiveMatch.SENSITIVE;
    private String clientAddressMode = null;
    private boolean isSearchFormEsitoConsegnaMultiplaEnabled = true;
    private boolean isCloned = false;
    private String protocolCloned = null;
    private String tipoNomeSoggettoLocaleCloned = null;
    private String labelAzione = null;

    public TipiDatabase getDatabaseType() {
        return this._getTipoDatabase((IProjectInfo)ProjectInfo.getInstance());
    }

    public TipiDatabase _getTipoDatabase(IProjectInfo pfInfo) {
        if (this.tipoDatabase == null) {
            try {
                PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance(log);
                this.tipoDatabase = govwayMonitorProperties.tipoDatabase(pfInfo);
            }
            catch (Exception e) {
                log.error("Errore la get Tipo Database: " + e.getMessage(), (Throwable)e);
            }
        }
        return this.tipoDatabase;
    }

    @Override
    public String getPrintPeriodo() {
        return super.getDefaultPrintPeriodoBehaviour();
    }

    public BaseSearchForm() {
        this.tipologiaRicerca = this.getDefaultTipologiaRicercaEnum();
        this.esitoGruppo = EsitoUtils.ALL_VALUE;
        this.esitoDettaglio = EsitoUtils.ALL_VALUE;
        try {
            EsitiProperties esitiProperties = EsitiConfigUtils.getEsitiPropertiesForContext((Logger)log);
            this.esitoContesto = esitiProperties.getEsitoTransactionContextDefault() != null ? esitiProperties.getEsitoTransactionContextDefault() : "-";
        }
        catch (Exception e) {
            log.error("Errore durante l'impostazione del default per il contesto: " + e.getMessage(), (Throwable)e);
            this.esitoContesto = "-";
        }
        this.tipoRicercaSPCoop = "spcoop";
        this.setPeriodo(this.periodoDefault != null ? this.periodoDefault : "Ultimo mese");
        this.sortOrder = SortOrder.DESC;
        this.sortField = null;
        this.sortOrders = new HashMap<String, Ordering>();
        try {
            PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance(log);
            this.intervalloRefresh = govwayMonitorProperties.getIntervalloRefreshTransazioniLive();
            this.tempoMassimoRefreshLive = govwayMonitorProperties.getTempoMassimoRefreshLive();
            this.setRicerchePersonalizzateAttive(govwayMonitorProperties.isAttivoModuloRicerchePersonalizzate());
            this.setStatistichePersonalizzateAttive(govwayMonitorProperties.isAttivoModuloTransazioniStatistichePersonalizzate());
            this._tipologiaRicercaEntrambiEnabled = govwayMonitorProperties.isVisualizzaVoceEntrambiFiltroRuolo();
            this.isSearchFormEsitoConsegnaMultiplaEnabled = govwayMonitorProperties.isSearchFormEsitoConsegnaMultiplaEnabled();
            this.escludiRichiesteScartate = govwayMonitorProperties.escludiRichiesteScartateDefaultValue();
            this.attivoIntegrationManagerMessageBox = govwayMonitorProperties.isAttivoTransazioniEsitoMessageBoxIntegrationManager();
        }
        catch (Exception e) {
            log.error("Errore durante la creazione del form: " + e.getMessage(), (Throwable)e);
        }
    }

    public BaseSearchForm(boolean useInBatch) {
        this.tipologiaRicerca = this.getDefaultTipologiaRicercaEnum();
        this.esitoGruppo = EsitoUtils.ALL_VALUE;
        this.esitoDettaglio = EsitoUtils.ALL_VALUE;
        try {
            EsitiProperties esitiProperties = EsitiConfigUtils.getEsitiPropertiesForContext((Logger)log);
            this.esitoContesto = esitiProperties.getEsitoTransactionContextDefault() != null ? esitiProperties.getEsitoTransactionContextDefault() : "-";
        }
        catch (Exception e) {
            log.error("Errore durante l'impostazione del default per il contesto: " + e.getMessage(), (Throwable)e);
            this.esitoContesto = "-";
        }
        try {
            PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance(log);
            this.escludiRichiesteScartate = govwayMonitorProperties.escludiRichiesteScartateDefaultValue();
            this.attivoIntegrationManagerMessageBox = govwayMonitorProperties.isAttivoTransazioniEsitoMessageBoxIntegrationManager();
        }
        catch (Exception e) {
            log.error("Errore durante la creazione del form: " + e.getMessage(), (Throwable)e);
        }
        this.tipoRicercaSPCoop = "spcoop";
        this.setPeriodo(this.periodoDefault != null ? this.periodoDefault : "Ultimo mese");
        this.intervalloRefresh = "";
        this.tempoMassimoRefreshLive = 0;
        this.ricerchePersonalizzateAttive = false;
        this.statistichePersonalizzateAttive = false;
        this.sortOrder = SortOrder.DESC;
        this.sortField = null;
        this.sortOrders = new HashMap<String, Ordering>();
    }

    @Override
    protected String ripulisciValori() {
        this.initSearchListener(null);
        return null;
    }

    @Override
    public void initSearchListener(ActionEvent ae) {
        try {
            super.initSearchListener(ae);
            this.tipologiaRicerca = this.getDefaultTipologiaRicercaEnum();
            this.esitoGruppo = EsitoUtils.ALL_VALUE;
            this.esitoDettaglio = EsitoUtils.ALL_VALUE;
            try {
                EsitiProperties esitiProperties = EsitiConfigUtils.getEsitiPropertiesForContext((Logger)log);
                this.esitoContesto = esitiProperties.getEsitoTransactionContextDefault() != null ? esitiProperties.getEsitoTransactionContextDefault() : "-";
            }
            catch (Exception e) {
                log.error("Errore durante l'impostazione del default per il contesto: " + e.getMessage(), (Throwable)e);
                this.esitoContesto = "-";
            }
            PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance(log);
            this.escludiRichiesteScartate = govwayMonitorProperties.escludiRichiesteScartateDefaultValue();
            this.tipoRicercaSPCoop = "spcoop";
            this.setPeriodo(this.periodoDefault != null ? this.periodoDefault : "Ultimo mese");
            this._setPeriodo();
            User utente = this.getUser();
            this.aggiornaNuovaDataRicerca();
            this.nomeAzione = null;
            this.nomeRicercaPersonalizzata = null;
            this.nomeServizio = null;
            this.nomeStatisticaPersonalizzata = null;
            this.filtro = null;
            this.servizioApplicativo = null;
            this.ricercaSelezionata = null;
            this.statisticaSelezionata = null;
            this.statistichePersonalizzate = null;
            this.ricerchePersonalizzate = null;
            this.tipoNomeDestinatario = null;
            this.tipoNomeMittente = null;
            String loggedUtenteSoggettoPddMonitor = Utility.getLoggedUtenteSoggettoPddMonitor();
            this.tipoNomeSoggettoLocale = this.isShowFiltroSoggettoLocale() && "qualsiasi".equals(loggedUtenteSoggettoPddMonitor) ? null : loggedUtenteSoggettoPddMonitor;
            this.tipoNomeTrafficoPerSoggetto = null;
            this.labelTipoNomeMittente = null;
            this.labelTipoNomeDestinatario = null;
            this.labelTipoNomeTrafficoPerSoggetto = null;
            this.labelTipoNomeSoggettoLocale = null;
            this.labelApi = null;
            this.labelNomeServizio = null;
            this.labelNomeAzione = null;
            this.gruppo = null;
            this.api = null;
            this.idCorrelazioneApplicativa = null;
            this.idEgov = null;
            this.tipoIdMessaggio = TipoMessaggio.Richiesta.name();
            this.idTransazione = null;
            this.idToken = null;
            this.purposeId = null;
            this.sortOrder = SortOrder.DESC;
            this.sortField = null;
            IProtocolFactory protocolFactory = null;
            if (this.isShowListaProtocolli()) {
                String loggedUtenteModalita = Utility.getLoggedUtenteModalita();
                if ("qualsiasi".equals(loggedUtenteModalita)) {
                    if (utente.getProtocolliSupportati() != null && utente.getProtocolliSupportati().size() > 0) {
                        protocolFactory = utente.getProtocolliSupportati().contains(ProtocolFactoryManager.getInstance().getDefaultProtocolFactory().getProtocol()) ? ProtocolFactoryManager.getInstance().getDefaultProtocolFactory() : ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)utente.getProtocolliSupportati().get(0));
                    } else {
                        try {
                            protocolFactory = ProtocolFactoryManager.getInstance().getDefaultProtocolFactory();
                        }
                        catch (Exception e) {
                            log.error("Errore durante l'impostazione del default per il protocollo: " + e.getMessage(), (Throwable)e);
                        }
                    }
                } else {
                    protocolFactory = loggedUtenteModalita == null ? ProtocolFactoryManager.getInstance().getDefaultProtocolFactory() : ProtocolFactoryManager.getInstance().getProtocolFactoryByName(loggedUtenteModalita);
                }
            } else {
                protocolFactory = utente.getProtocolloSelezionatoPddMonitor() != null ? ProtocolFactoryManager.getInstance().getProtocolFactoryByName(utente.getProtocolloSelezionatoPddMonitor()) : (utente.getProtocolliSupportati() != null && utente.getProtocolliSupportati().size() > 0 ? ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)utente.getProtocolliSupportati().get(0)) : ProtocolFactoryManager.getInstance().getDefaultProtocolFactory());
            }
            if (protocolFactory != null) {
                this.protocollo = protocolFactory.getProtocol();
            }
            this.riconoscimento = null;
            this.autenticazione = null;
            this.identificazione = null;
            this.tokenClaim = null;
            this.valoreRiconoscimento = null;
            this.mittenteMatchingType = TipoMatch.EQUALS;
            this.mittenteCaseSensitiveType = CaseSensitiveMatch.SENSITIVE;
            this.clientAddressMode = "--";
        }
        catch (Throwable e) {
            log.error("Errore durante l'inizializzazione: " + e.getMessage(), e);
        }
    }

    protected void initIdClusterAndCanali(PddMonitorProperties pddMonitorProperties) throws Exception {
        List<String> pddMonitorare = pddMonitorProperties.getListaPdDMonitorate_StatusPdD();
        this.setVisualizzaIdCluster(pddMonitorare != null && pddMonitorare.size() > 1);
        this.visualizzaIdClusterAsSelectList = pddMonitorProperties.isAttivoTransazioniUtilizzoSondaPdDListAsClusterId();
        if (pddMonitorare != null && pddMonitorare.size() > 1) {
            this.listIdCluster = new ArrayList<String>();
            this.listIdCluster.add("--");
            this.listIdCluster.addAll(pddMonitorare);
            this.listLabelIdCluster = new ArrayList<String>();
            ConfigurazioneNodiRuntime config = pddMonitorProperties.getConfigurazioneNodiRuntime();
            for (String nodoRun : this.listIdCluster) {
                String descrizione = null;
                if (config.containsNode(nodoRun)) {
                    descrizione = config.getDescrizione(nodoRun);
                }
                this.listLabelIdCluster.add(descrizione != null ? descrizione : nodoRun);
            }
        }
        this.visualizzaCanali = Utility.isCanaliAbilitato();
        if (this.visualizzaCanali) {
            List<String> canali = Utility.getCanali();
            this.listCanali = new ArrayList<String>();
            this.listCanali.add("--");
            if (canali != null && !canali.isEmpty()) {
                this.listCanali.addAll(canali);
                this.mapCanaleToNodi = new HashMap<String, List<String>>();
                for (String canale : canali) {
                    List<String> nodi = Utility.getNodi(canale);
                    if (nodi == null) {
                        nodi = new ArrayList<String>();
                    }
                    this.mapCanaleToNodi.put(canale, nodi);
                }
            }
        }
    }

    public void modalitaRicercaListener(ActionEvent ae) {
        this.sortOrders = new HashMap<String, Ordering>();
    }

    public void soggettoLocaleSelected(ActionEvent ae) {
        this.setRicercaUtente("--");
        this.setServizioApplicativo(null);
    }

    public void destinatarioSelected(ActionEvent ae) {
        this.nomeServizio = null;
        this.nomeAzione = null;
        this.ricerchePersonalizzate = null;
        this.statistichePersonalizzate = null;
        this.labelApi = null;
        this.labelNomeServizio = null;
        this.labelNomeAzione = null;
    }

    public void gruppoSelected(ActionEvent ae) {
        this.nomeServizio = null;
        this.nomeAzione = null;
        this.ricercaSelezionata = null;
        this.nomeRicercaPersonalizzata = null;
        this.nomeStatisticaPersonalizzata = null;
        this.labelApi = null;
        this.labelNomeServizio = null;
        this.labelAzione = null;
        this.labelNomeAzione = null;
        this.api = null;
    }

    public void apiSelected(ActionEvent ae) {
        this.nomeServizio = null;
        this.nomeAzione = null;
        this.ricercaSelezionata = null;
        this.nomeRicercaPersonalizzata = null;
        this.nomeStatisticaPersonalizzata = null;
        this.labelNomeServizio = null;
        this.labelAzione = null;
        this.labelNomeAzione = null;
    }

    public void servizioSelected(ActionEvent ae) {
        this.nomeAzione = null;
        this.ricercaSelezionata = null;
        this.nomeRicercaPersonalizzata = null;
        this.nomeStatisticaPersonalizzata = null;
        this.labelAzione = null;
        this.labelNomeAzione = null;
    }

    public void azioneSelected(ActionEvent ae) {
        this.ricercaSelezionata = null;
        this.nomeRicercaPersonalizzata = null;
        this.nomeStatisticaPersonalizzata = null;
    }

    public void identificazioneSelected(ActionEvent ae) {
        this.servizioApplicativo = null;
    }

    public void claimSelected(ActionEvent ae) {
    }

    public void tipologiaRicercaListener(ActionEvent ae) {
        this.nomeServizio = null;
        this.nomeAzione = null;
        this.ricerchePersonalizzate = null;
        this.ricercaSelezionata = null;
        this.tipoNomeDestinatario = null;
        this.tipoNomeMittente = null;
        String loggedUtenteSoggettoPddMonitor = Utility.getLoggedUtenteSoggettoPddMonitor();
        this.tipoNomeSoggettoLocale = this.isShowFiltroSoggettoLocale() && "qualsiasi".equals(loggedUtenteSoggettoPddMonitor) ? null : loggedUtenteSoggettoPddMonitor;
        this.tipoNomeTrafficoPerSoggetto = null;
        this.labelTipoNomeMittente = null;
        this.labelTipoNomeDestinatario = null;
        this.labelTipoNomeTrafficoPerSoggetto = null;
        this.labelTipoNomeSoggettoLocale = null;
        this.labelApi = null;
        this.labelNomeServizio = null;
        this.labelNomeAzione = null;
        this.servizioApplicativo = null;
        this.riconoscimento = null;
    }

    public User getUser() {
        if (this.user != null) {
            return this.user;
        }
        return Utility.getLoggedUtente();
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getTipoMittente() {
        return Utility.parseTipoSoggetto(this.tipoNomeMittente);
    }

    public String getNomeMittente() {
        return Utility.parseNomeSoggetto(this.tipoNomeMittente);
    }

    public void setTipoNomeMittente(String tipoNomeMittente) {
        this.tipoNomeMittente = tipoNomeMittente;
        if (StringUtils.isEmpty((CharSequence)this.tipoNomeMittente) || "--".equals(this.tipoNomeMittente)) {
            this.tipoNomeMittente = null;
        }
    }

    public String getNomeAzione() {
        return this.nomeAzione;
    }

    public void setNomeAzione(String nomeAzione) {
        this.nomeAzione = nomeAzione;
        if (StringUtils.isEmpty((CharSequence)nomeAzione) || "--".equals(nomeAzione)) {
            this.nomeAzione = null;
        }
    }

    public String getNomeAzioneTooltip() {
        if (this.nomeServizio != null && this.nomeAzione != null) {
            try {
                String tipoProtocollo = this.getProtocollo();
                IDServizio idServizio = Utility.parseServizioSoggetto(this.getNomeServizio());
                Map<String, String> findAzioniFromServizio = DynamicPdDBeanUtils.getInstance(log).findAzioniFromServizio(tipoProtocollo, idServizio, null);
                if (findAzioniFromServizio.containsKey(this.nomeAzione)) {
                    return findAzioniFromServizio.get(this.nomeAzione);
                }
            }
            catch (Exception e) {
                return this.nomeAzione;
            }
        }
        return this.nomeAzione;
    }

    public String estraiNomeServizioDalServizio() {
        if (this.nomeServizio != null) {
            try {
                IDServizio idServizio = Utility.parseServizioSoggetto(this.nomeServizio);
                return idServizio.getNome();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public String estraiTipoServizioDalServizio() {
        if (this.nomeServizio != null) {
            try {
                IDServizio idServizio = Utility.parseServizioSoggetto(this.nomeServizio);
                return idServizio.getTipo();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public String estraiNomeSoggettoDalServizio() {
        if (this.nomeServizio != null) {
            try {
                IDServizio idServizio = Utility.parseServizioSoggetto(this.nomeServizio);
                return idServizio.getSoggettoErogatore() != null ? idServizio.getSoggettoErogatore().getNome() : null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public String estraiTipoSoggettoDalServizio() {
        if (this.nomeServizio != null) {
            try {
                IDServizio idServizio = Utility.parseServizioSoggetto(this.nomeServizio);
                return idServizio.getSoggettoErogatore() != null ? idServizio.getSoggettoErogatore().getTipo() : null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public Integer estraiVersioneServizioDalServizio() {
        if (this.nomeServizio != null) {
            try {
                IDServizio idServizio = Utility.parseServizioSoggetto(this.nomeServizio);
                return idServizio.getVersione();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public String getGruppoTooltip() {
        if (StringUtils.isNotEmpty((CharSequence)this.getGruppo())) {
            return this.gruppo;
        }
        return null;
    }

    public String getGruppo() {
        return this.gruppo;
    }

    public void setGruppo(String gruppo) {
        this.gruppo = gruppo;
        if (StringUtils.isEmpty((CharSequence)gruppo) || "--".equals(gruppo)) {
            this.gruppo = null;
        }
    }

    public String getApiTooltip() {
        if (StringUtils.isNotEmpty((CharSequence)this.getApi())) {
            try {
                IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(this.api);
                return NamingUtils.getLabelAccordoServizioParteComune((IDAccordo)idAccordo);
            }
            catch (Throwable throwable) {
                return this.api;
            }
        }
        return null;
    }

    public String getApi() {
        return this.api;
    }

    public void setApi(String api) {
        this.api = api;
        if (StringUtils.isEmpty((CharSequence)api) || "--".equals(api)) {
            this.api = null;
        }
    }

    public String getNomeServizioTooltip() {
        if (StringUtils.isNotEmpty((CharSequence)this.getNomeServizio())) {
            try {
                String tipoProtocollo = this.getProtocollo();
                IDServizio idServizio = Utility.parseServizioSoggetto(this.getNomeServizio());
                String nomeSoggetto = null;
                if (TipologiaRicerca.ingresso.equals((Object)this.getTipologiaRicercaEnum())) {
                    if (StringUtils.isNotBlank((CharSequence)this.getSoggettoLocale())) {
                        nomeSoggetto = this.getSoggettoLocale();
                    }
                } else if (TipologiaRicerca.uscita.equals((Object)this.getTipologiaRicercaEnum()) && StringUtils.isNotBlank((CharSequence)this.getNomeDestinatario())) {
                    nomeSoggetto = this.getNomeDestinatario();
                }
                String label = StringUtils.isEmpty(nomeSoggetto) ? NamingUtils.getLabelAccordoServizioParteSpecifica((String)tipoProtocollo, (IDServizio)idServizio) : NamingUtils.getLabelAccordoServizioParteSpecificaSenzaErogatore((String)tipoProtocollo, (String)idServizio.getTipo(), (String)idServizio.getNome(), (Integer)idServizio.getVersione());
                return label;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public String getNomeServizio() {
        return this.nomeServizio;
    }

    public void setNomeServizio(String nomeServizio) {
        this.nomeServizio = nomeServizio;
        if (StringUtils.isEmpty((CharSequence)nomeServizio) || "--".equals(nomeServizio)) {
            this.nomeServizio = null;
        }
    }

    public String getTipoDestinatario() {
        if (this.tipoNomeDestinatario != null && !"".equals(this.tipoNomeDestinatario)) {
            return Utility.parseTipoSoggetto(this.tipoNomeDestinatario);
        }
        return this.estraiTipoSoggettoDalServizio();
    }

    public String getNomeDestinatario() {
        if (this.tipoNomeDestinatario != null && !"".equals(this.tipoNomeDestinatario)) {
            return Utility.parseNomeSoggetto(this.tipoNomeDestinatario);
        }
        return this.estraiNomeSoggettoDalServizio();
    }

    public void setTipoNomeDestinatario(String nomeDestinatario) {
        this.tipoNomeDestinatario = nomeDestinatario;
        if (StringUtils.isEmpty((CharSequence)nomeDestinatario) || "--".equals(nomeDestinatario)) {
            this.tipoNomeDestinatario = null;
        }
    }

    public String getTipologiaRicerca() {
        return this.getTipologiaRicercaEnum() != null ? this.getTipologiaRicercaEnum().toString() : "";
    }

    public void setTipologiaRicerca(String tipologiaRicerca) {
        if (StringUtils.isEmpty((CharSequence)tipologiaRicerca) || "--".equals(tipologiaRicerca)) {
            this.tipologiaRicerca = null;
        } else {
            this.setTipologiaRicerca(TipologiaRicerca.valueOf(tipologiaRicerca));
        }
    }

    public TipologiaRicerca getTipologiaRicercaEnum() {
        return this.tipologiaRicerca;
    }

    public void setTipologiaRicerca(TipologiaRicerca tipologiaRicerca) {
        this.tipologiaRicerca = tipologiaRicerca;
    }

    public String getDefaultTipologiaRicerca() {
        return this.getDefaultTipologiaRicercaEnum() != null ? this.getDefaultTipologiaRicercaEnum().toString() : "";
    }

    protected boolean isTipologiaRicercaEntrambiEnabled() {
        return this._tipologiaRicercaEntrambiEnabled;
    }

    public TipologiaRicerca getDefaultTipologiaRicercaEnum() {
        if (this.defaultTipologiaRicerca != null) {
            return this.defaultTipologiaRicerca;
        }
        if (this.isTipologiaRicercaEntrambiEnabled()) {
            return TipologiaRicerca.all;
        }
        return TipologiaRicerca.ingresso;
    }

    public void setDefaultTipologiaRicerca(TipologiaRicerca defaultTipologiaRicerca) {
        this.defaultTipologiaRicerca = defaultTipologiaRicerca;
    }

    public void setDefaultTipologiaRicerca(String defaultTipologiaRicerca) {
        if (StringUtils.isEmpty((CharSequence)defaultTipologiaRicerca) || "--".equals(defaultTipologiaRicerca)) {
            this.defaultTipologiaRicerca = null;
        } else {
            this.setDefaultTipologiaRicerca(TipologiaRicerca.valueOf(defaultTipologiaRicerca));
        }
    }

    public PermessiUtenteOperatore getPermessiUtenteOperatore() throws CoreException, UserInvalidException {
        User u = this.getUser();
        UserDetailsBean user = new UserDetailsBean();
        user.setUtente(u);
        String tipoSoggettoLocale = null;
        String nomeSoggettoLocale = null;
        if (!StringUtils.isEmpty((CharSequence)this.getTipoNomeSoggettoLocale()) && !"--".equals(this.getTipoNomeSoggettoLocale())) {
            tipoSoggettoLocale = Utility.parseTipoSoggetto(this.getTipoNomeSoggettoLocale());
            nomeSoggettoLocale = Utility.parseNomeSoggetto(this.getTipoNomeSoggettoLocale());
        }
        return PermessiUtenteOperatore.getPermessiUtenteOperatore(user, tipoSoggettoLocale, nomeSoggettoLocale);
    }

    public boolean isMultitenant() {
        return Utility.isMultitenantAbilitato();
    }

    public String getTipoTrafficoPerSoggetto() {
        return Utility.parseTipoSoggetto(this.tipoNomeTrafficoPerSoggetto);
    }

    public String getTrafficoPerSoggetto() {
        return Utility.parseNomeSoggetto(this.tipoNomeTrafficoPerSoggetto);
    }

    public void setTipoNomeTrafficoPerSoggetto(String trafficoPerSoggetto) {
        this.tipoNomeTrafficoPerSoggetto = trafficoPerSoggetto;
        if (StringUtils.isEmpty((CharSequence)trafficoPerSoggetto) || "--".equals(trafficoPerSoggetto)) {
            this.tipoNomeTrafficoPerSoggetto = null;
        }
    }

    public String getTipoSoggettoLocale() {
        return Utility.parseTipoSoggetto(this.getTipoNomeSoggettoLocale());
    }

    public String getSoggettoLocale() {
        return Utility.parseNomeSoggetto(this.getTipoNomeSoggettoLocale());
    }

    public void setTipoNomeSoggettoLocale(String soggettoLocale) {
        this.tipoNomeSoggettoLocale = soggettoLocale;
        if (StringUtils.isEmpty((CharSequence)soggettoLocale) || "--".equals(soggettoLocale)) {
            this.tipoNomeSoggettoLocale = null;
        }
    }

    public List<Soggetto> getSoggettiGestione() {
        User u = this.getUser();
        return Utility.getSoggettiGestione(u, this.getTipoNomeSoggettoLocale());
    }

    public Integer getEsitoGruppo() {
        return this.esitoGruppo;
    }

    public void setEsitoGruppo(Integer esito) {
        this.esitoGruppo = esito;
        this.checkDettaglio();
        this.checkDettaglioPersonalizzato();
    }

    public Integer getEsitoDettaglio() {
        return this.esitoDettaglio;
    }

    public void setEsitoDettaglio(Integer esito) {
        this.esitoDettaglio = esito;
        this.checkDettaglio();
    }

    public Integer[] getEsitoDettaglioPersonalizzato() {
        return this.esitoDettaglioPersonalizzato;
    }

    public void setEsitoDettaglioPersonalizzato(Integer[] esitoDettaglioPersonalizzato) {
        this.esitoDettaglioPersonalizzato = esitoDettaglioPersonalizzato;
    }

    public boolean isShowRichiesteScartate() {
        return this.esitoGruppo != null && (EsitoUtils.ALL_VALUE.intValue() == this.esitoGruppo.intValue() || EsitoUtils.ALL_ERROR_VALUE.intValue() == this.esitoGruppo.intValue() || EsitoUtils.ALL_ERROR_FAULT_APPLICATIVO_VALUE.intValue() == this.esitoGruppo.intValue());
    }

    private void checkDettaglio() {
        if (this.esitoDettaglio != null && EsitoUtils.ALL_VALUE.intValue() != this.esitoDettaglio.intValue()) {
            if (this.esitoGruppo != null && EsitoUtils.ALL_VALUE.intValue() != this.esitoGruppo.intValue()) {
                try {
                    EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)log, (String)this.getSafeProtocol());
                    List codes = null;
                    if (EsitoUtils.ALL_ERROR_VALUE.intValue() == this.esitoGruppo.intValue()) {
                        codes = esitiProperties.getEsitiCodeKo_senzaFaultApplicativo();
                    } else if (EsitoUtils.ALL_FAULT_APPLICATIVO_VALUE.intValue() == this.esitoGruppo.intValue()) {
                        codes = esitiProperties.getEsitiCodeFaultApplicativo();
                    } else if (EsitoUtils.ALL_OK_VALUE.intValue() == this.esitoGruppo.intValue()) {
                        codes = esitiProperties.getEsitiCodeOk_senzaFaultApplicativo();
                    } else if (EsitoUtils.ALL_PERSONALIZZATO_VALUE.intValue() == this.esitoGruppo.intValue()) {
                        this.esitoDettaglio = EsitoUtils.ALL_VALUE;
                    } else if (EsitoUtils.ALL_ERROR_FAULT_APPLICATIVO_VALUE.intValue() == this.esitoGruppo.intValue()) {
                        codes = esitiProperties.getEsitiCodeKo();
                        codes.addAll(esitiProperties.getEsitiCodeFaultApplicativo());
                    } else if (EsitoUtils.ALL_ERROR_CONSEGNA_VALUE.intValue() == this.esitoGruppo.intValue()) {
                        codes = esitiProperties.getEsitiCodeErroriConsegna();
                    } else if (EsitoUtils.ALL_ERROR_RICHIESTE_SCARTATE_VALUE.intValue() == this.esitoGruppo.intValue()) {
                        codes = esitiProperties.getEsitiCodeRichiestaScartate();
                    }
                    if (this.escludiRichiesteScartate) {
                        List escludiEsitiRichiesteMalformate = esitiProperties.getEsitiCodeRichiestaScartate();
                        boolean found = false;
                        if (escludiEsitiRichiesteMalformate != null) {
                            for (Integer code : escludiEsitiRichiesteMalformate) {
                                if (code == null || this.esitoDettaglio == null || code.intValue() != this.esitoDettaglio.intValue()) continue;
                                found = true;
                                break;
                            }
                        }
                        if (found) {
                            this.esitoDettaglio = EsitoUtils.ALL_VALUE;
                        }
                    }
                    boolean found = false;
                    if (codes != null) {
                        for (Integer code : codes) {
                            if (code == null || this.esitoDettaglio == null || code.intValue() != this.esitoDettaglio.intValue()) continue;
                            found = true;
                            break;
                        }
                    }
                    if (!found) {
                        this.esitoDettaglio = EsitoUtils.ALL_VALUE;
                    }
                }
                catch (Exception e) {
                    this.esitoDettaglio = EsitoUtils.ALL_VALUE;
                    log.error("Errore durante il controllo della compatibilit\u00e0 del dettaglio esito " + e.getMessage(), (Throwable)e);
                }
            } else if (this.escludiRichiesteScartate) {
                try {
                    EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)log, (String)this.getSafeProtocol());
                    List escludiEsitiRichiesteMalformate = esitiProperties.getEsitiCodeRichiestaScartate();
                    boolean found = false;
                    if (escludiEsitiRichiesteMalformate != null) {
                        for (Integer code : escludiEsitiRichiesteMalformate) {
                            if (code == null || this.esitoDettaglio == null || code.intValue() != this.esitoDettaglio.intValue()) continue;
                            found = true;
                            break;
                        }
                    }
                    if (found) {
                        this.esitoDettaglio = EsitoUtils.ALL_VALUE;
                    }
                }
                catch (Exception e) {
                    this.esitoDettaglio = EsitoUtils.ALL_VALUE;
                    log.error("Errore durante il controllo della compatibilit\u00e0 del dettaglio esito " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void checkDettaglioPersonalizzato() {
    }

    public String getEsitoContesto() {
        return this.esitoContesto;
    }

    public void setEsitoContesto(String esitoContesto) {
        this.esitoContesto = esitoContesto;
    }

    public boolean isEscludiRichiesteScartate() {
        return this.escludiRichiesteScartate;
    }

    public void setEscludiRichiesteScartate(boolean escludiRichiesteScartate) {
        this.escludiRichiesteScartate = escludiRichiesteScartate;
        this.checkDettaglio();
    }

    public String getTipoRicercaSPCoop() {
        return this.tipoRicercaSPCoop;
    }

    public void setTipoRicercaSPCoop(String tipoRicercaSPCoop) {
        this.tipoRicercaSPCoop = tipoRicercaSPCoop;
    }

    public BooleanNullable getTipologiaTransazioneSPCoop() {
        if ("spcoop".equals(this.tipoRicercaSPCoop)) {
            return BooleanNullable.TRUE();
        }
        if ("im".equals(this.tipoRicercaSPCoop)) {
            return BooleanNullable.FALSE();
        }
        return BooleanNullable.NULL();
    }

    public String getServizioApplicativo() {
        return this.servizioApplicativo;
    }

    public void setServizioApplicativo(String servizioApplicativo) {
        this.servizioApplicativo = servizioApplicativo;
        if (StringUtils.isEmpty((CharSequence)servizioApplicativo) || "--".equals(servizioApplicativo)) {
            this.servizioApplicativo = null;
        }
    }

    public String getNomeRicercaPersonalizzata() {
        return this.nomeRicercaPersonalizzata;
    }

    public void setNomeRicercaPersonalizzata(String nomeRicercaPersonalizzata) {
        if ("--".equals(nomeRicercaPersonalizzata)) {
            nomeRicercaPersonalizzata = null;
        }
        this.nomeRicercaPersonalizzata = nomeRicercaPersonalizzata;
    }

    public Ricerche getRicerchePersonalizzate() {
        return this.ricerchePersonalizzate;
    }

    public void setRicerchePersonalizzate(Ricerche ricerchePersonalizzate) {
        this.ricerchePersonalizzate = ricerchePersonalizzate;
    }

    public ConfigurazioneRicerca getRicercaSelezionata() {
        return this.ricercaSelezionata;
    }

    public void ricercaSelezionataListener(ActionEvent ae) {
        this.ricercaSelezionata = this.ricerchePersonalizzate.getRicercaByLabel(this.nomeRicercaPersonalizzata);
    }

    protected boolean validateForm() {
        return this.validateForm(false);
    }

    protected boolean validateForm(boolean statsSASValidazioneDatiMittente) {
        boolean sezioneDatiMittente;
        if (this.getPeriodo().equals("Personalizzato")) {
            if (this.getDataInizio() == null) {
                MessageUtils.addErrorMsg("Selezionare Data Inizio");
                return false;
            }
            if (this.getDataFine() == null) {
                MessageUtils.addErrorMsg("Selezionare Data Fine");
                return false;
            }
        }
        if (!statsSASValidazioneDatiMittente ? !(sezioneDatiMittente = this.validaSezioneDatiMittente()) : !(sezioneDatiMittente = this.validaSezioneDatiMittenteCustom())) {
            return false;
        }
        if (this.esitoGruppo != null && EsitoUtils.ALL_PERSONALIZZATO_VALUE.intValue() == this.esitoGruppo.intValue() && (this.esitoDettaglioPersonalizzato == null || this.esitoDettaglioPersonalizzato.length <= 0)) {
            MessageUtils.addErrorMsg("Selezionare almeno un esito di dettaglio");
            return false;
        }
        return true;
    }

    public String validaSezioneDatiMittenteAction() {
        this.validaSezioneDatiMittente();
        return null;
    }

    public String validaSezioneDatiMittenteCustomAction() {
        this.validaSezioneDatiMittenteCustom();
        return null;
    }

    public boolean validaSezioneDatiMittente() {
        if (StringUtils.isNotEmpty((CharSequence)this.getRiconoscimento())) {
            if (this.getRiconoscimento().equals("soggetto")) {
                if (StringUtils.isEmpty((CharSequence)this.getTipoNomeMittente())) {
                    MessageUtils.addErrorMsg(MessageManager.getInstance().getMessage("commons.search.missing_parameters.soggetto"));
                    return false;
                }
            } else if (this.getRiconoscimento().equals("applicativo")) {
                if (StringUtils.isEmpty((CharSequence)this.getIdentificazione())) {
                    MessageUtils.addErrorMsg(MessageManager.getInstance().getMessage("commons.search.missing_parameters.identificazione"));
                    return false;
                }
                if (StringUtils.isEmpty((CharSequence)this.getServizioApplicativo())) {
                    MessageUtils.addErrorMsg(MessageManager.getInstance().getMessage("commons.search.missing_parameters.applicativo"));
                    return false;
                }
            } else if (this.getRiconoscimento().equals("identificativoAutenticato")) {
                if (StringUtils.isEmpty((CharSequence)this.getAutenticazione())) {
                    MessageUtils.addErrorMsg(MessageManager.getInstance().getMessage("commons.search.missing_parameters.autenticazione"));
                    return false;
                }
                if (StringUtils.isEmpty((CharSequence)this.getValoreRiconoscimento())) {
                    MessageUtils.addErrorMsg(MessageManager.getInstance().getMessage("commons.search.missing_parameters.id"));
                    return false;
                }
                TipoMatch match = TipoMatch.valueOf(this.getMittenteMatchingType());
                boolean ricercaEsatta = TipoMatch.EQUALS.equals((Object)match);
                if (TipoAutenticazione.SSL.getValue().equalsIgnoreCase(this.getAutenticazione()) && ricercaEsatta) {
                    try {
                        CertificateUtils.validaPrincipal((String)this.getValoreRiconoscimento(), (PrincipalType)PrincipalType.SUBJECT);
                    }
                    catch (UtilsException e) {
                        MessageUtils.addErrorMsg(MessageManager.getInstance().getMessage("commons.search.missing_parameters.ssl.subject"));
                        return false;
                    }
                }
            } else if (this.getRiconoscimento().equals("ip")) {
                if (StringUtils.isEmpty((CharSequence)this.getValoreRiconoscimento())) {
                    MessageUtils.addErrorMsg(MessageManager.getInstance().getMessage("commons.search.missing_parameters.indirizzoIP"));
                    return false;
                }
            } else {
                if (StringUtils.isEmpty((CharSequence)this.getTokenClaim())) {
                    MessageUtils.addErrorMsg(MessageManager.getInstance().getMessage("commons.search.missing_parameters.claim"));
                    return false;
                }
                if (StringUtils.isEmpty((CharSequence)this.getValoreRiconoscimento())) {
                    MessageUtils.addErrorMsg(MessageManager.getInstance().getMessage("commons.search.missing_parameters.valore"));
                    return false;
                }
            }
        }
        return true;
    }

    public boolean validaSezioneDatiMittenteCustom() {
        return true;
    }

    @Override
    protected String eseguiFiltra() {
        if (!this.validateForm()) {
            return null;
        }
        return null;
    }

    public void setFiltro(IFilter filtro) {
        this.filtro = filtro;
    }

    public IFilter getFiltro() {
        return this.filtro;
    }

    public Statistiche getStatistichePersonalizzate() {
        return this.statistichePersonalizzate;
    }

    public ConfigurazioneStatistica getStatisticaSelezionata() {
        return this.statisticaSelezionata;
    }

    public void setStatistichePersonalizzate(Statistiche statistichePersonalizzate) {
        this.statistichePersonalizzate = statistichePersonalizzate;
    }

    public void setStatisticaSelezionata(ConfigurazioneStatistica statisticaSelezionata) {
        this.statisticaSelezionata = statisticaSelezionata;
    }

    public String getNomeStatisticaPersonalizzata() {
        return this.nomeStatisticaPersonalizzata;
    }

    public void setNomeStatisticaPersonalizzata(String nomeStatisticaPersonalizzata) {
        if ("--".equals(nomeStatisticaPersonalizzata)) {
            nomeStatisticaPersonalizzata = null;
        }
        this.nomeStatisticaPersonalizzata = nomeStatisticaPersonalizzata;
    }

    public void statisticaSelezionataListener(ActionEvent ae) {
        this.statisticaSelezionata = this.statistichePersonalizzate.getStatisticaByLabel(this.nomeStatisticaPersonalizzata);
    }

    public void setRicercaSelezionata(ConfigurazioneRicerca ricercaSelezionata) {
        this.ricercaSelezionata = ricercaSelezionata;
    }

    public String getIdCorrelazioneApplicativa() {
        return this.idCorrelazioneApplicativa;
    }

    public void setIdCorrelazioneApplicativa(String idCorrelazioneApplicativa) {
        this.idCorrelazioneApplicativa = idCorrelazioneApplicativa;
        if (StringUtils.isEmpty((CharSequence)this.idCorrelazioneApplicativa) || "--".equals(this.idCorrelazioneApplicativa)) {
            this.idCorrelazioneApplicativa = null;
        }
    }

    public String getIdEgov() {
        return this.idEgov;
    }

    public void setIdEgov(String idEgov) {
        this.idEgov = idEgov;
    }

    public String getTipoIdMessaggio() {
        if (this.tipoIdMessaggio == null) {
            this.tipoIdMessaggio = TipoMessaggio.Richiesta.name();
        }
        return this.tipoIdMessaggio;
    }

    public void setTipoIdMessaggio(String tipoIdMessaggio) {
        this.tipoIdMessaggio = tipoIdMessaggio;
    }

    public String getIdTransazione() {
        return this.idTransazione;
    }

    public void setIdTransazione(String idTransazione) {
        this.idTransazione = idTransazione;
    }

    public String getPurposeId() {
        return this.purposeId;
    }

    public void setPurposeId(String purposeId) {
        this.purposeId = purposeId;
    }

    public String getIdToken() {
        return this.idToken;
    }

    public void setIdToken(String idToken) {
        this.idToken = idToken;
    }

    public List<SelectItem> getEsitiGruppo() {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        try {
            EsitoUtils esitoUtils = new EsitoUtils(log, this.getSafeProtocol());
            list.add(new SelectItem((Object)EsitoUtils.ALL_VALUE, esitoUtils.getEsitoLabelFromValue((Object)EsitoUtils.ALL_VALUE, false)));
            list.add(new SelectItem((Object)EsitoUtils.ALL_ERROR_VALUE, esitoUtils.getEsitoLabelFromValue((Object)EsitoUtils.ALL_ERROR_VALUE, false)));
            list.add(new SelectItem((Object)EsitoUtils.ALL_FAULT_APPLICATIVO_VALUE, esitoUtils.getEsitoLabelFromValue((Object)EsitoUtils.ALL_FAULT_APPLICATIVO_VALUE, false)));
            list.add(new SelectItem((Object)EsitoUtils.ALL_ERROR_FAULT_APPLICATIVO_VALUE, esitoUtils.getEsitoLabelFromValue((Object)EsitoUtils.ALL_ERROR_FAULT_APPLICATIVO_VALUE, false)));
            list.add(new SelectItem((Object)EsitoUtils.ALL_ERROR_CONSEGNA_VALUE, esitoUtils.getEsitoLabelFromValue((Object)EsitoUtils.ALL_ERROR_CONSEGNA_VALUE, false)));
            list.add(new SelectItem((Object)EsitoUtils.ALL_ERROR_RICHIESTE_SCARTATE_VALUE, esitoUtils.getEsitoLabelFromValue((Object)EsitoUtils.ALL_ERROR_RICHIESTE_SCARTATE_VALUE, false)));
            list.add(new SelectItem((Object)EsitoUtils.ALL_OK_VALUE, esitoUtils.getEsitoLabelFromValue((Object)EsitoUtils.ALL_OK_VALUE, false)));
            list.add(new SelectItem((Object)EsitoUtils.ALL_PERSONALIZZATO_VALUE, esitoUtils.getEsitoLabelFromValue((Object)EsitoUtils.ALL_PERSONALIZZATO_VALUE, false)));
            return list;
        }
        catch (Exception e) {
            log.error("Errore durante il recupero della lista dei gruppi di esito " + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public boolean isShowDettaglioPersonalizzato() {
        return this.esitoGruppo != null && EsitoUtils.ALL_PERSONALIZZATO_VALUE.intValue() == this.esitoGruppo.intValue();
    }

    public boolean isShowDettaglio() {
        return this.esitoGruppo != null && EsitoUtils.ALL_FAULT_APPLICATIVO_VALUE.intValue() != this.esitoGruppo.intValue() && !this.isShowDettaglioPersonalizzato();
    }

    public List<SelectItem> getEsitiDettaglio(boolean statistiche) {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        try {
            List escludiEsiti_tmp;
            EsitoUtils esitoUtils = new EsitoUtils(log, this.getSafeProtocol());
            list.add(new SelectItem((Object)EsitoUtils.ALL_VALUE, esitoUtils.getEsitoLabelFromValue((Object)EsitoUtils.ALL_VALUE, statistiche)));
            EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)log, (String)this.getSafeProtocol());
            List esiti = esitiProperties.getEsitiCodeOrderLabel();
            List esitiFiltro = null;
            if (this.esitoGruppo != null) {
                if (EsitoUtils.ALL_OK_VALUE.intValue() == this.esitoGruppo.intValue()) {
                    esitiFiltro = esitiProperties.getEsitiCodeOk_senzaFaultApplicativo();
                } else if (EsitoUtils.ALL_ERROR_VALUE.intValue() == this.esitoGruppo.intValue()) {
                    esitiFiltro = esitiProperties.getEsitiCodeKo_senzaFaultApplicativo();
                } else if (EsitoUtils.ALL_ERROR_FAULT_APPLICATIVO_VALUE.intValue() == this.esitoGruppo.intValue()) {
                    esitiFiltro = esitiProperties.getEsitiCodeKo();
                } else if (EsitoUtils.ALL_ERROR_CONSEGNA_VALUE.intValue() == this.esitoGruppo.intValue()) {
                    esitiFiltro = esitiProperties.getEsitiCodeErroriConsegna();
                } else if (EsitoUtils.ALL_ERROR_RICHIESTE_SCARTATE_VALUE.intValue() == this.esitoGruppo.intValue()) {
                    esitiFiltro = esitiProperties.getEsitiCodeRichiestaScartate();
                }
            }
            ArrayList<Integer> escludiEsiti = null;
            if (this.escludiRichiesteScartate && this.esitoGruppo != null && EsitoUtils.ALL_ERROR_RICHIESTE_SCARTATE_VALUE.intValue() != this.esitoGruppo.intValue() && (escludiEsiti_tmp = esitiProperties.getEsitiCodeRichiestaScartate()) != null && !escludiEsiti_tmp.isEmpty()) {
                escludiEsiti = new ArrayList();
                escludiEsiti.addAll(escludiEsiti_tmp);
            }
            if (!this.isSearchFormEsitoConsegnaMultiplaEnabled) {
                if (escludiEsiti == null) {
                    escludiEsiti = new ArrayList<Integer>();
                }
                escludiEsiti.add(esitiProperties.convertoToCode(EsitoTransazioneName.CONSEGNA_MULTIPLA));
                escludiEsiti.add(esitiProperties.convertoToCode(EsitoTransazioneName.CONSEGNA_MULTIPLA_IN_CORSO));
                escludiEsiti.add(esitiProperties.convertoToCode(EsitoTransazioneName.CONSEGNA_MULTIPLA_COMPLETATA));
                escludiEsiti.add(esitiProperties.convertoToCode(EsitoTransazioneName.CONSEGNA_MULTIPLA_FALLITA));
            }
            for (Integer esito : esiti) {
                boolean found;
                if (esitiFiltro != null) {
                    found = false;
                    for (Integer esitoFiltro : esitiFiltro) {
                        if (esitoFiltro.intValue() != esito.intValue()) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                }
                if (escludiEsiti != null) {
                    found = false;
                    for (Integer checkEsito : escludiEsiti) {
                        if (checkEsito.intValue() != esito.intValue()) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                }
                String name = esitiProperties.getEsitoName(esito);
                EsitoTransazioneName esitoTransactionName = EsitoTransazioneName.convertoTo((String)name);
                if (statistiche && EsitoTransazioneName.isStatiConsegnaMultipla((EsitoTransazioneName)esitoTransactionName)) continue;
                SelectItem si = new SelectItem((Object)esito, esitoUtils.getEsitoLabelFromValue((Object)esito, statistiche));
                boolean pddSpecific = EsitoTransazioneName.isPddSpecific((EsitoTransazioneName)esitoTransactionName);
                boolean integrationManagerSavedInMessageBox = false;
                if (pddSpecific && (integrationManagerSavedInMessageBox = EsitoTransazioneName.isSavedInMessageBox((EsitoTransazioneName)esitoTransactionName)) && !this.attivoIntegrationManagerMessageBox) continue;
                boolean integrationManagerSpecific = EsitoTransazioneName.isIntegrationManagerSpecific((EsitoTransazioneName)esitoTransactionName);
                if ("spcoop".equals(this.tipoRicercaSPCoop)) {
                    if (!pddSpecific && integrationManagerSpecific) continue;
                    list.add(si);
                    continue;
                }
                if ("im".equals(this.tipoRicercaSPCoop)) {
                    if (!integrationManagerSpecific && pddSpecific) continue;
                    list.add(si);
                    continue;
                }
                list.add(si);
            }
        }
        catch (Exception e) {
            log.error("Errore durante il recupero della lista del dettaglio esito " + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return list;
    }

    protected List<Integer> getEsitiOrderLabel() throws Exception {
        EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)log, (String)this.getSafeProtocol());
        List esiti = esitiProperties.getEsitiCodeOrderLabel();
        return esiti;
    }

    public List<SelectItem> getEsitiDettagliPersonalizzati(boolean statistiche) {
        try {
            ArrayList<SelectItem> list = new ArrayList<SelectItem>();
            EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)log, (String)this.getSafeProtocol());
            List<Integer> esiti = this.getEsitiOrderLabel();
            for (Integer esito : esiti) {
                String name = esitiProperties.getEsitoName(esito);
                EsitoTransazioneName esitoTransactionName = EsitoTransazioneName.convertoTo((String)name);
                if (!this.isSearchFormEsitoConsegnaMultiplaEnabled && EsitoTransazioneName.isConsegnaMultipla((EsitoTransazioneName)esitoTransactionName) || statistiche && EsitoTransazioneName.isStatiConsegnaMultipla((EsitoTransazioneName)esitoTransactionName)) continue;
                SelectItem si = new SelectItem((Object)esito, esitiProperties.getEsitoLabel(esito));
                boolean pddSpecific = EsitoTransazioneName.isPddSpecific((EsitoTransazioneName)esitoTransactionName);
                boolean integrationManagerSavedInMessageBox = false;
                if (pddSpecific && (integrationManagerSavedInMessageBox = EsitoTransazioneName.isSavedInMessageBox((EsitoTransazioneName)esitoTransactionName)) && !this.attivoIntegrationManagerMessageBox) continue;
                boolean integrationManagerSpecific = EsitoTransazioneName.isIntegrationManagerSpecific((EsitoTransazioneName)esitoTransactionName);
                if ("spcoop".equals(this.tipoRicercaSPCoop)) {
                    if (!pddSpecific && integrationManagerSpecific) continue;
                    list.add(si);
                    continue;
                }
                if ("im".equals(this.tipoRicercaSPCoop)) {
                    if (!integrationManagerSpecific && pddSpecific) continue;
                    list.add(si);
                    continue;
                }
                list.add(si);
            }
            return list;
        }
        catch (Exception e) {
            log.error("Errore durante il recupero della lista del dettaglio esito personalizzato " + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public boolean isShowEsitiContesto() {
        return this.getEsitiContesto().size() > 2;
    }

    public List<SelectItem> getEsitiContesto() {
        return this.getEsitiContesto(false);
    }

    public List<SelectItem> getEsitiContesto(boolean addFasi) {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        try {
            EsitoUtils esitoUtils = new EsitoUtils(log, this.getSafeProtocol());
            list.add(new SelectItem((Object)"-", esitoUtils.getEsitoContestoLabelFromValue((Object)"-")));
            boolean addReqIn = false;
            boolean addReqOut = false;
            boolean addResOut = false;
            if (addFasi) {
                boolean erogazioni = !TipologiaRicerca.uscita.equals((Object)this.tipologiaRicerca);
                boolean fruizioni = !TipologiaRicerca.ingresso.equals((Object)this.tipologiaRicerca);
                addReqIn = DynamicPdDBeanUtils.getInstance(log).existsFaseTracciamentoDBRequestIn(erogazioni, fruizioni);
                addReqOut = DynamicPdDBeanUtils.getInstance(log).existsFaseTracciamentoDBRequestOut(erogazioni, fruizioni);
                addResOut = DynamicPdDBeanUtils.getInstance(log).existsFaseTracciamentoDBResponseOut(erogazioni, fruizioni);
            }
            this.addEsitiContesto(addReqIn, addReqOut, addResOut, esitoUtils, list);
        }
        catch (Exception e) {
            throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    private void addEsitiContesto(boolean addReqIn, boolean addReqOut, boolean addResOut, EsitoUtils esitoUtils, ArrayList<SelectItem> list) throws ProtocolException {
        EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)log, (String)this.getSafeProtocol());
        List esiti = esitiProperties.getEsitiTransactionContextCodeOrderLabel();
        for (String esito : esiti) {
            this.addEsitoContesto(addReqIn, addReqOut, addResOut, esitoUtils, list, esito, esiti);
        }
    }

    private void addEsitoContesto(boolean addReqIn, boolean addReqOut, boolean addResOut, EsitoUtils esitoUtils, ArrayList<SelectItem> list, String esito, List<String> esiti) {
        this.addEsitoContestoFasiIntermedie(addReqIn, addReqOut, addResOut, esitoUtils, list, esito, esiti);
        Object label = esitoUtils.getEsitoContestoLabelFromValue((Object)esito);
        if (addReqIn || addReqOut || addResOut) {
            label = esiti.size() > 1 ? (String)label + " - Risposta consegnata" : "Risposta consegnata";
        }
        SelectItem si = new SelectItem((Object)esito, (String)label);
        list.add(si);
    }

    private void addEsitoContestoFasiIntermedie(boolean addReqIn, boolean addReqOut, boolean addResOut, EsitoUtils esitoUtils, ArrayList<SelectItem> list, String esito, List<String> esiti) {
        SelectItem si;
        Object label;
        if (addReqIn) {
            label = esitoUtils.getEsitoContestoLabelFromValue((Object)esito);
            label = esiti.size() > 1 ? (String)label + " - Richiesta ricevuta" : "Richiesta ricevuta";
            si = new SelectItem((Object)EsitoUtils.buildEsitoContext((String)esito, (FaseTracciamento)FaseTracciamento.IN_REQUEST), (String)label);
            list.add(si);
        }
        if (addReqOut) {
            label = esitoUtils.getEsitoContestoLabelFromValue((Object)esito);
            label = esiti.size() > 1 ? (String)label + " - Richiesta in consegna" : "Richiesta in consegna";
            si = new SelectItem((Object)EsitoUtils.buildEsitoContext((String)esito, (FaseTracciamento)FaseTracciamento.OUT_REQUEST), (String)label);
            list.add(si);
        }
        if (addResOut) {
            label = esitoUtils.getEsitoContestoLabelFromValue((Object)esito);
            label = esiti.size() > 1 ? (String)label + " - Risposta in consegna" : "Risposta in consegna";
            si = new SelectItem((Object)EsitoUtils.buildEsitoContext((String)esito, (FaseTracciamento)FaseTracciamento.OUT_RESPONSE), (String)label);
            list.add(si);
        }
    }

    public List<SelectItem> getTipiIdMessaggio() {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        list.add(new SelectItem((Object)TipoMessaggio.Richiesta.name(), TipoMessaggio.Richiesta.getLabel()));
        list.add(new SelectItem((Object)TipoMessaggio.Risposta.name(), TipoMessaggio.Risposta.getLabel()));
        list.add(new SelectItem((Object)TipoMessaggio.Collaborazione.name(), TipoMessaggio.Collaborazione.getLabel()));
        list.add(new SelectItem((Object)TipoMessaggio.RiferimentoRichiesta.name(), TipoMessaggio.RiferimentoRichiesta.getLabel()));
        return list;
    }

    public List<SelectItem> getTipiIdCorrelazioneApplicativa() {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        list.add(new SelectItem((Object)TipoMessaggio.Richiesta.name(), TipoMessaggio.Richiesta.getLabel()));
        list.add(new SelectItem((Object)TipoMessaggio.Risposta.name(), TipoMessaggio.Risposta.getLabel()));
        return list;
    }

    public String getTipoNomeMittente() {
        return this.tipoNomeMittente;
    }

    public String getTipoNomeDestinatario() {
        return this.tipoNomeDestinatario;
    }

    public String getTipoNomeTrafficoPerSoggetto() {
        return this.tipoNomeTrafficoPerSoggetto;
    }

    public String getTipoNomeSoggettoLocale() {
        if (this.isCloned) {
            return this.tipoNomeSoggettoLocaleCloned;
        }
        if (!this.getSoggettoPddMonitor().equals("qualsiasi")) {
            this.setTipoNomeSoggettoLocale(Utility.getLoginBean().getSoggettoPddMonitor());
        }
        return this.tipoNomeSoggettoLocale;
    }

    public String getTipoNomeMittenteTooltip() {
        if (StringUtils.isNotEmpty((CharSequence)this.tipoNomeMittente)) {
            try {
                String tipoProtocollo = this.getProtocollo();
                IDSoggetto idSoggetto = new IDSoggetto();
                idSoggetto.setTipo(this.getTipoMittente());
                idSoggetto.setNome(this.getNomeMittente());
                String label = NamingUtils.getLabelSoggetto((String)tipoProtocollo, (IDSoggetto)idSoggetto);
                return label;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.tipoNomeMittente;
    }

    public String getTipoNomeDestinatarioTooltip() {
        if (StringUtils.isNotEmpty((CharSequence)this.tipoNomeDestinatario)) {
            try {
                String tipoProtocollo = this.getProtocollo();
                IDSoggetto idSoggetto = new IDSoggetto();
                idSoggetto.setTipo(this.getTipoDestinatario());
                idSoggetto.setNome(this.getNomeDestinatario());
                String label = NamingUtils.getLabelSoggetto((String)tipoProtocollo, (IDSoggetto)idSoggetto);
                return label;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.tipoNomeDestinatario;
    }

    public String getTipoNomeTrafficoPerSoggettoTooltip() {
        if (StringUtils.isNotEmpty((CharSequence)this.tipoNomeTrafficoPerSoggetto)) {
            try {
                String tipoProtocollo = this.getProtocollo();
                IDSoggetto idSoggetto = new IDSoggetto();
                idSoggetto.setTipo(this.getTipoTrafficoPerSoggetto());
                idSoggetto.setNome(this.getTrafficoPerSoggetto());
                String label = NamingUtils.getLabelSoggetto((String)tipoProtocollo, (IDSoggetto)idSoggetto);
                return label;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.tipoNomeTrafficoPerSoggetto;
    }

    public String getTipoNomeSoggettoLocaleTooltip() {
        if (StringUtils.isNotEmpty((CharSequence)this.getTipoNomeSoggettoLocale())) {
            try {
                String tipoProtocollo = this.getProtocollo();
                IDSoggetto idSoggetto = new IDSoggetto();
                idSoggetto.setTipo(this.getTipoSoggettoLocale());
                idSoggetto.setNome(this.getSoggettoLocale());
                String label = NamingUtils.getLabelSoggetto((String)tipoProtocollo, (IDSoggetto)idSoggetto);
                return label;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.getTipoNomeSoggettoLocale();
    }

    public String getIntervalloRefresh() {
        return this.intervalloRefresh;
    }

    public void setIntervalloRefresh(String intervalloRefresh) {
        this.intervalloRefresh = intervalloRefresh;
    }

    public boolean isRicerchePersonalizzateAttive() {
        return this.ricerchePersonalizzateAttive;
    }

    public void setRicerchePersonalizzateAttive(boolean ricerchePersonalizzateAttive) {
        this.ricerchePersonalizzateAttive = ricerchePersonalizzateAttive;
    }

    public boolean isStatistichePersonalizzateAttive() {
        return this.statistichePersonalizzateAttive;
    }

    public void setStatistichePersonalizzateAttive(boolean statistichePersonalizzateAttive) {
        this.statistichePersonalizzateAttive = statistichePersonalizzateAttive;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getModalita() {
        if (this.modalita == null) {
            return Utility.getLoginBean().getModalita();
        }
        return this.modalita;
    }

    public void setModalita(String modalita) {
        this.modalita = modalita;
    }

    public boolean isCloned() {
        return this.isCloned;
    }

    public void saveProtocollo() {
        this.protocolCloned = this.protocollo;
        this.tipoNomeSoggettoLocaleCloned = this.tipoNomeSoggettoLocale;
        this.isCloned = true;
    }

    public String getProtocollo() {
        if (this.isCloned) {
            return this.protocolCloned;
        }
        if (!this.getModalita().equals("qualsiasi")) {
            this.setProtocollo(Utility.getLoginBean().getModalita());
        }
        return this.protocollo;
    }

    public void setProtocollo(String protocollo) {
        this.protocollo = protocollo;
        if (StringUtils.isEmpty((CharSequence)protocollo) || "*".equals(protocollo)) {
            this.protocollo = null;
        }
    }

    public List<SelectItem> getProtocolli() throws Exception {
        this.protocolli = new ArrayList<SelectItem>();
        try {
            ProtocolFactoryManager pfManager = ProtocolFactoryManager.getInstance();
            MapReader protocolFactories = pfManager.getProtocolFactories();
            List<String> listaNomiProtocolli = Utility.getProtocolli(this.getUser(), pfManager, protocolFactories, true);
            for (String protocolKey : listaNomiProtocolli) {
                IProtocolFactory protocollo = (IProtocolFactory)protocolFactories.get((Object)protocolKey);
                this.protocolli.add(new SelectItem((Object)protocollo.getProtocol(), NamingUtils.getLabelProtocollo((String)protocollo.getProtocol())));
            }
        }
        catch (ProtocolException e) {
            log.error("Si e' verificato un errore durante il caricamento della lista protocolli: " + e.getMessage(), (Throwable)e);
        }
        return this.protocolli;
    }

    public boolean isShowListaProtocolli() {
        try {
            ProtocolFactoryManager pfManager = ProtocolFactoryManager.getInstance();
            MapReader protocolFactories = pfManager.getProtocolFactories();
            int numeroProtocolli = protocolFactories.size();
            if (numeroProtocolli == 1) {
                return false;
            }
            User utente = this.getUser();
            if (utente.getProtocolloSelezionatoPddMonitor() != null) {
                return false;
            }
            if (utente.getProtocolliSupportati() != null && utente.getProtocolliSupportati().size() <= 1) {
                return false;
            }
            List<String> listaNomiProtocolli = Utility.getProtocolli(this.getUser(), pfManager, protocolFactories, true);
            numeroProtocolli = listaNomiProtocolli.size();
            if (numeroProtocolli == 1) {
                return false;
            }
        }
        catch (Exception e) {
            log.error("Si e' verificato un errore durante il caricamento della lista protocolli: " + e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public String getSoggettoPddMonitor() {
        return this.getSoggettoPddMonitor(true);
    }

    public String getSoggettoPddMonitor(boolean checkLoginBean) {
        if (this.soggettoPddMonitor == null && checkLoginBean && this.checkSoggettoPddMonitor) {
            return Utility.getLoginBean().getSoggettoPddMonitor();
        }
        return this.soggettoPddMonitor;
    }

    public void setSoggettoPddMonitor(String soggettoPddMonitor) {
        this.soggettoPddMonitor = soggettoPddMonitor;
    }

    public void setCheckSoggettoPddMonitor(boolean checkSoggettoPddMonitor) {
        this.checkSoggettoPddMonitor = checkSoggettoPddMonitor;
    }

    public boolean isShowFiltroSoggettoLocale() {
        LoginBean lb = Utility.getLoginBean();
        if (lb == null) {
            return true;
        }
        return lb.isShowFiltroSoggettoLocale();
    }

    public boolean isSetFiltroProtocollo() {
        String protocollo = this.getProtocollo();
        boolean setFilter = StringUtils.isNotEmpty((CharSequence)protocollo) && !"qualsiasi".equals(protocollo);
        return setFilter;
    }

    public void protocolloSelected(ActionEvent ae) {
        String tipoProt = this.getProtocollo();
        this.setRicercaUtente("--");
        try {
            if (tipoProt != null) {
                String tipoErogatore = Utility.parseTipoSoggetto(this.getTipoNomeDestinatario());
                String nomeErogatore = Utility.parseNomeSoggetto(this.getTipoNomeDestinatario());
                if (nomeErogatore != null && !DynamicPdDBeanUtils.getInstance(log).isTipoSoggettoCompatibileConProtocollo(tipoErogatore, tipoProt)) {
                    this.setTipoNomeDestinatario(null);
                    this.setLabelTipoNomeDestinatario(null);
                    this.destinatarioSelected(ae);
                }
                String tipoSoggettoLocale = Utility.parseTipoSoggetto(this.getTipoNomeSoggettoLocale());
                String nomeSoggettoLocale = Utility.parseNomeSoggetto(this.getTipoNomeSoggettoLocale());
                if (nomeSoggettoLocale != null && !DynamicPdDBeanUtils.getInstance(log).isTipoSoggettoCompatibileConProtocollo(tipoSoggettoLocale, tipoProt)) {
                    this.setTipoNomeSoggettoLocale(null);
                    this.setLabelTipoNomeSoggettoLocale(null);
                    this.soggettoLocaleSelected(ae);
                }
                String tipoTrafficoPerSoggetto = Utility.parseTipoSoggetto(this.getTipoNomeTrafficoPerSoggetto());
                String nomeTrafficoPerSoggetto = Utility.parseNomeSoggetto(this.getTipoNomeTrafficoPerSoggetto());
                if (nomeTrafficoPerSoggetto != null && !DynamicPdDBeanUtils.getInstance(log).isTipoSoggettoCompatibileConProtocollo(tipoTrafficoPerSoggetto, tipoProt)) {
                    this.setTipoNomeTrafficoPerSoggetto(null);
                    this.setLabelTipoNomeTrafficoPerSoggetto(null);
                    this.destinatarioSelected(ae);
                }
                String tipoFruitore = Utility.parseTipoSoggetto(this.getTipoNomeMittente());
                String nomeFruitore = Utility.parseNomeSoggetto(this.getTipoNomeMittente());
                if (nomeFruitore != null && !DynamicPdDBeanUtils.getInstance(log).isTipoSoggettoCompatibileConProtocollo(tipoFruitore, tipoProt)) {
                    this.setTipoNomeMittente(null);
                    this.setLabelTipoNomeMittente(null);
                    this.destinatarioSelected(ae);
                }
                String tipoReferente = null;
                if (StringUtils.isNotEmpty((CharSequence)this.getApi())) {
                    IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(this.getApi());
                    tipoReferente = idAccordo.getSoggettoReferente().getTipo();
                }
                if (tipoReferente != null && !DynamicPdDBeanUtils.getInstance(log).isTipoSoggettoCompatibileConProtocollo(tipoReferente, tipoProt)) {
                    this.setApi(null);
                    this.setLabelApi(null);
                    this.apiSelected(ae);
                }
                String tipoServizio = null;
                if (StringUtils.isNotEmpty((CharSequence)this.getNomeServizio())) {
                    String tipoNomeSoggetto = this.getNomeServizio().split(" \\(")[0];
                    tipoServizio = Utility.parseTipoSoggetto(tipoNomeSoggetto);
                }
                if (tipoServizio != null && !DynamicPdDBeanUtils.getInstance(log).isTipoServizioCompatibileConProtocollo(tipoServizio, tipoProt)) {
                    this.setNomeServizio(null);
                    this.setLabelNomeServizio(null);
                    this.servizioSelected(ae);
                }
                if (this.getTipologiaRicercaEnum() != null && TipologiaRicerca.ingresso.equals((Object)this.getTipologiaRicercaEnum()) && StringUtils.isNotEmpty((CharSequence)this.getRiconoscimento()) && this.getRiconoscimento().equals("applicativo")) {
                    this.setServizioApplicativo(null);
                }
            }
        }
        catch (Exception e) {
            log.error("Si e' verificato un errore durante la selezione del protocollo:" + e.getMessage(), (Throwable)e);
        }
    }

    public Map<String, Ordering> getSortOrders() {
        return this.sortOrders;
    }

    public void setSortOrders(Map<String, Ordering> sortOrders) {
        this.sortOrders = sortOrders;
    }

    public int getTempoMassimoRefreshLive() {
        return this.tempoMassimoRefreshLive;
    }

    public void setTempoMassimoRefreshLive(int tempoMassimoRefreshLive) {
        this.tempoMassimoRefreshLive = tempoMassimoRefreshLive;
    }

    public boolean isSessioneLiveValida() {
        if (this.getDataRicercaRaw() != null) {
            Date d = new Date();
            log.debug("Controllo sessione live Attiva Da: [" + String.valueOf(this.getDataRicercaRaw()) + "] Tempo Residuo: [" + ((long)(this.tempoMassimoRefreshLive * 60000) - (d.getTime() - this.getDataRicercaRaw().getTime())) + "] ms");
            return this.getDataRicercaRaw().getTime() > d.getTime() - (long)(this.tempoMassimoRefreshLive * 60000);
        }
        return false;
    }

    public void setSessioneLiveValida(boolean sessioneLiveValida) {
        log.debug("setSessioneLiveValida {}]", (Object)sessioneLiveValida);
        if (sessioneLiveValida) {
            this.aggiornaNuovaDataRicerca();
        }
    }

    public AccordoServizioParteSpecifica getAspsFromNomeServizio(String nomeServizioOrig) {
        if (nomeServizioOrig == null) {
            return null;
        }
        try {
            IDServizio idServizio = Utility.parseServizioSoggetto(nomeServizioOrig);
            return this.getAspsFromNomeServizio(idServizio);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public AccordoServizioParteSpecifica getAspsFromNomeServizio(IDServizio idServizio) {
        AccordoServizioParteSpecifica aspsFromValues = null;
        if (idServizio == null) {
            return aspsFromValues;
        }
        try {
            String nomeServizio = idServizio.getNome();
            String tipoServizio = idServizio.getTipo();
            String nomeErogatore = idServizio.getSoggettoErogatore().getNome();
            String tipoErogatore = idServizio.getSoggettoErogatore().getTipo();
            Integer versioneServizio = idServizio.getVersione();
            aspsFromValues = DynamicPdDBeanUtils.getInstance(log).getAspsFromValues(tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return aspsFromValues;
    }

    public boolean isVisualizzaFiltroSoggettiSelectList() throws Exception {
        return PddMonitorProperties.getInstance(log).isVisualizzaFiltroSoggettiSelectList();
    }

    public boolean isExistsGruppi() throws Exception {
        String tipoProtocollo = this.getProtocollo();
        return DynamicPdDBeanUtils.getInstance(log).existsGruppi(tipoProtocollo);
    }

    public boolean isVisualizzaFiltroGruppiSelectList() throws Exception {
        return PddMonitorProperties.getInstance(log).isVisualizzaFiltroGruppiSelectList();
    }

    public boolean isVisualizzaFiltroServiziSelectList() throws Exception {
        return PddMonitorProperties.getInstance(log).isVisualizzaFiltroServiziSelectList();
    }

    public boolean isVisualizzaFiltroAzioniSelectList() throws Exception {
        return PddMonitorProperties.getInstance(log).isVisualizzaFiltroAzioniSelectList();
    }

    public String getLabelAzione() {
        if (this.labelAzione != null) {
            return this.labelAzione;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getNomeServizio())) {
            try {
                IDServizio idServizio = Utility.parseServizioSoggetto(this.getNomeServizio());
                AccordoServizioParteSpecifica asps = this.getAspsFromNomeServizio(idServizio);
                ServiceBinding serviceBinding = ServiceBinding.toEnumConstant((String)asps.getIdAccordoServizioParteComune().getServiceBinding());
                this.labelAzione = ServiceBinding.REST.equals((Object)serviceBinding) ? "Risorsa" : "Azione";
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                this.labelAzione = "Azione";
            }
        } else {
            this.labelAzione = "Azione";
        }
        return this.labelAzione;
    }

    public String getRiconoscimento() {
        return this.riconoscimento;
    }

    public void setRiconoscimento(String riconoscimento) {
        this.riconoscimento = riconoscimento;
        if (StringUtils.isEmpty((CharSequence)riconoscimento) || "--".equals(riconoscimento)) {
            this.riconoscimento = null;
        }
    }

    public List<SelectItem> getListaTipiRiconoscimento() {
        boolean searchModeByApplicativo;
        ArrayList<SelectItem> lst = new ArrayList<SelectItem>();
        lst.add(new SelectItem((Object)"--", "--"));
        boolean searchModeBySoggetto = TipologiaRicerca.ingresso.equals((Object)this.getTipologiaRicercaEnum());
        String protocolloSelezionato = this.getProtocollo();
        boolean protocolloSupportaApplicativoinErogazione = false;
        try {
            protocolloSupportaApplicativoinErogazione = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocolloSelezionato).createProtocolConfiguration().isSupportoAutenticazioneApplicativiErogazioni();
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = searchModeByApplicativo = !TipologiaRicerca.ingresso.equals((Object)this.getTipologiaRicercaEnum()) || protocolloSupportaApplicativoinErogazione;
        if (!TipologiaRicerca.ingresso.equals((Object)this.getTipologiaRicercaEnum()) && !TipologiaRicerca.uscita.equals((Object)this.getTipologiaRicercaEnum())) {
            searchModeBySoggetto = false;
            searchModeByApplicativo = false;
        }
        lst.add(new SelectItem((Object)"tokenInfo", MessageManager.getInstance().getMessage("commons.tokenInfo.label")));
        if (searchModeBySoggetto) {
            lst.add(new SelectItem((Object)"soggetto", MessageManager.getInstance().getMessage("commons.soggetto.label")));
        }
        if (searchModeByApplicativo) {
            lst.add(new SelectItem((Object)"applicativo", MessageManager.getInstance().getMessage("commons.applicativo.label")));
        }
        lst.add(new SelectItem((Object)"identificativoAutenticato", MessageManager.getInstance().getMessage("commons.identificativoAutenticato.label")));
        lst.add(new SelectItem((Object)"ip", MessageManager.getInstance().getMessage("commons.indirizzoIP.label")));
        return lst;
    }

    public String getAutenticazione() {
        return this.autenticazione;
    }

    public void setAutenticazione(String autenticazione) {
        this.autenticazione = autenticazione;
        if (StringUtils.isEmpty((CharSequence)autenticazione) || "--".equals(autenticazione)) {
            this.autenticazione = null;
        }
    }

    public List<SelectItem> getListaAutenticazioni() {
        ArrayList<SelectItem> lst = new ArrayList<SelectItem>();
        lst.add(new SelectItem((Object)"--", "--"));
        lst.add(new SelectItem((Object)TipoAutenticazione.SSL.getValue(), TipoAutenticazione.SSL.getLabel()));
        lst.add(new SelectItem((Object)TipoAutenticazione.BASIC.getValue(), TipoAutenticazione.BASIC.getLabel()));
        lst.add(new SelectItem((Object)TipoAutenticazione.APIKEY.getValue(), TipoAutenticazione.APIKEY.getLabel()));
        lst.add(new SelectItem((Object)TipoAutenticazione.PRINCIPAL.getValue(), TipoAutenticazione.PRINCIPAL.getLabel()));
        return lst;
    }

    public String getIdentificazione() {
        return this.identificazione;
    }

    public void setIdentificazione(String identificazione) {
        this.identificazione = identificazione;
        if (StringUtils.isEmpty((CharSequence)identificazione) || "--".equals(identificazione)) {
            this.identificazione = null;
        }
    }

    public List<SelectItem> getListaIdentificazioni() {
        ArrayList<SelectItem> lst = new ArrayList<SelectItem>();
        lst.add(new SelectItem((Object)"--", "--"));
        lst.add(new SelectItem((Object)"commons.identificazione.trasporto.label", MessageManager.getInstance().getMessage("commons.identificazione.trasporto.label")));
        lst.add(new SelectItem((Object)"commons.identificazione.token.label", MessageManager.getInstance().getMessage("commons.identificazione.token.label")));
        return lst;
    }

    public String getClientAddressMode() {
        if (this.clientAddressMode == null || StringUtils.isEmpty((CharSequence)this.clientAddressMode)) {
            return "--";
        }
        return this.clientAddressMode;
    }

    public void setClientAddressMode(String clientAddressMode) {
        this.clientAddressMode = clientAddressMode;
        if (StringUtils.isEmpty((CharSequence)clientAddressMode) || "--".equals(clientAddressMode)) {
            this.clientAddressMode = null;
        }
    }

    public boolean isShowPDNDFilters() {
        return TipologiaRicerca.ingresso.equals((Object)this.getTipologiaRicercaEnum()) && "modipa".equals(this.getProtocollo());
    }

    public List<SelectItem> getListaTokenClaim() {
        ArrayList<SelectItem> lst = new ArrayList<SelectItem>();
        MessageManager mm = MessageManager.getInstance();
        boolean showPDNDFilters = this.isShowPDNDFilters();
        lst.add(new SelectItem((Object)"--", "--"));
        lst.add(new SelectItem((Object)TipoCredenzialeMittente.TOKEN_ISSUER.getRawValue(), mm.getMessage("transazioni.search.sezioneFiltroRicercaLibera.tokenInfo.issuer.label")));
        lst.add(new SelectItem((Object)TipoCredenzialeMittente.TOKEN_CLIENT_ID.getRawValue(), mm.getMessage("transazioni.search.sezioneFiltroRicercaLibera.tokenInfo.clientID.label")));
        lst.add(new SelectItem((Object)TipoCredenzialeMittente.TOKEN_SUBJECT.getRawValue(), mm.getMessage("transazioni.search.sezioneFiltroRicercaLibera.tokenInfo.subject.label")));
        lst.add(new SelectItem((Object)TipoCredenzialeMittente.TOKEN_USERNAME.getRawValue(), mm.getMessage("transazioni.search.sezioneFiltroRicercaLibera.tokenInfo.username.label")));
        lst.add(new SelectItem((Object)TipoCredenzialeMittente.TOKEN_EMAIL.getRawValue(), mm.getMessage("transazioni.search.sezioneFiltroRicercaLibera.tokenInfo.email.label")));
        if (showPDNDFilters) {
            lst.add(new SelectItem((Object)TipoCredenzialeMittente.PDND_ORGANIZATION_NAME.getRawValue(), mm.getMessage("transazioni.search.sezioneFiltroRicercaLibera.pdndPrefix.organization.name.label")));
            lst.add(new SelectItem((Object)TipoCredenzialeMittente.PDND_ORGANIZATION_EXTERNAL_ID.getRawValue(), mm.getMessage("transazioni.search.sezioneFiltroRicercaLibera.pdndPrefix.organization.externalConsumerId.label")));
        }
        return lst;
    }

    public String getTokenClaim() {
        return this.tokenClaim;
    }

    public void setTokenClaim(String tokenClaim) {
        this.tokenClaim = tokenClaim;
        if (StringUtils.isEmpty((CharSequence)tokenClaim) || "--".equals(tokenClaim)) {
            this.tokenClaim = null;
        }
    }

    public String getValoreRiconoscimento() {
        return this.valoreRiconoscimento;
    }

    public void setValoreRiconoscimento(String valoreRiconoscimento) {
        this.valoreRiconoscimento = valoreRiconoscimento;
    }

    public String getMittenteMatchingType() {
        if (this.mittenteMatchingType != null) {
            return this.mittenteMatchingType.name();
        }
        return null;
    }

    public void setMittenteMatchingType(String mittenteMatchingType) {
        if (mittenteMatchingType != null) {
            this.mittenteMatchingType = TipoMatch.valueOf(mittenteMatchingType);
        }
    }

    public String getMittenteCaseSensitiveType() {
        if (this.mittenteCaseSensitiveType != null) {
            return this.mittenteCaseSensitiveType.name();
        }
        return null;
    }

    public void setMittenteCaseSensitiveType(String mittenteCaseSensitiveType) {
        if (mittenteCaseSensitiveType != null) {
            this.mittenteCaseSensitiveType = CaseSensitiveMatch.valueOf(mittenteCaseSensitiveType);
        }
    }

    public String getLabelTipoNomeMittente() {
        return this.labelTipoNomeMittente;
    }

    public void setLabelTipoNomeMittente(String labelTipoNomeMittente) {
        this.labelTipoNomeMittente = labelTipoNomeMittente;
        if (StringUtils.isEmpty((CharSequence)this.labelTipoNomeMittente) || "--".equals(this.labelTipoNomeMittente)) {
            this.labelTipoNomeMittente = null;
        }
    }

    public String getLabelTipoNomeDestinatario() {
        return this.labelTipoNomeDestinatario;
    }

    public void setLabelTipoNomeDestinatario(String labelTipoNomeDestinatario) {
        this.labelTipoNomeDestinatario = labelTipoNomeDestinatario;
        if (StringUtils.isEmpty((CharSequence)this.labelTipoNomeDestinatario) || "--".equals(this.labelTipoNomeDestinatario)) {
            this.labelTipoNomeDestinatario = null;
        }
    }

    public String getLabelTipoNomeTrafficoPerSoggetto() {
        return this.labelTipoNomeTrafficoPerSoggetto;
    }

    public void setLabelTipoNomeTrafficoPerSoggetto(String labelTipoNomeTrafficoPerSoggetto) {
        this.labelTipoNomeTrafficoPerSoggetto = labelTipoNomeTrafficoPerSoggetto;
        if (StringUtils.isEmpty((CharSequence)this.labelTipoNomeTrafficoPerSoggetto) || "--".equals(this.labelTipoNomeTrafficoPerSoggetto)) {
            this.labelTipoNomeTrafficoPerSoggetto = null;
        }
    }

    public String getLabelTipoNomeSoggettoLocale() {
        return this.labelTipoNomeSoggettoLocale;
    }

    public void setLabelTipoNomeSoggettoLocale(String labelTipoNomeSoggettoLocale) {
        this.labelTipoNomeSoggettoLocale = labelTipoNomeSoggettoLocale;
        if (StringUtils.isEmpty((CharSequence)this.labelTipoNomeSoggettoLocale) || "--".equals(this.labelTipoNomeSoggettoLocale)) {
            this.labelTipoNomeSoggettoLocale = null;
        }
    }

    public String getLabelApi() {
        return this.labelApi;
    }

    public void setLabelApi(String labelApi) {
        this.labelApi = labelApi;
        if (StringUtils.isEmpty((CharSequence)this.labelApi) || "--".equals(this.labelApi)) {
            this.labelApi = null;
        }
    }

    public String getLabelNomeServizio() {
        return this.labelNomeServizio;
    }

    public void setLabelNomeServizio(String labelNomeServizio) {
        this.labelNomeServizio = labelNomeServizio;
        if (StringUtils.isEmpty((CharSequence)this.labelNomeServizio) || "--".equals(this.labelNomeServizio)) {
            this.labelNomeServizio = null;
        }
    }

    public String getLabelNomeAzione() {
        return this.labelNomeAzione;
    }

    public void setLabelNomeAzione(String labelNomeAzione) {
        this.labelNomeAzione = labelNomeAzione;
        if (StringUtils.isEmpty((CharSequence)this.labelNomeAzione) || "--".equals(this.labelNomeAzione)) {
            this.labelNomeAzione = null;
        }
    }

    public List<SelectItem> getTipologieRicerca() {
        ArrayList<SelectItem> listaTipologie = new ArrayList<SelectItem>();
        listaTipologie.add(new SelectItem((Object)TipologiaRicerca.ingresso.toString(), "Erogazione"));
        listaTipologie.add(new SelectItem((Object)TipologiaRicerca.uscita.toString(), "Fruizione"));
        if (this.isTipologiaRicercaEntrambiEnabled()) {
            listaTipologie.add(new SelectItem((Object)TipologiaRicerca.all.toString(), "Erogazione/Fruizione"));
        }
        return listaTipologie;
    }

    public boolean isShowTipologia() {
        return true;
    }

    public String getDefaultLabelServizioApplicativo() {
        if (this.getTipologiaRicercaEnum().equals((Object)TipologiaRicerca.ingresso)) {
            if (StringUtils.isNotEmpty((CharSequence)this.getTipoNomeMittente())) {
                if (StringUtils.isNotEmpty((CharSequence)this.getIdentificazione())) {
                    return MessageManager.getInstance().getMessage("commons.search.applicativo.defaultLabel");
                }
                return MessageManager.getInstance().getMessage("commons.search.applicativo.defaultLabelNoIdentificazione");
            }
            if (StringUtils.isNotEmpty((CharSequence)this.getIdentificazione())) {
                return MessageManager.getInstance().getMessage("commons.search.applicativo.defaultLabelNoSoggettoFruitore");
            }
            String msg = MessageManager.getInstance().getMessage("commons.search.applicativo.defaultLabelNoIdentificazioneNoSoggettoFruitore");
            msg = MessageManager.getInstance().getMessage("commons.search.applicativo.defaultLabelNoIdentificazione");
            return msg;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getSoggettoLocale())) {
            if (StringUtils.isNotEmpty((CharSequence)this.getIdentificazione())) {
                return MessageManager.getInstance().getMessage("commons.search.applicativo.defaultLabel");
            }
            return MessageManager.getInstance().getMessage("commons.search.applicativo.defaultLabelNoIdentificazione");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getIdentificazione())) {
            return MessageManager.getInstance().getMessage("commons.search.applicativo.defaultLabelNoSoggettoLocal");
        }
        String msg = MessageManager.getInstance().getMessage("commons.search.applicativo.defaultLabelNoIdentificazioneNoSoggettoLocal");
        msg = MessageManager.getInstance().getMessage("commons.search.applicativo.defaultLabelNoSoggettoLocal");
        return msg;
    }

    public boolean isVisualizzaIdCluster() {
        return this.visualizzaIdCluster;
    }

    public void setVisualizzaIdCluster(boolean visualizzaIdCluster) {
        this.visualizzaIdCluster = visualizzaIdCluster;
    }

    public boolean isVisualizzaIdClusterAsSelectList() {
        return this.visualizzaIdClusterAsSelectList;
    }

    public void setVisualizzaIdClusterAsSelectList(boolean visualizzaIdClusterAsSelectList) {
        this.visualizzaIdClusterAsSelectList = visualizzaIdClusterAsSelectList;
    }

    public List<SelectItem> getListIdCluster() {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        if (this.listIdCluster != null && !this.listIdCluster.isEmpty()) {
            for (int i = 0; i < this.listIdCluster.size(); ++i) {
                List<String> nodi;
                String id = this.listIdCluster.get(i);
                if ("--".equals(id)) {
                    list.add(new SelectItem((Object)id));
                    continue;
                }
                String label = this.listLabelIdCluster.get(i);
                if (this.canale != null && !"".equals(this.canale) && !"--".equals(this.canale) && this.visualizzaCanali && this.mapCanaleToNodi != null && ((nodi = this.mapCanaleToNodi.get(this.canale)) == null || !nodi.contains(id))) continue;
                list.add(new SelectItem((Object)id, label));
            }
        }
        return list;
    }

    public String getClusterId() {
        if ("--".equals(this.clusterId)) {
            return null;
        }
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = "--".equals(clusterId) ? null : clusterId;
    }

    public boolean isVisualizzaCanali() {
        return this.visualizzaCanali;
    }

    public void setVisualizzaCanali(boolean visualizzaCanali) {
        this.visualizzaCanali = visualizzaCanali;
    }

    public List<SelectItem> getListCanali() {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        if (this.listCanali != null && !this.listCanali.isEmpty()) {
            for (String id : this.listCanali) {
                list.add(new SelectItem((Object)id));
            }
        }
        return list;
    }

    public String getCanale() {
        if ("--".equals(this.canale)) {
            return null;
        }
        return this.canale;
    }

    public void setCanale(String canale) {
        this.canale = "--".equals(canale) ? null : canale;
    }

    public List<String> getIdClusterByCanale(String canale) {
        return this.mapCanaleToNodi.get(canale);
    }

    public boolean isAllProtocol() {
        return "qualsiasi".equals(this.protocollo);
    }

    public String getSafeProtocol() {
        if (this.isCloned) {
            return this.protocolCloned;
        }
        if (this.protocollo == null || this.protocollo.equals("qualsiasi")) {
            IProtocolFactory protocolFactory;
            block10: {
                User utente = Utility.getLoggedUtente();
                protocolFactory = null;
                if (utente.getProtocolliSupportati() != null && !utente.getProtocolliSupportati().isEmpty()) {
                    try {
                        if (utente.getProtocolliSupportati().contains(ProtocolFactoryManager.getInstance().getDefaultProtocolFactory().getProtocol())) {
                            protocolFactory = ProtocolFactoryManager.getInstance().getDefaultProtocolFactory();
                            break block10;
                        }
                        protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)utente.getProtocolliSupportati().get(0));
                    }
                    catch (Exception e) {
                        log.error("Errore durante l'impostazione del default per il protocollo: " + e.getMessage(), (Throwable)e);
                    }
                } else {
                    try {
                        protocolFactory = ProtocolFactoryManager.getInstance().getDefaultProtocolFactory();
                    }
                    catch (Exception e) {
                        log.error("Errore durante l'impostazione del default per il protocollo: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            if (protocolFactory != null) {
                return protocolFactory.getProtocol();
            }
            return this.protocollo;
        }
        return this.protocollo;
    }

    @Override
    public String getProtocolloRicerca() {
        return "qualsiasi".equals(this.getProtocollo()) ? null : this.getProtocollo();
    }

    @Override
    public String getSoggettoRicerca() {
        return "qualsiasi".equals(this.getTipoNomeSoggettoLocale()) ? null : this.getTipoNomeSoggettoLocale();
    }

    @Override
    public void ripulisciRicercaUtente() {
        String currentProtocollo = this.getProtocollo();
        String currentTipoNomeSoggettoLocale = this.getTipoNomeSoggettoLocale();
        this.ripulisci();
        this.setProtocollo(currentProtocollo);
        this.setTipoNomeSoggettoLocale(currentTipoNomeSoggettoLocale);
    }

    public boolean isVisualizzaFiltroAzioni() {
        return StringUtils.isNotBlank((CharSequence)this.getNomeServizio()) || StringUtils.isNotBlank((CharSequence)this.getApi());
    }
}

