/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.xml;

import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPException;
import java.io.IOException;
import java.util.HashMap;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.utils.xml.DynamicNamespaceContext;
import org.openspcoop2.utils.xml.DynamicNamespaceContextFactory;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class MessageDynamicNamespaceContextFactory
extends DynamicNamespaceContextFactory {
    private static HashMap<String, MessageDynamicNamespaceContextFactory> dncfactoryMap = new HashMap();
    private OpenSPCoop2MessageFactory messageFactory;

    private static synchronized void init(OpenSPCoop2MessageFactory messageFactory) {
        String key = messageFactory.getClass().getName();
        if (!dncfactoryMap.containsKey(key)) {
            MessageDynamicNamespaceContextFactory fac = new MessageDynamicNamespaceContextFactory(messageFactory);
            dncfactoryMap.put(key, fac);
        }
    }

    public static MessageDynamicNamespaceContextFactory getInstance(OpenSPCoop2MessageFactory messageFactory) {
        String key = messageFactory.getClass().getName();
        if (!dncfactoryMap.containsKey(key)) {
            MessageDynamicNamespaceContextFactory.init(messageFactory);
        }
        return dncfactoryMap.get(key);
    }

    public MessageDynamicNamespaceContextFactory(OpenSPCoop2MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public DynamicNamespaceContext getNamespaceContextFromSoapEnvelope11(byte[] soapenvelope) throws SAXException, SOAPException, IOException, Exception {
        SOAPEnvelope envelope = (SOAPEnvelope)OpenSPCoop2MessageFactory.createSOAPElement(this.messageFactory, MessageType.SOAP_11, soapenvelope);
        return this.getNamespaceContextFromSoapEnvelope(MessageType.SOAP_11, envelope);
    }

    public DynamicNamespaceContext getNamespaceContextFromSoapEnvelope12(byte[] soapenvelope) throws SAXException, SOAPException, IOException, Exception {
        SOAPEnvelope envelope = (SOAPEnvelope)OpenSPCoop2MessageFactory.createSOAPElement(this.messageFactory, MessageType.SOAP_12, soapenvelope);
        return this.getNamespaceContextFromSoapEnvelope(MessageType.SOAP_12, envelope);
    }

    public DynamicNamespaceContext getNamespaceContextFromSoapEnvelope11(SOAPEnvelope soapenvelope) throws SAXException, SOAPException {
        return this.getNamespaceContextFromSoapEnvelope(MessageType.SOAP_11, soapenvelope);
    }

    public DynamicNamespaceContext getNamespaceContextFromSoapEnvelope12(SOAPEnvelope soapenvelope) throws SAXException, SOAPException {
        return this.getNamespaceContextFromSoapEnvelope(MessageType.SOAP_12, soapenvelope);
    }

    private DynamicNamespaceContext getNamespaceContextFromSoapEnvelope(MessageType messageType, SOAPEnvelope soapenvelope) throws SAXException, SOAPException {
        DynamicNamespaceContext dnc = new DynamicNamespaceContext();
        SOAPBody body = soapenvelope.getBody();
        if (body.hasFault()) {
            dnc.setSoapFault(true);
        } else if (!body.hasChildNodes()) {
            dnc.setSoapBodyEmpty(true);
        } else {
            Object prefix = null;
            try {
                prefix = OpenSPCoop2MessageFactory.getFirstChildElement(this.messageFactory, messageType, (SOAPElement)body).getPrefix();
            }
            catch (Throwable e) {
                prefix = body.getFirstChild().getPrefix();
            }
            if (prefix == null) {
                prefix = "";
            } else if (prefix != null && !"".equals(prefix)) {
                prefix = (String)prefix + ":";
            }
            dnc.setPrefixChildSoapBody((String)prefix);
        }
        dnc.findPrefixNamespace((Node)soapenvelope);
        return dnc;
    }
}

