/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.soap.dynamic;

import jakarta.activation.DataHandler;
import jakarta.xml.soap.AttachmentPart;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.soap.SOAPPart;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.openspcoop2.message.soap.AbstractOpenSPCoop2Message_saaj_impl;
import org.openspcoop2.message.soap.AbstractOpenSPCoop2Message_soap_impl;
import org.openspcoop2.message.soap.dynamic.DynamicSOAPHeader;
import org.openspcoop2.message.soap.dynamic.DynamicSOAPPart;

public class DynamicSOAPMessage<T extends AbstractOpenSPCoop2Message_saaj_impl>
extends SOAPMessage {
    private AbstractOpenSPCoop2Message_soap_impl<T> wrapped;
    private DynamicSOAPHeader<T> dynamicSoapHeader;
    private DynamicSOAPPart<T> dynamicSoapPart;

    public DynamicSOAPMessage(AbstractOpenSPCoop2Message_soap_impl<T> wrapped) {
        this.wrapped = wrapped;
    }

    private SOAPMessage _getSOAPMessage() {
        try {
            return ((AbstractOpenSPCoop2Message_saaj_impl)this.wrapped.getContent()).getSOAPMessage();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public SOAPHeader getSOAPHeader() throws SOAPException {
        if (this.wrapped.isSoapHeaderOptimizable()) {
            if (this.dynamicSoapHeader == null) {
                this.dynamicSoapHeader = new DynamicSOAPHeader<T>(this.wrapped);
            }
            return this.dynamicSoapHeader;
        }
        return this._getSOAPMessage().getSOAPHeader();
    }

    public SOAPPart getSOAPPart() {
        if (this.wrapped.isSoapHeaderOptimizable()) {
            if (this.dynamicSoapPart == null) {
                this.dynamicSoapPart = new DynamicSOAPPart<T>(this.wrapped);
            }
            return this.dynamicSoapPart;
        }
        return this._getSOAPMessage().getSOAPPart();
    }

    public void clearDynamicResources() {
        this.dynamicSoapHeader = null;
        if (this.dynamicSoapPart != null) {
            this.dynamicSoapPart.clearDynamicResources();
        }
        this.dynamicSoapPart = null;
    }

    public void addAttachmentPart(AttachmentPart arg0) {
        this._getSOAPMessage().addAttachmentPart(arg0);
    }

    public int countAttachments() {
        return this._getSOAPMessage().countAttachments();
    }

    public AttachmentPart createAttachmentPart() {
        return this._getSOAPMessage().createAttachmentPart();
    }

    public AttachmentPart getAttachment(SOAPElement arg0) throws SOAPException {
        return this._getSOAPMessage().getAttachment(arg0);
    }

    public Iterator<AttachmentPart> getAttachments() {
        return this._getSOAPMessage().getAttachments();
    }

    public Iterator<AttachmentPart> getAttachments(MimeHeaders arg0) {
        return this._getSOAPMessage().getAttachments(arg0);
    }

    public String getContentDescription() {
        return this._getSOAPMessage().getContentDescription();
    }

    public MimeHeaders getMimeHeaders() {
        return this._getSOAPMessage().getMimeHeaders();
    }

    public void removeAllAttachments() {
        this._getSOAPMessage().removeAllAttachments();
    }

    public void removeAttachments(MimeHeaders arg0) {
        this._getSOAPMessage().removeAttachments(arg0);
    }

    public void saveChanges() throws SOAPException {
        this._getSOAPMessage().saveChanges();
    }

    public boolean saveRequired() {
        return this._getSOAPMessage().saveRequired();
    }

    public void setContentDescription(String arg0) {
        this._getSOAPMessage().setContentDescription(arg0);
    }

    public void writeTo(OutputStream arg0) throws SOAPException, IOException {
        this._getSOAPMessage().writeTo(arg0);
    }

    public AttachmentPart createAttachmentPart(DataHandler dataHandler) {
        return this._getSOAPMessage().createAttachmentPart(dataHandler);
    }

    public AttachmentPart createAttachmentPart(Object content, String contentType) {
        return this._getSOAPMessage().createAttachmentPart(content, contentType);
    }

    public Object getProperty(String property) throws SOAPException {
        return this._getSOAPMessage().getProperty(property);
    }

    public SOAPBody getSOAPBody() throws SOAPException {
        return this._getSOAPMessage().getSOAPBody();
    }

    public void setProperty(String property, Object value) throws SOAPException {
        this._getSOAPMessage().setProperty(property, value);
    }
}

