/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.config;

import jakarta.mail.internet.ContentType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.message.config.AbstractMediaTypeCollection;
import org.openspcoop2.message.config.ConfigurationServiceBindingRest;
import org.openspcoop2.message.config.ConfigurationServiceBindingSoap;
import org.openspcoop2.message.config.ContextUrlCollection;
import org.openspcoop2.message.config.IntegrationErrorCollection;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;

public class ServiceBindingConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ServiceBinding defaultBinding;
    private ConfigurationServiceBindingSoap soap;
    private ConfigurationServiceBindingRest rest;
    private ContextUrlCollection contextUrlCollection;
    private Map<String, ServiceBinding> restrictedServiceBindingContextUrl = new HashMap<String, ServiceBinding>();
    private Map<String, ServiceBinding> restrictedServiceBindingServiceType = new HashMap<String, ServiceBinding>();

    public static String normalizeContext(String context) {
        if (context == null || "".equals(context)) {
            return "@EMPTY@";
        }
        return context;
    }

    public ServiceBindingConfiguration(ServiceBinding defaultBinding, ConfigurationServiceBindingSoap soap, ConfigurationServiceBindingRest rest, ContextUrlCollection contextUrlCollection) throws MessageException {
        if (defaultBinding == null) {
            throw new MessageException("Default ServiceBinding not defined");
        }
        if (soap == null) {
            throw new MessageException("SOAP-ServiceBinding not defined");
        }
        if (rest == null) {
            throw new MessageException("REST-ServiceBinding not defined");
        }
        this.defaultBinding = defaultBinding;
        this.soap = soap;
        this.rest = rest;
        this.contextUrlCollection = contextUrlCollection == null ? new ContextUrlCollection(this.soap.getBinding(), this.rest.getBinding()) : contextUrlCollection;
    }

    public ServiceBinding getDefaultBinding() {
        return this.defaultBinding;
    }

    public boolean isServiceBindingSupported(ServiceBinding serviceBinding) {
        if (ServiceBinding.SOAP.equals(serviceBinding)) {
            return this.soap.isEnabled();
        }
        return this.rest.isEnabled();
    }

    public List<MessageType> getMessageTypeSupported(ServiceBinding serviceBinding) {
        if (ServiceBinding.SOAP.equals(serviceBinding)) {
            return this.soap.getMessageTypeSupported();
        }
        return this.rest.getMessageTypeSupported();
    }

    public boolean isServiceBindingContextEnabled(ServiceBinding serviceBinding, String contextParam) {
        String context = ServiceBindingConfiguration.normalizeContext(contextParam);
        if (this.restrictedServiceBindingContextUrl.containsKey(context)) {
            if (ServiceBinding.SOAP.equals(this.restrictedServiceBindingContextUrl.get(context))) {
                return ServiceBinding.SOAP.equals(serviceBinding);
            }
            return ServiceBinding.REST.equals(serviceBinding);
        }
        return true;
    }

    public boolean isServiceBindingServiceTypeEnabled(ServiceBinding serviceBinding, String serviceType) {
        if (this.restrictedServiceBindingServiceType.containsKey(serviceType)) {
            if (ServiceBinding.SOAP.equals(this.restrictedServiceBindingServiceType.get(serviceType))) {
                return ServiceBinding.SOAP.equals(serviceBinding);
            }
            return ServiceBinding.REST.equals(serviceBinding);
        }
        return true;
    }

    public void addServiceBindingContextRestriction(ServiceBinding serviceBinding, String contextParam) {
        String context = ServiceBindingConfiguration.normalizeContext(contextParam);
        if (this.restrictedServiceBindingContextUrl.containsKey(context)) {
            this.restrictedServiceBindingContextUrl.remove(context);
        }
        this.restrictedServiceBindingContextUrl.put(context, serviceBinding);
    }

    public void addServiceBindingEmptyContextRestriction(ServiceBinding serviceBinding) {
        this.addServiceBindingContextRestriction(serviceBinding, null);
    }

    public void addServiceBindingServiceTypeRestriction(ServiceBinding serviceBinding, String serviceType) {
        if (this.restrictedServiceBindingServiceType.containsKey(serviceType)) {
            this.restrictedServiceBindingServiceType.remove(serviceType);
        }
        this.restrictedServiceBindingServiceType.put(serviceType, serviceBinding);
    }

    public IntegrationErrorCollection getInternalIntegrationErrorConfiguration(ServiceBinding serviceBinding) {
        if (ServiceBinding.SOAP.equals(serviceBinding)) {
            return this.soap.getInternalIntegrationErrorConfiguration();
        }
        return this.rest.getInternalIntegrationErrorConfiguration();
    }

    public IntegrationErrorCollection getExternalIntegrationErrorConfiguration(ServiceBinding serviceBinding) {
        if (ServiceBinding.SOAP.equals(serviceBinding)) {
            return this.soap.getExternalIntegrationErrorConfiguration();
        }
        return this.rest.getExternalIntegrationErrorConfiguration();
    }

    public boolean existsContextUrlMapping() {
        return this.contextUrlCollection != null && this.contextUrlCollection.sizeContextUrl() > 0;
    }

    public List<String> getContentTypesSupported(ServiceBinding serviceBinding, MessageRole messageType, TransportRequestContext transportContext) throws MessageException {
        return this.getContentTypesSupported(serviceBinding, messageType, transportContext.getProtocolWebContext(), transportContext.getFunction(), transportContext.getFunctionParameters());
    }

    public List<String> getContentTypesSupported(ServiceBinding serviceBinding, MessageRole messageType, String protocol, String function, String functionParameters) throws MessageException {
        AbstractMediaTypeCollection configurationFlow;
        if (serviceBinding == null) {
            throw new MessageException("ServiceBinding not defined");
        }
        if (messageType == null) {
            throw new MessageException("MessageType not defined");
        }
        if (ServiceBinding.SOAP.equals(serviceBinding)) {
            if (!this.soap.isEnabled()) {
                throw new MessageException("Typology [" + String.valueOf(serviceBinding) + "] not supported");
            }
            configurationFlow = MessageRole.REQUEST.equals(messageType) ? this.soap.getRequest() : this.soap.getResponse();
        } else {
            if (!this.rest.isEnabled()) {
                throw new MessageException("Typology [" + String.valueOf(serviceBinding) + "] not supported");
            }
            configurationFlow = MessageRole.REQUEST.equals(messageType) ? this.rest.getRequest() : this.rest.getResponse();
        }
        MessageType mpv = this.contextUrlCollection.getMessageType(protocol, function, functionParameters);
        if (mpv != null) {
            List<String> ct = this.contextUrlCollection.getContentTypesRestriction(protocol, function, functionParameters);
            if (ct == null) {
                ct = new ArrayList<String>();
            }
            if (ct.size() <= 0) {
                ct.add("*");
            }
            return ct;
        }
        return configurationFlow.getContentTypes();
    }

    public String getContentTypesSupportedAsString(ServiceBinding serviceBinding, MessageRole messageType, TransportRequestContext transportContext) throws MessageException {
        return this.getContentTypesSupportedAsString(serviceBinding, messageType, transportContext.getProtocolWebContext(), transportContext.getFunction(), transportContext.getFunctionParameters());
    }

    public String getContentTypesSupportedAsString(ServiceBinding serviceBinding, MessageRole messageType, String protocol, String function, String functionParameters) throws MessageException {
        StringBuilder bf = new StringBuilder();
        for (String ct : this.getContentTypesSupported(serviceBinding, messageType, protocol, function, functionParameters)) {
            if (bf.length() > 0) {
                bf.append(", ");
            }
            bf.append(ct);
        }
        return bf.toString();
    }

    public MessageType getRequestMessageType(ServiceBinding serviceBinding, TransportRequestContext transportContext, String contentType) throws MessageException {
        return this.getMessageType(serviceBinding, MessageRole.REQUEST, transportContext.getProtocolWebContext(), transportContext.getFunction(), transportContext.getFunctionParameters(), contentType, null);
    }

    public MessageType getResponseMessageType(ServiceBinding serviceBinding, TransportRequestContext transportContext, String contentType, Integer status) throws MessageException {
        return this.getMessageType(serviceBinding, MessageRole.RESPONSE, transportContext != null ? transportContext.getProtocolWebContext() : null, transportContext != null ? transportContext.getFunction() : null, transportContext != null ? transportContext.getFunctionParameters() : null, contentType, status);
    }

    public MessageType getMessageType(ServiceBinding serviceBinding, MessageRole messageRole, TransportRequestContext transportContext, String contentType, Integer status) throws MessageException {
        return this.getMessageType(serviceBinding, messageRole, transportContext.getProtocolWebContext(), transportContext.getFunction(), transportContext.getFunctionParameters(), contentType, status);
    }

    public MessageType getMessageType(ServiceBinding serviceBinding, MessageRole messageRole, String protocol, String function, String functionParameters, String contentType, Integer status) throws MessageException {
        if (serviceBinding == null) {
            throw new MessageException("ServiceBinding not defined");
        }
        if (messageRole == null) {
            throw new MessageException("MessageRole not defined");
        }
        String mediaType = contentType;
        boolean withAttachments = false;
        boolean mtom = false;
        if (ServiceBinding.SOAP.equals(serviceBinding) && mediaType != null) {
            try {
                if (ContentTypeUtilities.isMultipartRelated((String)mediaType)) {
                    withAttachments = true;
                    String internal = ContentTypeUtilities.getInternalMultipartContentType((String)mediaType);
                    if (internal != null && (mtom = ContentTypeUtilities.isMtom((String)(mediaType = internal)))) {
                        withAttachments = false;
                    }
                }
            }
            catch (Exception e) {
                throw new MessageException(e.getMessage(), e);
            }
        }
        try {
            if (mediaType != null) {
                ContentType ct = new ContentType(mediaType);
                mediaType = ct.getBaseType();
            }
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
        MessageType messageType = this.readMessageTypeEngine(serviceBinding, messageRole, protocol, function, functionParameters, status, mediaType);
        if (messageType != null && ServiceBinding.SOAP.equals(serviceBinding)) {
            if (withAttachments) {
                if (MessageType.SOAP_11.equals(messageType)) {
                    if (!this.soap.getBinding().isBinding_soap11_withAttachments()) {
                        throw new MessageException("SOAPWithAttachments disabled in Soap11 Binding");
                    }
                } else if (!this.soap.getBinding().isBinding_soap12_withAttachments()) {
                    throw new MessageException("SOAPWithAttachments disabled in Soap12 Binding");
                }
            }
            if (mtom) {
                if (MessageType.SOAP_11.equals(messageType)) {
                    if (!this.soap.getBinding().isBinding_soap11_mtom()) {
                        throw new MessageException("MTOM disabled in Soap11 Binding");
                    }
                } else if (!this.soap.getBinding().isBinding_soap12_mtom()) {
                    throw new MessageException("MTOM disabled in Soap12 Binding");
                }
            }
        }
        return messageType;
    }

    private MessageType readMessageTypeEngine(ServiceBinding serviceBinding, MessageRole messageRole, String protocol, String function, String functionParameters, Integer status, String mediaType) throws MessageException {
        AbstractMediaTypeCollection mediaTypeCollecton;
        MessageType messageType = this.contextUrlCollection.getMessageType(protocol, function, functionParameters);
        if (messageType != null) {
            List<String> ct = this.contextUrlCollection.getContentTypesRestriction(protocol, function, functionParameters);
            if (ct != null && ct.size() > 0) {
                if (mediaType != null && ct.contains(mediaType)) {
                    return messageType;
                }
            } else {
                return messageType;
            }
        }
        if (ServiceBinding.SOAP.equals(serviceBinding)) {
            if (!this.soap.isEnabled()) {
                throw new MessageException("Typology [" + String.valueOf(serviceBinding) + "] not supported");
            }
            mediaTypeCollecton = MessageRole.REQUEST.equals(messageRole) ? this.soap.getRequest() : this.soap.getResponse();
        } else {
            if (!this.rest.isEnabled()) {
                throw new MessageException("Typology [" + String.valueOf(serviceBinding) + "] not supported");
            }
            mediaTypeCollecton = MessageRole.REQUEST.equals(messageRole) ? this.rest.getRequest() : this.rest.getResponse();
        }
        messageType = mediaTypeCollecton.getMessageProcessor(mediaType, status);
        return messageType;
    }
}

