/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdi.validator;

import jakarta.xml.soap.SOAPElement;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.protocol.basic.validator.ValidazioneSintattica;
import org.openspcoop2.protocol.sdi.SDIBustaRawContent;
import org.openspcoop2.protocol.sdi.config.SDIProperties;
import org.openspcoop2.protocol.sdi.constants.SDICostantiServizioRiceviFile;
import org.openspcoop2.protocol.sdi.constants.SDICostantiServizioRiceviNotifica;
import org.openspcoop2.protocol.sdi.constants.SDICostantiServizioRicezioneFatture;
import org.openspcoop2.protocol.sdi.constants.SDICostantiServizioTrasmissioneFatture;
import org.openspcoop2.protocol.sdi.utils.SDIUtils;
import org.openspcoop2.protocol.sdi.validator.SDIValidatoreServizioRiceviFile;
import org.openspcoop2.protocol.sdi.validator.SDIValidatoreServizioRiceviNotifica;
import org.openspcoop2.protocol.sdi.validator.SDIValidatoreServizioRicezioneFatture;
import org.openspcoop2.protocol.sdi.validator.SDIValidatoreServizioTrasmissioneFatture;
import org.openspcoop2.protocol.sdi.validator.SDIValidazioneUtils;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.BustaRawContent;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.config.IProtocolConfiguration;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazioneErrori;
import org.openspcoop2.protocol.sdk.validator.ValidazioneSintatticaResult;

public class SDIValidazioneSintattica
extends ValidazioneSintattica<SOAPElement> {
    protected SDIValidazioneUtils validazioneUtils;
    protected SDIProperties sdiProperties;
    protected IProtocolConfiguration protocolConfiguration;
    protected List<Eccezione> erroriValidazione = new ArrayList<Eccezione>();
    protected List<Eccezione> erroriProcessamento = new ArrayList<Eccezione>();
    private CodiceErroreCooperazione codiceErrore;
    private String msgErrore;
    protected SDIBustaRawContent headerElement;

    public SDIValidazioneSintattica(IProtocolFactory<SOAPElement> factory, IState state) throws ProtocolException {
        super(factory, state);
        this.validazioneUtils = new SDIValidazioneUtils(factory);
        this.sdiProperties = SDIProperties.getInstance(this.log);
        this.protocolConfiguration = factory.createProtocolConfiguration();
    }

    public SDIBustaRawContent getBustaRawContent_senzaControlli(OpenSPCoop2Message msg) throws ProtocolException {
        try {
            SOAPElement se;
            if (msg != null && (se = SDIUtils.readHeader(msg.castAsSoap())) != null) {
                return new SDIBustaRawContent(se);
            }
            return null;
        }
        catch (Exception e) {
            this.log.debug("getHeaderProtocollo_senzaControlli error: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Busta getBusta_senzaControlli(OpenSPCoop2Message msg) throws ProtocolException {
        return null;
    }

    public ValidazioneSintatticaResult<SOAPElement> validaRichiesta(OpenSPCoop2Message msg, Busta datiBustaLettiURLMappingProperties, ProprietaValidazioneErrori proprietaValidazioneErrori) throws ProtocolException {
        ValidazioneSintatticaResult basicResult = super.validaRichiesta(msg, datiBustaLettiURLMappingProperties, proprietaValidazioneErrori);
        this.headerElement = this.getBustaRawContent_senzaControlli(msg);
        boolean isValido = this.valida(msg, basicResult.getBusta(), true, null);
        ErroreCooperazione errore = null;
        if (this.msgErrore != null && this.codiceErrore != null) {
            errore = new ErroreCooperazione(this.msgErrore, this.codiceErrore);
        }
        List<Eccezione> erroriValidazione = null;
        if (this.erroriValidazione.size() > 0) {
            erroriValidazione = this.erroriValidazione;
        }
        List erroriProcessamento = null;
        if (this.erroriProcessamento.size() > 0) {
            erroriValidazione = this.erroriProcessamento;
        }
        ValidazioneSintatticaResult result = new ValidazioneSintatticaResult(erroriValidazione, erroriProcessamento, null, basicResult.getBusta(), errore, null, (BustaRawContent)this.headerElement, isValido);
        return result;
    }

    public ValidazioneSintatticaResult<SOAPElement> validaRisposta(OpenSPCoop2Message msg, Busta bustaRichiesta, ProprietaValidazioneErrori proprietaValidazioneErrori) throws ProtocolException {
        ValidazioneSintatticaResult basicResult = super.validaRisposta(msg, bustaRichiesta, proprietaValidazioneErrori);
        boolean hasFault = false;
        try {
            hasFault = msg.castAsSoap().getSOAPBody().hasFault();
        }
        catch (Exception e) {
            throw new ProtocolException((Throwable)e);
        }
        if (hasFault) {
            return basicResult;
        }
        this.headerElement = this.getBustaRawContent_senzaControlli(msg);
        boolean isValido = this.valida(msg, basicResult.getBusta(), false, bustaRichiesta);
        ErroreCooperazione errore = null;
        if (this.msgErrore != null && this.codiceErrore != null) {
            errore = new ErroreCooperazione(this.msgErrore, this.codiceErrore);
        }
        List<Eccezione> erroriValidazione = null;
        if (this.erroriValidazione.size() > 0) {
            erroriValidazione = this.erroriValidazione;
        }
        List erroriProcessamento = null;
        if (this.erroriProcessamento.size() > 0) {
            erroriValidazione = this.erroriProcessamento;
        }
        ValidazioneSintatticaResult result = new ValidazioneSintatticaResult(erroriValidazione, erroriProcessamento, null, basicResult.getBusta(), errore, null, (BustaRawContent)this.headerElement, isValido);
        return result;
    }

    public boolean verifyProtocolPresence(TipoPdD tipoPdD, ProfiloDiCollaborazione profilo, RuoloMessaggio ruoloMessaggio, OpenSPCoop2Message msg) throws ProtocolException {
        try {
            boolean verify;
            if (msg == null) {
                return false;
            }
            if (msg.castAsSoap().getSOAPBody() == null) {
                return false;
            }
            SOAPElement child = SoapUtils.getNotEmptyFirstChildSOAPElement((SOAPElement)msg.castAsSoap().getSOAPBody());
            if (child == null) {
                return false;
            }
            String namespace = child.getNamespaceURI();
            if (namespace == null) {
                return false;
            }
            boolean bl = verify = SDICostantiServizioRiceviFile.SDI_SERVIZIO_RICEVI_FILE_NAMESPACE.equals(namespace) || SDICostantiServizioRiceviNotifica.SDI_SERVIZIO_RICEVI_NOTIFICA_NAMESPACE.equals(namespace) || SDICostantiServizioRicezioneFatture.RICEZIONE_SERVIZIO_RICEZIONE_FATTURE_NAMESPACE.equals(namespace) || SDICostantiServizioTrasmissioneFatture.TRASMISSIONE_SERVIZIO_TRASMISSIONE_FATTURE_NAMESPACE.equals(namespace);
            if (!verify) {
                if (RuoloMessaggio.RISPOSTA.equals((Object)ruoloMessaggio) && TipoPdD.DELEGATA.equals((Object)tipoPdD)) {
                    return this.sdiProperties.getNamespaceWhiteList().contains(namespace);
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean valida(OpenSPCoop2Message msg, Busta busta, boolean isRichiesta, Busta bustaRichiesta) {
        try {
            String[] propertiesNames;
            this._valida(msg, busta, isRichiesta);
            if (bustaRichiesta != null && busta.sizeProperties() > 0 && (propertiesNames = busta.getPropertiesNames()) != null) {
                for (int i = 0; i < propertiesNames.length; ++i) {
                    String key = propertiesNames[i];
                    String value = busta.getProperty(key);
                    if (key == null || value == null) continue;
                    bustaRichiesta.addProperty(key, value);
                }
            }
            if ("SdIRiceviFile".equals(busta.getServizio()) && bustaRichiesta != null && bustaRichiesta.getProperty("NomeFile") != null) {
                busta.addProperty("NomeFile", bustaRichiesta.getProperty("NomeFile"));
            }
            return true;
        }
        catch (Exception e) {
            this.msgErrore = "[ErroreInterno]: " + e.getMessage();
            this.log.error(this.msgErrore, (Throwable)e);
            this.codiceErrore = CodiceErroreCooperazione.FORMATO_NON_CORRETTO;
            return false;
        }
    }

    private void _valida(OpenSPCoop2Message msg, Busta busta, boolean isRichiesta) throws Exception {
        boolean whiteList;
        if (msg == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_NON_CORRETTO, "Messaggio non presente"));
            return;
        }
        if (msg.castAsSoap().getSOAPBody() == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_PRESENTE));
            return;
        }
        List soapBodyChilds = SoapUtils.getNotEmptyChildSOAPElement((SOAPElement)msg.castAsSoap().getSOAPBody());
        if (soapBodyChilds == null || soapBodyChilds.size() <= 0) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_PRESENTE));
            return;
        }
        if (soapBodyChilds.size() > 1) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Sono presenti pi\u00f9 elementi (" + soapBodyChilds.size() + ") all'interno del SoapBody"));
            return;
        }
        SOAPElement sdiMessage = (SOAPElement)soapBodyChilds.get(0);
        if (sdiMessage == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_PRESENTE));
            return;
        }
        if (busta == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_PRESENTE, "Informazioni di protocollo non presenti"));
            return;
        }
        if (busta.getTipoMittente() == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.TIPO_MITTENTE_NON_PRESENTE));
            return;
        }
        if (!this.protocolConfiguration.getTipiSoggetti().contains(busta.getTipoMittente())) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.TIPO_MITTENTE_SCONOSCIUTO));
            return;
        }
        if (!busta.getTipoMittente().equals(this.sdiProperties.getTipoSoggettoSDI())) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.TIPO_MITTENTE_NON_VALIDO));
            return;
        }
        if (busta.getMittente() == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.MITTENTE_NON_PRESENTE));
            return;
        }
        if (!busta.getMittente().equals(this.sdiProperties.getNomeSoggettoSDI())) {
            whiteList = false;
            if (busta.getMittente() != null && this.sdiProperties.getSoggettiWhiteList().contains(busta.getMittente())) {
                this.log.debug("Mittente [" + busta.getMittente() + "] in white list");
                whiteList = true;
            }
            if (!whiteList) {
                this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.MITTENTE_NON_VALIDO));
                return;
            }
        }
        if (busta.getTipoDestinatario() == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.TIPO_DESTINATARIO_NON_PRESENTE));
            return;
        }
        if (!this.protocolConfiguration.getTipiSoggetti().contains(busta.getTipoDestinatario())) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.TIPO_DESTINATARIO_SCONOSCIUTO));
            return;
        }
        if (busta.getDestinatario() == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.DESTINATARIO_NON_PRESENTE));
            return;
        }
        if (busta.getAzione() == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.AZIONE_NON_PRESENTE));
            return;
        }
        if (busta.getServizio() == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SERVIZIO_NON_PRESENTE));
            return;
        }
        if (!this.protocolConfiguration.getTipiServizi(ServiceBinding.SOAP).contains(busta.getTipoServizio())) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.TIPO_SERVIZIO_SCONOSCIUTO));
            return;
        }
        if ("TrasmissioneFatture".equals(busta.getServizio())) {
            this.validaServizioTrasmissione(msg, busta, isRichiesta, sdiMessage);
        } else if ("RicezioneFatture".equals(busta.getServizio())) {
            this.validaServizioRicezione(msg, busta, isRichiesta, sdiMessage);
        } else if ("SdIRiceviNotifica".equals(busta.getServizio())) {
            this.validaServizioRiceviNotifica(msg, busta, isRichiesta, sdiMessage);
        } else if ("SdIRiceviFile".equals(busta.getServizio())) {
            this.validaServizioRiceviFile(msg, busta, isRichiesta, sdiMessage);
        } else {
            whiteList = false;
            if (busta.getServizio() != null && this.sdiProperties.getServiziWhiteList().contains(busta.getServizio())) {
                this.log.debug("Servizio [" + busta.getServizio() + "] in white list");
                whiteList = true;
            }
            if (!whiteList) {
                this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SERVIZIO_NON_VALIDO));
                return;
            }
        }
    }

    private void validaServizioTrasmissione(OpenSPCoop2Message msg, Busta busta, boolean isRichiesta, SOAPElement sdiMessage) throws Exception {
        String azione = busta.getAzione();
        SDIValidatoreServizioTrasmissioneFatture validatore = new SDIValidatoreServizioTrasmissioneFatture(this, msg, isRichiesta, sdiMessage, busta);
        if ("RicevutaConsegna".equals(azione)) {
            validatore.validaRicevutaConsegna();
        } else if ("NotificaMancataConsegna".equals(azione)) {
            validatore.validaNotificaMancataConsegna();
        } else if ("NotificaScarto".equals(azione)) {
            validatore.validaNotificaScarto();
        } else if ("NotificaEsito".equals(azione)) {
            validatore.validaNotificaEsito();
        } else if ("NotificaDecorrenzaTermini".equals(azione)) {
            validatore.validaNotificaDecorrenzaTermini();
        } else if ("AttestazioneTrasmissioneFattura".equals(azione)) {
            validatore.validaAttestazioneTrasmissioneFattura();
        } else {
            boolean whiteList = false;
            if (busta.getAzione() != null && this.sdiProperties.getServiziWhiteList().contains(busta.getAzione())) {
                this.log.debug("Azione [" + busta.getAzione() + "] in white list");
                whiteList = true;
            }
            if (!whiteList) {
                this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.AZIONE_NON_VALIDA));
                return;
            }
        }
    }

    private void validaServizioRicezione(OpenSPCoop2Message msg, Busta busta, boolean isRichiesta, SOAPElement sdiMessage) throws Exception {
        String azione = busta.getAzione();
        SDIValidatoreServizioRicezioneFatture validatore = new SDIValidatoreServizioRicezioneFatture(this, msg, isRichiesta, sdiMessage, busta);
        if ("RiceviFatture".equals(azione)) {
            validatore.validaRiceviFatture();
        } else if ("NotificaDecorrenzaTermini".equals(azione)) {
            validatore.validaNotificaDecorrenzaTermini();
        } else {
            boolean whiteList = false;
            if (busta.getAzione() != null && this.sdiProperties.getServiziWhiteList().contains(busta.getAzione())) {
                this.log.debug("Azione [" + busta.getAzione() + "] in white list");
                whiteList = true;
            }
            if (!whiteList) {
                this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.AZIONE_NON_VALIDA));
                return;
            }
        }
    }

    private void validaServizioRiceviNotifica(OpenSPCoop2Message msg, Busta busta, boolean isRichiesta, SOAPElement sdiMessage) throws Exception {
        String azione = busta.getAzione();
        SDIValidatoreServizioRiceviNotifica validatore = new SDIValidatoreServizioRiceviNotifica(this, msg, isRichiesta, sdiMessage, busta);
        if ("NotificaEsito".equals(azione)) {
            validatore.validaNotificaEsito();
        } else {
            boolean whiteList = false;
            if (busta.getAzione() != null && this.sdiProperties.getServiziWhiteList().contains(busta.getAzione())) {
                this.log.debug("Azione [" + busta.getAzione() + "] in white list");
                whiteList = true;
            }
            if (!whiteList) {
                this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.AZIONE_NON_VALIDA));
                return;
            }
        }
    }

    private void validaServizioRiceviFile(OpenSPCoop2Message msg, Busta busta, boolean isRichiesta, SOAPElement sdiMessage) throws Exception {
        String azione = busta.getAzione();
        SDIValidatoreServizioRiceviFile validatore = new SDIValidatoreServizioRiceviFile(this, msg, isRichiesta, sdiMessage, busta);
        if ("RiceviFile".equals(azione)) {
            validatore.validaRiceviFile();
        } else {
            boolean whiteList = false;
            if (busta.getAzione() != null && this.sdiProperties.getServiziWhiteList().contains(busta.getAzione())) {
                this.log.debug("Azione [" + busta.getAzione() + "] in white list");
                whiteList = true;
            }
            if (!whiteList) {
                this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.AZIONE_NON_VALIDA));
                return;
            }
        }
    }
}

