/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdi.validator;

import it.gov.fatturapa.sdi.messaggi.v1_0.NotificaEsitoCommittenteType;
import it.gov.fatturapa.sdi.messaggi.v1_0.ScartoEsitoCommittenteType;
import it.gov.fatturapa.sdi.messaggi.v1_0.constants.TipiMessaggi;
import it.gov.fatturapa.sdi.messaggi.v1_0.utils.XSDValidatorWithSignature;
import it.gov.fatturapa.sdi.messaggi.v1_0.utils.serializer.JaxbDeserializer;
import it.gov.fatturapa.sdi.ws.ricezione.v1_0.types.constants.EsitoNotificaType;
import it.gov.fatturapa.sdi.ws.ricezione.v1_0.types.utils.ProjectInfo;
import jakarta.xml.soap.AttachmentPart;
import jakarta.xml.soap.SOAPElement;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.soap.mtom.MTOMUtilities;
import org.openspcoop2.protocol.sdi.config.SDIProperties;
import org.openspcoop2.protocol.sdi.constants.SDICostanti;
import org.openspcoop2.protocol.sdi.constants.SDICostantiServizioRiceviNotifica;
import org.openspcoop2.protocol.sdi.utils.SDICompatibilitaNamespaceErrati;
import org.openspcoop2.protocol.sdi.validator.SDIValidatoreNomeFile;
import org.openspcoop2.protocol.sdi.validator.SDIValidazioneSemantica;
import org.openspcoop2.protocol.sdi.validator.SDIValidazioneSintattica;
import org.openspcoop2.protocol.sdi.validator.SDIValidazioneUtils;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.xml.AbstractValidatoreXSD;
import org.w3c.dom.Element;

public class SDIValidatoreServizioRiceviNotifica {
    private SDIValidazioneSintattica sdiValidazioneSintattica;
    private SDIValidazioneSemantica sdiValidazioneSemantica;
    private OpenSPCoop2Message msg;
    private OpenSPCoop2MessageFactory messageFactory;
    private boolean isRichiesta;
    private SOAPElement sdiMessage;
    private String namespace;
    private Busta busta;

    public SDIValidatoreServizioRiceviNotifica(SDIValidazioneSintattica sdiValidazioneSintattica, OpenSPCoop2Message msg, boolean isRichiesta, SOAPElement sdiMessage, Busta busta) {
        this.sdiValidazioneSintattica = sdiValidazioneSintattica;
        this.msg = msg;
        this.messageFactory = this.msg != null ? this.msg.getFactory() : OpenSPCoop2MessageFactory.getDefaultMessageFactory();
        this.isRichiesta = isRichiesta;
        this.sdiMessage = sdiMessage;
        this.namespace = ProjectInfo.getInstance().getProjectNamespace();
        this.busta = busta;
    }

    public SDIValidatoreServizioRiceviNotifica(SDIValidazioneSemantica sdiValidazioneSemantica, OpenSPCoop2Message msg, boolean isRichiesta, SOAPElement sdiMessage, Busta busta) {
        this.sdiValidazioneSemantica = sdiValidazioneSemantica;
        this.msg = msg;
        this.messageFactory = this.msg != null ? this.msg.getFactory() : OpenSPCoop2MessageFactory.getDefaultMessageFactory();
        this.isRichiesta = isRichiesta;
        this.sdiMessage = sdiMessage;
        this.namespace = SDICostantiServizioRiceviNotifica.SDI_SERVIZIO_RICEVI_NOTIFICA_NAMESPACE;
        this.busta = busta;
    }

    private boolean checkServiceNamespace() throws Exception {
        if (!this.namespace.equals(this.sdiMessage.getNamespaceURI())) {
            this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Namespace [" + this.sdiMessage.getNamespaceURI() + "] differente da quello atteso [" + this.namespace + "]"));
            return false;
        }
        return true;
    }

    public void validaNotificaEsito() throws Exception {
        if (!this.checkServiceNamespace()) {
            return;
        }
        if (this.sdiValidazioneSintattica != null) {
            if (this.isRichiesta) {
                this._validazioneSintattica_NotificaEsito_richiesta();
            } else {
                this._validazioneSintattica_NotificaEsito_risposta();
            }
        } else if (this.isRichiesta) {
            this._validazioneSemantica_NotificaEsito_richiesta();
        } else {
            this._validazioneSemantica_NotificaEsito_risposta();
        }
    }

    private void _validazioneSintattica_NotificaEsito_richiesta() throws Exception {
        String nomeFile;
        String identificativoSdI;
        block19: {
            if (!"fileSdI".equals(this.sdiMessage.getLocalName())) {
                this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "LocalName [" + this.sdiMessage.getLocalName() + "] differente da quello atteso [fileSdI]"));
                return;
            }
            List elementChilds = SoapUtils.getNotEmptyChildSOAPElement((SOAPElement)this.sdiMessage);
            if (elementChilds == null || elementChilds.size() <= 0) {
                this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "RootElement [{" + this.namespace + "}" + this.sdiMessage.getLocalName() + "] non contiene elementi"));
                return;
            }
            identificativoSdI = null;
            nomeFile = null;
            Boolean fileRead = null;
            for (int i = 0; i < elementChilds.size(); ++i) {
                SOAPElement child = (SOAPElement)elementChilds.get(i);
                if ("IdentificativoSdI".equals(child.getLocalName())) {
                    if (identificativoSdI != null) {
                        this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_PRESENTE_PIU_VOLTE));
                        return;
                    }
                    if (child.getTextContent() == null) {
                        this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_VALORIZZATO));
                        return;
                    }
                    identificativoSdI = child.getTextContent();
                } else if ("NomeFile".equals(child.getLocalName())) {
                    if (nomeFile != null) {
                        this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [NomeFile] presente piu' volte"));
                        return;
                    }
                    if (child.getTextContent() == null) {
                        this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [NomeFile] non valorizzato"));
                        return;
                    }
                    nomeFile = child.getTextContent();
                } else if ("File".equals(child.getLocalName())) {
                    if (fileRead != null) {
                        this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] presente piu' volte"));
                        return;
                    }
                    fileRead = true;
                } else {
                    this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Element [" + child.getLocalName() + "] sconosciuto"));
                    return;
                }
                if (child.getNamespaceURI() == null) continue;
                this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Element [" + child.getLocalName() + "] appartiene al namespace (" + child.getNamespaceURI() + "). Era atteso un elemento senza namespace"));
                return;
            }
            if (identificativoSdI == null) {
                this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_PRESENTE));
                return;
            }
            if (nomeFile == null) {
                this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [NomeFile] non presente"));
                return;
            }
            if (fileRead == null) {
                this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] non presente"));
                return;
            }
            try {
                SDIValidatoreNomeFile.validaNomeFileMessaggi(nomeFile, TipiMessaggi.EC);
            }
            catch (Exception e) {
                this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [NomeFile] non valido: " + e.getMessage(), e, this.sdiValidazioneSintattica.sdiProperties.isEnableValidazioneNomeFile() == false));
                if (!this.sdiValidazioneSintattica.sdiProperties.isEnableValidazioneNomeFile().booleanValue()) break block19;
                return;
            }
        }
        this.busta.addProperty("IdentificativoSdI", identificativoSdI);
        this.busta.addProperty("NomeFile", nomeFile);
    }

    private void _validazioneSemantica_NotificaEsito_richiesta() throws Exception {
        byte[] esito;
        block11: {
            esito = null;
            try {
                QName qnameEsito = new QName("File");
                Iterator nodeEsitoIt = this.sdiMessage.getChildElements(qnameEsito);
                SOAPElement nodeEsito = (SOAPElement)nodeEsitoIt.next();
                Element xomReference = MTOMUtilities.getIfExistsXomReference((OpenSPCoop2MessageFactory)this.messageFactory, (Element)nodeEsito);
                if (xomReference != null) {
                    try {
                        String cid = MTOMUtilities.getCidXomReference((Element)xomReference);
                        if (cid == null) {
                            throw new Exception("XomReference without cid reference");
                        }
                        AttachmentPart ap = MTOMUtilities.getAttachmentPart((OpenSPCoop2Message)this.msg, (String)cid);
                        esito = Utilities.getAsByteArray((InputStream)ap.getDataHandler().getInputStream());
                        if (esito == null || esito.length <= 0) {
                            throw new Exception("Contenuto non presente");
                        }
                        break block11;
                    }
                    catch (Exception e) {
                        this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] non valorizzato correttamente: " + e.getMessage(), e));
                        return;
                    }
                }
                if (nodeEsito.getTextContent() == null) {
                    this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] non valorizzato"));
                    return;
                }
                String base64Metadati = nodeEsito.getTextContent();
                if (base64Metadati == null || "".equals(base64Metadati)) {
                    throw new Exception("Codifica Base64 non presente");
                }
                try {
                    esito = Base64Utilities.decode((String)base64Metadati);
                }
                catch (Exception e) {
                    this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] decodifica base64 non riuscita: " + e.getMessage(), e));
                    return;
                }
            }
            catch (Exception e) {
                this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] non accessibile: " + e.getMessage(), e));
                return;
            }
        }
        this._validazioneEsito(esito, this.sdiValidazioneSemantica.sdiProperties, this.sdiValidazioneSemantica.erroriValidazione, this.sdiValidazioneSemantica.validazioneUtils, this.sdiValidazioneSemantica.getProtocolFactory());
    }

    private void _validazioneEsito(byte[] esitoDoc, SDIProperties sdiProperties, List<Eccezione> eccezioniValidazione, SDIValidazioneUtils validazioneUtils, IProtocolFactory<?> protocolFactory) throws Exception {
        boolean forceEccezioneLivelloInfo = false;
        if (!sdiProperties.isEnableAccessoMessaggi().booleanValue()) {
            return;
        }
        if (sdiProperties.isEnableAccessoMessaggiWarningMode().booleanValue()) {
            forceEccezioneLivelloInfo = true;
        }
        byte[] esito = esitoDoc;
        if (sdiProperties.isEnableValidazioneMessaggiCompatibilitaNamespaceSenzaGov().booleanValue()) {
            esito = SDICompatibilitaNamespaceErrati.convertiXmlNamespaceSenzaGov(protocolFactory.getLogger(), esito);
        }
        if (sdiProperties.isEnableValidazioneXsdMessaggi().booleanValue()) {
            try {
                AbstractValidatoreXSD validatore = XSDValidatorWithSignature.getOpenSPCoop2MessageXSDValidator(protocolFactory.getLogger());
                validatore.valida((InputStream)new ByteArrayInputStream(esito));
            }
            catch (Exception e) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] contiene un file Notifica di Esito Committente non valido rispetto allo schema XSD: " + e.getMessage(), e, forceEccezioneLivelloInfo));
                return;
            }
        }
        NotificaEsitoCommittenteType esitoObject = null;
        try {
            JaxbDeserializer deserializer = new JaxbDeserializer();
            esitoObject = deserializer.readNotificaEsitoCommittenteType(esito);
        }
        catch (Exception e) {
            eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] contiene un file Notifica di Esito Committente non valido: " + e.getMessage(), e, forceEccezioneLivelloInfo));
            return;
        }
        if (esitoObject.getIdentificativoSdI() != null) {
            this.busta.addProperty("IdentificativoSdI", esitoObject.getIdentificativoSdI().toString());
        }
        if (esitoObject.getRiferimentoFattura() != null) {
            if (esitoObject.getRiferimentoFattura().getAnnoFattura() != null) {
                this.busta.addProperty("RiferimentoFattura-Anno", esitoObject.getRiferimentoFattura().getAnnoFattura().toString());
            }
            if (esitoObject.getRiferimentoFattura().getNumeroFattura() != null) {
                this.busta.addProperty("RiferimentoFattura-Numero", esitoObject.getRiferimentoFattura().getNumeroFattura());
            }
            if (esitoObject.getRiferimentoFattura().getPosizioneFattura() != null) {
                this.busta.addProperty("RiferimentoFattura-Posizione", esitoObject.getRiferimentoFattura().getPosizioneFattura().toString());
            }
        }
        if (esitoObject.getEsito() != null) {
            this.busta.addProperty("Esito", esitoObject.getEsito().name());
        }
        if (esitoObject.getDescrizione() != null) {
            this.busta.addProperty("Descrizione", esitoObject.getDescrizione());
        }
        if (esitoObject.getMessageIdCommittente() != null) {
            this.busta.addProperty("MessageIdCommittente", esitoObject.getMessageIdCommittente());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void _validazioneSintattica_NotificaEsito_risposta() throws Exception {
        if (!"rispostaSdINotificaEsito".equals(this.sdiMessage.getLocalName())) {
            this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "LocalName [" + this.sdiMessage.getLocalName() + "] differente da quello atteso [rispostaSdINotificaEsito]"));
            return;
        }
        elementChilds = SoapUtils.getNotEmptyChildSOAPElement((SOAPElement)this.sdiMessage);
        if (elementChilds == null || elementChilds.size() <= 0) {
            this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "RootElement [{" + this.namespace + "}" + this.sdiMessage.getLocalName() + "] non contiene elementi"));
            return;
        }
        esito = null;
        scartoElementRead = null;
        nomeFileScartoEsito = null;
        scartoEsitoRead = null;
        for (i = 0; i < elementChilds.size(); ++i) {
            child = (SOAPElement)elementChilds.get(i);
            if ("Esito".equals(child.getLocalName())) {
                if (esito != null) {
                    this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [Esito] presente piu' volte"));
                    return;
                }
                if (child.getTextContent() == null) {
                    this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [Esito] non valorizzato"));
                    return;
                }
                esito = child.getTextContent();
            } else if ("ScartoEsito".equals(child.getLocalName())) {
                if (scartoElementRead != null) {
                    this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [ScartoEsito] presente piu' volte"));
                    return;
                }
                scartoElementRead = true;
                elementScartoChilds = SoapUtils.getNotEmptyChildSOAPElement((SOAPElement)child);
                if (elementScartoChilds == null || elementScartoChilds.size() <= 0) {
                    this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [ScartoEsito] non contiene elementi"));
                    return;
                }
                for (j = 0; j < elementScartoChilds.size(); ++j) {
                    scartoChild = (SOAPElement)elementScartoChilds.get(j);
                    if ("NomeFile".equals(scartoChild.getLocalName())) {
                        if (nomeFileScartoEsito != null) {
                            this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [NomeFile] presente piu' volte"));
                            return;
                        }
                        if (scartoChild.getTextContent() == null) {
                            this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [NomeFile] non valorizzato"));
                            return;
                        }
                        nomeFileScartoEsito = scartoChild.getTextContent();
                        continue;
                    }
                    if (!"File".equals(scartoChild.getLocalName())) continue;
                    if (scartoEsitoRead != null) {
                        this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] presente piu' volte"));
                        return;
                    }
                    scartoEsitoRead = true;
                }
            } else {
                this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Element [" + child.getLocalName() + "] sconosciuto"));
                return;
            }
            if (child.getNamespaceURI() == null) continue;
            this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Element [" + child.getLocalName() + "] appartiene al namespace (" + child.getNamespaceURI() + "). Era atteso un elemento senza namespace"));
            return;
        }
        if (esito == null) {
            this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [Esito] non presente"));
            return;
        }
        try {
            if (!(EsitoNotificaType.ES00.name().equals(esito) || EsitoNotificaType.ES01.name().equals(esito) || EsitoNotificaType.ES02.name().equals(esito))) {
                throw new Exception("Valore [" + esito + "] differente dai valori attesi: [" + EsitoNotificaType.ES00.name() + "," + EsitoNotificaType.ES01.name() + "," + EsitoNotificaType.ES02.name() + "]");
            }
        }
        catch (Exception e) {
            this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [Esito] non valido: " + e.getMessage(), e));
            return;
        }
        if (EsitoNotificaType.ES00.name().equals(esito)) {
            if (scartoEsitoRead == null) {
                this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [ScartoEsito] non presente (richiesto dallo stato " + EsitoNotificaType.ES00.name() + ")"));
                return;
            }
            try {
                SDIValidatoreNomeFile.validaNomeFileMessaggi(nomeFileScartoEsito, TipiMessaggi.SE);
            }
            catch (Exception e) {
                this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [NomeFile] non valido: " + e.getMessage(), e, this.sdiValidazioneSintattica.sdiProperties.isEnableValidazioneNomeFile() == false));
                if (!this.sdiValidazioneSintattica.sdiProperties.isEnableValidazioneNomeFile().booleanValue()) ** GOTO lbl95
                return;
            }
        } else if (EsitoNotificaType.ES02.name().equals(esito)) {
            this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [ScartoEsito] indica un ES02 - Sistema non Disponibile del SdI"));
            return;
        }
lbl95:
        // 4 sources

        this.busta.addProperty("EsitoNotifica", esito);
    }

    private void _validazioneSemantica_NotificaEsito_risposta() throws Exception {
        byte[] scartoEsito;
        block20: {
            scartoEsito = null;
            try {
                QName qnameEsito = new QName("ScartoEsito");
                Iterator nodeEsitoIt = this.sdiMessage.getChildElements(qnameEsito);
                SOAPElement nodeEsito = null;
                if (nodeEsitoIt != null) {
                    Object o = null;
                    try {
                        o = nodeEsitoIt.next();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (o != null) {
                        nodeEsito = o;
                    }
                }
                if (nodeEsito == null) break block20;
                QName qnameEsitoFile = new QName("File");
                Iterator nodeEsitoFileIt = nodeEsito.getChildElements(qnameEsitoFile);
                SOAPElement nodeEsitoFile = null;
                if (nodeEsitoFileIt != null) {
                    Object o = null;
                    try {
                        o = nodeEsitoFileIt.next();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (o != null) {
                        nodeEsitoFile = o;
                    }
                }
                if (nodeEsitoFile == null) break block20;
                Element xomReference = MTOMUtilities.getIfExistsXomReference((OpenSPCoop2MessageFactory)this.messageFactory, nodeEsitoFile);
                if (xomReference != null) {
                    try {
                        String cid = MTOMUtilities.getCidXomReference((Element)xomReference);
                        if (cid == null) {
                            throw new Exception("XomReference without cid reference");
                        }
                        AttachmentPart ap = MTOMUtilities.getAttachmentPart((OpenSPCoop2Message)this.msg, (String)cid);
                        scartoEsito = Utilities.getAsByteArray((InputStream)ap.getDataHandler().getInputStream());
                        if (scartoEsito == null || scartoEsito.length <= 0) {
                            throw new Exception("Contenuto non presente");
                        }
                        break block20;
                    }
                    catch (Exception e) {
                        this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] non valorizzato correttamente: " + e.getMessage(), e));
                        return;
                    }
                }
                if (nodeEsitoFile.getTextContent() == null) {
                    this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] non valorizzato"));
                    return;
                }
                String base64Metadati = nodeEsitoFile.getTextContent();
                if (base64Metadati == null || "".equals(base64Metadati)) {
                    throw new Exception("Codifica Base64 non presente");
                }
                try {
                    scartoEsito = Base64Utilities.decode((String)base64Metadati);
                }
                catch (Exception e) {
                    this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] decodifica base64 non riuscita: " + e.getMessage(), e));
                    return;
                }
            }
            catch (Exception e) {
                this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] non accessibile: " + e.getMessage(), e));
                return;
            }
        }
        if (scartoEsito != null) {
            this._validazioneScartoEsito(scartoEsito, this.sdiValidazioneSemantica.sdiProperties, this.sdiValidazioneSemantica.erroriValidazione, this.sdiValidazioneSemantica.validazioneUtils, this.sdiValidazioneSemantica.getProtocolFactory());
        }
    }

    private void _validazioneScartoEsito(byte[] esitoDoc, SDIProperties sdiProperties, List<Eccezione> eccezioniValidazione, SDIValidazioneUtils validazioneUtils, IProtocolFactory<?> protocolFactory) throws Exception {
        boolean forceEccezioneLivelloInfo = false;
        if (!sdiProperties.isEnableAccessoMessaggi().booleanValue()) {
            return;
        }
        if (sdiProperties.isEnableAccessoMessaggiWarningMode().booleanValue()) {
            forceEccezioneLivelloInfo = true;
        }
        byte[] esito = esitoDoc;
        if (sdiProperties.isEnableValidazioneMessaggiCompatibilitaNamespaceSenzaGov().booleanValue()) {
            esito = SDICompatibilitaNamespaceErrati.convertiXmlNamespaceSenzaGov(protocolFactory.getLogger(), esito);
        }
        if (sdiProperties.isEnableValidazioneXsdMessaggi().booleanValue()) {
            try {
                AbstractValidatoreXSD validatore = XSDValidatorWithSignature.getOpenSPCoop2MessageXSDValidator(protocolFactory.getLogger());
                validatore.valida((InputStream)new ByteArrayInputStream(esito));
            }
            catch (Exception e) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [ScartoEsito] contiene un file Notifica di Scarto Esito Committente non valido rispetto allo schema XSD: " + e.getMessage(), e, forceEccezioneLivelloInfo));
                return;
            }
        }
        ScartoEsitoCommittenteType scartoEsitoObject = null;
        try {
            JaxbDeserializer deserializer = new JaxbDeserializer();
            scartoEsitoObject = deserializer.readScartoEsitoCommittenteType(esito);
            if (sdiProperties.isSaveMessaggiInContext().booleanValue()) {
                this.msg.addContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_MESSAGGIO_SERVIZIO_SDI, (Object)scartoEsitoObject);
            }
        }
        catch (Exception e) {
            eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [ScartoEsito] contiene un file Notifica di Scarto Esito Committente non valido: " + e.getMessage(), e, forceEccezioneLivelloInfo));
            return;
        }
        if (scartoEsitoObject.getIdentificativoSdI() != null) {
            this.busta.addProperty("IdentificativoSdI", scartoEsitoObject.getIdentificativoSdI().toString());
        }
        if (scartoEsitoObject.getRiferimentoFattura() != null) {
            if (scartoEsitoObject.getRiferimentoFattura().getAnnoFattura() != null) {
                this.busta.addProperty("RiferimentoFattura-Anno", scartoEsitoObject.getRiferimentoFattura().getAnnoFattura().toString());
            }
            if (scartoEsitoObject.getRiferimentoFattura().getNumeroFattura() != null) {
                this.busta.addProperty("RiferimentoFattura-Numero", scartoEsitoObject.getRiferimentoFattura().getNumeroFattura());
            }
            if (scartoEsitoObject.getRiferimentoFattura().getPosizioneFattura() != null) {
                this.busta.addProperty("RiferimentoFattura-Posizione", scartoEsitoObject.getRiferimentoFattura().getPosizioneFattura().toString());
            }
        }
        if (scartoEsitoObject.getScarto() != null) {
            this.busta.addProperty("Scarto", scartoEsitoObject.getScarto().name());
        }
        if (scartoEsitoObject.getMessageId() != null) {
            this.busta.addProperty("MessageId", scartoEsitoObject.getMessageId());
        }
        if (scartoEsitoObject.getMessageIdCommittente() != null) {
            this.busta.addProperty("MessageIdCommittente", scartoEsitoObject.getMessageIdCommittente());
        }
        if (scartoEsitoObject.getNote() != null) {
            this.busta.addProperty("Note", scartoEsitoObject.getNote());
        }
    }
}

