/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdi.utils;

import it.gov.fatturapa.sdi.fatturapa.v1_1.FatturaElettronicaType;
import it.gov.fatturapa.sdi.fatturapa.v1_1.ObjectFactory;
import it.gov.fatturapa.sdi.fatturapa.v1_1.utils.serializer.JaxbSerializer;
import it.gov.fatturapa.sdi.ws.ricezione.v1_0.types.FileSdIConMetadatiType;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.generic_project.exception.SerializerException;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageParseResult;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.soap.TunnelSoapUtils;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.behaviour.Behaviour;
import org.openspcoop2.pdd.core.behaviour.BehaviourEmitDiagnosticException;
import org.openspcoop2.pdd.core.behaviour.BehaviourException;
import org.openspcoop2.pdd.core.behaviour.BehaviourForwardTo;
import org.openspcoop2.pdd.core.behaviour.BehaviourForwardToConfiguration;
import org.openspcoop2.pdd.core.behaviour.BehaviourResponseTo;
import org.openspcoop2.pdd.core.behaviour.StatoFunzionalita;
import org.openspcoop2.pdd.core.behaviour.built_in.DefaultBehaviour;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdi.SDIFactory;
import org.openspcoop2.protocol.sdi.builder.SDIBustaBuilder;
import org.openspcoop2.protocol.sdi.builder.SDIImbustamento;
import org.openspcoop2.protocol.sdi.config.SDIProperties;
import org.openspcoop2.protocol.sdi.constants.SDICostanti;
import org.openspcoop2.protocol.sdi.utils.P7MInfo;
import org.openspcoop2.protocol.sdi.utils.SDILottoUtils;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.builder.ProprietaManifestAttachments;
import org.openspcoop2.protocol.sdk.constants.FaseSbustamento;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.beans.BaseBean;

public class FatturaPABehaviour
extends DefaultBehaviour {
    private static OpenSPCoop2Properties openspcoop2Properties = null;
    private static SDIProperties sdiProperties = null;

    private static synchronized void init() throws ProtocolException {
        if (openspcoop2Properties == null) {
            try {
                openspcoop2Properties = OpenSPCoop2Properties.getInstance();
                sdiProperties = SDIProperties.getInstance(OpenSPCoop2Logger.getLoggerOpenSPCoopCore());
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public Behaviour behaviour(GestoreMessaggi gestoreMessaggioRichiesta, Busta busta, PortaApplicativa pa, RequestInfo requestInfo) throws BehaviourException, BehaviourEmitDiagnosticException {
        if ("RicezioneFatture".equals(busta.getServizio()) && "RiceviFatture".equals(busta.getAzione())) {
            try {
                if (openspcoop2Properties == null) {
                    FatturaPABehaviour.init();
                }
                IState state = null;
                if (gestoreMessaggioRichiesta.getOpenspcoopstate() != null) {
                    state = gestoreMessaggioRichiesta.getOpenspcoopstate().getStatoRichiesta();
                }
                OpenSPCoop2Message msg = gestoreMessaggioRichiesta.getMessage();
                Object fatturaPAObject = msg.getContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_FATTURA);
                byte[] fatturaBytes = null;
                if (fatturaPAObject == null) {
                    try {
                        SDIFactory sdiFactory = new SDIFactory();
                        sdiFactory.createBustaBuilder(state).sbustamento(msg, (Context)gestoreMessaggioRichiesta.getPdDContext(), busta, RuoloMessaggio.RICHIESTA, new ProprietaManifestAttachments(), FaseSbustamento.PRE_CONSEGNA_RICHIESTA, requestInfo.getIntegrationServiceBinding(), requestInfo.getBindingConfig());
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        TunnelSoapUtils.sbustamentoMessaggio((OpenSPCoop2Message)msg, (OutputStream)bout);
                        bout.flush();
                        bout.close();
                        fatturaBytes = bout.toByteArray();
                        String formato = busta.getProperty("FormatoArchivioInvioFattura");
                        if (formato != null && formato.equals("P7M")) {
                            P7MInfo p7m = new P7MInfo(fatturaBytes, sdiFactory.getLogger());
                            fatturaBytes = p7m.getXmlDecoded();
                        }
                    }
                    catch (Throwable e) {
                        throw new CoreException("FatturaPA behaviour con l'opzione 'org.openspcoop2.protocol.sdi.parse.fattura.saveInContext' disabilitata. Lo sbustamento del messaggio non e' riuscito: " + e.getMessage(), e);
                    }
                }
                byte[] metadati = null;
                if (sdiProperties.isBehaviourCreaProtocolloSDI().booleanValue()) {
                    Object metadatiBytesObject = msg.getContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_FATTURA_METADATI_BYTES);
                    if (metadatiBytesObject == null) {
                        throw new CoreException("FatturaPA behaviour con opzione 'org.openspcoop2.protocol.sdi.behaviour.creaProtocolloSDI' \u00e8 utilizzabile solo se l'opzione 'org.openspcoop2.protocol.sdi.parse.fattura.saveInContext' \u00e8 abilitata");
                    }
                    metadati = (byte[])metadatiBytesObject;
                }
                Behaviour behaviour = new Behaviour();
                BehaviourResponseTo responseTo = new BehaviourResponseTo();
                responseTo.setResponseTo(true);
                behaviour.setResponseTo(responseTo);
                OpenSPCoop2Message replyTo = msg.getFactory().createEmptyMessage(msg.getMessageType(), MessageRole.RESPONSE);
                SDIImbustamento sdiImbustamento = new SDIImbustamento((SDIBustaBuilder)gestoreMessaggioRichiesta.getProtocolFactory().createBustaBuilder(state));
                sdiImbustamento.creaRisposta_ServizioRicezioneFatture_AzioneRiceviFatture(gestoreMessaggioRichiesta.getProtocolFactory(), state, busta, replyTo);
                behaviour.getResponseTo().setMessage(replyTo);
                List<Object> listForwardToList = new ArrayList();
                ArrayList<BaseBean> listForwardToObjectList = new ArrayList<BaseBean>();
                if (fatturaPAObject == null) {
                    listForwardToList = SDILottoUtils.splitLotto(fatturaBytes);
                } else if (fatturaPAObject instanceof it.gov.fatturapa.sdi.fatturapa.v1_0.FatturaElettronicaType) {
                    fattura = (it.gov.fatturapa.sdi.fatturapa.v1_0.FatturaElettronicaType)fatturaPAObject;
                    for (i = 0; i < fattura.sizeFatturaElettronicaBodyList(); ++i) {
                        fatturaSingola = new it.gov.fatturapa.sdi.fatturapa.v1_0.FatturaElettronicaType();
                        fatturaSingola.setVersione(fattura.getVersione());
                        fatturaSingola.setFatturaElettronicaHeader(fattura.getFatturaElettronicaHeader());
                        fatturaSingola.addFatturaElettronicaBody(fattura.getFatturaElettronicaBody(i));
                        serializer = new it.gov.fatturapa.sdi.fatturapa.v1_0.utils.serializer.JaxbSerializer();
                        of = new it.gov.fatturapa.sdi.fatturapa.v1_0.ObjectFactory();
                        xml = ((it.gov.fatturapa.sdi.fatturapa.v1_0.utils.serializer.JaxbSerializer)serializer).toByteArray(((it.gov.fatturapa.sdi.fatturapa.v1_0.ObjectFactory)of).createFatturaElettronica((it.gov.fatturapa.sdi.fatturapa.v1_0.FatturaElettronicaType)fatturaSingola));
                        listForwardToList.add(xml);
                        listForwardToObjectList.add(fatturaSingola);
                    }
                } else if (fatturaPAObject instanceof FatturaElettronicaType) {
                    fattura = (FatturaElettronicaType)fatturaPAObject;
                    for (i = 0; i < fattura.sizeFatturaElettronicaBodyList(); ++i) {
                        fatturaSingola = new FatturaElettronicaType();
                        fatturaSingola.setVersione(fattura.getVersione());
                        fatturaSingola.setFatturaElettronicaHeader(fattura.getFatturaElettronicaHeader());
                        fatturaSingola.addFatturaElettronicaBody(fattura.getFatturaElettronicaBody(i));
                        serializer = new JaxbSerializer();
                        of = new ObjectFactory();
                        xml = ((JaxbSerializer)serializer).toByteArray(((ObjectFactory)of).createFatturaElettronica((FatturaElettronicaType)fatturaSingola));
                        listForwardToList.add(xml);
                        listForwardToObjectList.add(fatturaSingola);
                    }
                } else if (fatturaPAObject instanceof it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_2.FatturaElettronicaType) {
                    fattura = (it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_2.FatturaElettronicaType)fatturaPAObject;
                    for (i = 0; i < fattura.sizeFatturaElettronicaBodyList(); ++i) {
                        fatturaSingola = new it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_2.FatturaElettronicaType();
                        fatturaSingola.setVersione(fattura.getVersione());
                        fatturaSingola.setFatturaElettronicaHeader(fattura.getFatturaElettronicaHeader());
                        fatturaSingola.addFatturaElettronicaBody(fattura.getFatturaElettronicaBody(i));
                        serializer = new it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_2.utils.serializer.JaxbSerializer();
                        of = new it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_2.ObjectFactory();
                        xml = ((it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_2.utils.serializer.JaxbSerializer)serializer).toByteArray(((it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_2.ObjectFactory)of).createFatturaElettronica((it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_2.FatturaElettronicaType)fatturaSingola));
                        listForwardToList.add(xml);
                        listForwardToObjectList.add(fatturaSingola);
                    }
                } else {
                    throw new CoreException("Tipo [" + fatturaPAObject.getClass().getName() + "] non gestito");
                }
                for (int j = 0; j < listForwardToList.size(); ++j) {
                    byte[] xml = (byte[])listForwardToList.get(j);
                    if (sdiProperties.isBehaviourCreaProtocolloSDI().booleanValue()) {
                        xml = this.imbustamentoSDI(busta, xml, metadati);
                    }
                    OpenSPCoop2MessageParseResult pr = msg.getFactory().envelopingMessage(msg.getMessageType(), MessageRole.REQUEST, "text/xml", "OpenSPCoop", xml, null, openspcoop2Properties.getAttachmentsProcessingMode(), true, openspcoop2Properties.useSoapMessageReader(), openspcoop2Properties.getSoapMessageReaderBufferThresholdKb());
                    OpenSPCoop2Message msgForwardTo = pr.getMessage_throwParseException();
                    if (listForwardToObjectList != null && j < listForwardToObjectList.size()) {
                        Object fatturaSingola = listForwardToObjectList.get(j);
                        msgForwardTo.addContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_FATTURA, fatturaSingola);
                    }
                    BehaviourForwardTo forwardTo = new BehaviourForwardTo();
                    forwardTo.setMessage(msgForwardTo);
                    if (!sdiProperties.isBehaviourCreaProtocolloSDI().booleanValue()) {
                        BehaviourForwardToConfiguration config = new BehaviourForwardToConfiguration();
                        config.setSbustamentoInformazioniProtocollo(StatoFunzionalita.DISABILITATA);
                        config.setSbustamentoSoap(StatoFunzionalita.CONFIGURAZIONE_ORIGINALE);
                        forwardTo.setConfig(config);
                    }
                    Busta bustaNewMessaggio = busta.newInstance();
                    int posizione = j + 1;
                    bustaNewMessaggio.setID("Fattura" + posizione + "_" + busta.getID());
                    bustaNewMessaggio.addProperty("PosizioneFatturaPA", "" + posizione);
                    forwardTo.setDescription("PosizioneFattura:" + posizione);
                    forwardTo.setBusta(bustaNewMessaggio);
                    behaviour.getForwardTo().add(forwardTo);
                }
                return behaviour;
            }
            catch (Exception e) {
                throw new BehaviourException(e.getMessage(), (Throwable)e);
            }
        }
        return super.behaviour(gestoreMessaggioRichiesta, busta, pa, requestInfo);
    }

    private byte[] imbustamentoSDI(Busta busta, byte[] xml, byte[] metadati) throws SerializerException {
        it.gov.fatturapa.sdi.ws.ricezione.v1_0.types.ObjectFactory of = new it.gov.fatturapa.sdi.ws.ricezione.v1_0.types.ObjectFactory();
        FileSdIConMetadatiType sdi = new FileSdIConMetadatiType();
        sdi.setIdentificativoSdI(busta.getProperty("IdentificativoSdI"));
        sdi.setNomeFile(busta.getProperty("NomeFile"));
        sdi.setFile(xml);
        sdi.setNomeFileMetadati(busta.getProperty("NomeFileMetadati"));
        sdi.setMetadati(metadati);
        it.gov.fatturapa.sdi.ws.ricezione.v1_0.types.utils.serializer.JaxbSerializer serializerWSRicezione = new it.gov.fatturapa.sdi.ws.ricezione.v1_0.types.utils.serializer.JaxbSerializer();
        return serializerWSRicezione.toByteArray(of.createFileSdIConMetadati(sdi));
    }
}

