/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import org.openspcoop2.core.config.rs.server.model.APIImpl;
import org.openspcoop2.core.config.rs.server.model.FruizioneModIOAuth;
import org.openspcoop2.core.config.rs.server.model.FruizioneModIRest;
import org.openspcoop2.core.config.rs.server.model.FruizioneModISoap;
import org.openspcoop2.core.config.rs.server.model.OneOfFruizioneModi;

public class Fruizione
extends APIImpl {
    @Schema(description="")
    private String descrizione = null;
    @Schema(description="")
    private String fruizioneNome = null;
    @Schema(description="")
    private Integer fruizioneVersione = null;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="")
    private String erogatore = null;
    @Schema(description="")
    private String canale = null;
    @Schema(description="")
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="protocollo", visible=true)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=FruizioneModIOAuth.class, name="oauth"), @JsonSubTypes.Type(value=FruizioneModISoap.class, name="soap"), @JsonSubTypes.Type(value=FruizioneModIRest.class, name="rest")})
    private OneOfFruizioneModi modi = null;

    @JsonProperty(value="descrizione")
    @Valid
    @Size(max=4000)
    public @Valid @Size(max=4000) String getDescrizione() {
        return this.descrizione;
    }

    public void setDescrizione(String descrizione) {
        this.descrizione = descrizione;
    }

    public Fruizione descrizione(String descrizione) {
        this.descrizione = descrizione;
        return this;
    }

    @JsonProperty(value="fruizione_nome")
    @Valid
    @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$")
    @Size(max=255)
    public @Valid @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String getFruizioneNome() {
        return this.fruizioneNome;
    }

    public void setFruizioneNome(String fruizioneNome) {
        this.fruizioneNome = fruizioneNome;
    }

    public Fruizione fruizioneNome(String fruizioneNome) {
        this.fruizioneNome = fruizioneNome;
        return this;
    }

    @JsonProperty(value="fruizione_versione")
    @Valid
    public Integer getFruizioneVersione() {
        return this.fruizioneVersione;
    }

    public void setFruizioneVersione(Integer fruizioneVersione) {
        this.fruizioneVersione = fruizioneVersione;
    }

    public Fruizione fruizioneVersione(Integer fruizioneVersione) {
        this.fruizioneVersione = fruizioneVersione;
        return this;
    }

    @JsonProperty(value="erogatore")
    @NotNull
    @Valid
    @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$")
    @Size(max=255)
    public @NotNull @Valid @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String getErogatore() {
        return this.erogatore;
    }

    public void setErogatore(String erogatore) {
        this.erogatore = erogatore;
    }

    public Fruizione erogatore(String erogatore) {
        this.erogatore = erogatore;
        return this;
    }

    @JsonProperty(value="canale")
    @Valid
    @Pattern(regexp="^[^\\s]+$")
    @Size(max=255)
    public @Valid @Pattern(regexp="^[^\\s]+$") @Size(max=255) String getCanale() {
        return this.canale;
    }

    public void setCanale(String canale) {
        this.canale = canale;
    }

    public Fruizione canale(String canale) {
        this.canale = canale;
        return this;
    }

    @JsonProperty(value="modi")
    @Valid
    public OneOfFruizioneModi getModi() {
        return this.modi;
    }

    public void setModi(OneOfFruizioneModi modi) {
        this.modi = modi;
    }

    public Fruizione modi(OneOfFruizioneModi modi) {
        this.modi = modi;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Fruizione {\n");
        sb.append("    ").append(Fruizione.toIndentedString(super.toString())).append("\n");
        sb.append("    descrizione: ").append(Fruizione.toIndentedString(this.descrizione)).append("\n");
        sb.append("    fruizioneNome: ").append(Fruizione.toIndentedString(this.fruizioneNome)).append("\n");
        sb.append("    fruizioneVersione: ").append(Fruizione.toIndentedString(this.fruizioneVersione)).append("\n");
        sb.append("    erogatore: ").append(Fruizione.toIndentedString(this.erogatore)).append("\n");
        sb.append("    canale: ").append(Fruizione.toIndentedString(this.canale)).append("\n");
        sb.append("    modi: ").append(Fruizione.toIndentedString(this.modi)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private static String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

