/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.config;

import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.config.driver.ExtendedInfoManager;
import org.openspcoop2.core.config.rs.server.config.DatasourceProperties;
import org.openspcoop2.core.config.rs.server.config.InitRuntimeConfigReader;
import org.openspcoop2.core.config.rs.server.config.LoggerProperties;
import org.openspcoop2.core.config.rs.server.config.ServerProperties;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.monitor.engine.alarm.AlarmConfigProperties;
import org.openspcoop2.monitor.engine.alarm.AlarmEngineConfig;
import org.openspcoop2.monitor.engine.alarm.AlarmManager;
import org.openspcoop2.pdd.config.ConfigurazioneNodiRuntime;
import org.openspcoop2.pdd.config.ConfigurazioneNodiRuntimeProperties;
import org.openspcoop2.pdd.core.byok.BYOKMapProperties;
import org.openspcoop2.pdd.core.dynamic.DynamicInfo;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.services.ServicesUtils;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.ConfigurazionePdD;
import org.openspcoop2.protocol.utils.ModIUtils;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.certificate.byok.BYOKManager;
import org.openspcoop2.utils.certificate.hsm.HSMManager;
import org.openspcoop2.utils.certificate.hsm.HSMUtils;
import org.openspcoop2.utils.certificate.ocsp.OCSPManager;
import org.openspcoop2.utils.crypt.CryptConfig;
import org.openspcoop2.utils.crypt.PasswordVerifier;
import org.openspcoop2.utils.json.YamlSnakeLimits;
import org.openspcoop2.utils.properties.MapProperties;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.security.ProviderUtils;
import org.openspcoop2.utils.transport.http.HttpLibrary;
import org.openspcoop2.utils.transport.http.HttpLibraryConnection;
import org.openspcoop2.web.ctrlstat.core.Connettori;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.DBManager;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationDB;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.lib.mvc.login.FailedAttempts;
import org.openspcoop2.web.lib.mvc.security.InputSanitizerProperties;
import org.openspcoop2.web.lib.mvc.security.SecurityProperties;
import org.openspcoop2.web.lib.mvc.security.Validatore;
import org.openspcoop2.web.lib.users.dao.InterfaceType;
import org.slf4j.Logger;

public class Startup
implements ServletContextListener {
    private static Logger log = null;
    private static InitRuntimeConfigReader initRuntimeConfigReader;
    private static boolean initializedLog;
    private static boolean initializedResources;

    public static Logger getLog() {
        return log;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (log != null) {
            log.info("Undeploy webService in corso...");
        }
        if (initRuntimeConfigReader != null) {
            initRuntimeConfigReader.setStop(true);
        }
        if (log != null) {
            log.info("Undeploy webService effettuato.");
        }
    }

    public void contextInitialized(ServletContextEvent sce) {
        Startup.initLog();
        Startup.initResources();
    }

    public static boolean isInitializedLog() {
        return initializedLog;
    }

    public static synchronized String initLog() {
        String confDir = null;
        try (InputStream is2 = Startup.class.getResourceAsStream("/rs-api-config.properties");){
            if (is2 != null) {
                Properties p = new Properties();
                p.load(is2);
                confDir = p.getProperty("confDirectory");
                if (confDir != null) {
                    confDir = confDir.trim();
                }
            }
        }
        catch (Exception is2) {
            // empty catch block
        }
        if (!initializedLog) {
            try {
                log = LoggerWrapperFactory.getLogger(Startup.class);
                LoggerProperties.initialize(log, confDir, null);
                initializedLog = true;
                log = LoggerProperties.getLoggerCore();
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
        return confDir;
    }

    public static boolean isInitializedResources() {
        return initializedResources;
    }

    public static synchronized void initResources() {
        if (!initializedResources) {
            String confDir = Startup.initLog();
            log.info("Inizializzazione rs api config in corso...");
            if (!ServerProperties.initialize(confDir, log)) {
                return;
            }
            ServerProperties serverProperties = null;
            try {
                serverProperties = ServerProperties.getInstance();
            }
            catch (Exception e) {
                Startup.doError("Errore durante l'inizializzazione del serverProperties", e);
            }
            try {
                if (serverProperties.getConnettoriRemoteAccessUtilityLibrary() != null) {
                    HttpLibraryConnection.setDefaultLibrary((HttpLibrary)serverProperties.getConnettoriRemoteAccessUtilityLibrary());
                }
                log.info("HttpLibraryConnection: {}", (Object)HttpLibraryConnection.getDefaultLibrary());
            }
            catch (Exception e) {
                Startup.doError("Inizializzazione libreria accesso risorse esterne non riuscita", e);
            }
            try {
                Logger logR = log;
                ServicesUtils.initCheckConnectionDB((Logger)logR, (boolean)serverProperties.isJdbcCloseConnectionCheckIsClosed(), (boolean)serverProperties.isJdbcCloseConnectionCheckAutocommit());
                DriverControlStationDB.setCheckLogger((Logger)logR);
                DriverControlStationDB.setCheckIsClosed((boolean)serverProperties.isJdbcCloseConnectionCheckIsClosed());
                DriverControlStationDB.setCheckAutocommit((boolean)serverProperties.isJdbcCloseConnectionCheckAutocommit());
                DBManager.setCheckLogger((Logger)logR);
                DBManager.setCheckIsClosed((boolean)serverProperties.isJdbcCloseConnectionCheckIsClosed());
                DBManager.setCheckAutocommit((boolean)serverProperties.isJdbcCloseConnectionCheckAutocommit());
            }
            catch (Exception e) {
                Startup.doError("Inizializzazione controlli connessione non riuscita", e);
            }
            try {
                String mapConfig = serverProperties.getEnvMapConfig();
                if (StringUtils.isNotEmpty((CharSequence)mapConfig)) {
                    log.info("Inizializzazione environment in corso...");
                    MapProperties.initialize((Logger)log, (String)mapConfig, (boolean)serverProperties.isEnvMapConfigRequired());
                    MapProperties mapProperties = MapProperties.getInstance();
                    mapProperties.initEnvironment();
                    String msgInit = "Environment inizializzato con le variabili definite nel file '" + mapConfig + "'\n\tJavaProperties: " + String.valueOf(mapProperties.getJavaMap().keys()) + "\n\tEnvProperties: " + String.valueOf(mapProperties.getEnvMap().keys()) + "\n\tObfuscateMode: " + mapProperties.getObfuscateModeDescription() + "\n\tObfuscatedJavaKeys: " + String.valueOf(mapProperties.getObfuscatedJavaKeys()) + "\n\tObfuscatedEnvKeys: " + String.valueOf(mapProperties.getObfuscatedEnvKeys());
                    log.info(msgInit);
                }
            }
            catch (Exception e) {
                Startup.doError("Errore durante l'inizializzazione dell'ambiente", e);
            }
            log.info("Inizializzazione security provider...");
            try {
                if (serverProperties.isSecurityLoadBouncyCastleProvider()) {
                    ProviderUtils.addBouncyCastleAfterSun((boolean)true);
                    log.info("Aggiunto Security Provider org.bouncycastle.jce.provider.BouncyCastleProvider");
                }
            }
            catch (Exception e) {
                Startup.doError("Errore durante l'inizializzazione dei security provider", e);
            }
            log.info("Inizializzazione security provider effettuata con successo");
            Startup.initHSM(serverProperties);
            BYOKManager byokManager = null;
            try {
                String byokConfig = serverProperties.getBYOKConfigurazione();
                if (StringUtils.isNotEmpty((CharSequence)byokConfig)) {
                    log.info("Inizializzazione BYOK in corso...");
                    File f = new File(byokConfig);
                    BYOKManager.init((File)f, (boolean)serverProperties.isBYOKRequired(), (Logger)log);
                    byokManager = BYOKManager.getInstance();
                    String msgInit = "Gestore BYOK inizializzato;\n\tHSM registrati: " + String.valueOf(byokManager.getKeystoreTypes()) + "\n\tSecurityEngine registrati: " + String.valueOf(byokManager.getSecurityEngineTypes()) + "\n\tGovWaySecurityEngine: " + byokManager.getSecurityEngineGovWayDescription();
                    log.info(msgInit);
                }
            }
            catch (Exception e) {
                Startup.doError("Errore durante l'inizializzazione del manager BYOK", e);
            }
            Startup.initOCSP(serverProperties);
            boolean reInitSecretMaps = false;
            try {
                String secretsConfig = serverProperties.getBYOKEnvSecretsConfig();
                if (byokManager != null && StringUtils.isNotEmpty((CharSequence)secretsConfig)) {
                    log.info("Inizializzazione secrets in corso...");
                    boolean useSecurityEngine = true;
                    HashMap dynamicMap = new HashMap();
                    DynamicInfo dynamicInfo = new DynamicInfo();
                    DynamicUtils.fillDynamicMap((Logger)log, dynamicMap, (DynamicInfo)dynamicInfo);
                    if (byokManager.isBYOKRemoteGovWayNodeUnwrapConfig()) {
                        reInitSecretMaps = true;
                        useSecurityEngine = false;
                    }
                    BYOKMapProperties.initialize((Logger)log, (String)secretsConfig, (boolean)serverProperties.isBYOKEnvSecretsConfigRequired(), (boolean)useSecurityEngine, dynamicMap, (boolean)true);
                    BYOKMapProperties secretsProperties = BYOKMapProperties.getInstance();
                    secretsProperties.initEnvironment();
                    String msgInit = "Environment inizializzato con i secrets definiti nel file '" + secretsConfig + "'\n\tJavaProperties: " + String.valueOf(secretsProperties.getJavaMap().keys()) + "\n\tEnvProperties: " + String.valueOf(secretsProperties.getEnvMap().keys()) + "\n\tObfuscateMode: " + secretsProperties.getObfuscateModeDescription();
                    log.info(msgInit);
                }
            }
            catch (Exception e) {
                Startup.doError("Errore durante l'inizializzazione dell'ambiente (secrets)", e);
            }
            if (!DatasourceProperties.initialize(confDir, log)) {
                return;
            }
            try {
                if (!org.openspcoop2.web.ctrlstat.config.DatasourceProperties.initialize((Properties)DatasourceProperties.getInstance().getPropertiesConsole(), (Logger)log)) {
                    return;
                }
            }
            catch (Exception e) {
                log.error("Inizializzazione database console fallita: " + e.getMessage(), (Throwable)e);
            }
            log.info("Inizializzazione ExtendedInfoManager in corso...");
            try {
                ExtendedInfoManager.initialize((Loader)new Loader(), null, null, null);
            }
            catch (Exception e) {
                Startup.logAndThrow(e.getMessage(), e);
            }
            log.info("Inizializzazione ExtendedInfoManager effettuata con successo");
            log.info("Inizializzazione NodiRuntime in corso...");
            try {
                boolean configFileRequired = false;
                ConfigurazioneNodiRuntime.initialize((String)serverProperties.getConfigurazioneNodiRuntime(), (boolean)configFileRequired, (ConfigurazioneNodiRuntimeProperties[])new ConfigurazioneNodiRuntimeProperties[0]);
            }
            catch (Exception e) {
                Startup.doError("Errore durante l'inizializzazione del gestore dei nodi run", e);
            }
            log.info("Inizializzazione NodiRuntime effettuata con successo");
            log.info("Inizializzazione ProtocolFactoryManager in corso...");
            ServerProperties properties = null;
            try {
                properties = ServerProperties.getInstance();
                ConfigurazionePdD configPdD = new ConfigurazionePdD();
                configPdD.setAttesaAttivaJDBC(-1L);
                configPdD.setCheckIntervalJDBC(-1);
                configPdD.setLoader(new Loader(Startup.class.getClassLoader()));
                configPdD.setLog(log);
                ProtocolFactoryManager.initialize((Logger)log, (ConfigurazionePdD)configPdD, (String)properties.getProtocolloDefault());
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
            log.info("ProtocolFactoryManager DBManager effettuata con successo");
            Startup.initConsoleResources();
            Startup.initConnettori(confDir);
            Startup.initAllarmi();
            if (reInitSecretMaps) {
                try {
                    initRuntimeConfigReader = new InitRuntimeConfigReader(serverProperties, ConfigurazioneNodiRuntime.getConfigurazioneNodiRuntime(), reInitSecretMaps);
                    initRuntimeConfigReader.start();
                    log.info("RuntimeConfigReader avviato con successo.");
                }
                catch (Exception e) {
                    log.error("Errore durante l'inizializzazione del RuntimeConfigReader: " + e.getMessage(), (Throwable)e);
                }
            }
            try {
                FailedAttempts.createInstance((String)serverProperties.getLoginRetryDelays());
            }
            catch (Exception e) {
                Startup.doError("Errore durante l'inizializzazione del FailedAttempts", e);
            }
            initializedResources = true;
            log.info("Inizializzazione rs api config effettuata con successo.");
        }
    }

    private static void initConsoleResources() {
        log.info("Inizializzazione Risorse Statiche Console in corso...");
        try {
            Properties yamlSnakeLimits;
            ServerProperties serverProperties = ServerProperties.getInstance();
            ConsoleHelper.setTipoInterfacciaAPI((InterfaceType)InterfaceType.STANDARD);
            ControlStationCore.setUtenzePasswordEncryptEngineApiMode((CryptConfig)serverProperties.getUtenzeCryptConfig());
            ControlStationCore.setApplicativiPasswordEncryptEngineApiMode((CryptConfig)serverProperties.getApplicativiCryptConfig());
            ControlStationCore.setApplicativiApiKeyPasswordGeneratedLengthApiMode((Integer)serverProperties.getApplicativiApiKeyPasswordGeneratedLength());
            if (serverProperties.isApplicativiBasicPasswordEnableConstraints()) {
                ControlStationCore.setApplicativiPasswordVerifierEngineApiMode((PasswordVerifier)serverProperties.getApplicativiPasswordVerifier());
            }
            ControlStationCore.setSoggettiPasswordEncryptEngineApiMode((CryptConfig)serverProperties.getSoggettiCryptConfig());
            ControlStationCore.setSoggettiApiKeyPasswordGeneratedLengthApiMode((Integer)serverProperties.getSoggettiApiKeyPasswordGeneratedLength());
            if (serverProperties.isSoggettiBasicPasswordEnableConstraints()) {
                ControlStationCore.setSoggettiPasswordVerifierEngineApiMode((PasswordVerifier)serverProperties.getSoggettiPasswordVerifier());
            }
            if ((yamlSnakeLimits = serverProperties.getApiYamlSnakeLimits()) != null && !yamlSnakeLimits.isEmpty()) {
                YamlSnakeLimits.initialize((Logger)log, (Properties)yamlSnakeLimits);
            }
            ControlStationCore.setIsSoggettiApplicativiCredenzialiBasicPermitSameCredentialsApiMode((Boolean)serverProperties.isSoggettiApplicativiCredenzialiBasicPermitSameCredentials());
            ControlStationCore.setIsSoggettiApplicativiCredenzialiSslPermitSameCredentialsApiMode((Boolean)serverProperties.isSoggettiApplicativiCredenzialiSslPermitSameCredentials());
            ControlStationCore.setIsSoggettiApplicativiCredenzialiPrincipalPermitSameCredentialsApiMode((Boolean)serverProperties.isSoggettiApplicativiCredenzialiPrincipalPermitSameCredentials());
            DBUtils.setKeystoreJksPasswordRequired((boolean)serverProperties.isKeystoreJksPasswordRequired());
            DBUtils.setKeystoreJksKeyPasswordRequired((boolean)serverProperties.isKeystoreJksKeyPasswordRequired());
            DBUtils.setKeystorePkcs12PasswordRequired((boolean)serverProperties.isKeystorePkcs12PasswordRequired());
            DBUtils.setKeystorePkcs12KeyPasswordRequired((boolean)serverProperties.isKeystorePkcs12KeyPasswordRequired());
            DBUtils.setTruststoreJksPasswordRequired((boolean)serverProperties.isTruststoreJksPasswordRequired());
            DBUtils.setTruststorePkcs12PasswordRequired((boolean)serverProperties.isTruststorePkcs12PasswordRequired());
            Properties consoleSecurityConfiguration = serverProperties.getConsoleSecurityConfiguration();
            SecurityProperties.init((Properties)consoleSecurityConfiguration, (Logger)log);
            Properties consoleInputSanitizerConfiguration = serverProperties.getConsoleInputSanitizerConfiguration();
            InputSanitizerProperties.init((Properties)consoleInputSanitizerConfiguration, (Logger)log);
            Validatore.init((SecurityProperties)SecurityProperties.getInstance(), (InputSanitizerProperties)InputSanitizerProperties.getInstance(), (Logger)log);
            if (ProtocolFactoryManager.getInstance().existsProtocolFactory("modipa")) {
                CostantiDB.setServiziDigestEnabled((boolean)ModIUtils.isSignalHubEnabled());
            }
        }
        catch (Exception e) {
            Startup.logAndThrow(e.getMessage(), e);
        }
        log.info("Inizializzazione Risorse Statiche Console effettuata con successo");
    }

    private static void initConnettori(String confDir) {
        log.info("Inizializzazione Connettori in corso...");
        try {
            Connettori.initialize((Logger)log, (boolean)true, (String)confDir, (String)ServerProperties.getInstance().getProtocolloDefault());
        }
        catch (Exception e) {
            Startup.logAndThrow(e.getMessage(), e);
        }
        log.info("Inizializzazione Connettori effettuata con successo");
    }

    private static void initAllarmi() {
        try {
            if (ServerProperties.getInstance().isConfigurazioneAllarmiEnabled()) {
                log.info("Inizializzazione Allarmi in corso...");
                AlarmEngineConfig alarmEngineConfig = AlarmConfigProperties.getAlarmConfiguration((Logger)log, (String)ServerProperties.getInstance().getAllarmiConfigurazione(), (String)ServerProperties.getInstance().getConfDirectory());
                AlarmManager.setAlarmEngineConfig((AlarmEngineConfig)alarmEngineConfig);
                CostantiDB.setAllarmiEnabled((boolean)true);
                log.info("Inizializzazione Allarmi effettuata con successo");
            }
        }
        catch (Exception e) {
            String msgErrore = "Errore durante l'inizializzazione degli allarmi: " + e.getMessage();
            Startup.logAndThrow(msgErrore, e);
        }
    }

    private static void initHSM(ServerProperties serverProperties) {
        try {
            String hsmConfig = serverProperties.getHSMConfigurazione();
            if (StringUtils.isNotEmpty((CharSequence)hsmConfig)) {
                log.info("Inizializzazione HSM in corso...");
                File f = new File(hsmConfig);
                HSMManager.init((File)f, (boolean)serverProperties.isHSMRequired(), (Logger)log, (boolean)false);
                HSMUtils.setHsmConfigurableKeyPassword((boolean)serverProperties.isHSMKeyPasswordConfigurable());
                log.info("Inizializzazione HSM effettuata con successo");
            }
        }
        catch (Exception e) {
            Startup.doError("Errore durante l'inizializzazione del manager HSM", e);
        }
    }

    private static void initOCSP(ServerProperties serverProperties) {
        log.info("Inizializzazione OCSP in corso...");
        try {
            String ocspConfig = serverProperties.getOCSPConfigurazione();
            if (StringUtils.isNotEmpty((CharSequence)ocspConfig)) {
                File f = new File(ocspConfig);
                OCSPManager.init((File)f, (boolean)serverProperties.isOCSPRequired(), (boolean)serverProperties.isOCSPLoadDefault(), (Logger)log);
            }
        }
        catch (Exception e) {
            Startup.doError("Errore durante l'inizializzazione del manager OCSP", e);
        }
        log.info("Inizializzazione OCSP effettuata con successo");
    }

    private static void logAndThrow(String msgErrore, Exception e) {
        log.error(msgErrore, (Throwable)e);
        throw new UtilsRuntimeException(msgErrore, (Throwable)e);
    }

    private static void doError(String msg, Exception e) {
        String msgErrore = msg + ": " + e.getMessage();
        log.error(msgErrore, (Throwable)e);
        throw new UtilsRuntimeException(msgErrore, (Throwable)e);
    }

    static {
        initializedLog = false;
        initializedResources = false;
    }
}

