/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api.impl.fruizioni.gruppi;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.constants.TipoAutenticazionePrincipal;
import org.openspcoop2.core.config.rs.server.api.FruizioniGruppiApi;
import org.openspcoop2.core.config.rs.server.api.impl.Enums;
import org.openspcoop2.core.config.rs.server.api.impl.Helper;
import org.openspcoop2.core.config.rs.server.api.impl.IdServizio;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ErogazioniApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ErogazioniEnv;
import org.openspcoop2.core.config.rs.server.config.ServerProperties;
import org.openspcoop2.core.config.rs.server.model.ApiDescrizione;
import org.openspcoop2.core.config.rs.server.model.Gruppo;
import org.openspcoop2.core.config.rs.server.model.GruppoAzioni;
import org.openspcoop2.core.config.rs.server.model.GruppoEreditaConfigurazione;
import org.openspcoop2.core.config.rs.server.model.GruppoItem;
import org.openspcoop2.core.config.rs.server.model.GruppoNome;
import org.openspcoop2.core.config.rs.server.model.GruppoNuovaConfigurazione;
import org.openspcoop2.core.config.rs.server.model.ListaGruppi;
import org.openspcoop2.core.config.rs.server.model.ModalitaConfigurazioneGruppoEnum;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.service.BaseImpl;
import org.openspcoop2.utils.service.authorization.AuthorizationConfig;
import org.openspcoop2.utils.service.authorization.AuthorizationManager;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.beans.utils.BaseHelper;
import org.openspcoop2.utils.service.beans.utils.ListaUtils;
import org.openspcoop2.utils.service.context.IContext;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaFruitoriPorteDelegateMappingInfo;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaHelper;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaUtilities;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateCore;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateHelper;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateUtilities;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.LoggerFactory;

public class FruizioniGruppiApiServiceImpl
extends BaseImpl
implements FruizioniGruppiApi {
    public FruizioniGruppiApiServiceImpl() {
        super(LoggerFactory.getLogger(FruizioniGruppiApiServiceImpl.class));
    }

    private AuthorizationConfig getAuthorizationConfig() throws Exception {
        return new AuthorizationConfig(ServerProperties.getInstance().getProperties());
    }

    @Override
    public void addFruizioneGruppoAzioni(GruppoAzioni body, String erogatore, String nome, Integer versione, String nomeGruppo, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            IDPortaDelegata idPd = (IDPortaDelegata)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getIDGruppoPD(nomeGruppo, env.idSoggetto.toIDSoggetto(), idAsps, env.apsCore), (String)"Gruppo per la fruizione scelta");
            PortaDelegata pd = env.pdCore.getPortaDelegata(idPd);
            List<String> azioniOccupate = ErogazioniApiHelper.getAzioniOccupateFruizione(idAsps, env.idSoggetto.toIDSoggetto(), env.apsCore, env.pdCore);
            ErogazioniApiHelper.checkAzioniAdd(body.getAzioni(), azioniOccupate, env.apcCore.getAzioni(asps, env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue()), false, false, null));
            env.requestWrapper.overrideParameterValues("azioni", body.getAzioni().toArray(new String[0]));
            long idFruizione = env.apsCore.getIdFruizioneAccordoServizioParteSpecifica(env.idSoggetto.toIDSoggetto(), (IDServizio)idAsps);
            List listaMappingFruizione = env.apsCore.serviziFruitoriMappingList(Long.valueOf(idFruizione), env.idSoggetto.toIDSoggetto(), (IDServizio)idAsps, null);
            if (!env.paHelper.porteDelAzioneCheckData(TipoOperazione.ADD, azioniOccupate, listaMappingFruizione)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            for (String azione : body.getAzioni()) {
                pd.getAzione().addAzioneDelegata(azione);
            }
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void createFruizioneGruppo(Gruppo body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            String mappingPadre = null;
            String fruizioneAutenticazione = null;
            String fruizioneAutenticazioneOpzionale = null;
            TipoAutenticazionePrincipal fruizioneAutenticazionePrincipal = null;
            List<String> fruizioneAutenticazioneParametroList = null;
            if (body.getConfigurazione().getModalita() == ModalitaConfigurazioneGruppoEnum.NUOVA) {
                GruppoNuovaConfigurazione confNuova = (GruppoNuovaConfigurazione)ErogazioniApiHelper.deserializeModalitaConfGruppo(body.getConfigurazione().getModalita(), body.getConfigurazione());
                if (confNuova.getAutenticazione() != null) {
                    fruizioneAutenticazione = Enums.toTipoAutenticazione(confNuova.getAutenticazione().getTipo()).toString();
                    BooleanNullable autenticazioneOpzionaleNullable = ErogazioniApiHelper.getAutenticazioneOpzionale(confNuova.getAutenticazione());
                    fruizioneAutenticazioneOpzionale = ServletUtils.boolToCheckBoxStatus((Boolean)(autenticazioneOpzionaleNullable != null ? autenticazioneOpzionaleNullable.getValue() : null));
                    fruizioneAutenticazionePrincipal = ErogazioniApiHelper.getTipoAutenticazionePrincipal(confNuova.getAutenticazione());
                    fruizioneAutenticazioneParametroList = ErogazioniApiHelper.getAutenticazioneParametroList(env, confNuova.getAutenticazione().getTipo(), confNuova.getAutenticazione());
                }
            } else if (body.getConfigurazione().getModalita() == ModalitaConfigurazioneGruppoEnum.EREDITA) {
                GruppoEreditaConfigurazione confEredita = (GruppoEreditaConfigurazione)ErogazioniApiHelper.deserializeModalitaConfGruppo(body.getConfigurazione().getModalita(), body.getConfigurazione());
                List<MappingFruizionePortaDelegata> mappings = ErogazioniApiHelper.getMappingGruppiPD(confEredita.getNome(), env.idSoggetto.toIDSoggetto(), idAsps, env.apsCore);
                if (mappings.isEmpty()) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il gruppo " + confEredita.getNome() + " da cui ereditare \u00e8 inesistente");
                }
                mappingPadre = mappings.get(0).getNome();
            }
            AccordiServizioParteSpecificaFruitoriPorteDelegateMappingInfo mappingInfo = AccordiServizioParteSpecificaUtilities.getMappingInfo(mappingPadre, (IDSoggetto)env.idSoggetto.toIDSoggetto(), (AccordoServizioParteSpecifica)asps, (AccordiServizioParteSpecificaCore)env.apsCore);
            MappingFruizionePortaDelegata mappingSelezionato = mappingInfo.getMappingSelezionato();
            MappingFruizionePortaDelegata mappingDefault = mappingInfo.getMappingDefault();
            if (mappingDefault == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna fruizione trovata");
            }
            if (mappingSelezionato == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Gruppo con nome  non trovato");
            }
            List azioniOccupate = mappingInfo.getAzioniOccupate();
            ErogazioniApiHelper.checkAzioniAdd(body.getAzioni(), azioniOccupate, env.apcCore.getAzioni(asps, env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue()), false, false, null));
            if (!env.apsHelper.configurazioneFruizioneCheckData(TipoOperazione.ADD, mappingInfo.getNomeNuovaConfigurazione(), body.getNome(), body.getAzioni().toArray(new String[0]), asps, azioniOccupate, body.getConfigurazione().getModalita().toString(), null, env.isSupportatoAutenticazioneSoggetti, mappingInfo)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            AccordiServizioParteSpecificaUtilities.addAccordoServizioParteSpecificaPorteDelegate((MappingFruizionePortaDelegata)mappingDefault, (MappingFruizionePortaDelegata)mappingSelezionato, (String)mappingInfo.getNomeNuovaConfigurazione(), (String)body.getNome(), (String[])body.getAzioni().toArray(new String[0]), (String)body.getConfigurazione().getModalita().toString(), (String)body.getConfigurazione().getModalita().toString(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, (boolean)false, (boolean)true, null, null, null, null, (boolean)false, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, (String)"no", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, (boolean)false, null, null, (String)fruizioneAutenticazione, (String)fruizioneAutenticazioneOpzionale, (TipoAutenticazionePrincipal)fruizioneAutenticazionePrincipal, fruizioneAutenticazioneParametroList, (String)"disabilitato", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, (String)"disabilitato", null, null, null, null, null, null, null, null, null, null, null, (IDSoggetto)env.idSoggetto.toIDSoggetto(), (AccordoServizioParteSpecifica)asps, (String)env.userLogin, (AccordiServizioParteSpecificaCore)env.apsCore, (AccordiServizioParteSpecificaHelper)env.apsHelper, null, null, null, null, null, null, null, null);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteFruizioneGruppo(String erogatore, String nome, Integer versione, String nomeGruppo, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            IDPortaDelegata idPortaDelegata = ErogazioniApiHelper.getIDGruppoPD(nomeGruppo, env.idSoggetto.toIDSoggetto(), idAsps, env.apsCore);
            if (idPortaDelegata != null) {
                StringBuilder inUsoMessage = new StringBuilder();
                AccordiServizioParteSpecificaUtilities.deleteAccordoServizioParteSpecificaFruitoriPorteDelegate(new ArrayList<IDPortaDelegata>(Arrays.asList(idPortaDelegata)), (AccordoServizioParteSpecifica)asps, (IDSoggetto)env.idSoggetto.toIDSoggetto(), (String)env.userLogin, (AccordiServizioParteSpecificaCore)env.apsCore, (AccordiServizioParteSpecificaHelper)env.apsHelper, (StringBuilder)inUsoMessage);
                if (inUsoMessage.length() > 0) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)inUsoMessage.toString()));
                }
            } else if (env.delete_404) {
                throw FaultCode.NOT_FOUND.toException("Gruppo " + nomeGruppo + " non associato alla fruizione");
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteFruizioneGruppoAzione(String erogatore, String nome, Integer versione, String nomeGruppo, String nomeAzione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            IDPortaDelegata idPd = (IDPortaDelegata)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getIDGruppoPD(nomeGruppo, env.idSoggetto.toIDSoggetto(), idAsps, env.apsCore), (String)"Gruppo per la fruizione scelta");
            PortaDelegata pd = env.pdCore.getPortaDelegata(idPd);
            if (BaseHelper.findFirst((Iterable)pd.getAzione().getAzioneDelegataList(), a -> a.equals(nomeAzione)).isPresent()) {
                StringBuilder inUsoMessage = new StringBuilder();
                PorteDelegateUtilities.deletePortaDelegataAzioni((PortaDelegata)pd, (AccordoServizioParteSpecifica)asps, (PorteDelegateCore)env.pdCore, (PorteDelegateHelper)env.pdHelper, (StringBuilder)inUsoMessage, new ArrayList<String>(Arrays.asList(nomeAzione)), (String)env.userLogin);
                if (inUsoMessage.length() > 0) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)inUsoMessage.toString()));
                }
            } else if (env.delete_404) {
                throw FaultCode.NOT_FOUND.toException("Azione " + nomeAzione + " non associata al gruppo " + nomeGruppo);
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaGruppi findAllFruizioneGruppi(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio, Integer limit, Integer offset, String azione) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            int idLista = Liste.CONFIGURAZIONE_FRUIZIONE;
            ConsoleSearch ricerca = Helper.setupRicercaPaginata(null, limit, offset, idLista, env.idSoggetto.toIDSoggetto(), env.tipo_protocollo);
            if (!StringUtils.isEmpty((CharSequence)azione)) {
                ricerca.addFilter(idLista, "filtroAzione", azione);
            }
            List mappings = env.apsCore.serviziFruitoriMappingList(env.idSoggetto.toIDSoggetto(), (IDServizio)idAsps, (ISearch)ricerca);
            if (env.findall_404 && mappings.isEmpty()) {
                throw FaultCode.NOT_FOUND.toException("Nessun gruppo associato alla fruizione");
            }
            ListaGruppi ret = (ListaGruppi)ListaUtils.costruisciListaPaginata((UriInfo)context.getUriInfo(), (Integer)ricerca.getIndexIniziale(idLista), (Integer)ricerca.getPageSize(idLista), (long)ricerca.getNumEntries(idLista), ListaGruppi.class);
            for (MappingFruizionePortaDelegata m : mappings) {
                PortaDelegata pd = env.pdCore.getPortaDelegata(m.getIdPortaDelegata());
                GruppoItem g = new GruppoItem();
                g.setAzioni(pd.getAzione().getAzioneDelegataList());
                g.setNome(m.getDescrizione());
                g.setPredefinito(m.isDefault());
                ret.addItemsItem(g);
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiDescrizione getFruizioneDescrizioneGruppo(String erogatore, String nome, Integer versione, String nomeGruppo, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            IDPortaDelegata idPortaDelegata = (IDPortaDelegata)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getIDGruppoPD(nomeGruppo, env.idSoggetto.toIDSoggetto(), idAsps, env.apsCore), (String)"Gruppo per la fruizione scelta");
            PortaDelegata pd = (PortaDelegata)BaseHelper.supplyOrNotFound(() -> env.pdCore.getPortaDelegata(idPortaDelegata), (String)"Gruppo per la fruizione scelta");
            ApiDescrizione descr = new ApiDescrizione();
            descr.setDescrizione(pd.getDescrizione());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return descr;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public GruppoAzioni getFruizioneGruppoAzioni(String erogatore, String nome, Integer versione, String nomeGruppo, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            IDPortaDelegata idPortaDelegata = (IDPortaDelegata)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getIDGruppoPD(nomeGruppo, env.idSoggetto.toIDSoggetto(), idAsps, env.apsCore), (String)"Gruppo per la fruizione scelta");
            PortaDelegata pd = (PortaDelegata)BaseHelper.supplyOrNotFound(() -> env.pdCore.getPortaDelegata(idPortaDelegata), (String)"Gruppo per la fruizione scelta");
            GruppoAzioni ret = new GruppoAzioni();
            ret.setAzioni(pd.getAzione().getAzioneDelegataList());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateFruizioneDescrizioneGruppo(ApiDescrizione body, String erogatore, String nome, Integer versione, String nomeGruppo, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            IDPortaDelegata idPortaDelegata = (IDPortaDelegata)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getIDGruppoPD(nomeGruppo, env.idSoggetto.toIDSoggetto(), idAsps, env.apsCore), (String)"Gruppo per la fruizione scelta");
            PortaDelegata pd = (PortaDelegata)BaseHelper.supplyOrNotFound(() -> env.pdCore.getPortaDelegata(idPortaDelegata), (String)"Gruppo per la fruizione scelta");
            pd.setDescrizione(body.getDescrizione());
            env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateFruizioneGruppoNome(GruppoNome body, String erogatore, String nome, Integer versione, String nomeGruppo, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            List listaMapping = env.apsCore.serviziFruitoriMappingList(env.idSoggetto.toIDSoggetto(), (IDServizio)idAsps, null);
            List<String> mappingUtilizzati = ErogazioniApiHelper.getDescrizioniMappingPD(listaMapping);
            BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getIDGruppoPD(nomeGruppo, env.idSoggetto.toIDSoggetto(), idAsps, env.apsCore), (String)"Gruppo per la fruizione scelta");
            if (mappingUtilizzati.stream().filter(m -> m.equalsIgnoreCase(body.getNome())).findFirst().isPresent()) {
                throw FaultCode.CONFLITTO.toException("Il nome gruppo indicato &egrave; gi&agrave; utilizzato in un'altra configurazione");
            }
            if (!env.paHelper.configurazioneCambiaNomeCheck(TipoOperazione.OTHER, body.getNome(), mappingUtilizzati, true)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            MappingFruizionePortaDelegata mapping = AccordiServizioParteSpecificaUtilities.getMappingPDFilterByDescription((List)listaMapping, (String)nomeGruppo);
            mapping.setDescrizione(body.getNome());
            env.pdCore.aggiornaDescrizioneMappingFruizionePortaDelegata(mapping, env.userLogin);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }
}

