/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api.impl.applicativi;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.Credenziali;
import org.openspcoop2.core.config.InvocazionePorta;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.rs.server.api.ApplicativiApi;
import org.openspcoop2.core.config.rs.server.api.impl.ApiKeyInfo;
import org.openspcoop2.core.config.rs.server.api.impl.Helper;
import org.openspcoop2.core.config.rs.server.api.impl.HttpRequestWrapper;
import org.openspcoop2.core.config.rs.server.api.impl.applicativi.ApplicativiApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.applicativi.ApplicativiEnv;
import org.openspcoop2.core.config.rs.server.config.ServerProperties;
import org.openspcoop2.core.config.rs.server.model.Applicativo;
import org.openspcoop2.core.config.rs.server.model.AuthenticationApiKey;
import org.openspcoop2.core.config.rs.server.model.AuthenticationHttpBasic;
import org.openspcoop2.core.config.rs.server.model.BaseCredenziali;
import org.openspcoop2.core.config.rs.server.model.ListaApplicativi;
import org.openspcoop2.core.config.rs.server.model.ModalitaAccessoEnum;
import org.openspcoop2.core.config.rs.server.model.OneOfBaseCredenzialiCredenziali;
import org.openspcoop2.core.config.rs.server.model.Proprieta4000OpzioneCifratura;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.utils.service.BaseImpl;
import org.openspcoop2.utils.service.authorization.AuthorizationConfig;
import org.openspcoop2.utils.service.authorization.AuthorizationManager;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.beans.utils.BaseHelper;
import org.openspcoop2.utils.service.beans.utils.ListaUtils;
import org.openspcoop2.utils.service.context.IContext;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiCore;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiGeneralInfo;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiHelper;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiUtilities;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.LoggerFactory;

public class ApplicativiApiServiceImpl
extends BaseImpl
implements ApplicativiApi {
    public ApplicativiApiServiceImpl() {
        super(LoggerFactory.getLogger(ApplicativiApiServiceImpl.class));
    }

    private AuthorizationConfig getAuthorizationConfig() throws Exception {
        return new AuthorizationConfig(ServerProperties.getInstance().getProperties());
    }

    @Override
    public void createApplicativo(Applicativo body, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            Applicativo applicativo = body;
            try {
                applicativo.setCredenziali(ApplicativiApiHelper.translateCredenzialiApplicativo(applicativo, true));
            }
            catch (WebApplicationException e) {
                throw e;
            }
            catch (Throwable e) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(e);
            }
            HttpRequestWrapper wrap = new HttpRequestWrapper(context.getServletRequest());
            ApplicativiEnv env = new ApplicativiEnv((HttpServletRequest)wrap, profilo, soggetto, context);
            String protocollo = env.protocolFactory.getProtocol();
            String tipoSoggetto = (String)ProtocolFactoryManager.getInstance().getDefaultOrganizationTypes().get((Object)protocollo);
            IDSoggetto idSoggetto = new IDSoggetto(tipoSoggetto, env.idSoggetto.getNome());
            IDServizioApplicativo idSA = new IDServizioApplicativo();
            idSA.setIdSoggettoProprietario(idSoggetto);
            idSA.setNome(applicativo.getNome());
            ApiKeyInfo keyInfo = ApplicativiApiHelper.createApiKey(applicativo.getCredenziali(), idSA, env.saCore, protocollo);
            boolean updateKey = false;
            ServizioApplicativo sa = ApplicativiApiHelper.applicativoToServizioApplicativo(applicativo, env.tipo_protocollo, env.idSoggetto.getNome(), env.stationCore, keyInfo, true);
            if (ApplicativiApiHelper.isApplicativoDuplicato(sa, env.saCore)) {
                throw FaultCode.CONFLITTO.toException("Il Servizio Applicativo " + sa.getNome() + " \u00e8 gi\u00e0 stato registrato per il soggetto scelto.");
            }
            ProtocolProperties protocolProperties = null;
            if (profilo != null && (protocolProperties = ApplicativiApiHelper.getProtocolProperties(body, profilo, sa, env)) != null) {
                sa.setProtocolPropertyList(ProtocolPropertiesUtils.toProtocolPropertiesConfig((ProtocolProperties)protocolProperties, (ConsoleOperationType)ConsoleOperationType.ADD, null));
            }
            ApplicativiApiHelper.overrideSAParameters(wrap, (ConsoleHelper)env.saHelper, sa, applicativo, keyInfo, updateKey);
            wrap.overrideParameter("protocollo", env.tipo_protocollo);
            List listaTipiProtocollo = ProtocolFactoryManager.getInstance().getProtocolNamesAsList();
            IDSoggetto soggettoMultitenantSelezionato = new IDSoggetto(env.idSoggetto.getTipo(), env.idSoggetto.getNome());
            String dominio = null;
            boolean dominioInterno = env.isDominioInterno(idSoggetto);
            if (!dominioInterno) {
                if (!(profilo == null || profilo.equals((Object)ProfiloEnum.APIGATEWAY) || profilo.equals((Object)ProfiloEnum.MODI) || profilo.equals((Object)ProfiloEnum.MODIPA))) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Impossibile creare un applicativo per un soggetto esterno col profilo [" + String.valueOf(profilo) + "]");
                }
                dominio = "esterno";
            }
            ApplicativiApiHelper.validateCredentials(applicativo.getCredenziali(), dominioInterno, profilo != null && (profilo.equals((Object)ProfiloEnum.MODI) || profilo.equals((Object)ProfiloEnum.MODIPA)));
            ServiziApplicativiGeneralInfo generalInfo = ServiziApplicativiUtilities.getGeneralInfo((boolean)false, (String)env.idSoggetto.getId().toString(), (List)listaTipiProtocollo, (ServiziApplicativiCore)env.saCore, (ServiziApplicativiHelper)env.saHelper, (String)env.userLogin, (boolean)true, (String)soggettoMultitenantSelezionato.toString(), (String)dominio);
            List listExtendedConnettore = null;
            if (!env.saHelper.servizioApplicativoCheckData(TipoOperazione.ADD, generalInfo.getSoggettiList(), -1L, sa.getTipologiaFruizione(), sa.getTipologiaErogazione(), listExtendedConnettore, null, new StringBuilder())) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            ApplicativiApiHelper.validateProperties(env, protocolProperties, sa, ConsoleOperationType.ADD);
            env.saCore.performCreateOperation(env.userLogin, false, new Object[]{sa});
            if (keyInfo != null) {
                context.getServletResponse().setHeader("X-Api-Key", keyInfo.getApiKey());
                if (keyInfo.isMultipleApiKeys()) {
                    context.getServletResponse().setHeader("X-App-Id", keyInfo.getAppId());
                }
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteApplicativo(String nome, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApplicativiEnv env = new ApplicativiEnv(context.getServletRequest(), profilo, soggetto, context);
            IDServizioApplicativo idServizioApplicativo = null;
            ServizioApplicativo sa = null;
            try {
                idServizioApplicativo = new IDServizioApplicativo();
                idServizioApplicativo.setIdSoggettoProprietario(env.idSoggetto.toIDSoggetto());
            }
            catch (Exception e) {
                throw FaultCode.NOT_FOUND.toException("Soggetto non trovato.");
            }
            idServizioApplicativo.setNome(nome);
            try {
                sa = env.saCore.getServizioApplicativo(idServizioApplicativo);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (sa != null) {
                StringBuilder inUsoMessage = new StringBuilder();
                ServiziApplicativiUtilities.deleteServizioApplicativo((ServizioApplicativo)sa, (String)context.getAuthentication().getName(), (ServiziApplicativiCore)env.saCore, (ServiziApplicativiHelper)env.saHelper, (StringBuilder)inUsoMessage, (String)"\n");
                if (inUsoMessage.length() > 0) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)inUsoMessage.toString()));
                }
            } else if (env.delete_404) {
                throw FaultCode.NOT_FOUND.toException("Servizio applicativo con nome: " + nome + " non trovato.");
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaApplicativi findAllApplicativi(ProfiloEnum profilo, String soggetto, String q, Integer limit, Integer offset, String ruolo, ModalitaAccessoEnum tipoCredenziali, Boolean profiloQualsiasi, Boolean soggettoQualsiasi) {
        IContext context = this.getContext();
        try {
            String filtro;
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApplicativiEnv env = new ApplicativiEnv(context.getServletRequest(), profilo, soggetto, context);
            int idLista = Liste.SERVIZIO_APPLICATIVO;
            ConsoleSearch ricerca = Helper.setupRicercaPaginata(q, limit, offset, idLista, env.idSoggetto.toIDSoggetto(), env.tipo_protocollo);
            if (profiloQualsiasi != null && profiloQualsiasi.booleanValue()) {
                ricerca.clearFilter(idLista, "filtroProtocollo");
            }
            if (soggettoQualsiasi != null && soggettoQualsiasi.booleanValue()) {
                ricerca.clearFilter(idLista, "filtroSoggetto");
            }
            ricerca.addFilter(idLista, "filtroTipoSA", "client");
            if (ruolo != null && ruolo.trim().length() > 0) {
                ricerca.addFilter(idLista, "filtroRuolo", ruolo.trim());
            }
            if (tipoCredenziali != null && (filtro = Helper.tipoAuthFromModalitaAccesso.get((Object)tipoCredenziali)) != null && !"".equals(filtro)) {
                ricerca.addFilter(idLista, "filtroTipoCredenziali", filtro);
            }
            List saLista = env.saCore.soggettiServizioApplicativoList(null, (ISearch)ricerca);
            ListaApplicativi ret = (ListaApplicativi)ListaUtils.costruisciListaPaginata((UriInfo)context.getUriInfo(), (Integer)ricerca.getIndexIniziale(idLista), (Integer)ricerca.getPageSize(idLista), (long)ricerca.getNumEntries(idLista), ListaApplicativi.class);
            saLista.forEach(sa -> ret.addItemsItem(ApplicativiApiHelper.servizioApplicativoToApplicativoItem(sa)));
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return Helper.returnOrNotFound(ret);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public Applicativo getApplicativo(String nome, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApplicativiEnv env = new ApplicativiEnv(context.getServletRequest(), profilo, soggetto, context);
            ServizioApplicativo sa = null;
            try {
                IDServizioApplicativo idServizioApplicativo = new IDServizioApplicativo();
                idServizioApplicativo.setIdSoggettoProprietario(env.idSoggetto.toIDSoggetto());
                idServizioApplicativo.setNome(nome);
                sa = env.saCore.getServizioApplicativo(idServizioApplicativo);
            }
            catch (Exception e) {
                throw FaultCode.NOT_FOUND.toException("Servizio applicativo con nome: " + nome + " non trovato.");
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            Applicativo applicativo = ApplicativiApiHelper.servizioApplicativoToApplicativo(sa);
            ApplicativiApiHelper.populateProtocolInfo(sa, applicativo, env, profilo);
            return applicativo;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateApplicativo(Applicativo body, String nome, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            Object apiKeyCred;
            boolean appId;
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            Applicativo applicativo = body;
            try {
                applicativo.setCredenziali(ApplicativiApiHelper.translateCredenzialiApplicativo(applicativo, false));
            }
            catch (WebApplicationException e) {
                throw e;
            }
            catch (Throwable e) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(e);
            }
            ApplicativiEnv env = new ApplicativiEnv(context.getServletRequest(), profilo, soggetto, context);
            soggetto = env.idSoggetto.getNome();
            ServizioApplicativo oldSa = (ServizioApplicativo)BaseHelper.supplyOrNotFound(() -> ApplicativiApiHelper.getServizioApplicativo(nome, env.idSoggetto.getNome(), env.tipo_protocollo, env.saCore), (String)"Servizio Applicativo");
            ApiKeyInfo keyInfo = ApplicativiApiHelper.getApiKey(oldSa, false);
            boolean updateKey = false;
            ServizioApplicativo tmpSa = ApplicativiApiHelper.applicativoToServizioApplicativo(applicativo, env.tipo_protocollo, soggetto, env.stationCore, keyInfo, false);
            ServizioApplicativo newSa = ApplicativiApiHelper.getServizioApplicativo(nome, env.idSoggetto.getNome(), env.tipo_protocollo, env.saCore);
            if (ModalitaAccessoEnum.HTTP_BASIC.equals((Object)body.getCredenziali().getModalitaAccesso())) {
                AuthenticationHttpBasic httpBasic = (AuthenticationHttpBasic)body.getCredenziali();
                if (httpBasic.getPassword() == null || StringUtils.isEmpty((CharSequence)httpBasic.getPassword())) {
                    boolean set = false;
                    if (newSa.getInvocazionePorta() != null && newSa.getInvocazionePorta().sizeCredenzialiList() > 0) {
                        Credenziali cTmp;
                        Credenziali cNewSaImageDB = newSa.getInvocazionePorta().getCredenziali(0);
                        Credenziali credenziali = cTmp = tmpSa.getInvocazionePorta().sizeCredenzialiList() > 0 ? tmpSa.getInvocazionePorta().getCredenziali(0) : null;
                        if (cNewSaImageDB != null && cTmp != null) {
                            cTmp.setPassword(cNewSaImageDB.getPassword());
                            cTmp.setCertificateStrictVerification(cNewSaImageDB.isCertificateStrictVerification());
                            set = true;
                        }
                    }
                    if (!set) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Tipo di autenticazione '" + String.valueOf((Object)body.getCredenziali().getModalitaAccesso()) + "'; indicare la password");
                    }
                }
            } else if (ModalitaAccessoEnum.API_KEY.equals((Object)body.getCredenziali().getModalitaAccesso()) && (appId = Helper.isAppId(((AuthenticationApiKey)(apiKeyCred = (AuthenticationApiKey)body.getCredenziali())).isAppId())) != keyInfo.isMultipleApiKeys()) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Tipo di autenticazione '" + String.valueOf((Object)body.getCredenziali().getModalitaAccesso()) + "'; modifica del tipo (appId) non consentita");
            }
            newSa.setNome(tmpSa.getNome());
            newSa.setDescrizione(tmpSa.getDescrizione());
            newSa.setIdSoggetto(tmpSa.getIdSoggetto());
            newSa.setNomeSoggettoProprietario(tmpSa.getNomeSoggettoProprietario());
            newSa.setTipoSoggettoProprietario(tmpSa.getTipoSoggettoProprietario());
            newSa.getInvocazionePorta().setCredenzialiList(tmpSa.getInvocazionePorta().getCredenzialiList());
            newSa.getInvocazionePorta().setRuoli(tmpSa.getInvocazionePorta().getRuoli());
            newSa.getProprietaList().clear();
            if (applicativo.getProprieta() != null && !applicativo.getProprieta().isEmpty()) {
                for (Proprieta4000OpzioneCifratura proprieta : applicativo.getProprieta()) {
                    Proprieta pConfig = new Proprieta();
                    pConfig.setNome(proprieta.getNome());
                    if (env.saCore != null && env.saCore.getDriverBYOKUtilities() != null && proprieta.isEncrypted() != null && proprieta.isEncrypted().booleanValue()) {
                        pConfig.setValore(env.saCore.getDriverBYOKUtilities().wrap(proprieta.getValore()));
                    } else {
                        if (proprieta.getValore().length() > 4000) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il valore della propriet\u00e0 non deve superare i 4000 caratteri");
                        }
                        pConfig.setValore(proprieta.getValore());
                    }
                    newSa.addProprieta(pConfig);
                }
            }
            ProtocolProperties protocolProperties = null;
            if (profilo != null && (protocolProperties = ApplicativiApiHelper.getProtocolProperties(body, profilo, newSa, env)) != null) {
                newSa.setProtocolPropertyList(ProtocolPropertiesUtils.toProtocolPropertiesConfig((ProtocolProperties)protocolProperties, (ConsoleOperationType)ConsoleOperationType.ADD, null));
            }
            IDServizioApplicativo oldID = new IDServizioApplicativo();
            oldID.setIdSoggettoProprietario(ApplicativiApiHelper.getIDSoggetto(oldSa.getNomeSoggettoProprietario(), env.tipo_protocollo));
            oldID.setNome(oldSa.getNome());
            newSa.setOldIDServizioApplicativoForUpdate(oldID);
            boolean dominioInternoNewSoggetto = env.isDominioInterno(new IDSoggetto(newSa.getTipoSoggettoProprietario(), newSa.getNomeSoggettoProprietario()));
            ApplicativiApiHelper.validateCredentials(applicativo.getCredenziali(), dominioInternoNewSoggetto, profilo != null && (profilo.equals((Object)ProfiloEnum.MODI) || profilo.equals((Object)ProfiloEnum.MODIPA)));
            List listExtendedConnettore = null;
            ApplicativiApiHelper.overrideSAParameters(env.requestWrapper, (ConsoleHelper)env.saHelper, newSa, applicativo, keyInfo, updateKey);
            env.requestWrapper.overrideParameter("protocollo", env.tipo_protocollo);
            if (!env.saHelper.servizioApplicativoCheckData(TipoOperazione.CHANGE, null, oldSa.getIdSoggetto().longValue(), newSa.getTipologiaFruizione(), newSa.getTipologiaErogazione(), listExtendedConnettore, newSa, new StringBuilder())) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            ApplicativiApiHelper.validateProperties(env, protocolProperties, newSa, ConsoleOperationType.CHANGE);
            List listOggettiDaAggiornare = ServiziApplicativiUtilities.getOggettiDaAggiornare((ServiziApplicativiCore)env.saCore, (IDServizioApplicativo)oldID, (ServizioApplicativo)newSa);
            env.saCore.performUpdateOperation(env.userLogin, false, listOggettiDaAggiornare.toArray());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateCredenzialiApplicativo(BaseCredenziali body, String nome, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            OneOfBaseCredenzialiCredenziali credenziali = null;
            try {
                credenziali = ApplicativiApiHelper.translateCredenzialiApplicativo(body, true);
            }
            catch (WebApplicationException e) {
                throw e;
            }
            catch (Throwable e) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(e);
            }
            ApplicativiEnv env = new ApplicativiEnv(context.getServletRequest(), profilo, soggetto, context);
            ServizioApplicativo oldSa = (ServizioApplicativo)BaseHelper.supplyOrNotFound(() -> ApplicativiApiHelper.getServizioApplicativo(nome, env.idSoggetto.getNome(), env.tipo_protocollo, env.saCore), (String)"Servizio Applicativo");
            IDServizioApplicativo oldID = new IDServizioApplicativo();
            oldID.setIdSoggettoProprietario(ApplicativiApiHelper.getIDSoggetto(oldSa.getNomeSoggettoProprietario(), env.tipo_protocollo));
            oldID.setNome(oldSa.getNome());
            ApiKeyInfo keyInfo = ApplicativiApiHelper.createApiKey(credenziali, oldID, env.saCore, env.protocolFactory.getProtocol());
            boolean updateKey = true;
            List<Credenziali> newCredenziali = ApplicativiApiHelper.credenzialiFromAuth(credenziali, keyInfo);
            if (oldSa.getInvocazionePorta() == null) {
                oldSa.setInvocazionePorta(new InvocazionePorta());
            }
            oldSa.getInvocazionePorta().getCredenzialiList().clear();
            oldSa.getInvocazionePorta().getCredenzialiList().addAll(newCredenziali);
            oldSa.setOldIDServizioApplicativoForUpdate(oldID);
            boolean dominioInterno = env.isDominioInterno(oldID.getIdSoggettoProprietario());
            ApplicativiApiHelper.validateCredentials(body.getCredenziali(), dominioInterno, profilo != null && (profilo.equals((Object)ProfiloEnum.MODI) || profilo.equals((Object)ProfiloEnum.MODIPA)));
            List listExtendedConnettore = null;
            ApplicativiApiHelper.overrideSAParameters(env.requestWrapper, (ConsoleHelper)env.saHelper, oldSa, credenziali, keyInfo, updateKey);
            env.requestWrapper.overrideParameter("protocollo", env.tipo_protocollo);
            if (!env.saHelper.servizioApplicativoCheckData(TipoOperazione.CHANGE, null, oldSa.getIdSoggetto().longValue(), oldSa.getTipologiaFruizione(), oldSa.getTipologiaErogazione(), listExtendedConnettore, oldSa, new StringBuilder())) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            List listOggettiDaAggiornare = ServiziApplicativiUtilities.getOggettiDaAggiornare((ServiziApplicativiCore)env.saCore, (IDServizioApplicativo)oldID, (ServizioApplicativo)oldSa);
            env.saCore.performUpdateOperation(env.userLogin, false, listOggettiDaAggiornare.toArray());
            if (keyInfo != null) {
                context.getServletResponse().setHeader("X-Api-Key", keyInfo.getApiKey());
                if (keyInfo.isMultipleApiKeys()) {
                    context.getServletResponse().setHeader("X-App-Id", keyInfo.getAppId());
                }
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }
}

