/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.openspcoop2.core.config.rs.server.model.ApiDescrizione;
import org.openspcoop2.core.config.rs.server.model.Gruppo;
import org.openspcoop2.core.config.rs.server.model.GruppoAzioni;
import org.openspcoop2.core.config.rs.server.model.GruppoNome;
import org.openspcoop2.core.config.rs.server.model.ListaGruppi;
import org.openspcoop2.core.config.rs.server.model.Problem;
import org.openspcoop2.utils.service.beans.ProfiloEnum;

@Path(value="/")
public interface ErogazioniGruppiApi {
    @POST
    @Path(value="/erogazioni/{nome}/{versione}/gruppi/{nome_gruppo}/azioni")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Aggiunta di azioni o risorse dell'API al gruppo", tags={"erogazioni-gruppi"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Resource created"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Conflict (L'entit\u00e0 che si vuole creare risulta gi\u00e0 esistente)", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void addErogazioneGruppoAzioni(@Valid GruppoAzioni var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @PathParam(value="nome_gruppo") @Size(max=255) @Size(max=255) String var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @POST
    @Path(value="/erogazioni/{nome}/{versione}/gruppi")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Creazione di un gruppo di azioni o risorse dell'API erogata", tags={"erogazioni-gruppi"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Resource created"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Conflict (L'entit\u00e0 che si vuole creare risulta gi\u00e0 esistente)", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void createErogazioneGruppo(@Valid Gruppo var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @DELETE
    @Path(value="/erogazioni/{nome}/{versione}/gruppi/{nome_gruppo}")
    @Produces(value={"application/problem+json"})
    @Operation(summary="Elimina il gruppo identificato dal nome", tags={"erogazioni-gruppi"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Gruppo eliminate con successo"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void deleteErogazioneGruppo(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @PathParam(value="nome_gruppo") @Size(max=255) @Size(max=255) String var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @DELETE
    @Path(value="/erogazioni/{nome}/{versione}/gruppi/{nome_gruppo}/azioni/{nome_azione}")
    @Produces(value={"application/problem+json"})
    @Operation(summary="Elimina l'azione o la risorsa dell'API associata al gruppo", tags={"erogazioni-gruppi"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Azione eliminate con successo"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void deleteErogazioneGruppoAzione(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @PathParam(value="nome_gruppo") @Size(max=255) @Size(max=255) String var3, @PathParam(value="nome_azione") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/gruppi")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Ricerca i gruppi in cui sono stati classificate le azioni o le risorse dell'API", tags={"erogazioni-gruppi"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ricerca eseguita correttamente", content={@Content(mediaType="application/json", schema=@Schema(implementation=ListaGruppi.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ListaGruppi findAllErogazioneGruppi(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var5, @QueryParam(value="limit") Integer var6, @QueryParam(value="offset") @DefaultValue(value="0") Integer var7, @QueryParam(value="azione") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var8);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/gruppi/{nome_gruppo}/descrizione")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce la descrizione del gruppo", tags={"erogazioni-gruppi"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dati della descrizione restituiti con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiDescrizione.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ApiDescrizione getErogazioneDescrizioneGruppo(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @PathParam(value="nome_gruppo") @Size(max=255) @Size(max=255) String var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/gruppi/{nome_gruppo}")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce azioni/risorse associate al gruppo identificato dal nome", tags={"erogazioni-gruppi"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Elenco di azioni/risorse restituite con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=GruppoAzioni.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public GruppoAzioni getErogazioneGruppoAzioni(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @PathParam(value="nome_gruppo") @Size(max=255) @Size(max=255) String var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @PUT
    @Path(value="/erogazioni/{nome}/{versione}/gruppi/{nome_gruppo}/descrizione")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare la descrizione del gruppo", tags={"erogazioni-gruppi"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="La descrizione \u00e8 stato aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void updateErogazioneDescrizioneGruppo(@Valid ApiDescrizione var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @PathParam(value="nome_gruppo") @Size(max=255) @Size(max=255) String var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @PUT
    @Path(value="/erogazioni/{nome}/{versione}/gruppi/{nome_gruppo}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare il nome del gruppo", tags={"erogazioni-gruppi"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Configurazione del gruppo aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void updateErogazioneGruppoNome(@Valid GruppoNome var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @PathParam(value="nome_gruppo") @Size(max=255) @Size(max=255) String var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);
}

