/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.File;
import org.openspcoop2.core.config.rs.server.model.ApiCanale;
import org.openspcoop2.core.config.rs.server.model.ApiImplStato;
import org.openspcoop2.core.config.rs.server.model.CachingRisposta;
import org.openspcoop2.core.config.rs.server.model.ConfigurazioneApiCanale;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutenticazione;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazione;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneRuoli;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneRuolo;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneScope;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneScopes;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneSoggetti;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneSoggetto;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneView;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiErogazioneAutorizzazioneApplicativi;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiErogazioneAutorizzazioneApplicativo;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiGestioneToken;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiIdentificazioneAttributi;
import org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRichiesta;
import org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRisposta;
import org.openspcoop2.core.config.rs.server.model.ElencoProprieta;
import org.openspcoop2.core.config.rs.server.model.GestioneCors;
import org.openspcoop2.core.config.rs.server.model.ListaCorrelazioneApplicativaRichiesta;
import org.openspcoop2.core.config.rs.server.model.ListaCorrelazioneApplicativaRisposta;
import org.openspcoop2.core.config.rs.server.model.ListaRateLimitingPolicy;
import org.openspcoop2.core.config.rs.server.model.Problem;
import org.openspcoop2.core.config.rs.server.model.ProprietaOpzioneCifratura;
import org.openspcoop2.core.config.rs.server.model.RateLimitingCriteriMetricaEnum;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyErogazione;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyErogazioneUpdate;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyErogazioneView;
import org.openspcoop2.core.config.rs.server.model.RegistrazioneDiagnosticiConfigurazione;
import org.openspcoop2.core.config.rs.server.model.RegistrazioneMessaggi;
import org.openspcoop2.core.config.rs.server.model.RegistrazioneTransazioniConfigurazione;
import org.openspcoop2.core.config.rs.server.model.Validazione;
import org.openspcoop2.utils.service.beans.ProfiloEnum;

@Path(value="/")
public interface ErogazioniConfigurazioneApi {
    @POST
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/applicativi")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Aggiunta di applicativi all'elenco degli applicativi autorizzati", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Resource created"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Conflict (L'entit\u00e0 che si vuole creare risulta gi\u00e0 esistente)", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void addErogazioneControlloAccessiAutorizzazioneApplicativi(@Valid ControlloAccessiErogazioneAutorizzazioneApplicativo var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @POST
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/token/applicativi")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Aggiunta di applicativi token all'elenco degli applicativi autorizzati", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Resource created"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Conflict (L'entit\u00e0 che si vuole creare risulta gi\u00e0 esistente)", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void addErogazioneControlloAccessiAutorizzazioneApplicativiToken(@Valid ControlloAccessiErogazioneAutorizzazioneApplicativo var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @POST
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/ruoli")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Aggiunta di ruoli all'elenco dei ruoli autorizzati", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Resource created"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Conflict (L'entit\u00e0 che si vuole creare risulta gi\u00e0 esistente)", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void addErogazioneControlloAccessiAutorizzazioneRuoli(@Valid ControlloAccessiAutorizzazioneRuolo var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @POST
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/token/ruoli")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Aggiunta di ruoli all'elenco dei ruoli token autorizzati", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Resource created"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Conflict (L'entit\u00e0 che si vuole creare risulta gi\u00e0 esistente)", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void addErogazioneControlloAccessiAutorizzazioneRuoliToken(@Valid ControlloAccessiAutorizzazioneRuolo var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @POST
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/scope")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Aggiunta di scope all'elenco degli scope autorizzati", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Resource created"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Conflict (L'entit\u00e0 che si vuole creare risulta gi\u00e0 esistente)", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void addErogazioneControlloAccessiAutorizzazioneScope(@Valid ControlloAccessiAutorizzazioneScope var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @POST
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/soggetti")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Aggiunta di soggetti all'elenco dei soggetti autorizzati", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Resource created"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Conflict (L'entit\u00e0 che si vuole creare risulta gi\u00e0 esistente)", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void addErogazioneControlloAccessiAutorizzazioneSoggetti(@Valid ControlloAccessiAutorizzazioneSoggetto var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @POST
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/proprieta")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Aggiunta di una propriet\u00e0 di configurazione", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Resource created"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Conflict (L'entit\u00e0 che si vuole creare risulta gi\u00e0 esistente)", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void addErogazioneProprieta(@Valid ProprietaOpzioneCifratura var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @POST
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/rate-limiting")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Aggiunta di una policy di rate limiting", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Resource created"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Conflict (L'entit\u00e0 che si vuole creare risulta gi\u00e0 esistente)", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void addErogazioneRateLimitingPolicy(@Valid RateLimitingPolicyErogazione var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @POST
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/tracciamento/correlazione-applicativa/richiesta")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Aggiunta di una regola di correlazione applicativa", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Resource created"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Conflict (L'entit\u00e0 che si vuole creare risulta gi\u00e0 esistente)", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void addErogazioneTracciamentoCorrelazioneApplicativaRichiesta(@Valid CorrelazioneApplicativaRichiesta var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @POST
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/tracciamento/correlazione-applicativa/risposta")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Aggiunta di una regola di correlazione applicativa", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Resource created"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Conflict (L'entit\u00e0 che si vuole creare risulta gi\u00e0 esistente)", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void addErogazioneTracciamentoCorrelazioneApplicativaRisposta(@Valid CorrelazioneApplicativaRisposta var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @DELETE
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/applicativi/{applicativo_autorizzato}")
    @Produces(value={"application/problem+json"})
    @Operation(summary="Elimina applicativi dall'elenco degli applicativi autorizzati", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Applicativi eliminati con successo"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void deleteErogazioneControlloAccessiAutorizzazioneApplicativi(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @PathParam(value="applicativo_autorizzato") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="soggetto_applicativo") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @DELETE
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/token/applicativi/{applicativo_autorizzato}")
    @Produces(value={"application/problem+json"})
    @Operation(summary="Elimina applicativi dall'elenco degli applicativi token autorizzati", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Applicativi Token eliminati con successo"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void deleteErogazioneControlloAccessiAutorizzazioneApplicativiToken(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @PathParam(value="applicativo_autorizzato") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="soggetto_applicativo") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @DELETE
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/ruoli/{ruolo_autorizzato}")
    @Produces(value={"application/problem+json"})
    @Operation(summary="Elimina ruoli dall'elenco dei ruoli autorizzati", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Ruoli eliminati con successo"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void deleteErogazioneControlloAccessiAutorizzazioneRuoli(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @PathParam(value="ruolo_autorizzato") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @DELETE
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/token/ruoli/{ruolo_autorizzato}")
    @Produces(value={"application/problem+json"})
    @Operation(summary="Elimina ruoli dall'elenco dei ruoli token autorizzati", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Ruoli eliminati con successo"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void deleteErogazioneControlloAccessiAutorizzazioneRuoliToken(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @PathParam(value="ruolo_autorizzato") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @DELETE
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/scope/{scope_autorizzato}")
    @Produces(value={"application/problem+json"})
    @Operation(summary="Elimina scope dall'elenco degli scope autorizzati", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Scope eliminati con successo"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void deleteErogazioneControlloAccessiAutorizzazioneScope(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @PathParam(value="scope_autorizzato") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @DELETE
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/soggetti/{soggetto_autorizzato}")
    @Produces(value={"application/problem+json"})
    @Operation(summary="Elimina soggetti all'elenco dei soggetti autorizzati", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Soggetti eliminati con successo"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void deleteErogazioneControlloAccessiAutorizzazioneSoggetti(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @PathParam(value="soggetto_autorizzato") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @DELETE
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/proprieta/{proprieta}")
    @Produces(value={"application/problem+json"})
    @Operation(summary="Elimina la propriet\u00e0 di configurazione dall'elenco di quelle attivate", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Propriet\u00e0 di configurazione eliminata con successo"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void deleteErogazioneProprietaConfigurazione(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @PathParam(value="proprieta") @Size(max=255) @Size(max=255) String var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @DELETE
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/rate-limiting/{id_policy}")
    @Produces(value={"application/problem+json"})
    @Operation(summary="Elimina la policy dall'elenco delle policies attive", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Policy eliminata con successo"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void deleteErogazioneRateLimitingPolicy(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @PathParam(value="id_policy") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @DELETE
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/tracciamento/correlazione-applicativa/richiesta/{elemento}")
    @Produces(value={"application/problem+json"})
    @Operation(summary="Elimina la regola di correlazione applicativa dall'elenco di quelle attivate per la richiesta", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Regola eliminata con successo"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void deleteErogazioneTracciamentoCorrelazioneApplicativaRichiesta(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @PathParam(value="elemento") @Size(max=255) @Size(max=255) String var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @DELETE
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/tracciamento/correlazione-applicativa/risposta/{elemento}")
    @Produces(value={"application/problem+json"})
    @Operation(summary="Elimina la regola di correlazione applicativa dall'elenco di quelle attivate per la risposta", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Regola eliminata con successo"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void deleteErogazioneTracciamentoCorrelazioneApplicativaRisposta(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @PathParam(value="elemento") @Size(max=255) @Size(max=255) String var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/download-xacml-policy")
    @Produces(value={"application/xml", "application/problem+json"})
    @Operation(summary="Restituisce la policy XACML associata all'autorizzazione", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Interfaccia dell'API restituita con successo", content={@Content(mediaType="application/xml", schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public byte[] downloadErogazioneControlloAccessiAutorizzazioneXacmlPolicy(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/rate-limiting")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce l'elenco delle policy di rate limiting configurate", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Elenco policy di rate limiting restituito con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=ListaRateLimitingPolicy.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ListaRateLimitingPolicy findAllErogazioneRateLimitingPolicies(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6, @QueryParam(value="q") String var7, @QueryParam(value="limit") Integer var8, @QueryParam(value="offset") @DefaultValue(value="0") Integer var9, @QueryParam(value="metrica") RateLimitingCriteriMetricaEnum var10);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/tracciamento/correlazione-applicativa/richiesta")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce l'elenco delle regole di correlazione applicativa per la richiesta", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Elenco regole di correlazione applicativa restituito con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=ListaCorrelazioneApplicativaRichiesta.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ListaCorrelazioneApplicativaRichiesta findAllErogazioneTracciamentoCorrelazioneApplicativaRichiesta(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6, @QueryParam(value="q") String var7, @QueryParam(value="limit") Integer var8, @QueryParam(value="offset") @DefaultValue(value="0") Integer var9);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/tracciamento/correlazione-applicativa/risposta")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce l'elenco delle regole di correlazione applicativa per la risposta", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Elenco regole di correlazione applicativa restituito con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=ListaCorrelazioneApplicativaRisposta.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ListaCorrelazioneApplicativaRisposta findAllErogazioneTracciamentoCorrelazioneApplicativaRisposta(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6, @QueryParam(value="q") String var7, @QueryParam(value="limit") Integer var8, @QueryParam(value="offset") @DefaultValue(value="0") Integer var9);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/caching-risposta")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce la configurazione relativa al caching delle risposte", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dettaglio della configurazione restituito con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=CachingRisposta.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public CachingRisposta getErogazioneCachingRisposta(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/canale")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce il canale associato all'erogazione", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Canale restituito con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiCanale.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ApiCanale getErogazioneCanale(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var5);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/controllo-accessi/autenticazione")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce la configurazione relativa all'autenticazione per quanto concerne il controllo degli accessi", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dettaglio della configurazione restituito con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=ControlloAccessiAutenticazione.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ControlloAccessiAutenticazione getErogazioneControlloAccessiAutenticazione(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce la configurazione relativa all'autorizzazione per quanto concerne il controllo degli accessi", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dettaglio della configurazione restituito con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=ControlloAccessiAutorizzazioneView.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ControlloAccessiAutorizzazioneView getErogazioneControlloAccessiAutorizzazione(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/applicativi")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce l'elenco degli applicativi autorizzati", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Elenco applicativi autorizzati restituito con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=ControlloAccessiErogazioneAutorizzazioneApplicativi.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ControlloAccessiErogazioneAutorizzazioneApplicativi getErogazioneControlloAccessiAutorizzazioneApplicativi(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/token/applicativi")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce l'elenco degli applicativi token autorizzati", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Elenco applicativi token autorizzati restituito con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=ControlloAccessiErogazioneAutorizzazioneApplicativi.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ControlloAccessiErogazioneAutorizzazioneApplicativi getErogazioneControlloAccessiAutorizzazioneApplicativiToken(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/ruoli")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce l'elenco dei ruoli autorizzati", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Elenco ruoli autorizzati restituito con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=ControlloAccessiAutorizzazioneRuoli.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ControlloAccessiAutorizzazioneRuoli getErogazioneControlloAccessiAutorizzazioneRuoli(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/token/ruoli")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce l'elenco dei ruoli token autorizzati", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Elenco ruoli token autorizzati restituito con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=ControlloAccessiAutorizzazioneRuoli.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ControlloAccessiAutorizzazioneRuoli getErogazioneControlloAccessiAutorizzazioneRuoliToken(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/scope")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce l'elenco degli scope autorizzati", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Elenco scope autorizzati restituito con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=ControlloAccessiAutorizzazioneScopes.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ControlloAccessiAutorizzazioneScopes getErogazioneControlloAccessiAutorizzazioneScope(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/soggetti")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce l'elenco dei soggetti autorizzati", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Elenco soggetti autorizzati restituito con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=ControlloAccessiAutorizzazioneSoggetti.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ControlloAccessiAutorizzazioneSoggetti getErogazioneControlloAccessiAutorizzazioneSoggetti(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/controllo-accessi/gestione-token")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce la configurazione relativa alla gestione dei token per quanto concerne il controllo degli accessi", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dettaglio della configurazione restituito con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=ControlloAccessiGestioneToken.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ControlloAccessiGestioneToken getErogazioneControlloAccessiGestioneToken(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/controllo-accessi/identificazione-attributi")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce la configurazione relativa all'identificazione degli attributi per quanto concerne il controllo degli accessi", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dettaglio della configurazione restituito con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=ControlloAccessiIdentificazioneAttributi.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ControlloAccessiIdentificazioneAttributi getErogazioneControlloAccessiIdentificazioneAttributi(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/proprieta")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce le propriet\u00e0 di configurazione attivate", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dettaglio della configurazione restituito con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=ElencoProprieta.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ElencoProprieta getErogazioneElencoProprieta(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/gestione-cors")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce le informazioni sulla configurazione CORS associata all'erogazione", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Informazioni sulla configurazione CORS restituite con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=GestioneCors.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public GestioneCors getErogazioneGestioneCORS(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var5);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/proprieta/{proprieta}")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce il dettaglio di una propriet\u00e0 di configurazione", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dati della propriet\u00e0 di configurazione restituiti con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProprietaOpzioneCifratura.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ProprietaOpzioneCifratura getErogazioneProprieta(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @PathParam(value="proprieta") @Size(max=255) @Size(max=255) String var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/rate-limiting/{id_policy}")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce il dettaglio di una policy di rate limiting", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dati della policy restituiti con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=RateLimitingPolicyErogazioneView.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public RateLimitingPolicyErogazioneView getErogazioneRateLimitingPolicy(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @PathParam(value="id_policy") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/tracciamento/diagnostici")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce la configurazione relativa alla registrazione dei diagnostici", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dettaglio della configurazione restituito con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=RegistrazioneDiagnosticiConfigurazione.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public RegistrazioneDiagnosticiConfigurazione getErogazioneRegistrazioneDiagnostici(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/registrazione-messaggi")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce la configurazione relativa alla registrazione dei messaggi", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dettaglio della configurazione restituito con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=RegistrazioneMessaggi.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public RegistrazioneMessaggi getErogazioneRegistrazioneMessaggi(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/tracciamento/transazioni")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce la configurazione relativa alla registrazione delle transazioni", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dettaglio della configurazione restituito con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=RegistrazioneTransazioniConfigurazione.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public RegistrazioneTransazioniConfigurazione getErogazioneRegistrazioneTransazioni(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/stato")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce l'indicazione sullo stato del gruppo", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dettaglio dello stato restituito con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiImplStato.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ApiImplStato getErogazioneStato(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/tracciamento/correlazione-applicativa/richiesta/{elemento}")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce il dettaglio di una regola di correlazione applicativa per la richiesta", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dati della regola restituiti con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=CorrelazioneApplicativaRichiesta.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public CorrelazioneApplicativaRichiesta getErogazioneTracciamentoCorrelazioneApplicativaRichiesta(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @PathParam(value="elemento") @Size(max=255) @Size(max=255) String var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/tracciamento/correlazione-applicativa/risposta/{elemento}")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce il dettaglio di una regola di correlazione applicativa per la risposta", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dati della regola restituiti con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=CorrelazioneApplicativaRisposta.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public CorrelazioneApplicativaRisposta getErogazioneTracciamentoCorrelazioneApplicativaRisposta(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @PathParam(value="elemento") @Size(max=255) @Size(max=255) String var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @GET
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/validazione")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce la configurazione relativa alla validazione dei contenuti applicativi", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dettaglio della configurazione restituito con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=Validazione.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public Validazione getErogazioneValidazione(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @PUT
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/caching-risposta")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare la configurazione relativa al caching delle risposte", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Configurazione aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void updateErogazioneCachingRisposta(@Valid CachingRisposta var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @PUT
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/canale")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare il canale associato all'erogazione", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Il canale \u00e8 stato aggiornato correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void updateErogazioneCanale(@Valid ConfigurazioneApiCanale var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @PUT
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/controllo-accessi/autenticazione")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare la configurazione relativa all'autenticazione per quanto concerne il controllo degli accessi", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Configurazione aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void updateErogazioneControlloAccessiAutenticazione(@Valid ControlloAccessiAutenticazione var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @PUT
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare la configurazione relativa all'autorizzazione per quanto concerne il controllo degli accessi", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Configurazione aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void updateErogazioneControlloAccessiAutorizzazione(@Valid ControlloAccessiAutorizzazione var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @PUT
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/controllo-accessi/gestione-token")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare la configurazione relativa alla gestione dei token per quanto concerne il controllo degli accessi", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Configurazione aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void updateErogazioneControlloAccessiGestioneToken(@Valid ControlloAccessiGestioneToken var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @PUT
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/controllo-accessi/identificazione-attributi")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare la configurazione relativa all'identificazione degli attributi per quanto concerne il controllo degli accessi", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Configurazione aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void updateErogazioneControlloIdentificazioneAttributi(@Valid ControlloAccessiIdentificazioneAttributi var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @PUT
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/gestione-cors")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare la configurazione CORS associata all'erogazione", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Configurazione dell'erogazione aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void updateErogazioneGestioneCORS(@Valid GestioneCors var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @PUT
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/proprieta/{proprieta}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Modifica i dati di una propriet\u00e0 di configurazione", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="La propriet\u00e0 di configurazione \u00e8 stata aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void updateErogazioneProprieta(@Valid ProprietaOpzioneCifratura var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @PathParam(value="proprieta") @Size(max=255) @Size(max=255) String var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @PUT
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/rate-limiting/{id_policy}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Modifica i dati di una policy di rate limiting", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="La policy \u00e8 stata aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void updateErogazioneRateLimitingPolicy(@Valid RateLimitingPolicyErogazioneUpdate var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @PathParam(value="id_policy") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @PUT
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/tracciamento/diagnostici")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare la configurazione relativa alla registrazione dei diagnostici", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Configurazione aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void updateErogazioneRegistrazioneDiagnostici(@Valid RegistrazioneDiagnosticiConfigurazione var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @PUT
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/registrazione-messaggi")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare la configurazione relativa alla registrazione dei messaggi", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Configurazione aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void updateErogazioneRegistrazioneMessaggi(@Valid RegistrazioneMessaggi var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @PUT
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/tracciamento/transazioni")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare la configurazione relativa alla registrazione delle transazioni", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Configurazione aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void updateErogazioneRegistrazioneTransazioni(@Valid RegistrazioneTransazioniConfigurazione var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @PUT
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/stato")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare lo stato del gruppo", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Configurazione del gruppo aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void updateErogazioneStato(@Valid ApiImplStato var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @PUT
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/tracciamento/correlazione-applicativa/richiesta/{elemento}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Modifica i dati di una regola di correlazione applicativa per la richiesta", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="La regola \u00e8 stata aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void updateErogazioneTracciamentoCorrelazioneApplicativaRichiesta(@Valid CorrelazioneApplicativaRichiesta var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @PathParam(value="elemento") @Size(max=255) @Size(max=255) String var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @PUT
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/tracciamento/correlazione-applicativa/risposta/{elemento}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Modifica i dati di una regola di correlazione applicativa per la risposta", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="La regola \u00e8 stata aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void updateErogazioneTracciamentoCorrelazioneApplicativaRisposta(@Valid CorrelazioneApplicativaRisposta var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @PathParam(value="elemento") @Size(max=255) @Size(max=255) String var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @PUT
    @Path(value="/erogazioni/{nome}/{versione}/configurazioni/validazione")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare la configurazione relativa alla validazione dei contenuti applicativi", tags={"erogazioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Configurazione aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void updateErogazioneValidazione(@Valid Validazione var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);
}

