/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.eventi.bean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.faces.event.ActionEvent;
import org.openspcoop2.web.monitor.core.bean.AbstractDateSearchForm;
import org.openspcoop2.web.monitor.core.constants.CaseSensitiveMatch;
import org.openspcoop2.web.monitor.core.constants.Costanti;
import org.openspcoop2.web.monitor.core.constants.TipoMatch;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.ricerche.ModuloRicerca;
import org.openspcoop2.web.monitor.core.utils.MessageUtils;
import org.openspcoop2.web.monitor.eventi.constants.EventiCostanti;
import org.slf4j.Logger;

public class EventiSearchForm
extends AbstractDateSearchForm {
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private String severita;
    private String tipo;
    private String codice;
    private TipoMatch matchingType = TipoMatch.EQUALS;
    private CaseSensitiveMatch caseSensitiveType = CaseSensitiveMatch.SENSITIVE;
    private String idCluster;
    private String idConfigurazione;
    private String canale;
    private String severitaDefault = "--";
    private static List<String> elencoFieldsRicercaDaIgnorare = new ArrayList<String>();

    protected String ripulisciValori() {
        this.initSearchListener(null);
        return null;
    }

    public EventiSearchForm() {
        try {
            PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)log);
            this.setUseCount(govwayMonitorProperties.isAttivoUtilizzaCountListaEventi());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.ripulisciValori();
    }

    public void initSearchListener(ActionEvent ae) {
        super.initSearchListener(ae);
        this.setPeriodo(this.periodoDefault != null ? this.periodoDefault : "Ultimo mese");
        this._setPeriodo();
        this.aggiornaNuovaDataRicerca();
        this.severita = this.severitaDefault;
        this.tipo = null;
        this.codice = null;
        this.matchingType = TipoMatch.EQUALS;
        this.caseSensitiveType = CaseSensitiveMatch.SENSITIVE;
        this.idCluster = null;
        this.idConfigurazione = null;
        this.canale = null;
        this.severitaDefault = "--";
        this.executeQuery = false;
    }

    protected String eseguiAggiorna() {
        this.setAggiornamentoDatiAbilitato(true);
        return this._filtra(true);
    }

    protected String eseguiFiltra() {
        this.setAggiornamentoDatiAbilitato(true);
        return this._filtra(false);
    }

    private String _filtra(boolean mantieniDataRicerca) {
        if (this.getPeriodo().equals("Personalizzato")) {
            if (this.getDataInizio() == null) {
                MessageUtils.addErrorMsg((String)"Selezionare Data Inizio");
                return null;
            }
            if (this.getDataFine() == null) {
                MessageUtils.addErrorMsg((String)"Selezionare Data Fine");
                return null;
            }
        }
        if (!mantieniDataRicerca) {
            this.aggiornaNuovaDataRicerca();
            this._setPeriodo();
        } else {
            this.congelaDataRicerca();
        }
        return null;
    }

    public String getSeverita() {
        return this.severita;
    }

    public void setSeverita(String severita) {
        this.severita = severita;
    }

    public String getTipo() {
        return this.tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public String getCodice() {
        return this.codice;
    }

    public void setCodice(String codice) {
        this.codice = codice;
    }

    public String getSeveritaDefault() {
        return this.severitaDefault;
    }

    public void setSeveritaDefault(String severitaDefault) {
        this.severitaDefault = severitaDefault;
    }

    public String getIdCluster() {
        if ("--".equals(this.idCluster)) {
            return null;
        }
        return this.idCluster;
    }

    public void setIdCluster(String idCluster) {
        this.idCluster = "--".equals(idCluster) ? null : idCluster;
    }

    public String getCanale() {
        if ("--".equals(this.canale)) {
            return null;
        }
        return this.canale;
    }

    public void setCanale(String canale) {
        this.canale = "--".equals(canale) ? null : canale;
    }

    public String getIdConfigurazione() {
        return this.idConfigurazione;
    }

    public void setIdConfigurazione(String idConfigurazione) {
        this.idConfigurazione = idConfigurazione;
    }

    public String getMatchingType() {
        if (this.matchingType != null) {
            return this.matchingType.name();
        }
        return null;
    }

    public void setMatchingType(String MatchingType) {
        if (MatchingType != null) {
            this.matchingType = TipoMatch.valueOf((String)MatchingType);
        }
    }

    public String getCaseSensitiveType() {
        if (this.caseSensitiveType != null) {
            return this.caseSensitiveType.name();
        }
        return null;
    }

    public void setCaseSensitiveType(String caseSensitiveType) {
        if (caseSensitiveType != null) {
            this.caseSensitiveType = CaseSensitiveMatch.valueOf((String)caseSensitiveType);
        }
    }

    public String getPrintPeriodo() {
        return super.getDefaultPrintPeriodoBehaviour();
    }

    public ModuloRicerca getModulo() {
        return ModuloRicerca.EVENTI;
    }

    public String getModalitaRicerca() {
        return "--";
    }

    public boolean isVisualizzaComandoSalvaRicerca() {
        return true;
    }

    public List<String> getElencoFieldRicercaDaIgnorare() {
        return elencoFieldsRicercaDaIgnorare;
    }

    public String getProtocolloRicerca() {
        return null;
    }

    public String getSoggettoRicerca() {
        return null;
    }

    public void ripulisciRicercaUtente() {
        this.ripulisci();
    }

    static {
        elencoFieldsRicercaDaIgnorare.addAll(Arrays.asList(Costanti.SEARCH_FORM_FIELDS_DA_NON_SALVARE));
        elencoFieldsRicercaDaIgnorare.addAll(Arrays.asList(EventiCostanti.SEARCH_FORM_FIELDS_DA_NON_SALVARE));
    }
}

