/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.utils;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.constants.CostantiLabel;
import org.openspcoop2.core.registry.driver.FiltroRicercaProtocolPropertyRegistry;
import org.openspcoop2.protocol.sdk.properties.AbstractProperty;
import org.openspcoop2.protocol.sdk.properties.BooleanProperty;
import org.openspcoop2.protocol.sdk.properties.NumberProperty;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.StringProperty;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.UtilsRuntimeException;

public class ProtocolUtils {
    public static MapKey<String> protocolToMapKey(String protocollo) {
        if ("trasparente".equals(protocollo)) {
            return CostantiLabel.TRASPARENTE_PROTOCOL_MAP_KEY;
        }
        if ("modipa".equals(protocollo)) {
            return CostantiLabel.MODIPA_PROTOCOL_MAP_KEY;
        }
        if ("spcoop".equals(protocollo)) {
            return CostantiLabel.SPCOOP_PROTOCOL_MAP_KEY;
        }
        if ("as4".equals(protocollo)) {
            return CostantiLabel.AS4_PROTOCOL_MAP_KEY;
        }
        if ("sdi".equals(protocollo)) {
            return CostantiLabel.SDI_PROTOCOL_MAP_KEY;
        }
        if ("__noprotocol".equals(protocollo)) {
            return CostantiLabel.NO_PROTOCOL_MAP_KEY;
        }
        return Map.newMapKey((String)protocollo);
    }

    public static List<String> orderProtocolli(List<String> protocolliDispondibili) {
        int i;
        String protocollo2;
        ArrayList<String> l = new ArrayList<String>();
        ArrayList<String> newL = new ArrayList<String>();
        for (String protocollo2 : protocolliDispondibili) {
            newL.add(protocollo2);
        }
        for (i = 0; i < newL.size(); ++i) {
            protocollo2 = (String)newL.get(i);
            if (!"trasparente".equals(protocollo2)) continue;
            l.add((String)newL.remove(i));
            break;
        }
        for (i = 0; i < newL.size(); ++i) {
            protocollo2 = (String)newL.get(i);
            if (!"modipa".equals(protocollo2)) continue;
            l.add((String)newL.remove(i));
            break;
        }
        for (i = 0; i < newL.size(); ++i) {
            protocollo2 = (String)newL.get(i);
            if (!"spcoop".equals(protocollo2)) continue;
            l.add((String)newL.remove(i));
            break;
        }
        for (i = 0; i < newL.size(); ++i) {
            protocollo2 = (String)newL.get(i);
            if (!"as4".equals(protocollo2)) continue;
            l.add((String)newL.remove(i));
            break;
        }
        for (i = 0; i < newL.size(); ++i) {
            protocollo2 = (String)newL.get(i);
            if (!"sdi".equals(protocollo2)) continue;
            l.add((String)newL.remove(i));
            break;
        }
        for (i = 0; i < newL.size(); ++i) {
            protocollo2 = (String)newL.get(i);
            l.add(protocollo2);
        }
        return l;
    }

    public static List<FiltroRicercaProtocolPropertyRegistry> convert(ProtocolProperties protocolProperties) {
        ArrayList<FiltroRicercaProtocolPropertyRegistry> list = null;
        if (protocolProperties != null && protocolProperties.sizeProperties() > 0) {
            list = new ArrayList<FiltroRicercaProtocolPropertyRegistry>();
            for (int i = 0; i < protocolProperties.sizeProperties(); ++i) {
                FiltroRicercaProtocolPropertyRegistry fpp = new FiltroRicercaProtocolPropertyRegistry();
                AbstractProperty<?> p = protocolProperties.getProperty(i);
                fpp.setName(p.getId());
                if (p instanceof StringProperty) {
                    StringProperty sp = (StringProperty)p;
                    if (sp.getValue() != null && !"".equals(sp.getValue())) {
                        fpp.setValueAsString((String)sp.getValue());
                        fpp.setSearchWithLike(sp.getSearchWithLike());
                    }
                } else if (p instanceof NumberProperty) {
                    NumberProperty np = (NumberProperty)p;
                    fpp.setValueAsLong((Long)np.getValue());
                } else if (p instanceof BooleanProperty) {
                    BooleanProperty bp = (BooleanProperty)p;
                    fpp.setValueAsBoolean((Boolean)bp.getValue());
                } else {
                    throw new UtilsRuntimeException("Tipo di Filtro [" + p.getClass().getName() + "] non supportato");
                }
                list.add(fpp);
            }
        }
        return list;
    }
}

