/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.utils;

import java.util.List;
import java.util.Map;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.utils.EsitoTransportContextIdentificationMode;
import org.openspcoop2.utils.regexp.RegExpException;
import org.openspcoop2.utils.regexp.RegExpNotFoundException;
import org.openspcoop2.utils.regexp.RegExpNotValidException;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.regexp.RegularExpressionPatternCompileMode;
import org.openspcoop2.utils.transport.TransportUtils;

public class EsitoTransportContextIdentification {
    private String name;
    private EsitoTransportContextIdentificationMode mode;
    private String regularExpr;
    private String value;
    private String type;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EsitoTransportContextIdentificationMode getMode() {
        return this.mode;
    }

    public void setMode(EsitoTransportContextIdentificationMode mode) {
        this.mode = mode;
    }

    public String getRegularExpr() {
        return this.regularExpr;
    }

    public void setRegularExpr(String regularExpr) {
        this.regularExpr = regularExpr;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean match(Map<String, List<String>> p) throws ProtocolException {
        for (String key : p.keySet()) {
            List values = (List)TransportUtils.getRawObject(p, (String)key);
            if (values == null || values.isEmpty()) continue;
            for (String valueKey : values) {
                if (key.equalsIgnoreCase(this.name)) {
                    switch (this.mode) {
                        case EXISTS: {
                            return true;
                        }
                        case MATCH: {
                            try {
                                if (RegularExpressionEngine.isMatch((String)valueKey, (String)this.regularExpr, (RegularExpressionPatternCompileMode[])new RegularExpressionPatternCompileMode[]{RegularExpressionPatternCompileMode.CASE_INSENSITIVE})) {
                                    return true;
                                }
                                break;
                            }
                            catch (RegExpNotFoundException notFound) {
                                break;
                            }
                            catch (RegExpException | RegExpNotValidException exp) {
                                throw new ProtocolException(exp.getMessage(), exp);
                            }
                        }
                        case CONTAINS: {
                            if (this.regularExpr == null) {
                                if (this.value == null || valueKey == null || !valueKey.toLowerCase().contains(this.value.toLowerCase())) break;
                                return true;
                            }
                            String valueRexExp = null;
                            try {
                                valueRexExp = RegularExpressionEngine.getStringMatchPattern((String)valueKey, (String)this.regularExpr, (RegularExpressionPatternCompileMode[])new RegularExpressionPatternCompileMode[]{RegularExpressionPatternCompileMode.CASE_INSENSITIVE});
                            }
                            catch (RegExpNotFoundException notFound) {
                                break;
                            }
                            catch (RegExpException | RegExpNotValidException exp) {
                                throw new ProtocolException(exp.getMessage(), exp);
                            }
                            if (this.value == null || valueRexExp == null || !valueRexExp.toLowerCase().contains(this.value.toLowerCase())) break;
                            return true;
                        }
                        case EQUALS: {
                            if (this.regularExpr == null) {
                                if (!(this.value == null ? valueKey == null : this.value.equalsIgnoreCase(valueKey))) break;
                                return true;
                            }
                            String valueRexExp = null;
                            try {
                                valueRexExp = RegularExpressionEngine.getStringMatchPattern((String)valueKey, (String)this.regularExpr, (RegularExpressionPatternCompileMode[])new RegularExpressionPatternCompileMode[]{RegularExpressionPatternCompileMode.CASE_INSENSITIVE});
                            }
                            catch (RegExpNotFoundException notFound) {
                                break;
                            }
                            catch (RegExpException | RegExpNotValidException exp) {
                                throw new ProtocolException(exp.getMessage(), exp);
                            }
                            if (!(this.value == null ? valueRexExp == null : this.value.equalsIgnoreCase(valueRexExp))) break;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }
}

