/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk.tracciamento;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.tracciamento.Allegati;
import org.openspcoop2.core.tracciamento.Dominio;
import org.openspcoop2.core.tracciamento.DominioSoggetto;
import org.openspcoop2.core.tracciamento.Proprieta;
import org.openspcoop2.core.tracciamento.Protocollo;
import org.openspcoop2.core.tracciamento.TracciaEsitoElaborazione;
import org.openspcoop2.core.tracciamento.constants.TipoEsitoElaborazione;
import org.openspcoop2.core.tracciamento.constants.TipoPdD;
import org.openspcoop2.core.tracciamento.constants.TipoTraccia;
import org.openspcoop2.protocol.sdk.Allegato;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.BustaRawContent;
import org.openspcoop2.protocol.sdk.constants.EsitoElaborazioneMessaggioTracciatura;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.tracciamento.EsitoElaborazioneMessaggioTracciato;

public class Traccia
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean stored = false;
    protected Busta busta;
    private byte[] bustaInByte;
    private BustaRawContent<?> bustaRawContent;
    protected Map<String, String> properties = new HashMap<String, String>();
    private String protocollo;
    private org.openspcoop2.core.tracciamento.Traccia traccia;
    private List<Allegato> allegati = new ArrayList<Allegato>();

    public Traccia() {
        this.traccia = new org.openspcoop2.core.tracciamento.Traccia();
    }

    public Traccia(org.openspcoop2.core.tracciamento.Traccia traccia) {
        this.traccia = traccia;
        if (traccia.getBusta() != null && traccia.getBusta().getProtocollo() != null) {
            this.protocollo = traccia.getBusta().getProtocollo().getIdentificativo();
        }
        if (traccia.getBusta() != null) {
            this.busta = new Busta(traccia.getBusta());
        }
        if (traccia.getAllegati() != null && traccia.getAllegati().sizeAllegatoList() > 0) {
            for (org.openspcoop2.core.tracciamento.Allegato allegato : traccia.getAllegati().getAllegatoList()) {
                this.addAllegato(new Allegato(allegato), false);
            }
        }
    }

    public boolean isStored() {
        return this.stored;
    }

    public void setStored(boolean stored) {
        this.stored = stored;
    }

    public org.openspcoop2.core.tracciamento.Traccia getTraccia() {
        return this.traccia;
    }

    public void setTraccia(org.openspcoop2.core.tracciamento.Traccia traccia) {
        this.traccia = traccia;
        if (traccia.getBusta() != null && traccia.getBusta().getProtocollo() != null) {
            this.protocollo = traccia.getBusta().getProtocollo().getIdentificativo();
        }
        if (traccia.getAllegati() != null && traccia.getAllegati().sizeAllegatoList() > 0) {
            for (org.openspcoop2.core.tracciamento.Allegato allegato : traccia.getAllegati().getAllegatoList()) {
                this.addAllegato(new Allegato(allegato), false);
            }
        }
    }

    public Long getId() {
        return this.traccia.getId();
    }

    public void setId(Long id) {
        this.traccia.setId(id);
    }

    public String getIdTransazione() {
        return this.traccia.getIdTransazione();
    }

    public void setIdTransazione(String idTransazione) {
        this.traccia.setIdTransazione(idTransazione);
    }

    public Date getGdo() {
        return this.traccia.getOraRegistrazione();
    }

    public void setGdo(Date value) {
        this.traccia.setOraRegistrazione(value);
    }

    public IDSoggetto getIdSoggetto() {
        IDSoggetto idSoggetto = null;
        if (this.traccia.getDominio() != null) {
            if (this.traccia.getDominio().getSoggetto() != null) {
                if (idSoggetto == null) {
                    idSoggetto = new IDSoggetto();
                }
                idSoggetto.setTipo(this.traccia.getDominio().getSoggetto().getTipo());
                idSoggetto.setNome(this.traccia.getDominio().getSoggetto().getBase());
            }
            if (this.traccia.getDominio().getIdentificativoPorta() != null) {
                if (idSoggetto == null) {
                    idSoggetto = new IDSoggetto();
                }
                idSoggetto.setCodicePorta(this.traccia.getDominio().getIdentificativoPorta());
            }
        }
        return idSoggetto;
    }

    public void setIdSoggetto(IDSoggetto value) {
        if (value != null && (value.getTipo() != null || value.getNome() != null || value.getCodicePorta() != null)) {
            if (value.getTipo() != null || value.getNome() != null) {
                if (this.traccia.getDominio() == null) {
                    this.traccia.setDominio(new Dominio());
                }
                if (this.traccia.getDominio().getSoggetto() == null) {
                    this.traccia.getDominio().setSoggetto(new DominioSoggetto());
                }
                this.traccia.getDominio().getSoggetto().setTipo(value.getTipo());
                this.traccia.getDominio().getSoggetto().setBase(value.getNome());
            } else if (this.traccia.getDominio() != null) {
                this.traccia.getDominio().setSoggetto(null);
            }
            if (value.getCodicePorta() != null) {
                if (this.traccia.getDominio() == null) {
                    this.traccia.setDominio(new Dominio());
                }
                this.traccia.getDominio().setIdentificativoPorta(value.getCodicePorta());
            } else if (this.traccia.getDominio() != null) {
                this.traccia.getDominio().setIdentificativoPorta(null);
            }
        } else if (this.traccia.getDominio() != null) {
            if (this.traccia.getDominio().getFunzione() == null) {
                this.traccia.setDominio(null);
            } else {
                this.traccia.getDominio().setIdentificativoPorta(null);
                this.traccia.getDominio().setSoggetto(null);
            }
        }
    }

    public org.openspcoop2.core.constants.TipoPdD getTipoPdD() {
        if (this.traccia.getDominio() != null && this.traccia.getDominio().getFunzione() != null) {
            switch (this.traccia.getDominio().getFunzione()) {
                case PORTA_DELEGATA: {
                    return org.openspcoop2.core.constants.TipoPdD.DELEGATA;
                }
                case PORTA_APPLICATIVA: {
                    return org.openspcoop2.core.constants.TipoPdD.APPLICATIVA;
                }
                case INTEGRATION_MANAGER: {
                    return org.openspcoop2.core.constants.TipoPdD.INTEGRATION_MANAGER;
                }
                case ROUTER: {
                    return org.openspcoop2.core.constants.TipoPdD.ROUTER;
                }
            }
        }
        return null;
    }

    public void setTipoPdD(org.openspcoop2.core.constants.TipoPdD tipoPdD) {
        if (tipoPdD != null) {
            if (this.traccia.getDominio() == null) {
                this.traccia.setDominio(new Dominio());
            }
            switch (tipoPdD) {
                case DELEGATA: {
                    this.traccia.getDominio().setFunzione(TipoPdD.PORTA_DELEGATA);
                    break;
                }
                case APPLICATIVA: {
                    this.traccia.getDominio().setFunzione(TipoPdD.PORTA_APPLICATIVA);
                    break;
                }
                case INTEGRATION_MANAGER: {
                    this.traccia.getDominio().setFunzione(TipoPdD.INTEGRATION_MANAGER);
                    break;
                }
                case ROUTER: {
                    this.traccia.getDominio().setFunzione(TipoPdD.ROUTER);
                }
            }
        } else if (this.traccia.getDominio() != null) {
            if (this.traccia.getDominio().getIdentificativoPorta() == null && this.traccia.getDominio().getSoggetto() == null) {
                this.traccia.setDominio(null);
            } else {
                this.traccia.getDominio().setFunzione(null);
            }
        }
    }

    public RuoloMessaggio getTipoMessaggio() {
        if (this.traccia.getTipo() != null) {
            switch (this.traccia.getTipo()) {
                case RICHIESTA: {
                    return RuoloMessaggio.RICHIESTA;
                }
                case RISPOSTA: {
                    return RuoloMessaggio.RISPOSTA;
                }
            }
        }
        return null;
    }

    public void setTipoMessaggio(RuoloMessaggio value) {
        if (value != null) {
            switch (value) {
                case RICHIESTA: {
                    this.traccia.setTipo(TipoTraccia.RICHIESTA);
                    break;
                }
                case RISPOSTA: {
                    this.traccia.setTipo(TipoTraccia.RISPOSTA);
                }
            }
        }
    }

    public Busta getBusta() {
        return this.busta;
    }

    public void setBusta(Busta value) {
        Busta busta = this.busta = value != null ? value.newInstance() : null;
        if (value != null) {
            this.traccia.setBusta(value.getBusta());
        } else {
            this.traccia.setBusta(null);
        }
    }

    public byte[] getBustaAsByteArray() {
        return this.bustaInByte;
    }

    public void setBustaAsByteArray(byte[] bustaInByte) {
        this.bustaInByte = bustaInByte;
    }

    public BustaRawContent<?> getBustaAsRawContent() {
        return this.bustaRawContent;
    }

    public void setBustaAsRawContent(BustaRawContent<?> bustaElement) {
        this.bustaRawContent = bustaElement;
    }

    public String getBustaAsString() {
        return this.traccia.getBustaRaw();
    }

    public void setBustaAsString(String bustaAsString) {
        this.traccia.setBustaRaw(bustaAsString);
    }

    public String getCorrelazioneApplicativa() {
        return this.traccia.getIdentificativoCorrelazioneRichiesta();
    }

    public void setCorrelazioneApplicativa(String value) {
        this.traccia.setIdentificativoCorrelazioneRichiesta(value);
    }

    public String getCorrelazioneApplicativaRisposta() {
        return this.traccia.getIdentificativoCorrelazioneRisposta();
    }

    public void setCorrelazioneApplicativaRisposta(String value) {
        this.traccia.setIdentificativoCorrelazioneRisposta(value);
    }

    public String getLocation() {
        return this.traccia.getLocation();
    }

    public void setLocation(String value) {
        this.traccia.setLocation(value);
    }

    public void addPropertyInBusta(String key, String value) {
        if (this.traccia.getBusta() == null) {
            this.traccia.setBusta(new org.openspcoop2.core.tracciamento.Busta());
        }
        if (this.traccia.getBusta().getProtocollo() == null) {
            this.traccia.getBusta().setProtocollo(new Protocollo());
        }
        if (this.traccia.getBusta().getProtocollo().getProprietaList() == null) {
            this.traccia.getBusta().getProtocollo().setProprietaList(new ArrayList());
        }
        boolean exists = false;
        for (int i = 0; i < this.traccia.getBusta().getProtocollo().sizeProprietaList(); ++i) {
            Proprieta p = this.traccia.getBusta().getProtocollo().getProprieta(i);
            if (!key.equals(p.getNome())) continue;
            exists = true;
            break;
        }
        if (!exists) {
            Proprieta proprieta = new Proprieta();
            proprieta.setNome(key);
            proprieta.setValore(value);
            this.traccia.getBusta().getProtocollo().addProprieta(proprieta);
        }
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public int sizeProperties() {
        return this.properties.size();
    }

    public String getProperty(String key) {
        String value = this.properties.get(key);
        if ((value == null || "".equals(value)) && ((String)((Object)Costanti.ID_TRANSAZIONE.getValue())).equals(key) && this.traccia.getBusta() != null && this.traccia.getBusta().getProtocollo() != null && this.traccia.getBusta().getProtocollo().getProprietaList() != null) {
            for (int i = 0; i < this.traccia.getBusta().getProtocollo().sizeProprietaList(); ++i) {
                Proprieta p = this.traccia.getBusta().getProtocollo().getProprieta(i);
                if (!((String)((Object)Costanti.ID_TRANSAZIONE.getValue())).equals(p.getNome())) continue;
                return p.getValore();
            }
        }
        return value;
    }

    public String removeProperty(String key) {
        return this.properties.remove(key);
    }

    public String[] getPropertiesValues() {
        return this.properties.values().toArray(new String[this.properties.size()]);
    }

    public String[] getPropertiesNames() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    public void setProperties(Map<String, String> params) {
        this.properties = params;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getProtocollo() {
        return this.protocollo;
    }

    public void setProtocollo(String protocollo) {
        this.protocollo = protocollo;
    }

    public EsitoElaborazioneMessaggioTracciato getEsitoElaborazioneMessaggioTracciato() {
        if (this.traccia.getEsitoElaborazione() != null) {
            EsitoElaborazioneMessaggioTracciato esito = new EsitoElaborazioneMessaggioTracciato();
            esito.setDettaglio(this.traccia.getEsitoElaborazione().getDettaglio());
            if (this.traccia.getEsitoElaborazione().getTipo() != null) {
                switch (this.traccia.getEsitoElaborazione().getTipo()) {
                    case INVIATO: {
                        esito.setEsito(EsitoElaborazioneMessaggioTracciatura.INVIATO);
                        break;
                    }
                    case RICEVUTO: {
                        esito.setEsito(EsitoElaborazioneMessaggioTracciatura.RICEVUTO);
                        break;
                    }
                    case ERRORE: {
                        esito.setEsito(EsitoElaborazioneMessaggioTracciatura.ERRORE);
                    }
                }
            }
            return esito;
        }
        return null;
    }

    public void setEsitoElaborazioneMessaggioTracciato(EsitoElaborazioneMessaggioTracciato esitoElaborazioneMessaggioTracciato) {
        if (esitoElaborazioneMessaggioTracciato == null) {
            return;
        }
        if (this.traccia.getEsitoElaborazione() == null) {
            this.traccia.setEsitoElaborazione(new TracciaEsitoElaborazione());
        }
        this.traccia.getEsitoElaborazione().setDettaglio(esitoElaborazioneMessaggioTracciato.getDettaglio());
        if (esitoElaborazioneMessaggioTracciato.getEsito() != null) {
            switch (esitoElaborazioneMessaggioTracciato.getEsito()) {
                case INVIATO: {
                    this.traccia.getEsitoElaborazione().setTipo(TipoEsitoElaborazione.INVIATO);
                    break;
                }
                case RICEVUTO: {
                    this.traccia.getEsitoElaborazione().setTipo(TipoEsitoElaborazione.RICEVUTO);
                    break;
                }
                case ERRORE: {
                    this.traccia.getEsitoElaborazione().setTipo(TipoEsitoElaborazione.ERRORE);
                }
            }
        }
    }

    public List<Allegato> getListaAllegati() {
        return this.allegati;
    }

    public int sizeListaAllegati() {
        return this.allegati.size();
    }

    public void addAllegato(Allegato a) {
        this.addAllegato(a, true);
    }

    private void addAllegato(Allegato a, boolean addCore) {
        this.allegati.add(a);
        if (addCore) {
            if (this.traccia.getAllegati() == null) {
                this.traccia.setAllegati(new Allegati());
            }
            this.traccia.getAllegati().addAllegato(a.getAllegato());
        }
    }

    public Allegato getAllegato(int index) {
        return this.allegati.get(index);
    }

    public Allegato removeAllegato(int index) {
        this.traccia.getAllegati().removeAllegato(index);
        return this.allegati.remove(index);
    }

    protected void setListaAllegati(List<Allegato> listaAllegati) {
        this.allegati = listaAllegati;
    }

    public Traccia newInstance() {
        Traccia clone = new Traccia();
        clone.setId(this.getId() != null ? Long.valueOf("" + this.getId()) : null);
        clone.setGdo(this.getGdo() != null ? new Date(this.getGdo().getTime()) : null);
        clone.setIdSoggetto(this.getIdSoggetto() != null ? this.getIdSoggetto().clone() : null);
        clone.setTipoPdD(this.getTipoPdD());
        clone.setTipoMessaggio(this.getTipoMessaggio());
        clone.setBusta(this.getBusta() != null ? this.getBusta().newInstance() : null);
        ByteArrayOutputStream bout = null;
        if (this.getBustaAsByteArray() != null) {
            bout = new ByteArrayOutputStream();
            try {
                bout.write(this.getBustaAsByteArray());
                bout.flush();
                bout.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            clone.setBustaAsByteArray(bout.toByteArray());
        }
        clone.setBustaAsRawContent(this.getBustaAsRawContent());
        clone.setBustaAsString(this.getBustaAsString() != null ? new String(this.getBustaAsString()) : null);
        clone.setCorrelazioneApplicativa(this.getCorrelazioneApplicativa() != null ? new String(this.getCorrelazioneApplicativa()) : null);
        clone.setCorrelazioneApplicativaRisposta(this.getCorrelazioneApplicativaRisposta() != null ? new String(this.getCorrelazioneApplicativaRisposta()) : null);
        clone.setLocation(this.getLocation() != null ? new String(this.getLocation()) : null);
        clone.setEsitoElaborazioneMessaggioTracciato(this.getEsitoElaborazioneMessaggioTracciato() != null ? this.getEsitoElaborazioneMessaggioTracciato().clone() : null);
        if (this.properties != null && this.properties.size() > 0) {
            for (String key : this.properties.keySet()) {
                String value = this.properties.get(key);
                if (key == null || value == null) continue;
                clone.addProperty(new String(key), new String(value));
            }
        }
        clone.setProtocollo(this.protocollo != null ? new String(this.protocollo) : null);
        for (int i = 0; i < this.sizeListaAllegati(); ++i) {
            clone.addAllegato(this.getAllegato(i).clone());
        }
        return clone;
    }
}

