/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk.state;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.IDService;

public class FunctionContextCustom
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String context;
    private IDService idService;
    private Map<String, IDService> subcontext;

    public FunctionContextCustom(String context, IDService idService) throws ProtocolException {
        this(context, idService, null);
    }

    public FunctionContextCustom(String context, Map<String, IDService> subcontext) throws ProtocolException {
        this(context, null, subcontext);
    }

    private FunctionContextCustom(String context, IDService idServiceParam, Map<String, IDService> subcontextMap) throws ProtocolException {
        if (context == null) {
            throw new ProtocolException("Context undefined");
        }
        if (!StringUtils.isAlphanumeric((CharSequence)(context = context.trim()))) {
            throw new ProtocolException("Context '" + context + "' unsupported: only alphanumeric character permitted");
        }
        this.context = context;
        if (idServiceParam == null && (subcontextMap == null || subcontextMap.size() <= 0)) {
            throw new ProtocolException("IDService and Subcontext not found");
        }
        if (idServiceParam != null) {
            FunctionContextCustom.checkIDService(idServiceParam);
            this.idService = idServiceParam;
        }
        if (subcontextMap != null && subcontextMap.size() > 0) {
            for (String subcontextCheck : subcontextMap.keySet()) {
                IDService idServiceCheck = subcontextMap.get(subcontextCheck);
                String prefix = "Subcontext '" + subcontextCheck + "' ";
                int count = 0;
                for (String subcontextRegistered : subcontextMap.keySet()) {
                    if (subcontextRegistered.equals(subcontextCheck)) {
                        ++count;
                        continue;
                    }
                    if (subcontextCheck.length() < subcontextRegistered.length() || !subcontextCheck.startsWith(subcontextRegistered)) continue;
                    throw new ProtocolException(prefix + "not valid: exists another subcontext '" + subcontextRegistered + "' with same prefix");
                }
                if (count > 1) {
                    throw new ProtocolException(prefix + "registered more than one (founded:" + count + ")");
                }
                Object tmp = subcontextCheck;
                while (((String)tmp).contains("/")) {
                    tmp = ((String)tmp).replace("/", "");
                }
                if (!StringUtils.isAlphanumeric((CharSequence)tmp)) {
                    throw new ProtocolException(prefix + "unsupported: only alphanumeric character or '/' permitted");
                }
                if (subcontextCheck.startsWith("/")) {
                    throw new ProtocolException(prefix + "unsupported: cannot start with '/' character");
                }
                if (subcontextCheck.endsWith("/")) {
                    throw new ProtocolException(prefix + "unsupported: cannot ends with '/' character");
                }
                FunctionContextCustom.checkIDService(idServiceCheck);
            }
            this.subcontext = subcontextMap;
        }
    }

    private static void checkIDService(IDService idService) throws ProtocolException {
        if (!(IDService.PORTA_DELEGATA.equals(idService) || IDService.PORTA_DELEGATA_BIO.equals(idService) || IDService.PORTA_DELEGATA_NIO.equals(idService) || IDService.PORTA_DELEGATA_XML_TO_SOAP.equals(idService) || IDService.PORTA_DELEGATA_XML_TO_SOAP_BIO.equals(idService) || IDService.PORTA_DELEGATA_XML_TO_SOAP_NIO.equals(idService) || IDService.PORTA_APPLICATIVA.equals(idService) || IDService.PORTA_APPLICATIVA_BIO.equals(idService) || IDService.PORTA_APPLICATIVA_NIO.equals(idService) || IDService.INTEGRATION_MANAGER_SOAP.equals(idService))) {
            throw new ProtocolException("IDService '" + String.valueOf(idService) + "' unsupported");
        }
    }

    public boolean isMatch(String contextParam, String subContextParam) {
        return this.getServiceMatch(contextParam, subContextParam) != null;
    }

    public IDService getServiceMatch(String contextParam, String subContextParam) {
        if (this.context.equals(contextParam)) {
            if (subContextParam != null && !"".equals(subContextParam) && this.subcontext != null && this.subcontext.size() > 0) {
                for (String subcontextCheck : this.subcontext.keySet()) {
                    if (!subContextParam.startsWith(subcontextCheck)) continue;
                    return this.subcontext.get(subcontextCheck);
                }
            }
            if (this.idService != null) {
                return this.idService;
            }
        }
        return null;
    }

    public String getFunctionMatch(String contextParam, String subContextParam) {
        if (this.context.equals(contextParam)) {
            if (subContextParam != null && !"".equals(subContextParam) && this.subcontext != null && this.subcontext.size() > 0) {
                for (String subcontextCheck : this.subcontext.keySet()) {
                    if (!subContextParam.startsWith(subcontextCheck)) continue;
                    return this.context + "/" + subcontextCheck;
                }
            }
            if (this.idService != null) {
                return this.context;
            }
        }
        return null;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public IDService getIdService() {
        return this.idService;
    }

    public void setIdService(IDService idService) {
        this.idService = idService;
    }

    public Map<String, IDService> getSubcontext() {
        return this.subcontext;
    }
}

