/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk.archive;

import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.ArchiveIdCorrelazione;
import org.openspcoop2.protocol.sdk.archive.IArchiveObject;

public class ArchivePluginClasse
implements IArchiveObject {
    private String tipoPlugin;
    private String tipo;
    private String className;
    private String label;
    private Plugin plugin;
    private ArchiveIdCorrelazione idCorrelazione;

    public static String buildKey(String tipoPlugin, String tipo) throws ProtocolException {
        if (tipoPlugin == null) {
            throw new ProtocolException("tipoPlugin non fornito");
        }
        if (tipo == null) {
            throw new ProtocolException("tipo non fornito");
        }
        StringBuilder bf = new StringBuilder();
        bf.append("PluginClasse_");
        bf.append(tipoPlugin);
        bf.append("_");
        bf.append(tipo);
        return bf.toString();
    }

    @Override
    public String key() throws ProtocolException {
        return ArchivePluginClasse.buildKey(this.tipoPlugin, this.tipo);
    }

    public ArchivePluginClasse(Plugin plugin, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        if (plugin == null) {
            throw new ProtocolException("Plugin non fornito");
        }
        if (plugin.getTipoPlugin() == null) {
            throw new ProtocolException("Plugin.tipoPlugin non definito");
        }
        if (plugin.getTipo() == null) {
            throw new ProtocolException("Plugin.tipo non definito");
        }
        if (plugin.getClassName() == null) {
            throw new ProtocolException("Plugin.className non definito");
        }
        if (plugin.getLabel() == null) {
            throw new ProtocolException("Plugin.label non definito");
        }
        this.tipoPlugin = plugin.getTipoPlugin();
        this.tipo = plugin.getTipo();
        this.className = plugin.getClassName();
        this.label = plugin.getLabel();
        this.plugin = plugin;
        this.idCorrelazione = idCorrelazione;
    }

    public String getTipoPlugin() {
        return this.tipoPlugin;
    }

    public String getTipo() {
        return this.tipo;
    }

    public String getClassName() {
        return this.className;
    }

    public String getLabel() {
        return this.label;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public ArchiveIdCorrelazione getIdCorrelazione() {
        return this.idCorrelazione;
    }
}

