/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.manifest.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.message.xml.ValidatoreXSD;
import org.openspcoop2.protocol.manifest.Openspcoop2;
import org.openspcoop2.protocol.manifest.Registry;
import org.openspcoop2.protocol.manifest.Web;
import org.openspcoop2.protocol.manifest.utils.XMLUtilsException;
import org.openspcoop2.utils.xml.JaxbUtils;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLUtils {
    static ValidatoreXSD validatoreXSD = null;

    public static synchronized void initValidatoreXSD(Logger log) throws Exception {
        if (validatoreXSD == null) {
            validatoreXSD = new ValidatoreXSD(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), log, XMLUtils.class.getResourceAsStream("/protocolManifest.xsd"));
        }
    }

    public static ValidatoreXSD getValidatoreXSD(Logger log) throws Exception {
        if (validatoreXSD == null) {
            XMLUtils.initValidatoreXSD(log);
        }
        return validatoreXSD;
    }

    public static boolean validate(Openspcoop2 openspcoop2, StringBuilder motivoErroreValidazione) {
        int size = motivoErroreValidazione.length();
        if (openspcoop2.getProtocol() == null) {
            motivoErroreValidazione.append("Protocol non definito\n");
        }
        if (openspcoop2.getProtocol().getName() == null) {
            motivoErroreValidazione.append("Protocol.name non definito\n");
        }
        if (openspcoop2.getProtocol().getFactory() == null) {
            motivoErroreValidazione.append("Protocol.factory non definito\n");
        }
        if (openspcoop2.getBinding() == null) {
            motivoErroreValidazione.append("Binding non definito\n");
        }
        if (openspcoop2.getWeb() == null) {
            motivoErroreValidazione.append("Web non definito\n");
        } else if (!(openspcoop2.getWeb().sizeContextList() > 0 || openspcoop2.getWeb().getEmptyContext() != null && openspcoop2.getWeb().getEmptyContext().getEnabled())) {
            motivoErroreValidazione.append("WebContext non definito ne tramite un context ne tramite un empty context\n");
        }
        if (openspcoop2.getRegistry() == null) {
            motivoErroreValidazione.append("Registry non definito\n");
        } else {
            Registry reg = openspcoop2.getRegistry();
            if (reg.getOrganization() == null) {
                motivoErroreValidazione.append("Registry.Organization non definito\n");
            } else if (reg.getOrganization().getTypes() == null || reg.getOrganization().getTypes().sizeTypeList() <= 0) {
                motivoErroreValidazione.append("Registry.Organization.types non definito\n");
            }
            if (reg.getService() == null) {
                motivoErroreValidazione.append("Registry.Service non definito\n");
            } else if (reg.getService().getTypes() == null || reg.getService().getTypes().sizeTypeList() <= 0) {
                motivoErroreValidazione.append("Registry.Service.types non definito\n");
            }
            if (reg.getVersions() == null) {
                motivoErroreValidazione.append("Registry.Versions non definito\n");
            } else if (reg.getVersions().sizeVersionList() <= 0) {
                motivoErroreValidazione.append("Registry.Versions.version non definito\n");
            }
        }
        return motivoErroreValidazione.length() == size;
    }

    public static Openspcoop2 getOpenspcoop2Manifest(Logger log, byte[] m) throws XMLUtilsException {
        ByteArrayInputStream bin = null;
        try {
            bin = new ByteArrayInputStream(m);
            Openspcoop2 openspcoop2 = XMLUtils.getOpenspcoop2Manifest(log, bin);
            return openspcoop2;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static Openspcoop2 getOpenspcoop2Manifest(Logger log, File m) throws XMLUtilsException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(m);
            Openspcoop2 openspcoop2 = XMLUtils.getOpenspcoop2Manifest(log, fin);
            return openspcoop2;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static Openspcoop2 getOpenspcoop2Manifest(Logger log, String m) throws XMLUtilsException {
        return XMLUtils.getOpenspcoop2Manifest(log, m.getBytes());
    }

    public static Openspcoop2 getOpenspcoop2Manifest(Logger log, InputStream m) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] reads = new byte[1024];
            int letti = 0;
            while ((letti = m.read(reads)) != -1) {
                bout.write(reads, 0, letti);
            }
            bout.flush();
            bout.close();
            byte[] xml = bout.toByteArray();
            ByteArrayInputStream binValidazione = new ByteArrayInputStream(xml);
            ValidatoreXSD validatoreXSD = XMLUtils.getValidatoreXSD(log);
            validatoreXSD.valida((InputStream)binValidazione);
            ByteArrayInputStream binTrasformazione = new ByteArrayInputStream(xml);
            return (Openspcoop2)JaxbUtils.xmlToObj((InputStream)binTrasformazione, Openspcoop2.class);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateOpenspcoop2Manifest(Openspcoop2 manifest, File out) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(manifest, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            JaxbUtils.objToXml((String)out.getName(), (byte[])XMLUtils.generateOpenspcoop2Manifest_engine(manifest));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateOpenspcoop2Manifest(Openspcoop2 manifest, String fileName) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(manifest, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            JaxbUtils.objToXml((String)fileName, (byte[])XMLUtils.generateOpenspcoop2Manifest_engine(manifest));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static byte[] generateOpenspcoop2Manifest(Openspcoop2 manifest) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(manifest, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            return XMLUtils.generateOpenspcoop2Manifest_engine(manifest);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateOpenspcoop2Manifest(Openspcoop2 manifest, OutputStream out) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(manifest, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            out.write(XMLUtils.generateOpenspcoop2Manifest_engine(manifest));
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    private static byte[] generateOpenspcoop2Manifest_engine(Openspcoop2 manifest) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            JaxbUtils.objToXml((OutputStream)bout, Openspcoop2.class, (Object)manifest);
            byte[] dichiarazione = bout.toByteArray();
            return dichiarazione;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static boolean isOpenspcoop2Manifest(byte[] doc) {
        try {
            MessageXMLUtils xmlUtils = MessageXMLUtils.DEFAULT;
            Document docXML = xmlUtils.newDocument(doc);
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isOpenspcoop2Manifest(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isOpenspcoop2Manifest(Document docXML) {
        try {
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isOpenspcoop2Manifest(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isOpenspcoop2Manifest(Element elemXML) {
        try {
            return "openspcoop2".equals(elemXML.getLocalName()) && "http://www.openspcoop2.org/protocol/manifest".equals(elemXML.getNamespaceURI());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String toString(Openspcoop2 manifest) {
        int i;
        StringBuilder bf = new StringBuilder();
        bf.append(" Protocollo " + manifest.getProtocol().getName() + " \n");
        bf.append("Factory[" + manifest.getProtocol().getFactory() + "]\n");
        bf.append("Default Binding [" + String.valueOf(manifest.getBinding().getDefault()) + "]");
        bf.append("Binding SOAP [" + (manifest.getBinding().getSoap() != null) + "]\n");
        bf.append("Binding REST [" + (manifest.getBinding().getRest() != null) + "]\n");
        Web web = manifest.getWeb();
        for (int i2 = 0; i2 < web.sizeContextList(); ++i2) {
            bf.append("Context[" + i2 + "]=[" + web.getContext(i2).getName() + "]\n");
        }
        if (web.getEmptyContext() != null) {
            bf.append("EmptyContext=[" + web.getEmptyContext().getEnabled() + "]\n");
        } else {
            bf.append("EmptyContext not defined\n");
        }
        Registry reg = manifest.getRegistry();
        if (reg.getOrganization() != null && reg.getOrganization().getTypes() != null) {
            for (i = 0; i < reg.getOrganization().getTypes().sizeTypeList(); ++i) {
                bf.append("Organization.type[" + i + "]=[" + reg.getOrganization().getTypes().getType(i).getName() + "]\n");
            }
        }
        if (reg.getService() != null && reg.getService().getTypes() != null) {
            for (i = 0; i < reg.getService().getTypes().sizeTypeList(); ++i) {
                bf.append("Services.type[" + i + "]=[" + reg.getService().getTypes().getType(i).getName() + "]\n");
            }
        }
        if (reg.getVersions() != null) {
            for (i = 0; i < reg.getVersions().sizeVersionList(); ++i) {
                bf.append("Versions[" + i + "]=[" + reg.getVersions().getVersion(i).getName() + "]\n");
            }
        }
        return bf.toString();
    }
}

