/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.validator;

import java.util.Date;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.basic.BasicStateComponentFactory;
import org.openspcoop2.protocol.basic.validator.ValidatoreErrori;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.BustaRawContent;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.Trasmissione;
import org.openspcoop2.protocol.sdk.builder.IBustaBuilder;
import org.openspcoop2.protocol.sdk.builder.ProprietaManifestAttachments;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.constants.TipoOraRegistrazione;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.validator.IValidazioneSintattica;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazioneErrori;
import org.openspcoop2.protocol.sdk.validator.ValidazioneSintatticaResult;
import org.openspcoop2.utils.date.DateManager;

public class ValidazioneSintattica<BustaRawType>
extends BasicStateComponentFactory
implements IValidazioneSintattica<BustaRawType> {
    private IBustaBuilder<BustaRawType> bustaBuilder = null;
    protected Context context;

    public ValidazioneSintattica(IProtocolFactory<BustaRawType> factory, IState state) throws ProtocolException {
        super(factory, state);
        this.bustaBuilder = factory.createBustaBuilder(state);
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public ValidazioneSintatticaResult<BustaRawType> validaRichiesta(OpenSPCoop2Message msg, Busta datiBustaLettiURLMappingProperties, ProprietaValidazioneErrori proprietaValidazioneErrori) throws ProtocolException {
        Busta busta = null;
        busta = datiBustaLettiURLMappingProperties != null ? datiBustaLettiURLMappingProperties : new Busta(this.protocolFactory.getProtocol());
        Date oraRegistrazione = DateManager.getDate();
        busta.setOraRegistrazione(oraRegistrazione);
        if (busta.getTipoOraRegistrazione() == null) {
            busta.setTipoOraRegistrazione(TipoOraRegistrazione.LOCALE, this.protocolFactory.createTraduttore().toString(busta.getTipoOraRegistrazione()));
        }
        if (busta.sizeListaTrasmissioni() > 0) {
            for (Trasmissione trasmissione : busta.getListaTrasmissioni()) {
                if (trasmissione.getOraRegistrazione() == null) {
                    trasmissione.setOraRegistrazione(oraRegistrazione);
                }
                if (trasmissione.getTempo() != null) continue;
                trasmissione.setTempo(TipoOraRegistrazione.LOCALE, this.protocolFactory.createTraduttore().toString(busta.getTipoOraRegistrazione()));
            }
        }
        return new ValidazioneSintatticaResult(null, null, null, busta, null, null, null, true);
    }

    @Override
    public ValidazioneSintatticaResult<BustaRawType> validaRisposta(OpenSPCoop2Message msg, Busta bustaRichiesta, ProprietaValidazioneErrori proprietaValidazioneErrori) throws ProtocolException {
        Busta bustaRisposta = bustaRichiesta.invertiBusta(bustaRichiesta.getTipoOraRegistrazione(), bustaRichiesta.getTipoOraRegistrazioneValue());
        bustaRisposta.setRiferimentoMessaggio(bustaRichiesta.getID());
        bustaRisposta.setProfiloDiCollaborazione(bustaRichiesta.getProfiloDiCollaborazione(), bustaRichiesta.getProfiloDiCollaborazioneValue());
        bustaRisposta.setTipoServizio(bustaRichiesta.getTipoServizio());
        bustaRisposta.setServizio(bustaRichiesta.getServizio());
        bustaRisposta.setVersioneServizio(bustaRichiesta.getVersioneServizio());
        bustaRisposta.setAzione(bustaRichiesta.getAzione());
        String idSenzaData = null;
        try {
            Date d = this.bustaBuilder.extractDateFromID(bustaRichiesta.getID());
            if (d != null) {
                String[] split = bustaRichiesta.getID().split("-");
                idSenzaData = bustaRichiesta.getID().substring(split[0].length() + 1);
            } else {
                idSenzaData = bustaRichiesta.getID();
            }
        }
        catch (Exception e) {
            throw new ProtocolException("Identificativo di richiesta in un formato errato, estrazione della data non riuscita: " + e.getMessage(), e);
        }
        bustaRisposta.setID(this.bustaBuilder.newID(new IDSoggetto(bustaRisposta.getTipoMittente(), bustaRisposta.getMittente(), bustaRisposta.getIdentificativoPortaMittente()), idSenzaData, RuoloMessaggio.RISPOSTA));
        bustaRisposta.setInoltro(bustaRichiesta.getInoltro(), bustaRichiesta.getInoltroValue());
        bustaRisposta.setCollaborazione(bustaRichiesta.getCollaborazione());
        if (bustaRichiesta.sizeListaTrasmissioni() == 1) {
            bustaRisposta.addTrasmissione(bustaRichiesta.getTrasmissione(0).invertiTrasmissione(bustaRichiesta.getTipoOraRegistrazione(), bustaRichiesta.getTipoOraRegistrazioneValue()));
        }
        boolean hasFault = false;
        try {
            if (msg != null && ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                hasFault = msg.castAsSoap().hasSOAPFault();
            }
        }
        catch (Exception e) {
            throw new ProtocolException(e);
        }
        if (hasFault) {
            ValidatoreErrori validatoreErrori = new ValidatoreErrori(this.protocolFactory, this.state);
            if (bustaRisposta.getProfiloDiCollaborazione().equals((Object)ProfiloDiCollaborazione.ONEWAY)) {
                if (validatoreErrori.isBustaErrore(bustaRichiesta, msg, proprietaValidazioneErrori)) {
                    return new ValidazioneSintatticaResult(null, null, null, bustaRisposta, null, null, null, true);
                }
                return new ValidazioneSintatticaResult(null, null, null, null, ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreProcessamento("Analizzato un messaggio fault"), bustaRisposta, null, false);
            }
            if (bustaRisposta.getProfiloDiCollaborazione().equals((Object)ProfiloDiCollaborazione.SINCRONO)) {
                if (validatoreErrori.isBustaErrore(bustaRichiesta, msg, proprietaValidazioneErrori)) {
                    return new ValidazioneSintatticaResult(null, null, null, bustaRisposta, ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreProcessamento("Analizzato un messaggio fault"), bustaRisposta, null, true);
                }
                return new ValidazioneSintatticaResult(null, null, null, bustaRisposta, null, null, null, true);
            }
        }
        return new ValidazioneSintatticaResult(null, null, null, bustaRisposta, null, null, null, true);
    }

    @Override
    public boolean verifyProtocolPresence(TipoPdD tipoPdD, ProfiloDiCollaborazione profilo, RuoloMessaggio ruoloMessaggio, OpenSPCoop2Message msg) throws ProtocolException {
        if (TipoPdD.DELEGATA.equals((Object)tipoPdD)) {
            if (RuoloMessaggio.RICHIESTA.equals(ruoloMessaggio)) {
                return false;
            }
            return !ProfiloDiCollaborazione.ONEWAY.equals((Object)profilo);
        }
        if (TipoPdD.APPLICATIVA.equals((Object)tipoPdD)) {
            return RuoloMessaggio.RICHIESTA.equals(ruoloMessaggio);
        }
        if (TipoPdD.ROUTER.equals((Object)tipoPdD)) {
            if (RuoloMessaggio.RICHIESTA.equals(ruoloMessaggio)) {
                return true;
            }
            return !ProfiloDiCollaborazione.ONEWAY.equals((Object)profilo);
        }
        throw new ProtocolException("TipoPdD [" + String.valueOf(tipoPdD) + "] non gestito");
    }

    @Override
    public ValidazioneSintatticaResult<BustaRawType> validazioneFault(OpenSPCoop2Message msg) {
        return null;
    }

    @Override
    public ValidazioneSintatticaResult<BustaRawType> validazioneManifestAttachments(OpenSPCoop2Message msg, ProprietaManifestAttachments proprietaManifestAttachments) {
        return null;
    }

    @Override
    public BustaRawContent<BustaRawType> getBustaRawContent_senzaControlli(OpenSPCoop2Message msg) throws ProtocolException {
        return null;
    }

    @Override
    public Busta getBusta_senzaControlli(OpenSPCoop2Message msg) throws ProtocolException {
        return null;
    }
}

