/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.tracciamento;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.protocol.basic.BasicComponentFactory;
import org.openspcoop2.protocol.basic.ProtocolliRegistrati;
import org.openspcoop2.protocol.basic.tracciamento.TracciaDriverUtilities;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.tracciamento.DriverTracciamentoException;
import org.openspcoop2.protocol.sdk.tracciamento.DriverTracciamentoNotFoundException;
import org.openspcoop2.protocol.sdk.tracciamento.FiltroRicercaTracce;
import org.openspcoop2.protocol.sdk.tracciamento.FiltroRicercaTracceConPaginazione;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaDriver;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.StringWrapper;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.resources.GestoreJNDI;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.slf4j.Logger;

public class TracciaDriver
extends BasicComponentFactory
implements ITracciaDriver {
    DataSource datasource = null;
    Connection connection = null;
    boolean connectionOpenViaJDBCInCostructor = false;
    String tipoDatabase = null;
    public static final String IDTRACCIA = "@@@@@-----@@@@-----IDTRACCIA-DB----@@@@@-----@@@@";
    private static final String TRACCIA_EXCEPTION_PREFIX = "Tracciamento exception: ";
    private List<String> properties;
    private ProtocolliRegistrati protocolliRegistrati;

    public void setProperties(List<String> properties) {
        this.properties = properties;
    }

    public TracciaDriver(IProtocolFactory<?> factory) throws ProtocolException {
        super(factory);
    }

    @Override
    public IProtocolFactory<?> getProtocolFactory() {
        return this.protocolFactory;
    }

    public void init(ProtocolliRegistrati protocolliRegistrati, String nomeDataSource, String tipoDatabase, Properties jndiContext) throws DriverTracciamentoException {
        this.init(protocolliRegistrati, nomeDataSource, tipoDatabase, jndiContext, null);
    }

    public void init(ProtocolliRegistrati protocolliRegistrati, String nomeDataSource, String tipoDatabase, Properties jndiContext, Logger log) throws DriverTracciamentoException {
        this.protocolliRegistrati = protocolliRegistrati;
        try {
            this.log = log == null ? LoggerWrapperFactory.getLogger((String)"DRIVER_DB_LOGANALIZER") : log;
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("Errore durante l'inizializzazione del logger (datasource params): " + e.getMessage(), e);
        }
        try {
            this.log.info("Inizializzo DriverLogAnalyzer (datasource params)");
            GestoreJNDI gestoreJNDI = new GestoreJNDI(jndiContext);
            this.datasource = (DataSource)gestoreJNDI.lookup(nomeDataSource);
            if (this.datasource == null) {
                throw new ProtocolException("datasource is null");
            }
            this.log.info("Inizializzo DriverLogAnalyzer terminata.");
        }
        catch (Exception e) {
            this.logError("Errore durante la ricerca del datasource(datasource params): " + e.getMessage(), e);
            throw new DriverTracciamentoException("Errore durante la ricerca del datasource (datasource params): " + e.getMessage(), e);
        }
        try {
            this.log.info("Inizializzo ISQLQueryObject (datasource params)");
            if (!TipiDatabase.isAMember((String)tipoDatabase)) {
                throw new ProtocolException("Tipo database non gestito (datasource params)");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info("Inizializzo ISQLQueryObject terminata (datasource params)");
        }
        catch (Exception e) {
            this.logError("Errore durante la ricerca del SQLQueryObject(datasource params): " + e.getMessage(), e);
            throw new DriverTracciamentoException("Errore durante la ricerca del SQLQueryObject (datasource params): " + e.getMessage(), e);
        }
    }

    public void init(ProtocolliRegistrati protocolliRegistrati, DataSource dataSourceObject, String tipoDatabase) throws DriverTracciamentoException {
        this.init(protocolliRegistrati, dataSourceObject, tipoDatabase, null);
    }

    public void init(ProtocolliRegistrati protocolliRegistrati, DataSource dataSourceObject, String tipoDatabase, Logger log) throws DriverTracciamentoException {
        this.protocolliRegistrati = protocolliRegistrati;
        try {
            this.log = log == null ? LoggerWrapperFactory.getLogger((String)"DRIVER_DB_LOGANALIZER") : log;
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("Errore durante l'inizializzazione del logger (datasource): " + e.getMessage(), e);
        }
        try {
            this.datasource = dataSourceObject;
            if (this.datasource == null) {
                throw new ProtocolException("datasource is null");
            }
        }
        catch (Exception e) {
            this.logError("Errore durante la ricerca del datasource...", e);
            throw new DriverTracciamentoException("Errore durante la ricerca del datasource (datasource): " + e.getMessage(), e);
        }
        try {
            this.log.info("Inizializzo ISQLQueryObject (datasource)");
            if (!TipiDatabase.isAMember((String)tipoDatabase)) {
                throw new ProtocolException("Tipo database non gestito (datasource)");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info("Inizializzo ISQLQueryObject terminata (datasource)");
        }
        catch (Exception e) {
            this.logError("Errore durante la ricerca del SQLQueryObject (datasource): " + e.getMessage(), e);
            throw new DriverTracciamentoException("Errore durante la ricerca del SQLQueryObject (datasource): " + e.getMessage(), e);
        }
    }

    public void init(ProtocolliRegistrati protocolliRegistrati, Connection connection, String tipoDatabase, Logger log) throws DriverTracciamentoException {
        this.protocolliRegistrati = protocolliRegistrati;
        try {
            this.log = log;
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("Errore durante l'inizializzazione del logger (connection): " + e.getMessage(), e);
        }
        this.connection = connection;
        try {
            this.log.info("Inizializzo ISQLQueryObject (connection)");
            if (!TipiDatabase.isAMember((String)tipoDatabase)) {
                throw new ProtocolException("Tipo database non gestito (connection)");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info("Inizializzo ISQLQueryObject terminata (connection)");
        }
        catch (Exception e) {
            this.logError("Errore durante la ricerca del SQLQueryObject (connection): " + e.getMessage(), e);
            throw new DriverTracciamentoException("Errore durante la ricerca del SQLQueryObject (connection): " + e.getMessage(), e);
        }
    }

    public void init(ProtocolliRegistrati protocolliRegistrati, String urlJDBC, String driverJDBC, String username, String password, String tipoDatabase, Logger log) throws DriverTracciamentoException {
        this.protocolliRegistrati = protocolliRegistrati;
        try {
            this.log = log;
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("Errore durante l'inizializzazione del logger (connectionUrl params): " + e.getMessage(), e);
        }
        try {
            Class.forName(driverJDBC);
            this.connection = username != null ? DriverManager.getConnection(urlJDBC, username, password) : DriverManager.getConnection(urlJDBC);
            this.connectionOpenViaJDBCInCostructor = true;
        }
        catch (Exception e) {
            this.logError("Errore durante l'inizializzazione della connessione (connectionUrl params): " + e.getMessage(), e);
            throw new DriverTracciamentoException("Errore durante l'inizializzazione della connessione (connectionUrl params): " + e.getMessage(), e);
        }
        try {
            this.log.info("Inizializzo ISQLQueryObject (connectionUrl params)");
            if (!TipiDatabase.isAMember((String)tipoDatabase)) {
                throw new ProtocolException("Tipo database non gestito (connectionUrl params)");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info("Inizializzo ISQLQueryObject terminata (connectionUrl params)");
        }
        catch (Exception e) {
            this.logError("Errore durante la ricerca del SQLQueryObject (connectionUrl params): " + e.getMessage(), e);
            throw new DriverTracciamentoException("Errore durante la ricerca del SQLQueryObject (connectionUrl params): " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int countTracce(FiltroRicercaTracce filtro) throws DriverTracciamentoException {
        int n;
        Connection connectionDB = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int contatore = 0;
        try {
            connectionDB = this.connection != null ? this.connection : this.datasource.getConnection();
            this.checkConnection(connectionDB);
            ISQLQueryObject sqlQueryObject = TracciaDriverUtilities.createSQLQueryObj_countTracce(filtro, this.tipoDatabase);
            String sql = sqlQueryObject.createSQLQuery();
            StringWrapper sqlDebug = new StringWrapper(sqlQueryObject.createSQLQuery());
            TracciaDriverUtilities.setValuesSearch(sqlDebug, filtro, 1);
            this.logDebug("Query: " + String.valueOf(sqlDebug));
            pstmt = connectionDB.prepareStatement(sql);
            TracciaDriverUtilities.setValuesSearch(pstmt, filtro, 1);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                contatore = rs.getInt("countTracce");
            }
            rs.close();
            pstmt.close();
            this.logDebug("Query found " + contatore + " rows ");
            n = contatore;
        }
        catch (Exception e) {
            try {
                throw new DriverTracciamentoException(TRACCIA_EXCEPTION_PREFIX + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, pstmt);
                try {
                    if (this.connection != null) throw throwable;
                    if (connectionDB == null) throw throwable;
                    JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)connectionDB, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)pstmt);
        try {
            if (this.connection != null) return n;
            if (connectionDB == null) return n;
            JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)connectionDB, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
            return n;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    @Override
    public List<Traccia> getTracce(FiltroRicercaTracceConPaginazione filtro) throws DriverTracciamentoException, DriverTracciamentoNotFoundException {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection connectionDB;
        block13: {
            connectionDB = null;
            pstmt = null;
            rs = null;
            ArrayList<Traccia> tracce = new ArrayList<Traccia>();
            connectionDB = this.connection != null ? this.connection : this.datasource.getConnection();
            this.checkConnection(connectionDB);
            ISQLQueryObject sqlQueryObject = TracciaDriverUtilities.createSQLQueryObj_searchTracce(filtro, this.tipoDatabase);
            String sql = sqlQueryObject.createSQLQuery();
            StringWrapper sqlDebug = new StringWrapper(sqlQueryObject.createSQLQuery());
            TracciaDriverUtilities.setValuesSearch(sqlDebug, filtro, 1);
            this.logDebug("Query: " + String.valueOf(sqlDebug));
            pstmt = connectionDB.prepareStatement(sql);
            TracciaDriverUtilities.setValuesSearch(pstmt, filtro, 1);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Long idTraccia = rs.getLong("idTraccia");
                Traccia traccia = TracciaDriverUtilities.getTraccia(connectionDB, this.tipoDatabase, this.log, idTraccia, this.properties, this.protocolliRegistrati);
                tracce.add(traccia);
            }
            rs.close();
            pstmt.close();
            this.logDebug("Query found " + tracce.size() + " rows");
            if (tracce.isEmpty()) break block13;
            ArrayList<Traccia> arrayList = tracce;
            JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)pstmt);
            try {
                if (this.connection == null && connectionDB != null) {
                    JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)connectionDB, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return arrayList;
        }
        try {
            try {
                throw new DriverTracciamentoNotFoundException("Non sono state trovate tracce che rispettano i criteri di ricerca impostati");
            }
            catch (DriverTracciamentoNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DriverTracciamentoException(TRACCIA_EXCEPTION_PREFIX + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            JDBCUtilities.closeResources(rs, pstmt);
            try {
                if (this.connection == null && connectionDB != null) {
                    JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)connectionDB, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    @Override
    public int deleteTracce(FiltroRicercaTracce filtro) throws DriverTracciamentoException {
        int deleted = 0;
        Connection con = this.getConnection();
        Statement stmt = null;
        try {
            ISQLQueryObject sqlQueryObject = TracciaDriverUtilities.createSQLQueryObj_deleteTracce(filtro, this.tipoDatabase);
            String sql = sqlQueryObject.createSQLDelete();
            StringWrapper sqlDebug = new StringWrapper(sqlQueryObject.createSQLDelete());
            TracciaDriverUtilities.setValuesSearch(sqlDebug, filtro, 1);
            this.logDebug("Delete: " + String.valueOf(sqlDebug));
            stmt = con.prepareStatement(sql);
            TracciaDriverUtilities.setValuesSearch(stmt, filtro, 1);
            deleted = stmt.executeUpdate();
            this.logDebug("Deleted " + deleted + " rows");
            int n = deleted;
            return n;
        }
        catch (Exception e) {
            throw new DriverTracciamentoException(e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            this.releaseConnection(con);
            this.logDebug("Tracce Eliminate: " + deleted);
        }
    }

    @Override
    public Traccia getTraccia(String idBusta, IDSoggetto codicePorta) throws DriverTracciamentoException, DriverTracciamentoNotFoundException {
        return this.getTracciaEngine(idBusta, codicePorta, false);
    }

    @Override
    public Traccia getTraccia(String idBusta, IDSoggetto codicePorta, boolean ricercaIdBustaComeRiferimentoMessaggio) throws DriverTracciamentoException, DriverTracciamentoNotFoundException {
        return this.getTracciaEngine(idBusta, codicePorta, ricercaIdBustaComeRiferimentoMessaggio);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Traccia getTracciaEngine(String idBusta, IDSoggetto codicePorta, boolean rifMsg) throws DriverTracciamentoException, DriverTracciamentoNotFoundException {
        Traccia traccia;
        Connection connectionDB = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Traccia tr = null;
        try {
            connectionDB = this.connection != null ? this.connection : this.datasource.getConnection();
            this.checkConnection(connectionDB);
            ISQLQueryObject sqlQueryObject = TracciaDriverUtilities.getSQLQueryObject(this.tipoDatabase);
            sqlQueryObject.addFromTable("tracce");
            sqlQueryObject.addSelectField("id");
            if (rifMsg) {
                sqlQueryObject.addWhereCondition("rif_messaggio=?");
            } else {
                sqlQueryObject.addWhereCondition("id_messaggio=?");
            }
            if (TracciaDriverUtilities.isDefined(codicePorta)) {
                if (TracciaDriverUtilities.isDefined(codicePorta.getCodicePorta())) {
                    sqlQueryObject.addWhereCondition("pdd_codice=?");
                }
                if (TracciaDriverUtilities.isDefined(codicePorta.getTipo())) {
                    sqlQueryObject.addWhereCondition("pdd_tipo_soggetto=?");
                }
                if (TracciaDriverUtilities.isDefined(codicePorta.getNome())) {
                    sqlQueryObject.addWhereCondition("pdd_nome_soggetto=?");
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            pstmt = connectionDB.prepareStatement(sqlQueryObject.toString());
            int index = 1;
            pstmt.setString(index++, idBusta);
            if (TracciaDriverUtilities.isDefined(codicePorta)) {
                if (TracciaDriverUtilities.isDefined(codicePorta.getCodicePorta())) {
                    pstmt.setString(index++, codicePorta.getCodicePorta());
                }
                if (TracciaDriverUtilities.isDefined(codicePorta.getTipo())) {
                    pstmt.setString(index++, codicePorta.getTipo());
                }
                if (TracciaDriverUtilities.isDefined(codicePorta.getNome())) {
                    pstmt.setString(index++, codicePorta.getNome());
                }
            }
            if ((rs = pstmt.executeQuery()).next()) {
                Long idTraccia = rs.getLong("id");
                tr = TracciaDriverUtilities.getTraccia(connectionDB, this.tipoDatabase, this.log, idTraccia, this.properties, this.protocolliRegistrati);
            }
            rs.close();
            pstmt.close();
            if (tr == null) {
                throw new DriverTracciamentoNotFoundException("Traccia non trovata (idBusta:" + idBusta + ") (dominio-porta:" + String.valueOf(codicePorta) + ") (rifmsg:" + rifMsg + ")");
            }
            traccia = tr;
        }
        catch (DriverTracciamentoNotFoundException d) {
            try {
                throw d;
                catch (Exception e) {
                    throw new DriverTracciamentoException(TRACCIA_EXCEPTION_PREFIX + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, pstmt);
                try {
                    if (this.connection != null) throw throwable;
                    if (connectionDB == null) throw throwable;
                    JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)connectionDB, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)pstmt);
        try {
            if (this.connection != null) return traccia;
            if (connectionDB == null) return traccia;
            JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)connectionDB, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
            return traccia;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return traccia;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Traccia getTraccia(String idTransazione, RuoloMessaggio tipoTraccia) throws DriverTracciamentoException, DriverTracciamentoNotFoundException {
        Traccia traccia;
        Connection connectionDB = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Traccia tr = null;
        try {
            connectionDB = this.connection != null ? this.connection : this.datasource.getConnection();
            this.checkConnection(connectionDB);
            ISQLQueryObject sqlQueryObject = TracciaDriverUtilities.getSQLQueryObject(this.tipoDatabase);
            sqlQueryObject.addFromTable("tracce");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_transazione=?");
            sqlQueryObject.addWhereCondition("tipo_messaggio=?");
            sqlQueryObject.setANDLogicOperator(true);
            pstmt = connectionDB.prepareStatement(sqlQueryObject.toString());
            int index = 1;
            pstmt.setString(index++, idTransazione);
            pstmt.setString(index++, tipoTraccia.toString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                Long idTraccia = rs.getLong("id");
                tr = TracciaDriverUtilities.getTraccia(connectionDB, this.tipoDatabase, this.log, idTraccia, this.properties, this.protocolliRegistrati);
            }
            rs.close();
            pstmt.close();
            if (tr == null) {
                throw new DriverTracciamentoNotFoundException("Traccia non trovata (idTransazione:" + idTransazione + ") (tipo:" + String.valueOf(tipoTraccia) + ")");
            }
            traccia = tr;
        }
        catch (DriverTracciamentoNotFoundException d) {
            try {
                throw d;
                catch (Exception e) {
                    throw new DriverTracciamentoException(TRACCIA_EXCEPTION_PREFIX + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, pstmt);
                try {
                    if (this.connection != null) throw throwable;
                    if (connectionDB == null) throw throwable;
                    JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)connectionDB, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)pstmt);
        try {
            if (this.connection != null) return traccia;
            if (connectionDB == null) return traccia;
            JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)connectionDB, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
            return traccia;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return traccia;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Traccia getTraccia(RuoloMessaggio tipoTraccia, Map<String, String> propertiesRicerca) throws DriverTracciamentoException, DriverTracciamentoNotFoundException {
        Traccia traccia;
        Connection connectionDB = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Traccia tr = null;
        try {
            connectionDB = this.connection != null ? this.connection : this.datasource.getConnection();
            this.checkConnection(connectionDB);
            ISQLQueryObject sqlQueryObject = TracciaDriverUtilities.getSQLQueryObject(this.tipoDatabase);
            sqlQueryObject.addFromTable("tracce");
            sqlQueryObject.addSelectField("id");
            if (propertiesRicerca == null) throw new ProtocolException("Properties di ricerca non fornite");
            if (propertiesRicerca.size() <= 0) throw new ProtocolException("Properties di ricerca non fornite");
            for (String string : propertiesRicerca.keySet()) {
                if (IDTRACCIA.equals(string)) {
                    sqlQueryObject.addWhereCondition("id=?");
                    continue;
                }
                sqlQueryObject.addWhereCondition(string + "=?");
            }
            sqlQueryObject.addWhereCondition("tipo_messaggio=?");
            sqlQueryObject.setANDLogicOperator(true);
            pstmt = connectionDB.prepareStatement(sqlQueryObject.toString());
            int index = 1;
            for (String key : propertiesRicerca.keySet()) {
                String value = propertiesRicerca.get(key);
                if (IDTRACCIA.equals(key)) {
                    pstmt.setLong(index, Long.parseLong(value));
                } else {
                    pstmt.setString(index, value);
                }
                ++index;
            }
            pstmt.setString(index, tipoTraccia.toString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                Long l = rs.getLong("id");
                tr = TracciaDriverUtilities.getTraccia(connectionDB, this.tipoDatabase, this.log, l, this.properties, this.protocolliRegistrati);
            }
            rs.close();
            pstmt.close();
            if (tr == null) {
                throw new DriverTracciamentoNotFoundException("Traccia non trovata (sizeProperties:" + propertiesRicerca.size() + ") (tipo:" + String.valueOf(tipoTraccia) + ")");
            }
            traccia = tr;
        }
        catch (DriverTracciamentoNotFoundException d) {
            try {
                throw d;
                catch (Exception e) {
                    throw new DriverTracciamentoException(TRACCIA_EXCEPTION_PREFIX + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, pstmt);
                try {
                    if (this.connection != null) throw throwable;
                    if (connectionDB == null) throw throwable;
                    JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)connectionDB, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)pstmt);
        try {
            if (this.connection != null) return traccia;
            if (connectionDB == null) return traccia;
            JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)connectionDB, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
            return traccia;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return traccia;
    }

    @Override
    public void close() throws DriverTracciamentoException {
        try {
            if (this.connectionOpenViaJDBCInCostructor && this.connection != null && !this.connection.isClosed()) {
                JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)this.connection, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
            }
        }
        catch (Exception e) {
            throw new DriverTracciamentoException(e.getMessage(), e);
        }
    }

    private void checkConnection(Connection connectionDB) throws ProtocolException {
        if (connectionDB == null && this.connection == null) {
            throw new ProtocolException("Connection non ottenuta dal datasource[" + String.valueOf(this.datasource) + "]");
        }
    }

    public Connection getConnection() {
        if (this.datasource == null) {
            return null;
        }
        Connection connectionDB = null;
        try {
            connectionDB = this.datasource.getConnection();
        }
        catch (Exception e) {
            return null;
        }
        return connectionDB;
    }

    public void releaseConnection(Connection connectionDB) {
        try {
            JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)connectionDB, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public String getTipoDatabase() {
        return this.tipoDatabase;
    }
}

