/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.diagnostica;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.openspcoop2.core.diagnostica.MessaggioDiagnostico;
import org.openspcoop2.core.diagnostica.utils.XMLUtils;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.protocol.basic.BasicComponentFactory;
import org.openspcoop2.protocol.basic.diagnostica.DiagnosticXMLRootElement;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.XMLRootElement;
import org.openspcoop2.protocol.sdk.constants.TipoSerializzazione;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticSerializer;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.w3c.dom.Element;

public class DiagnosticSerializer
extends BasicComponentFactory
implements IDiagnosticSerializer {
    protected MessageXMLUtils xmlUtils = MessageXMLUtils.DEFAULT;
    private boolean prettyDocument = false;
    private boolean omitXmlDeclaration = false;

    public DiagnosticSerializer(IProtocolFactory<?> protocolFactory) throws ProtocolException {
        super(protocolFactory);
    }

    @Override
    public void setPrettyDocument(boolean v) {
        this.prettyDocument = v;
    }

    @Override
    public boolean isPrettyDocument() {
        return this.prettyDocument;
    }

    @Override
    public void setOmitXmlDeclaration(boolean v) {
        this.omitXmlDeclaration = v;
    }

    @Override
    public boolean isOmitXmlDeclaration() {
        return this.omitXmlDeclaration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element toElement(MsgDiagnostico msgDiag) throws ProtocolException {
        Element el = null;
        String tmpId = null;
        try {
            if (msgDiag.sizeProperties() > 0) {
                tmpId = msgDiag.removeProperty("@@@@@-----@@@@-----IDDIAGNOSTICI-DB----@@@@@-----@@@@");
            }
            byte[] xmlDiagnostico = XMLUtils.generateMessaggioDiagnostico((MessaggioDiagnostico)msgDiag.getMessaggioDiagnostico());
            el = this.xmlUtils.newElement(xmlDiagnostico);
        }
        catch (Exception e) {
            this.logAndThrowError(e, "DiagnosticSerializer.toElement error");
        }
        finally {
            if (tmpId != null) {
                msgDiag.addProperty("@@@@@-----@@@@-----IDDIAGNOSTICI-DB----@@@@@-----@@@@", tmpId);
            }
        }
        return el;
    }

    private void logAndThrowError(Exception e, String msg) throws ProtocolException {
        String er = msg + ": " + e.getMessage();
        this.log.error(er, (Throwable)e);
        throw new ProtocolException(er, e);
    }

    @Override
    public String toString(MsgDiagnostico msgDiag, TipoSerializzazione tipoSerializzazione) throws ProtocolException {
        return this.toByteArrayOutputStream(msgDiag, tipoSerializzazione).toString();
    }

    @Override
    public byte[] toByteArray(MsgDiagnostico msgDiag, TipoSerializzazione tipoSerializzazione) throws ProtocolException {
        return this.toByteArrayOutputStream(msgDiag, tipoSerializzazione).toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteArrayOutputStream toByteArrayOutputStream(MsgDiagnostico msgDiag, TipoSerializzazione tipoSerializzazione) throws ProtocolException {
        ByteArrayOutputStream ret = null;
        String tmpId = null;
        try {
            if (msgDiag.sizeProperties() > 0) {
                tmpId = msgDiag.removeProperty("@@@@@-----@@@@-----IDDIAGNOSTICI-DB----@@@@@-----@@@@");
            }
            if (TipoSerializzazione.JSON.equals(tipoSerializzazione)) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                String s = XMLUtils.generateMessaggioDiagnosticoAsJson((MessaggioDiagnostico)msgDiag.getMessaggioDiagnostico(), (boolean)this.prettyDocument);
                bout.write(s.getBytes());
                bout.flush();
                bout.close();
                ret = bout;
            } else {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                XMLUtils.generateMessaggioDiagnostico((MessaggioDiagnostico)msgDiag.getMessaggioDiagnostico(), (OutputStream)bout, (boolean)this.prettyDocument, (boolean)this.omitXmlDeclaration);
                bout.flush();
                bout.close();
                ret = bout;
            }
        }
        catch (Exception e) {
            this.logAndThrowError(e, "DiagnosticSerializer.toString error");
        }
        finally {
            if (tmpId != null) {
                msgDiag.addProperty("@@@@@-----@@@@-----IDDIAGNOSTICI-DB----@@@@@-----@@@@", tmpId);
            }
        }
        return ret;
    }

    @Override
    public XMLRootElement getXMLRootElement() throws ProtocolException {
        return new DiagnosticXMLRootElement();
    }

    public MsgDiagnostico toMsgDiagnostico(String msgDiag, TipoSerializzazione tipoSerializzazione) throws ProtocolException {
        try {
            if (TipoSerializzazione.JSON.equals(tipoSerializzazione)) {
                return new MsgDiagnostico(XMLUtils.toMessaggioDiagnosticoFromJson((String)msgDiag));
            }
            return new MsgDiagnostico(XMLUtils.toMessaggioDiagnosticoFromXml((String)msgDiag));
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public MsgDiagnostico toMsgDiagnostico(byte[] msgDiag, TipoSerializzazione tipoSerializzazione) throws ProtocolException {
        try {
            if (TipoSerializzazione.JSON.equals(tipoSerializzazione)) {
                return new MsgDiagnostico(XMLUtils.toMessaggioDiagnosticoFromJson((byte[])msgDiag));
            }
            return new MsgDiagnostico(XMLUtils.toMessaggioDiagnosticoFromXml((byte[])msgDiag));
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }
}

