/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.diagnostica;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.protocol.basic.diagnostica.DiagnosticSearchType;
import org.openspcoop2.protocol.sdk.diagnostica.FiltroRicercaDiagnostici;
import org.openspcoop2.protocol.sdk.diagnostica.FiltroRicercaDiagnosticiConPaginazione;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.utils.StringWrapper;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectException;
import org.slf4j.Logger;

public class DiagnosticDriverUtilities {
    private DiagnosticDriverUtilities() {
    }

    public static ISQLQueryObject createSQLQueryObj_searchMessaggiDiagnostici(FiltroRicercaDiagnosticiConPaginazione filter, String tipoDatabase) throws SQLQueryObjectException {
        return DiagnosticDriverUtilities.createSQLQueryObj(filter, tipoDatabase, DiagnosticSearchType.MSGDIAGNOSTICI);
    }

    public static ISQLQueryObject createSQLQueryObj_countMessaggiDiagnostici(FiltroRicercaDiagnostici filter, String tipoDatabase) throws SQLQueryObjectException {
        return DiagnosticDriverUtilities.createSQLQueryObj(filter, tipoDatabase, DiagnosticSearchType.COUNT_MSGDIAGNOSTICI);
    }

    public static ISQLQueryObject createSQLQueryObj_deleteMessaggiDiagnostici(FiltroRicercaDiagnostici filter, String tipoDatabase) throws SQLQueryObjectException {
        ISQLQueryObject from = DiagnosticDriverUtilities.createSQLQueryObj(filter, tipoDatabase, DiagnosticSearchType.DELETE_MSGDIAGNOSTICI);
        ISQLQueryObject sqlQueryObjectDelete = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
        sqlQueryObjectDelete.addDeleteTable("msgdiagnostici");
        sqlQueryObjectDelete.addWhereINSelectSQLCondition(false, "id", from);
        return sqlQueryObjectDelete;
    }

    private static ISQLQueryObject createSQLQueryObj(FiltroRicercaDiagnostici filter, String tipoDatabase, DiagnosticSearchType tipoRicerca) throws SQLQueryObjectException {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
        boolean distinct = true;
        switch (tipoRicerca) {
            case MSGDIAGNOSTICI: {
                sqlQueryObject.setSelectDistinct(distinct);
                sqlQueryObject.addSelectAliasField("msgdiagnostici.id", "idMsgDiagnostico");
                sqlQueryObject.addSelectField("msgdiagnostici.gdo");
                break;
            }
            case COUNT_MSGDIAGNOSTICI: {
                sqlQueryObject.addSelectCountField("msgdiagnostici.id", "countMsgDiagnostici", distinct);
                break;
            }
            case DELETE_MSGDIAGNOSTICI: {
                sqlQueryObject.setSelectDistinct(distinct);
                sqlQueryObject.addSelectAliasField("msgdiagnostici.id", "idMsgDiagnostico");
            }
        }
        sqlQueryObject.addFromTable("msgdiagnostici");
        sqlQueryObject.setANDLogicOperator(true);
        if (DiagnosticDriverUtilities.isDefined(filter.getDataInizio())) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.gdo>=?");
        }
        if (DiagnosticDriverUtilities.isDefined(filter.getDataFine())) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.gdo<=?");
        }
        if (DiagnosticDriverUtilities.isDefined(filter.getIdTransazione())) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.id_transazione=?");
        }
        if (DiagnosticDriverUtilities.isDefined(filter.getIdFunzione())) {
            String idF = filter.getIdFunzione();
            if ("RicezioneContenutiApplicativi".equals(idF) || "Imbustamento".equals(idF) || "RicezioneBuste".equals(idF) || "Sbustamento".equals(idF)) {
                sqlQueryObject.addWhereLikeCondition("msgdiagnostici.idfunzione", idF, true, true);
            } else if ("InoltroBuste".equals(idF)) {
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("msgdiagnostici.idfunzione", idF), sqlQueryObject.getWhereLikeCondition("msgdiagnostici.idfunzione", "InoltroRisposte")});
            } else if ("ConsegnaContenutiApplicativi".equals(idF)) {
                sqlQueryObject.addWhereLikeCondition("msgdiagnostici.idfunzione", idF);
            } else {
                sqlQueryObject.addWhereCondition("msgdiagnostici.idfunzione=?");
            }
        }
        if (DiagnosticDriverUtilities.isDefined(filter.getDominio())) {
            if (DiagnosticDriverUtilities.isDefined(filter.getDominio().getCodicePorta())) {
                sqlQueryObject.addWhereCondition("msgdiagnostici.pdd_codice=?");
            }
            if (DiagnosticDriverUtilities.isDefined(filter.getDominio().getTipo())) {
                sqlQueryObject.addWhereCondition("msgdiagnostici.pdd_tipo_soggetto=?");
            }
            if (DiagnosticDriverUtilities.isDefined(filter.getDominio().getNome())) {
                sqlQueryObject.addWhereCondition("msgdiagnostici.pdd_nome_soggetto=?");
            }
        }
        if (DiagnosticDriverUtilities.isDefined(filter.getIdBustaRichiesta())) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.idmessaggio=?");
        }
        if (DiagnosticDriverUtilities.isDefined(filter.getIdBustaRisposta())) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.idmessaggio_risposta=?");
        }
        if (DiagnosticDriverUtilities.isDefined(filter.getSeverita())) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.severita<=?");
        }
        if (DiagnosticDriverUtilities.isDefined(filter.getCodice())) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.codice=?");
        }
        if (DiagnosticDriverUtilities.isDefined(filter.getMessaggioCercatoInternamenteTestoDiagnostico())) {
            sqlQueryObject.addWhereLikeCondition("msgdiagnostici.messaggio", filter.getMessaggioCercatoInternamenteTestoDiagnostico(), true, true);
        }
        if (DiagnosticDriverUtilities.isDefined(filter.getProtocollo())) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.protocollo=?");
        }
        if (DiagnosticDriverUtilities.isDefined(filter.getApplicativo())) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.applicativo=?");
        } else if (DiagnosticDriverUtilities.isDefined(filter.getCheckApplicativoIsNull()) && filter.getCheckApplicativoIsNull() != null && filter.getCheckApplicativoIsNull().booleanValue()) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.applicativo is null");
        }
        if (filter.getProperties() != null) {
            for (String key : filter.getProperties().keySet()) {
                switch (tipoRicerca) {
                    case MSGDIAGNOSTICI: 
                    case COUNT_MSGDIAGNOSTICI: 
                    case DELETE_MSGDIAGNOSTICI: {
                        if ("@@@@@-----@@@@-----IDDIAGNOSTICI-DB----@@@@@-----@@@@".equals(key)) {
                            sqlQueryObject.addWhereCondition("msgdiagnostici.id=?");
                            break;
                        }
                        sqlQueryObject.addWhereCondition("msgdiagnostici." + key + "=?");
                    }
                }
            }
        }
        switch (tipoRicerca) {
            case MSGDIAGNOSTICI: {
                FiltroRicercaDiagnosticiConPaginazione f = (FiltroRicercaDiagnosticiConPaginazione)filter;
                if (f.getLimit() > 0) {
                    sqlQueryObject.setLimit(f.getLimit());
                }
                if (f.getOffset() > 0) {
                    sqlQueryObject.setOffset(f.getOffset());
                }
                sqlQueryObject.addOrderBy("gdo");
                sqlQueryObject.setSortType(f.isAsc());
                break;
            }
        }
        return sqlQueryObject;
    }

    public static int setValues_searchMessaggiDiagnostici(FiltroRicercaDiagnostici filter, Object object, int startIndex) throws SQLQueryObjectException, SQLException {
        return DiagnosticDriverUtilities.setValuesSearch(filter, object, startIndex, DiagnosticSearchType.MSGDIAGNOSTICI);
    }

    public static int setValues_countMessaggiDiagnostici(FiltroRicercaDiagnostici filter, Object object, int startIndex) throws SQLQueryObjectException, SQLException {
        return DiagnosticDriverUtilities.setValuesSearch(filter, object, startIndex, DiagnosticSearchType.COUNT_MSGDIAGNOSTICI);
    }

    public static int setValues_deleteMessaggiDiagnostici(FiltroRicercaDiagnostici filter, Object object, int startIndex) throws SQLQueryObjectException, SQLException {
        return DiagnosticDriverUtilities.setValuesSearch(filter, object, startIndex, DiagnosticSearchType.DELETE_MSGDIAGNOSTICI);
    }

    private static int setValuesSearch(FiltroRicercaDiagnostici filter, Object object, int startIndex, DiagnosticSearchType tipoRicerca) throws SQLException {
        String idF;
        if (tipoRicerca != null) {
            // empty if block
        }
        SimpleDateFormat dateformat = DateUtils.getSimpleDateFormatMs();
        PreparedStatement pstmt = null;
        StringWrapper query = null;
        if (object instanceof PreparedStatement) {
            pstmt = (PreparedStatement)object;
        } else if (object instanceof StringWrapper) {
            query = (StringWrapper)object;
        } else {
            throw new SQLException("Tipo di parametro [" + object.getClass().getName() + "] non gestito");
        }
        if (DiagnosticDriverUtilities.isDefined(filter.getDataInizio())) {
            if (pstmt != null) {
                pstmt.setTimestamp(startIndex++, new Timestamp(filter.getDataInizio().getTime()));
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + dateformat.format(filter.getDataInizio()) + "'");
            }
        }
        if (DiagnosticDriverUtilities.isDefined(filter.getDataFine())) {
            if (pstmt != null) {
                pstmt.setTimestamp(startIndex++, new Timestamp(filter.getDataFine().getTime()));
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + dateformat.format(filter.getDataFine()) + "'");
            }
        }
        if (DiagnosticDriverUtilities.isDefined(filter.getIdTransazione())) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, filter.getIdTransazione());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filter.getIdTransazione() + "'");
            }
        }
        if (!(!DiagnosticDriverUtilities.isDefined(filter.getIdFunzione()) || "RicezioneContenutiApplicativi".equals(idF = filter.getIdFunzione()) || "Imbustamento".equals(idF) || "RicezioneBuste".equals(idF) || "Sbustamento".equals(idF) || "InoltroBuste".equals(idF) || "ConsegnaContenutiApplicativi".equals(idF))) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, idF);
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + idF + "'");
            }
        }
        if (DiagnosticDriverUtilities.isDefined(filter.getDominio())) {
            if (DiagnosticDriverUtilities.isDefined(filter.getDominio().getCodicePorta())) {
                if (pstmt != null) {
                    pstmt.setString(startIndex++, filter.getDominio().getCodicePorta());
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + filter.getDominio().getCodicePorta() + "'");
                }
            }
            if (DiagnosticDriverUtilities.isDefined(filter.getDominio().getTipo())) {
                if (pstmt != null) {
                    pstmt.setString(startIndex++, filter.getDominio().getTipo());
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + filter.getDominio().getTipo() + "'");
                }
            }
            if (DiagnosticDriverUtilities.isDefined(filter.getDominio().getNome())) {
                if (pstmt != null) {
                    pstmt.setString(startIndex++, filter.getDominio().getNome());
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + filter.getDominio().getNome() + "'");
                }
            }
        }
        if (DiagnosticDriverUtilities.isDefined(filter.getIdBustaRichiesta())) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, filter.getIdBustaRichiesta());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filter.getIdBustaRichiesta() + "'");
            }
        }
        if (DiagnosticDriverUtilities.isDefined(filter.getIdBustaRisposta())) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, filter.getIdBustaRisposta());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filter.getIdBustaRisposta() + "'");
            }
        }
        if (DiagnosticDriverUtilities.isDefined(filter.getSeverita())) {
            if (pstmt != null) {
                pstmt.setInt(startIndex++, filter.getSeverita());
            }
            if (query != null) {
                query.replaceFirst("\\?", "" + filter.getSeverita());
            }
        }
        if (DiagnosticDriverUtilities.isDefined(filter.getCodice())) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, filter.getCodice());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filter.getCodice() + "'");
            }
        }
        if (DiagnosticDriverUtilities.isDefined(filter.getProtocollo())) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, filter.getProtocollo());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filter.getProtocollo() + "'");
            }
        }
        if (DiagnosticDriverUtilities.isDefined(filter.getApplicativo())) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, filter.getApplicativo());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filter.getApplicativo() + "'");
            }
        } else if (!DiagnosticDriverUtilities.isDefined(filter.getCheckApplicativoIsNull()) || filter.getCheckApplicativoIsNull() == null || filter.getCheckApplicativoIsNull().booleanValue()) {
            // empty if block
        }
        if (filter.getProperties() != null) {
            for (String key : filter.getProperties().keySet()) {
                String value = filter.getProperties().get(key);
                if ("@@@@@-----@@@@-----IDDIAGNOSTICI-DB----@@@@@-----@@@@".equals(key)) {
                    if (pstmt != null) {
                        pstmt.setLong(startIndex++, Long.parseLong(value));
                    }
                    if (query == null) continue;
                    query.replaceFirst("\\?", value);
                    continue;
                }
                if (pstmt != null) {
                    pstmt.setString(startIndex++, value);
                }
                if (query == null) continue;
                query.replaceFirst("\\?", "'" + value + "'");
            }
        }
        return startIndex;
    }

    public static MsgDiagnostico getMsgDiagnostico(Connection c, String tipoDatabase, Logger log, long id, List<String> properties) throws SQLQueryObjectException, SQLException {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
        sqlQueryObject.addFromTable("msgdiagnostici");
        sqlQueryObject.addWhereCondition("id=?");
        String msgD = "Eseguo query : " + sqlQueryObject.createSQLQuery().replaceFirst("\\?", "" + id);
        log.debug(msgD);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = c.prepareStatement(sqlQueryObject.createSQLQuery());
            stmt.setLong(1, id);
            rs = stmt.executeQuery();
            if (rs.next()) {
                MsgDiagnostico msg = new MsgDiagnostico();
                msg.setId(rs.getLong("id"));
                msg.addProperty("@@@@@-----@@@@-----IDDIAGNOSTICI-DB----@@@@@-----@@@@", "" + msg.getId());
                Timestamp gdo = rs.getTimestamp("gdo");
                msg.setGdo(gdo);
                msg.setIdTransazione(rs.getString("id_transazione"));
                msg.setApplicativo(rs.getString("applicativo"));
                IDSoggetto idSoggetto = new IDSoggetto();
                idSoggetto.setCodicePorta(rs.getString("pdd_codice"));
                idSoggetto.setNome(rs.getString("pdd_nome_soggetto"));
                idSoggetto.setTipo(rs.getString("pdd_tipo_soggetto"));
                msg.setIdSoggetto(idSoggetto);
                msg.setIdFunzione(rs.getString("idfunzione"));
                msg.setSeverita(rs.getInt("severita"));
                msg.setMessaggio(rs.getString("messaggio"));
                msg.setIdBusta(rs.getString("idmessaggio"));
                msg.setIdBustaRisposta(rs.getString("idmessaggio_risposta"));
                msg.setCodice(rs.getString("codice"));
                msg.setProtocollo(rs.getString("protocollo"));
                if (properties != null) {
                    for (int i = 0; i < properties.size(); ++i) {
                        String key = properties.get(i);
                        msg.addProperty(key, rs.getString(key));
                    }
                }
                MsgDiagnostico msgDiagnostico = msg;
                return msgDiagnostico;
            }
            throw new SQLQueryObjectException("MsgDiagnostico con id[" + id + "] non trovato");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected static boolean isDefined(String v) {
        return v != null && !"".equals(v);
    }

    protected static boolean isDefined(Boolean v) {
        return v != null;
    }

    protected static boolean isDefined(Integer v) {
        return v != null;
    }

    protected static boolean isDefined(List<?> v) {
        return v != null && !v.isEmpty();
    }

    protected static boolean isDefined(Date v) {
        return v != null;
    }

    protected static boolean isDefined(IDSoggetto v) {
        return v != null;
    }
}

