/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.config;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.utils.AllarmiDriverUtils;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.PortaDelegataAzione;
import org.openspcoop2.core.config.constants.PortaDelegataAzioneIdentificazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.utils.ControlloTrafficoDriverUtils;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.mapping.SubscriptionUtils;
import org.openspcoop2.protocol.basic.config.AbstractIntegrationConfiguration;
import org.openspcoop2.protocol.manifest.IntegrationConfiguration;
import org.openspcoop2.protocol.manifest.IntegrationConfigurationResourceIdentificationMode;
import org.openspcoop2.protocol.manifest.constants.ResourceIdentificationType;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.config.ProtocolSubscription;
import org.openspcoop2.protocol.sdk.constants.ConsoleInterfaceType;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;

public class SubscriptionConfiguration
extends AbstractIntegrationConfiguration {
    private static final long serialVersionUID = 1L;
    private static final String SUBSCRIPTION_PREFIX = "Subscription from ";
    private static final String SUBSCRIPTION_PREFIX_2 = "Subscription for service ";
    private static final String INTERNAL_SUBSCRIPTION_PREFIX = "Internal Subscription '";

    protected SubscriptionConfiguration(IntegrationConfiguration integrationConfiguration) {
        super(integrationConfiguration);
    }

    public static boolean isDescriptionDefault(String descrizione) {
        return descrizione != null && (descrizione.startsWith(SUBSCRIPTION_PREFIX) || descrizione.startsWith(SUBSCRIPTION_PREFIX_2) || descrizione.startsWith(INTERNAL_SUBSCRIPTION_PREFIX));
    }

    public ProtocolSubscription createDefaultSubscription(IDSoggetto idFruitore, IDServizio idServizio) throws ProtocolException {
        ProtocolSubscription subscription = new ProtocolSubscription();
        PortaDelegata portaDelegata = new PortaDelegata();
        portaDelegata.setNome(this.getNome(idServizio, idFruitore, null, null, this.integrationConfiguration.getName().getParamList()));
        portaDelegata.setDescrizione(SUBSCRIPTION_PREFIX + idFruitore.toString() + " for service " + idServizio.toString());
        if (portaDelegata.getDescrizione().length() > 255) {
            portaDelegata.setDescrizione(SUBSCRIPTION_PREFIX_2 + idServizio.toString());
        }
        if (portaDelegata.getDescrizione().length() > 255) {
            portaDelegata.setDescrizione(null);
        }
        IDPortaDelegata idPortaDelegata = SubscriptionUtils.setCommonParameter((PortaDelegata)portaDelegata, (IDSoggetto)idFruitore, (IDServizio)idServizio, (boolean)true, (boolean)false);
        PortaDelegataAzione pdAzione = new PortaDelegataAzione();
        ResourceIdentificationType defaultIdentification = this.integrationConfiguration.getResourceIdentification().getIdentificationModes().getDefault();
        if (defaultIdentification == null) {
            defaultIdentification = this.integrationConfiguration.getResourceIdentification().getIdentificationModes().getMode(0).getName();
        }
        boolean setPattern = false;
        switch (defaultIdentification) {
            case CONTENT: {
                pdAzione.setIdentificazione(PortaDelegataAzioneIdentificazione.CONTENT_BASED);
                setPattern = true;
                break;
            }
            case HEADER: {
                pdAzione.setIdentificazione(PortaDelegataAzioneIdentificazione.HEADER_BASED);
                setPattern = true;
                break;
            }
            case URL: {
                pdAzione.setIdentificazione(PortaDelegataAzioneIdentificazione.URL_BASED);
                setPattern = true;
                break;
            }
            case INPUT: {
                pdAzione.setIdentificazione(PortaDelegataAzioneIdentificazione.INPUT_BASED);
                break;
            }
            case INTERFACE: {
                pdAzione.setIdentificazione(PortaDelegataAzioneIdentificazione.INTERFACE_BASED);
                break;
            }
            case SOAP_ACTION: {
                pdAzione.setIdentificazione(PortaDelegataAzioneIdentificazione.SOAP_ACTION_BASED);
                break;
            }
            case PROTOCOL: {
                throw new ProtocolException("IdentificationMode '" + String.valueOf(defaultIdentification) + "' unsupported");
            }
        }
        if (setPattern) {
            pdAzione.setPattern(this.getNome(idServizio, idFruitore, portaDelegata.getNome(), null, this.integrationConfiguration.getResourceIdentification().getIdentificationParameter().getParamList()));
        }
        if (this.integrationConfiguration.getResourceIdentification().getIdentificationModes().isForceInterfaceMode()) {
            pdAzione.setForceInterfaceBased(StatoFunzionalita.ABILITATO);
        } else {
            pdAzione.setForceInterfaceBased(StatoFunzionalita.DISABILITATO);
        }
        portaDelegata.setAzione(pdAzione);
        portaDelegata.setRicercaPortaAzioneDelegata(StatoFunzionalita.ABILITATO);
        subscription.setPortaDelegata(portaDelegata);
        MappingFruizionePortaDelegata mappingFruizione = SubscriptionUtils.createMappingDefault((IDSoggetto)idFruitore, (IDServizio)idServizio, (IDPortaDelegata)idPortaDelegata);
        subscription.setMapping(mappingFruizione);
        return subscription;
    }

    public List<PortaDelegataAzioneIdentificazione> supportedIdentificationModes(ConsoleInterfaceType consoleType) throws ProtocolException {
        ArrayList<PortaDelegataAzioneIdentificazione> list = new ArrayList<PortaDelegataAzioneIdentificazione>();
        for (IntegrationConfigurationResourceIdentificationMode mode : this.integrationConfiguration.getResourceIdentification().getIdentificationModes().getModeList()) {
            if (mode.isOnlyAdvancedMode() && ConsoleInterfaceType.STANDARD.equals((Object)consoleType)) continue;
            ResourceIdentificationType type = mode.getName();
            switch (type) {
                case CONTENT: {
                    list.add(PortaDelegataAzioneIdentificazione.CONTENT_BASED);
                    break;
                }
                case HEADER: {
                    list.add(PortaDelegataAzioneIdentificazione.HEADER_BASED);
                    break;
                }
                case URL: {
                    list.add(PortaDelegataAzioneIdentificazione.URL_BASED);
                    break;
                }
                case INPUT: {
                    list.add(PortaDelegataAzioneIdentificazione.INPUT_BASED);
                    break;
                }
                case INTERFACE: {
                    list.add(PortaDelegataAzioneIdentificazione.INTERFACE_BASED);
                    break;
                }
                case SOAP_ACTION: {
                    list.add(PortaDelegataAzioneIdentificazione.SOAP_ACTION_BASED);
                    break;
                }
                case PROTOCOL: {
                    throw new ProtocolException("IdentificationMode '" + String.valueOf(type) + "' unsupported");
                }
            }
        }
        return list;
    }

    public ProtocolSubscription createSubscription(IConfigIntegrationReader configIntegrationReader, IDSoggetto idFruitore, IDServizio idServizio, PortaDelegata portaDelegataDefault, String ruleName, String description, String ... azione) throws ProtocolException {
        return this.createSubscription(configIntegrationReader, idFruitore, idServizio, portaDelegataDefault, (PortaDelegata)null, ruleName, description, azione);
    }

    public ProtocolSubscription createSubscription(IConfigIntegrationReader configIntegrationReader, IDSoggetto idFruitore, IDServizio idServizio, PortaDelegata portaDelegataDefault, PortaDelegata portaDelegataDaClonare, String ruleName, String description, String ... azione) throws ProtocolException {
        if (azione == null || azione.length <= 0) {
            throw new ProtocolException("Actions undefined");
        }
        String nomePortaDelegante = portaDelegataDefault.getNome();
        String nomeNuovaPortaDelegata = this.getNome(idServizio, idFruitore, nomePortaDelegante, ruleName, this.integrationConfiguration.getResourceIdentification().getSpecificResource().getName().getParamList());
        String descrizioneNuovaPortaDelegata = INTERNAL_SUBSCRIPTION_PREFIX + ruleName + "' for " + nomePortaDelegante;
        if (descrizioneNuovaPortaDelegata.length() > 255) {
            descrizioneNuovaPortaDelegata = INTERNAL_SUBSCRIPTION_PREFIX + ruleName + "'";
        }
        if (descrizioneNuovaPortaDelegata.length() > 255) {
            descrizioneNuovaPortaDelegata = null;
        }
        ProtocolSubscription subscription = new ProtocolSubscription();
        PortaDelegata portaDelegata = null;
        boolean setDatiServizio = false;
        boolean portaClonata = false;
        if (portaDelegataDaClonare != null) {
            portaDelegata = (PortaDelegata)portaDelegataDaClonare.clone();
            portaDelegata.setId(null);
            portaDelegata.setGestioneCors(null);
            portaDelegata.setCanale(null);
            IDPortaDelegata idPD = new IDPortaDelegata();
            idPD.setNome(portaDelegataDaClonare.getNome());
            List<AttivazionePolicy> listAP = null;
            try {
                listAP = configIntegrationReader.getRateLimitingPolicy(idPD);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ArrayList<String> idPolicyCreate = new ArrayList<String>();
            if (listAP != null && !listAP.isEmpty()) {
                for (AttivazionePolicy attivazionePolicy : listAP) {
                    AttivazionePolicy apCloned = (AttivazionePolicy)attivazionePolicy.clone();
                    if (apCloned.getIdPolicy() == null || apCloned.getFiltro() == null || !portaDelegataDaClonare.getNome().equals(apCloned.getFiltro().getNomePorta())) continue;
                    try {
                        apCloned.getFiltro().setNomePorta(nomeNuovaPortaDelegata);
                        String serialId = configIntegrationReader.getNextPolicyInstanceSerialId(apCloned.getIdPolicy());
                        String idActive = ControlloTrafficoDriverUtils.buildIdActivePolicy((String)apCloned.getIdPolicy(), (String)serialId);
                        for (int limit = 0; idPolicyCreate.contains(idActive) && limit < 1000; ++limit) {
                            serialId = ControlloTrafficoDriverUtils.incrementPolicyInstanceSerialId((String)serialId);
                            idActive = ControlloTrafficoDriverUtils.buildIdActivePolicy((String)apCloned.getIdPolicy(), (String)serialId);
                        }
                        idPolicyCreate.add(idActive);
                        apCloned.setIdActivePolicy(idActive);
                        if (subscription.getRateLimitingPolicies() == null) {
                            subscription.setRateLimitingPolicies(new ArrayList());
                        }
                        subscription.getRateLimitingPolicies().add(apCloned);
                    }
                    catch (Exception serialId) {}
                }
            }
            List<Allarme> listAllarmi = null;
            try {
                listAllarmi = configIntegrationReader.getAllarmi(idPD);
            }
            catch (Exception attivazionePolicy) {
                // empty catch block
            }
            ArrayList<String> idAllarmiCreate = new ArrayList<String>();
            if (listAllarmi != null && !listAllarmi.isEmpty()) {
                for (Allarme allarme : listAllarmi) {
                    Allarme allarmeCloned = (Allarme)allarme.clone();
                    if (allarmeCloned.getTipo() == null || allarmeCloned.getFiltro() == null || !portaDelegataDaClonare.getNome().equals(allarmeCloned.getFiltro().getNomePorta())) continue;
                    try {
                        allarmeCloned.getFiltro().setNomePorta(nomeNuovaPortaDelegata);
                        String serialId = configIntegrationReader.getNextAlarmInstanceSerialId(allarmeCloned.getTipo());
                        String uniqueName = AllarmiDriverUtils.buildIdAlarm((String)allarmeCloned.getTipo(), (String)serialId);
                        for (int limit = 0; idAllarmiCreate.contains(uniqueName) && limit < 1000; ++limit) {
                            serialId = AllarmiDriverUtils.incrementAlarmInstanceSerialId((String)serialId);
                            uniqueName = AllarmiDriverUtils.buildIdAlarm((String)allarmeCloned.getTipo(), (String)serialId);
                        }
                        idAllarmiCreate.add(uniqueName);
                        allarmeCloned.setNome(uniqueName);
                        if (subscription.getAllarmi() == null) {
                            subscription.setAllarmi(new ArrayList());
                        }
                        subscription.getAllarmi().add(allarmeCloned);
                    }
                    catch (Exception exception) {}
                }
            }
            portaClonata = true;
        } else {
            portaDelegata = new PortaDelegata();
            setDatiServizio = true;
        }
        portaDelegata.setNome(nomeNuovaPortaDelegata);
        portaDelegata.setDescrizione(descrizioneNuovaPortaDelegata);
        IDPortaDelegata idPortaDelegata = SubscriptionUtils.setCommonParameter((PortaDelegata)portaDelegata, (IDSoggetto)idFruitore, (IDServizio)idServizio, (boolean)setDatiServizio, (boolean)portaClonata);
        SubscriptionUtils.setAzioneDelegate((PortaDelegata)portaDelegata, (String)nomePortaDelegante, (String[])azione);
        subscription.setPortaDelegata(portaDelegata);
        MappingFruizionePortaDelegata mappingFruizione = SubscriptionUtils.createMapping((IDSoggetto)idFruitore, (IDServizio)idServizio, (IDPortaDelegata)idPortaDelegata, (String)ruleName, (String)description);
        subscription.setMapping(mappingFruizione);
        return subscription;
    }
}

