/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.archive.abstraction;

import freemarker.template.Template;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.openspcoop2.core.config.constants.PortaApplicativaAzioneIdentificazione;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.protocol.abstraction.Erogazione;
import org.openspcoop2.protocol.abstraction.Soggetto;
import org.openspcoop2.protocol.abstraction.constants.Tipologia;
import org.openspcoop2.protocol.abstraction.template.DatiServizio;
import org.openspcoop2.protocol.abstraction.template.DatiServizioApplicativoErogatore;
import org.openspcoop2.protocol.abstraction.template.DatiSoggetto;
import org.openspcoop2.protocol.abstraction.template.IdSoggetto;
import org.openspcoop2.protocol.abstraction.template.TemplateErogazione;
import org.openspcoop2.protocol.basic.archive.ZIPReadUtils;
import org.openspcoop2.protocol.basic.archive.abstraction.AbstractConverter;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.Archive;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteSpecifica;
import org.openspcoop2.protocol.sdk.archive.ArchiveIdCorrelazione;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaApplicativa;
import org.openspcoop2.protocol.sdk.constants.ArchiveVersion;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.utils.ManagerUtils;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.resources.TemplateUtils;
import org.slf4j.Logger;

public class ErogazioneConverter
extends AbstractConverter {
    public static synchronized ArchiveIdCorrelazione generateIdCorrelazione(String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio, String descrizione) throws ProtocolException {
        String uuid = "Erogazione_" + tipoSoggettoErogatore + "/" + nomeSoggettoErogatore + "_" + tipoServizio + "/" + nomeServizio + "_" + System.currentTimeMillis();
        Utilities.sleep((long)1L);
        ArchiveIdCorrelazione idCorrelazione = new ArchiveIdCorrelazione(uuid);
        Object d = null;
        d = descrizione != null && !"".equals(descrizione) ? descrizione : "Erogazione servizio:" + tipoServizio + "/" + nomeServizio + " erogatore:" + tipoSoggettoErogatore + "/" + nomeSoggettoErogatore;
        idCorrelazione.setDescrizione((String)d);
        return idCorrelazione;
    }

    public ErogazioneConverter(Logger log, ZIPReadUtils zipReader) throws ProtocolException {
        super(log, zipReader);
    }

    public ArchiveIdCorrelazione fillArchive(Archive archive, Erogazione erogazione, TemplateErogazione templateErogazione, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, boolean validationDocuments) throws ProtocolException {
        try {
            byte[] xml;
            int i;
            byte[] xml2;
            IDAccordo idAccordoServizioParteComune = null;
            if (erogazione.getAccordoServizioParteComune().getUri() != null) {
                idAccordoServizioParteComune = this.idAccordoFactory.getIDAccordoFromUri(erogazione.getAccordoServizioParteComune().getUri());
                if (!this.existsAccordoServizioParteComune(archive, registryReader, idAccordoServizioParteComune)) {
                    throw new ProtocolException("Accordo di Servizio Parte Comune [" + idAccordoServizioParteComune.toString() + "] non esistente");
                }
            } else if (erogazione.getAccordoServizioParteComune().getIdAccordo().getSoggetto() != null && erogazione.getAccordoServizioParteComune().getIdAccordo().getVersione() != null) {
                idAccordoServizioParteComune = this.idAccordoFactory.getIDAccordoFromValues(erogazione.getAccordoServizioParteComune().getIdAccordo().getNome(), erogazione.getAccordoServizioParteComune().getIdAccordo().getSoggetto().getTipo(), erogazione.getAccordoServizioParteComune().getIdAccordo().getSoggetto().getNome(), erogazione.getAccordoServizioParteComune().getIdAccordo().getVersione());
                if (!this.existsAccordoServizioParteComune(archive, registryReader, idAccordoServizioParteComune)) {
                    throw new ProtocolException("Accordo di Servizio Parte Comune [" + idAccordoServizioParteComune.toString() + "] non esistente");
                }
            } else {
                idAccordoServizioParteComune = this.findIdAccordoServizioParteComune(archive, registryReader, erogazione.getAccordoServizioParteComune().getIdAccordo().getNome(), erogazione.getAccordoServizioParteComune().getIdAccordo().getSoggetto(), erogazione.getAccordoServizioParteComune().getIdAccordo().getVersione());
            }
            IdSoggetto soggettoErogatore = new IdSoggetto();
            soggettoErogatore.setTipo(erogazione.getSoggettoErogatore().getIdSoggetto().getTipo());
            soggettoErogatore.setNome(erogazione.getSoggettoErogatore().getIdSoggetto().getNome());
            String protocollo = ManagerUtils.getProtocolByOrganizationType(soggettoErogatore.getTipo());
            String nomeServizio = null;
            nomeServizio = erogazione.getServizio() != null && erogazione.getServizio().getNome() != null ? erogazione.getServizio().getNome() : (erogazione.getAccordoServizioParteComune().getServizio() != null ? erogazione.getAccordoServizioParteComune().getServizio() : idAccordoServizioParteComune.getNome());
            String tipoServizio = null;
            tipoServizio = erogazione.getServizio() != null && erogazione.getServizio().getTipo() != null ? erogazione.getServizio().getTipo() : ManagerUtils.getDefaultServiceType(protocollo);
            DatiServizio datiServizio = new DatiServizio();
            datiServizio.setUriAccordoServizioParteComune(this.idAccordoFactory.getUriFromIDAccordo(idAccordoServizioParteComune));
            datiServizio.setPortType(erogazione.getAccordoServizioParteComune().getServizio());
            datiServizio.setTipo(tipoServizio);
            datiServizio.setNome(nomeServizio);
            if (erogazione.getServizio() != null) {
                datiServizio.setEndpoint(erogazione.getServizio().getEndpoint());
                if (erogazione.getServizio().getTipologiaServizio() != null) {
                    datiServizio.setTipologiaServizio(erogazione.getServizio().getTipologiaServizio().getValue());
                }
            }
            datiServizio.setErogatore(soggettoErogatore);
            boolean createApplicativoErogatore = false;
            boolean createPortaApplicativa = false;
            DatiServizioApplicativoErogatore datiApplicativiErogatore = null;
            if (Tipologia.INTERNA.equals(erogazione.getTipologia())) {
                createPortaApplicativa = true;
                if (erogazione.getServizioApplicativo() == null) {
                    throw new ProtocolException("Servizio Applicativo (Nome o DatiApplicativi) non indicati. Questi dati sono obbligatori per una erogazione di tipologia 'interna'");
                }
                datiApplicativiErogatore = new DatiServizioApplicativoErogatore();
                datiApplicativiErogatore.setNome(erogazione.getServizioApplicativo().getNome());
                datiApplicativiErogatore.setNomePortaApplicativa(erogazione.getServizioApplicativo().getNomePortaApplicativa());
                if (datiApplicativiErogatore.getNome() != null) {
                    boolean existsSA = this.existsServizioApplicativo(archive, configIntegrationReader, erogazione.getSoggettoErogatore().getIdSoggetto(), datiApplicativiErogatore.getNome());
                    if (!existsSA) {
                        if (erogazione.getServizioApplicativo().getDatiApplicativi() == null) {
                            throw new ProtocolException("Servizio Applicativo (DatiApplicativi) non indicati. Questi dati sono obbligatori per una erogazione di tipologia 'interna', quando viene indicato un servizio applicativo non esistente");
                        }
                        if (erogazione.getServizioApplicativo().getDatiApplicativi().getEndpoint() == null) {
                            throw new ProtocolException("Servizio Applicativo (Endpoint) non indicato. Questo dato \u00e8 obbligatorio per una erogazione di tipologia 'interna', quando viene indicato un servizio applicativo non esistente");
                        }
                        createApplicativoErogatore = true;
                    } else if (erogazione.getServizioApplicativo().getDatiApplicativi() != null && erogazione.getServizioApplicativo().getDatiApplicativi().getEndpoint() != null) {
                        createApplicativoErogatore = true;
                    }
                } else {
                    if (erogazione.getServizioApplicativo().getDatiApplicativi() == null) {
                        throw new ProtocolException("Servizio Applicativo (Nome o DatiApplicativi) non indicati. Questi dati sono obbligatori per una erogazione di tipologia 'interna'");
                    }
                    if (erogazione.getServizioApplicativo().getDatiApplicativi().getEndpoint() == null) {
                        throw new ProtocolException("Servizio Applicativo (Endpoint) non indicato. Questo dato \u00e8 obbligatorio per una erogazione di tipologia 'interna', quando non viene indicato un servizio applicativo");
                    }
                    createApplicativoErogatore = true;
                }
                if (createApplicativoErogatore) {
                    datiApplicativiErogatore.setEndpoint(erogazione.getServizioApplicativo().getDatiApplicativi().getEndpoint());
                    if (erogazione.getServizioApplicativo().getDatiApplicativi().getCredenzialiBasic() != null) {
                        datiApplicativiErogatore.setUsername(erogazione.getServizioApplicativo().getDatiApplicativi().getCredenzialiBasic().getUsername());
                        datiApplicativiErogatore.setPassword(erogazione.getServizioApplicativo().getDatiApplicativi().getCredenzialiBasic().getPassword());
                    }
                }
            } else if (erogazione.getServizioApplicativo() != null) {
                throw new ProtocolException("Servizio Applicativo (Nomi o DatiApplicativi) indicati in una erogazione di tipologia 'esterna'. Tale tipologia non prevede la configurazione di una PA e di un ServizioApplicativo");
            }
            boolean createSoggetto = false;
            boolean createPdd = false;
            DatiSoggetto datiSoggetto = new DatiSoggetto();
            datiSoggetto.setId(soggettoErogatore);
            if (!this.existsSoggetto(archive, registryReader, erogazione.getSoggettoErogatore().getIdSoggetto())) {
                if (erogazione.getSoggettoErogatore().getNotExistsBehaviour() == null || !erogazione.getSoggettoErogatore().getNotExistsBehaviour().isCreate()) {
                    throw new ProtocolException("Soggetto Erogatore [" + soggettoErogatore.getTipo() + "/" + soggettoErogatore.getNome() + "] non esistente");
                }
                createSoggetto = true;
                datiSoggetto.setEndpoint(erogazione.getSoggettoErogatore().getNotExistsBehaviour().getEndpoint());
                datiSoggetto.setPortaDominio(erogazione.getSoggettoErogatore().getNotExistsBehaviour().getPortaDominio());
                if (datiSoggetto.getPortaDominio() != null) {
                    if (this.existsPdd(archive, registryReader, datiSoggetto.getPortaDominio())) {
                        if (Tipologia.INTERNA.equals(erogazione.getTipologia())) {
                            if (!this.isPddOperativa(archive, registryReader, datiSoggetto.getPortaDominio())) {
                                throw new ProtocolException("La pdd [" + datiSoggetto.getPortaDominio() + "] indicata per il Soggetto Erogatore [" + soggettoErogatore.getTipo() + "/" + soggettoErogatore.getNome() + "] possiede un tipo 'esterno' non compatibile con una erogazione di tipologia 'interna'. Deve essere associata una pdd di tipo 'operativo'");
                            }
                        } else if (this.isPddOperativa(archive, registryReader, datiSoggetto.getPortaDominio())) {
                            throw new ProtocolException("La pdd [" + datiSoggetto.getPortaDominio() + "] indicata per il Soggetto Erogatore [" + soggettoErogatore.getTipo() + "/" + soggettoErogatore.getNome() + "] possiede un tipo 'operativo' non compatibile con una erogazione di tipologia 'esterna'. Deve essere associata una pdd di tipo 'esterno'");
                        }
                    } else {
                        if (Tipologia.INTERNA.equals(erogazione.getTipologia())) {
                            throw new ProtocolException("PdD [" + datiSoggetto.getPortaDominio() + "] non esistente (E' obbligatorio fornire una PdD esistente di tipo 'operativo' se la tipologia di erogazione \u00e8 'interna')");
                        }
                        createPdd = true;
                    }
                } else if (Tipologia.INTERNA.equals(erogazione.getTipologia())) {
                    datiSoggetto.setPortaDominio(this.getPddOperativa(registryReader));
                } else {
                    createPdd = true;
                }
            }
            ArchiveIdCorrelazione idCorrelazione = ErogazioneConverter.generateIdCorrelazione(soggettoErogatore.getTipo(), soggettoErogatore.getNome(), datiServizio.getTipo(), datiServizio.getNome(), erogazione.getDescrizione());
            HashMap<String, Serializable> data = new HashMap<String, Serializable>();
            data.put("servizio", datiServizio);
            data.put("soggetto", datiSoggetto);
            if (datiApplicativiErogatore != null) {
                data.put("applicativoErogatore", datiApplicativiErogatore);
            }
            if (createPdd) {
                xml2 = TemplateUtils.toByteArray((Template)templateErogazione.getTemplatePdd(), data);
                try {
                    this.filler.readPortaDominio(archive, new ByteArrayInputStream(xml2), xml2, "pdd", validationDocuments, idCorrelazione);
                }
                catch (Exception e) {
                    throw new Exception("XmlTemplate[" + new String(xml2) + "]\n" + e.getMessage(), e);
                }
            }
            if (createSoggetto) {
                xml2 = TemplateUtils.toByteArray((Template)templateErogazione.getTemplateSoggetto(), data);
                try {
                    this.filler.readSoggetto(archive, new ByteArrayInputStream(xml2), xml2, "soggetto", soggettoErogatore.getTipo(), soggettoErogatore.getNome(), validationDocuments, idCorrelazione);
                }
                catch (Exception e) {
                    throw new Exception("XmlTemplate[" + new String(xml2) + "]\n" + e.getMessage(), e);
                }
            }
            for (i = 0; i < templateErogazione.getTemplateAccordiParteSpecifica().size(); ++i) {
                xml = TemplateUtils.toByteArray((Template)templateErogazione.getTemplateAccordiParteSpecifica().get(i), data);
                try {
                    String tipo = datiServizio.getTipo();
                    String nome = datiServizio.getNome();
                    this.filler.readAccordoServizioParteSpecifica(archive, new ByteArrayInputStream(xml), xml, "asps_" + i, soggettoErogatore.getTipo(), soggettoErogatore.getNome(), "asps_" + i, tipo, nome, "USE_VERSION_XML_BEAN", validationDocuments, idCorrelazione, ArchiveVersion.V_1, null, null, null);
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("XmlTemplate[" + new String(xml) + "]\n" + e.getMessage(), e);
                }
            }
            if (erogazione.getServizio() != null && erogazione.getServizio().getFruitori() != null && erogazione.getServizio().getFruitori().sizeFruitoreList() > 0) {
                for (i = 0; i < erogazione.getServizio().getFruitori().sizeFruitoreList(); ++i) {
                    Soggetto fruitore = erogazione.getServizio().getFruitori().getFruitore(i);
                    IdSoggetto s = new IdSoggetto();
                    s.setTipo(fruitore.getTipo());
                    s.setNome(fruitore.getNome());
                    data.remove("fruitore");
                    data.put("fruitore", s);
                    byte[] xml3 = TemplateUtils.toByteArray((Template)templateErogazione.getTemplateFruitore(), data);
                    try {
                        this.filler.readAccordoServizioParteSpecifica_Fruitore(archive, new ByteArrayInputStream(xml3), xml3, "fruitore_" + i, "asps_" + i, soggettoErogatore.getTipo(), soggettoErogatore.getNome(), tipoServizio, nomeServizio, "USE_VERSION_XML_BEAN", validationDocuments, idCorrelazione, ArchiveVersion.V_1, null, null);
                        continue;
                    }
                    catch (Exception e) {
                        throw new Exception("XmlTemplate[" + new String(xml3) + "]\n" + e.getMessage(), e);
                    }
                }
            }
            data.remove("fruitore");
            if (createApplicativoErogatore) {
                for (i = 0; i < templateErogazione.getTemplateServiziApplicativi().size(); ++i) {
                    xml = TemplateUtils.toByteArray((Template)templateErogazione.getTemplateServiziApplicativi().get(i), data);
                    try {
                        this.filler.readServizioApplicativo(archive, new ByteArrayInputStream(xml), xml, "sa_" + i, soggettoErogatore.getTipo(), soggettoErogatore.getNome(), validationDocuments, idCorrelazione);
                        continue;
                    }
                    catch (Exception e) {
                        throw new Exception("XmlTemplate[" + new String(xml) + "]\n" + e.getMessage(), e);
                    }
                }
            }
            if (createPortaApplicativa) {
                for (i = 0; i < templateErogazione.getTemplatePorteApplicative().size(); ++i) {
                    xml = TemplateUtils.toByteArray((Template)templateErogazione.getTemplatePorteApplicative().get(i), data);
                    try {
                        this.filler.readPortaApplicativa(archive, new ByteArrayInputStream(xml), xml, "pa_" + i, soggettoErogatore.getTipo(), soggettoErogatore.getNome(), validationDocuments, idCorrelazione);
                        continue;
                    }
                    catch (Exception e) {
                        throw new Exception("XmlTemplate[" + new String(xml) + "]\n" + e.getMessage(), e);
                    }
                }
            }
            for (i = 0; i < archive.getPorteApplicative().size(); ++i) {
                ArchivePortaApplicativa aPA = (ArchivePortaApplicativa)archive.getPorteApplicative().get(i);
                if (!idCorrelazione.equals(aPA.getIdCorrelazione())) continue;
                for (int j = 0; j < archive.getAccordiServizioParteSpecifica().size(); ++j) {
                    ArchiveAccordoServizioParteSpecifica aASPS = (ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(j);
                    if (!idCorrelazione.equals(aASPS.getIdCorrelazione())) continue;
                    MappingErogazionePortaApplicativa mapping = new MappingErogazionePortaApplicativa();
                    mapping.setNome("regola_" + i + "_" + aPA.getIdPortaApplicativa().getNome());
                    mapping.setIdServizio(aASPS.getIdAccordoServizioParteSpecifica());
                    mapping.setIdPortaApplicativa(aPA.getIdPortaApplicativa());
                    mapping.setDefault(aPA.getPortaApplicativa().getAzione() == null || !PortaApplicativaAzioneIdentificazione.DELEGATED_BY.equals((Object)aPA.getPortaApplicativa().getAzione().getIdentificazione()));
                    if (aASPS.getMappingPorteApplicativeAssociate() == null) {
                        aASPS.setMappingPorteApplicativeAssociate(new ArrayList<MappingErogazionePortaApplicativa>());
                    }
                    aASPS.getMappingPorteApplicativeAssociate().add(mapping);
                }
            }
            return idCorrelazione;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }
}

