/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.archive.abstraction;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.protocol.basic.archive.ZIPReadUtils;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.Archive;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioComposto;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteComune;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteSpecifica;
import org.openspcoop2.protocol.sdk.archive.ArchivePdd;
import org.openspcoop2.protocol.sdk.archive.ArchiveServizioApplicativo;
import org.openspcoop2.protocol.sdk.archive.ArchiveSoggetto;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaAccordi;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaServizi;
import org.openspcoop2.protocol.sdk.registry.RegistryException;
import org.openspcoop2.protocol.sdk.registry.RegistryNotFound;
import org.slf4j.Logger;

public abstract class AbstractConverter {
    protected IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
    protected IDServizioFactory idServizioFactory = IDServizioFactory.getInstance();
    protected Logger log;
    protected ZIPReadUtils filler;

    protected AbstractConverter(Logger log, ZIPReadUtils zipReader) throws ProtocolException {
        this.log = log;
        this.filler = zipReader;
    }

    protected boolean existsPdd(Archive archive, IRegistryReader registryReader, String pdd) {
        if (registryReader.existsPortaDominio(pdd)) {
            return true;
        }
        if (archive.getPdd().size() > 0) {
            for (int i = 0; i < archive.getPdd().size(); ++i) {
                String nome = ((ArchivePdd)archive.getPdd().get(i)).getPortaDominio().getNome();
                if (!nome.equals(pdd)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isPddOperativa(Archive archive, IRegistryReader registryReader, String pdd) throws RegistryException {
        if (registryReader.existsPortaDominio(pdd)) {
            try {
                if (registryReader.findIdPorteDominio(true).contains(pdd)) {
                    return true;
                }
            }
            catch (RegistryNotFound notFound) {
                return false;
            }
        }
        return false;
    }

    protected String getPddOperativa(IRegistryReader registryReader) throws RegistryNotFound, RegistryException {
        return registryReader.findIdPorteDominio(true).get(0);
    }

    protected boolean existsSoggetto(Archive archive, IRegistryReader registryReader, org.openspcoop2.protocol.abstraction.Soggetto idSoggetto) {
        if (registryReader.existsSoggetto(new IDSoggetto(idSoggetto.getTipo(), idSoggetto.getNome()))) {
            return true;
        }
        if (archive.getSoggetti().size() > 0) {
            for (int i = 0; i < archive.getSoggetti().size(); ++i) {
                Soggetto soggetto = ((ArchiveSoggetto)archive.getSoggetti().get(i)).getSoggettoRegistro();
                if (soggetto == null || !idSoggetto.getTipo().equals(soggetto.getTipo()) || !idSoggetto.getNome().equals(soggetto.getNome())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean existsServizioApplicativo(Archive archive, IConfigIntegrationReader configIntegrationReader, org.openspcoop2.protocol.abstraction.Soggetto idSoggetto, String nomeServizioApplicativo) {
        IDServizioApplicativo idServizioApplicativo = new IDServizioApplicativo();
        idServizioApplicativo.setIdSoggettoProprietario(new IDSoggetto(idSoggetto.getTipo(), idSoggetto.getNome()));
        idServizioApplicativo.setNome(nomeServizioApplicativo);
        if (configIntegrationReader.existsServizioApplicativo(idServizioApplicativo)) {
            return true;
        }
        if (archive.getServiziApplicativi().size() > 0) {
            for (int i = 0; i < archive.getServiziApplicativi().size(); ++i) {
                ServizioApplicativo sa = ((ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i)).getServizioApplicativo();
                if (sa == null || !idSoggetto.getTipo().equals(sa.getTipoSoggettoProprietario()) || !idSoggetto.getNome().equals(sa.getNomeSoggettoProprietario()) || !nomeServizioApplicativo.equals(sa.getNome())) continue;
                return true;
            }
        }
        return false;
    }

    protected String getTipoCredenzialeServizioApplicativo(Archive archive, IConfigIntegrationReader configIntegrationReader, org.openspcoop2.protocol.abstraction.Soggetto idSoggetto, String nomeServizioApplicativo) throws Exception {
        IDServizioApplicativo idServizioApplicativo = new IDServizioApplicativo();
        idServizioApplicativo.setIdSoggettoProprietario(new IDSoggetto(idSoggetto.getTipo(), idSoggetto.getNome()));
        idServizioApplicativo.setNome(nomeServizioApplicativo);
        ServizioApplicativo sa = null;
        if (configIntegrationReader.existsServizioApplicativo(idServizioApplicativo)) {
            sa = configIntegrationReader.getServizioApplicativo(idServizioApplicativo);
        } else if (archive.getServiziApplicativi().size() > 0) {
            for (int i = 0; i < archive.getServiziApplicativi().size(); ++i) {
                ServizioApplicativo saTmp = ((ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i)).getServizioApplicativo();
                if (saTmp == null || !idSoggetto.getTipo().equals(saTmp.getTipoSoggettoProprietario()) || !idSoggetto.getNome().equals(saTmp.getNomeSoggettoProprietario()) || !nomeServizioApplicativo.equals(saTmp.getNome())) continue;
                sa = saTmp;
                break;
            }
        }
        if (sa == null) {
            throw new Exception("Servizio Applicativo [" + idServizioApplicativo.toString() + "] non esistente");
        }
        if (sa.getInvocazionePorta() == null) {
            throw new Exception("Servizio Applicativo [" + idServizioApplicativo.toString() + "] non possiede delle credenziali di accesso alla PdD (Indicare un applicativo con tipologia 'fruitore')");
        }
        if (sa.getInvocazionePorta().sizeCredenzialiList() <= 0) {
            throw new Exception("Servizio Applicativo [" + idServizioApplicativo.toString() + "] non possiede delle credenziali di accesso alla PdD (Indicare un applicativo con tipologia 'fruitore') con credenziali");
        }
        return sa.getInvocazionePorta().getCredenziali(0).getTipo().getValue();
    }

    protected boolean existsAccordoServizioParteComune(Archive archive, IRegistryReader registryReader, IDAccordo idAccordo) throws RegistryException {
        try {
            registryReader.getAccordoServizioParteComune(idAccordo);
            return true;
        }
        catch (RegistryNotFound registryNotFound) {
            IDAccordo id2;
            if (archive.getAccordiServizioParteComune().size() > 0) {
                for (int i = 0; i < archive.getAccordiServizioParteComune().size(); ++i) {
                    try {
                        id2 = this.idAccordoFactory.getIDAccordoFromAccordo(((ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i)).getAccordoServizioParteComune());
                        if (idAccordo.equals((Object)id2)) {
                            return true;
                        }
                        continue;
                    }
                    catch (Exception id2) {
                        // empty catch block
                    }
                }
            }
            if (archive.getAccordiServizioComposto().size() > 0) {
                for (int i = 0; i < archive.getAccordiServizioComposto().size(); ++i) {
                    try {
                        id2 = this.idAccordoFactory.getIDAccordoFromAccordo(((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i)).getAccordoServizioParteComune());
                        if (idAccordo.equals((Object)id2)) {
                            return true;
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return false;
        }
    }

    protected IDAccordo findIdAccordoServizioParteComune(Archive archive, IRegistryReader registryReader, String nome, org.openspcoop2.protocol.abstraction.Soggetto idSoggetto, Integer versione) throws DriverRegistroServiziException, ProtocolException, RegistryException {
        String uri;
        IDAccordo id3;
        ArrayList<IDAccordo> idAccordi = new ArrayList<IDAccordo>();
        ArrayList<String> uriAccordi = new ArrayList<String>();
        ProtocolFiltroRicercaAccordi filtroAccordi = new ProtocolFiltroRicercaAccordi();
        filtroAccordi.setNome(nome);
        if (versione != null) {
            filtroAccordi.setVersione(versione);
        }
        if (idSoggetto != null) {
            IDSoggetto idSoggettoOp2 = new IDSoggetto(idSoggetto.getTipo(), idSoggetto.getNome());
            filtroAccordi.setSoggetto(idSoggettoOp2);
        }
        try {
            List<IDAccordo> found = registryReader.findIdAccordiServizioParteComune(filtroAccordi);
            if (found.size() > 0) {
                for (IDAccordo id2 : found) {
                    idAccordi.add(id2);
                    uriAccordi.add(this.idAccordoFactory.getUriFromIDAccordo(id2));
                }
            }
        }
        catch (RegistryNotFound found) {
            // empty catch block
        }
        if (archive.getAccordiServizioParteComune().size() > 0) {
            for (int i = 0; i < archive.getAccordiServizioParteComune().size(); ++i) {
                try {
                    id3 = this.idAccordoFactory.getIDAccordoFromAccordo(((ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i)).getAccordoServizioParteComune());
                    if (!nome.equals(id3.getNome()) || versione != null && id3.getVersione() != null && versione.intValue() != id3.getVersione().intValue() || idSoggetto != null && (id3.getSoggettoReferente() == null || idSoggetto.getTipo() != null && !idSoggetto.getTipo().equals(id3.getSoggettoReferente().getTipo()) || idSoggetto.getNome() != null && !idSoggetto.getNome().equals(id3.getSoggettoReferente().getNome())) || uriAccordi.contains(uri = this.idAccordoFactory.getUriFromIDAccordo(id3))) continue;
                    idAccordi.add(id3);
                    uriAccordi.add(uri);
                    continue;
                }
                catch (Exception id3) {
                    // empty catch block
                }
            }
        }
        if (archive.getAccordiServizioComposto().size() > 0) {
            for (int i = 0; i < archive.getAccordiServizioComposto().size(); ++i) {
                try {
                    id3 = this.idAccordoFactory.getIDAccordoFromAccordo(((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i)).getAccordoServizioParteComune());
                    if (!nome.equals(id3.getNome()) || versione != null && id3.getVersione() != null && versione.intValue() != id3.getVersione().intValue() || idSoggetto != null && (id3.getSoggettoReferente() == null || idSoggetto.getTipo() != null && !idSoggetto.getTipo().equals(id3.getSoggettoReferente().getTipo()) || idSoggetto.getNome() != null && !idSoggetto.getNome().equals(id3.getSoggettoReferente().getNome())) || uriAccordi.contains(uri = this.idAccordoFactory.getUriFromIDAccordo(id3))) continue;
                    idAccordi.add(id3);
                    uriAccordi.add(uri);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (idAccordi.size() == 1) {
            return (IDAccordo)idAccordi.get(0);
        }
        String filtro = "Nome[" + nome + "]";
        if (versione != null) {
            filtro = filtro + " Versione[" + versione + "]";
        }
        if (idSoggetto != null) {
            filtro = filtro + " TipoSoggetto[" + idSoggetto.getTipo() + "]";
            filtro = filtro + " NomeSoggetto[" + idSoggetto.getNome() + "]";
        }
        if (idAccordi.size() < 1) {
            throw new ProtocolException("Non risultano accordi di servizio parte comune che corrispondono al seguente criterio di ricerca: " + filtro);
        }
        throw new ProtocolException("Risultano pi\u00f9 accordi di servizio parte comune (" + uriAccordi.size() + ") che corrispondono al seguente criterio di ricerca: " + filtro + "\nGli accordi sono: " + ((Object)uriAccordi).toString());
    }

    protected boolean existsAccordoServizioParteSpecifica(Archive archive, IRegistryReader registryReader, IDServizio idServizio) throws RegistryException {
        try {
            registryReader.getAccordoServizioParteSpecifica(idServizio);
            return true;
        }
        catch (RegistryNotFound registryNotFound) {
            if (archive.getAccordiServizioParteSpecifica().size() > 0) {
                for (int i = 0; i < archive.getAccordiServizioParteSpecifica().size(); ++i) {
                    try {
                        AccordoServizioParteSpecifica asps = ((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i)).getAccordoServizioParteSpecifica();
                        IDServizio id = IDServizioFactory.getInstance().getIDServizioFromValues(asps.getTipo(), asps.getNome(), asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore(), asps.getVersione().intValue());
                        if (idServizio.equals((Object)id)) {
                            return true;
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return false;
        }
    }

    protected AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(Archive archive, IRegistryReader registryReader, IDServizio idServizio) throws RegistryException {
        try {
            return registryReader.getAccordoServizioParteSpecifica(idServizio);
        }
        catch (RegistryNotFound registryNotFound) {
            if (archive.getAccordiServizioParteSpecifica().size() > 0) {
                for (int i = 0; i < archive.getAccordiServizioParteSpecifica().size(); ++i) {
                    try {
                        AccordoServizioParteSpecifica asps = ((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i)).getAccordoServizioParteSpecifica();
                        if (idServizio.getTipo().equals(asps.getTipo()) && idServizio.getNome().equals(asps.getNome()) && idServizio.getVersione().intValue() == asps.getVersione().intValue() && idServizio.getSoggettoErogatore().getTipo().equals(asps.getTipoSoggettoErogatore()) && idServizio.getSoggettoErogatore().getNome().equals(asps.getNomeSoggettoErogatore())) {
                            return asps;
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return null;
        }
    }

    protected IDServizio findIdAccordoServizioParteSpecifica(Archive archive, IRegistryReader registryReader, String nome, String tipo, Integer versione, org.openspcoop2.protocol.abstraction.Soggetto idSoggetto) throws DriverRegistroServiziException, ProtocolException, RegistryException {
        ArrayList<IDServizio> idAccordi = new ArrayList<IDServizio>();
        ArrayList<String> uriAccordi = new ArrayList<String>();
        ProtocolFiltroRicercaServizi filtroAccordi = new ProtocolFiltroRicercaServizi();
        filtroAccordi.setTipoServizio(tipo);
        filtroAccordi.setNomeServizio(nome);
        if (idSoggetto != null) {
            IDSoggetto idSoggettoOp2 = new IDSoggetto(idSoggetto.getTipo(), idSoggetto.getNome());
            filtroAccordi.setSoggettoErogatore(idSoggettoOp2);
        }
        try {
            List<IDServizio> found = registryReader.findIdAccordiServizioParteSpecifica(filtroAccordi);
            if (found.size() > 0) {
                for (IDServizio id : found) {
                    idAccordi.add(id);
                    uriAccordi.add(id.toString());
                }
            }
        }
        catch (RegistryNotFound found) {
            // empty catch block
        }
        if (archive.getAccordiServizioParteSpecifica().size() > 0) {
            for (int i = 0; i < archive.getAccordiServizioParteSpecifica().size(); ++i) {
                try {
                    IDServizio idServizio;
                    String uri;
                    AccordoServizioParteSpecifica asps = ((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i)).getAccordoServizioParteSpecifica();
                    if (tipo != null && !tipo.equals(asps.getTipo()) || !nome.equals(asps.getNome()) || versione != null && versione.intValue() != asps.getVersione().intValue() || idSoggetto == null || !idSoggetto.getTipo().equals(asps.getTipoSoggettoErogatore()) || !idSoggetto.getNome().equals(asps.getNomeSoggettoErogatore()) || uriAccordi.contains(uri = (idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(tipo, nome, new IDSoggetto(idSoggetto.getTipo(), idSoggetto.getNome()), versione.intValue())).toString())) continue;
                    idAccordi.add(idServizio);
                    uriAccordi.add(uri);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (idAccordi.size() == 1) {
            return (IDServizio)idAccordi.get(0);
        }
        String filtro = "Nome[" + nome + "]";
        if (tipo != null) {
            filtro = filtro + " Tipo[" + tipo + "]";
        }
        if (idSoggetto != null) {
            filtro = filtro + " TipoSoggetto[" + idSoggetto.getTipo() + "]";
            filtro = filtro + " NomeSoggetto[" + idSoggetto.getNome() + "]";
        }
        if (idAccordi.size() < 1) {
            throw new ProtocolException("Non risultano accordi di servizio parte specifica che corrispondono al seguente criterio di ricerca: " + filtro);
        }
        throw new ProtocolException("Risultano pi\u00f9 accordi di servizio parte specifica (" + uriAccordi.size() + ") che corrispondono al seguente criterio di ricerca: " + filtro + "\nGli accordi sono: " + ((Object)uriAccordi).toString());
    }
}

