/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.archive;

import jakarta.activation.FileDataSource;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.constants.RuoloPorta;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazione;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazioneRegola;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.RegistroPlugin;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.Soggetto;
import org.openspcoop2.core.config.constants.TipoAutorizzazione;
import org.openspcoop2.core.config.driver.ExtendedInfoManager;
import org.openspcoop2.core.config.utils.ConfigurazionePdDUtils;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.ConfigurazioneGenerale;
import org.openspcoop2.core.controllo_traffico.ConfigurazionePolicy;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.utils.XSDValidator;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Azione;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.Gruppo;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.Scope;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.registry.utils.RegistroServiziUtils;
import org.openspcoop2.protocol.abstraction.Erogazione;
import org.openspcoop2.protocol.abstraction.Fruizione;
import org.openspcoop2.protocol.abstraction.csv.Deserializer;
import org.openspcoop2.protocol.abstraction.template.TemplateErogazione;
import org.openspcoop2.protocol.abstraction.template.TemplateFruizione;
import org.openspcoop2.protocol.abstraction.utils.serializer.JaxbDeserializer;
import org.openspcoop2.protocol.basic.archive.IdentificativoAccordo;
import org.openspcoop2.protocol.basic.archive.IdentificativoDocumento;
import org.openspcoop2.protocol.basic.archive.IdentificativoProprietaProtocollo;
import org.openspcoop2.protocol.basic.archive.IdentificativoServizioApplicativo;
import org.openspcoop2.protocol.basic.archive.ProprietarioProprietaProtocollo;
import org.openspcoop2.protocol.basic.archive.ZIPUtils;
import org.openspcoop2.protocol.basic.archive.abstraction.ErogazioneConverter;
import org.openspcoop2.protocol.basic.archive.abstraction.FruizioneConverter;
import org.openspcoop2.protocol.information_missing.Openspcoop2;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.Archive;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoCooperazione;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioComposto;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteComune;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteSpecifica;
import org.openspcoop2.protocol.sdk.archive.ArchiveActivePolicy;
import org.openspcoop2.protocol.sdk.archive.ArchiveAllarme;
import org.openspcoop2.protocol.sdk.archive.ArchiveAttributeAuthority;
import org.openspcoop2.protocol.sdk.archive.ArchiveConfigurationPolicy;
import org.openspcoop2.protocol.sdk.archive.ArchiveFruitore;
import org.openspcoop2.protocol.sdk.archive.ArchiveGruppo;
import org.openspcoop2.protocol.sdk.archive.ArchiveIdCorrelazione;
import org.openspcoop2.protocol.sdk.archive.ArchivePdd;
import org.openspcoop2.protocol.sdk.archive.ArchivePluginArchivio;
import org.openspcoop2.protocol.sdk.archive.ArchivePluginClasse;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaApplicativa;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaDelegata;
import org.openspcoop2.protocol.sdk.archive.ArchiveRuolo;
import org.openspcoop2.protocol.sdk.archive.ArchiveScope;
import org.openspcoop2.protocol.sdk.archive.ArchiveServizioApplicativo;
import org.openspcoop2.protocol.sdk.archive.ArchiveSoggetto;
import org.openspcoop2.protocol.sdk.archive.ArchiveTokenPolicy;
import org.openspcoop2.protocol.sdk.archive.ArchiveUrlInvocazioneRegola;
import org.openspcoop2.protocol.sdk.archive.MapPlaceholder;
import org.openspcoop2.protocol.sdk.constants.ArchiveVersion;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.io.ZipUtilities;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.slf4j.Logger;

public class ZIPReadUtils {
    protected Logger log = null;
    protected IRegistryReader registryReader;
    protected IConfigIntegrationReader configIntegrationReader;
    protected org.openspcoop2.core.registry.utils.serializer.JaxbDeserializer jaxbRegistryDeserializer = null;
    protected org.openspcoop2.core.config.utils.serializer.JaxbDeserializer jaxbConfigDeserializer = null;
    protected org.openspcoop2.core.plugins.utils.serializer.JaxbDeserializer jaxbPluginDeserializer = null;
    protected org.openspcoop2.core.controllo_traffico.utils.serializer.JaxbDeserializer jaxbControlloTrafficoDeserializer = null;
    protected org.openspcoop2.core.allarmi.utils.serializer.JaxbDeserializer jaxbAllarmeDeserializer = null;
    protected org.openspcoop2.protocol.information_missing.utils.serializer.JaxbDeserializer jaxbInformationMissingDeserializer = null;
    private JaxbDeserializer jaxbAbstractionDeserializer = null;
    private ErogazioneConverter _erogazioneConverter = null;
    private FruizioneConverter _fruizioneConverter = null;
    private TemplateErogazione templateErogazione;
    private List<Erogazione> erogazioni;
    private List<byte[]> csvErogazioni;
    private byte[] csvFormatErogazione;
    private byte[] csvMappingErogazione;
    private byte[] csvTemplateErogazione;
    private TemplateFruizione templateFruizione;
    private List<Fruizione> fruizioni;
    private List<byte[]> csvFruizioni;
    private byte[] csvFormatFruizione;
    private byte[] csvMappingFruizione;
    private byte[] csvTemplateFruizione;
    public static final String USE_VERSION_XML_BEAN = "USE_VERSION_XML_BEAN";

    private ErogazioneConverter getErogazioneConverter() throws ProtocolException {
        if (this._erogazioneConverter == null) {
            this._initializeConverter();
        }
        return this._erogazioneConverter;
    }

    private FruizioneConverter getFruizioneConverter() throws ProtocolException {
        if (this._fruizioneConverter == null) {
            this._initializeConverter();
        }
        return this._fruizioneConverter;
    }

    private synchronized void _initializeConverter() throws ProtocolException {
        if (this._erogazioneConverter == null) {
            this._erogazioneConverter = new ErogazioneConverter(this.log, this);
        }
        if (this._fruizioneConverter == null) {
            this._fruizioneConverter = new FruizioneConverter(this.log, this);
        }
    }

    private synchronized void initializeErogazioni() throws ProtocolException {
        if (this.templateErogazione == null) {
            this.templateErogazione = new TemplateErogazione();
            this.erogazioni = new ArrayList<Erogazione>();
            this.csvErogazioni = new ArrayList<byte[]>();
        }
    }

    private synchronized void initializeFruizioni() throws ProtocolException {
        if (this.templateFruizione == null) {
            this.templateFruizione = new TemplateFruizione();
            this.fruizioni = new ArrayList<Fruizione>();
            this.csvFruizioni = new ArrayList<byte[]>();
        }
    }

    public ZIPReadUtils(Logger log, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader) throws ProtocolException {
        this.log = log;
        this.registryReader = registryReader;
        this.configIntegrationReader = configIntegrationReader;
        this.jaxbRegistryDeserializer = new org.openspcoop2.core.registry.utils.serializer.JaxbDeserializer();
        this.jaxbConfigDeserializer = new org.openspcoop2.core.config.utils.serializer.JaxbDeserializer();
        this.jaxbPluginDeserializer = new org.openspcoop2.core.plugins.utils.serializer.JaxbDeserializer();
        this.jaxbControlloTrafficoDeserializer = new org.openspcoop2.core.controllo_traffico.utils.serializer.JaxbDeserializer();
        this.jaxbAllarmeDeserializer = new org.openspcoop2.core.allarmi.utils.serializer.JaxbDeserializer();
        this.jaxbInformationMissingDeserializer = new org.openspcoop2.protocol.information_missing.utils.serializer.JaxbDeserializer();
        this.jaxbAbstractionDeserializer = new JaxbDeserializer();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Archive getArchive(byte[] zip, MapPlaceholder placeholder, boolean validationDocuments) throws ProtocolException {
        File tmp = null;
        FileOutputStream fout = null;
        try {
            tmp = FileSystemUtilities.createTempFile((String)"openspcoop", (String)".zip");
            fout = new FileOutputStream(tmp);
            fout.write(zip);
            fout.flush();
            fout.close();
            Archive archive = this.getArchive(tmp, placeholder, validationDocuments);
            return archive;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
                if (tmp != null && tmp.delete()) {
                    // empty if block
                }
            }
            catch (Exception exception) {}
        }
    }

    public Archive getArchive(String fileName, MapPlaceholder placeholder, boolean validationDocuments) throws ProtocolException {
        return this.getArchive(new File(fileName), placeholder, validationDocuments);
    }

    public Archive getArchive(File zip, MapPlaceholder placeholder, boolean validationDocuments) throws ProtocolException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zip);
            Archive archive = this.getArchive(zipFile, placeholder, validationDocuments);
            return archive;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Archive getArchive(InputStream m, MapPlaceholder placeholder, boolean validationDocuments) throws ProtocolException {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            byte[] read = new byte[1024];
            int letti = 0;
            while ((letti = m.read(read)) >= 0) {
                bout.write(read, 0, letti);
            }
            bout.flush();
            bout.close();
            m.close();
            Archive archive = this.getArchive(bout.toByteArray(), placeholder, validationDocuments);
            return archive;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
        finally {
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Archive getArchive(ZipFile zip, MapPlaceholder placeholder, boolean validationDocuments) throws ProtocolException {
        try {
            Archive archivio = new Archive();
            if (placeholder == null) {
                placeholder = new MapPlaceholder();
            }
            ArchiveIdCorrelazione idCorrelazione = new ArchiveIdCorrelazione("@PackageOpenSPCoop@");
            idCorrelazione.setDescrizione(zip.getName());
            ArchiveVersion archiveVersion = ArchiveVersion.V_UNDEFINED;
            String openspcoopVersion = null;
            ExtendedInfoManager extendedInfoManager = ExtendedInfoManager.getInstance();
            HashMap<String, PortaDelegata> mapKeyForExtendedInfoPortaDelegata = new HashMap<String, PortaDelegata>();
            boolean existsExtendsConfigForPortaDelegata = extendedInfoManager.newInstanceExtendedInfoPortaDelegata() != null;
            HashMap<String, PortaApplicativa> mapKeyForExtendedInfoPortaApplicativa = new HashMap<String, PortaApplicativa>();
            boolean existsExtendsConfigForPortaApplicativa = extendedInfoManager.newInstanceExtendedInfoPortaApplicativa() != null;
            HashMap<String, IDSoggetto> mapKeySoggetti = new HashMap<String, IDSoggetto>();
            HashMap<String, IDSoggetto> mapKeyFruitori = new HashMap<String, IDSoggetto>();
            HashMap<String, IdentificativoAccordo> mapKeyAccordi = new HashMap<String, IdentificativoAccordo>();
            HashMap<String, IdentificativoDocumento> mapKeyDocumenti = new HashMap<String, IdentificativoDocumento>();
            HashMap<String, IdentificativoProprietaProtocollo> mapKeyProtocolProperties = new HashMap<String, IdentificativoProprietaProtocollo>();
            HashMap<String, IdentificativoServizioApplicativo> mapKeyServiziApplicativi = new HashMap<String, IdentificativoServizioApplicativo>();
            String rootDir = null;
            Iterator it = ZipUtilities.entries((ZipFile)zip, (boolean)true);
            while (it.hasNext()) {
                ZipEntry zipEntry = (ZipEntry)it.next();
                String entryName = ZipUtilities.operativeSystemConversion((String)zipEntry.getName());
                if (rootDir == null) {
                    rootDir = ZipUtilities.getRootDir((String)entryName);
                }
                if (zipEntry.isDirectory()) continue;
                FileDataSource fds = new FileDataSource(entryName);
                String nome = fds.getName();
                String tipo = nome.substring(nome.lastIndexOf(".") + 1, nome.length());
                tipo = tipo.toUpperCase();
                InputStream inputStream = zip.getInputStream(zipEntry);
                byte[] content = Utilities.getAsByteArray((InputStream)inputStream);
                ByteArrayInputStream bin = null;
                try {
                    byte[] xml;
                    if (entryName.equals(rootDir + "archive.info")) {
                        archiveVersion = ArchiveVersion.toArchiveVersion(content);
                        openspcoopVersion = ArchiveVersion.toProductVersion(content);
                        this.log.debug("Version [" + String.valueOf((Object)archiveVersion) + "] product[" + openspcoopVersion + "]");
                        continue;
                    }
                    if (entryName.startsWith(rootDir + "configurazione" + File.separatorChar)) {
                        xml = placeholder.replace(content);
                        if (entryName.contains(File.separatorChar + "extended" + File.separatorChar)) {
                            this.readConfigurazioneExtended(archivio, bin, xml, entryName, validationDocuments, extendedInfoManager);
                            continue;
                        }
                        bin = new ByteArrayInputStream(xml);
                        this.readConfigurazione(archivio, bin, xml, entryName, validationDocuments);
                        continue;
                    }
                    if (entryName.startsWith(rootDir + "configUrlInvocazione" + File.separatorChar)) {
                        xml = placeholder.replace(content);
                        if (entryName.contains(File.separatorChar + "regole" + File.separatorChar)) {
                            bin = new ByteArrayInputStream(xml);
                            this.readUrlInvocazioneRegola(archivio, bin, xml, entryName, validationDocuments, idCorrelazione);
                            continue;
                        }
                        bin = new ByteArrayInputStream(xml);
                        this.readUrlInvocazione(archivio, bin, xml, entryName, validationDocuments);
                        continue;
                    }
                    if (entryName.startsWith(rootDir + "controlloTraffico" + File.separatorChar)) {
                        xml = placeholder.replace(content);
                        if (entryName.contains(File.separatorChar + "configPolicies" + File.separatorChar)) {
                            bin = new ByteArrayInputStream(xml);
                            this.readControlloTraffico_configurazionePolicy(archivio, bin, xml, entryName, validationDocuments, idCorrelazione);
                            continue;
                        }
                        if (entryName.contains(File.separatorChar + "policies" + File.separatorChar)) {
                            bin = new ByteArrayInputStream(xml);
                            this.readControlloTraffico_attivazionePolicy(archivio, bin, xml, entryName, validationDocuments, idCorrelazione);
                            continue;
                        }
                        bin = new ByteArrayInputStream(xml);
                        this.readControlloTraffico_configurazione(archivio, bin, xml, entryName, validationDocuments);
                        continue;
                    }
                    if (entryName.startsWith(rootDir + "allarmi" + File.separatorChar)) {
                        xml = placeholder.replace(content);
                        bin = new ByteArrayInputStream(xml);
                        this.readAllarme(archivio, bin, xml, entryName, validationDocuments, idCorrelazione);
                        continue;
                    }
                    if (entryName.startsWith(rootDir + "tokenPolicy" + File.separatorChar)) {
                        xml = placeholder.replace(content);
                        if (entryName.contains(File.separatorChar + "validation" + File.separatorChar)) {
                            bin = new ByteArrayInputStream(xml);
                            this.readTokenValidationPolicy(archivio, bin, xml, entryName, validationDocuments, idCorrelazione);
                            continue;
                        }
                        if (entryName.contains(File.separatorChar + "retrieve" + File.separatorChar)) {
                            bin = new ByteArrayInputStream(xml);
                            this.readTokenRetrievePolicy(archivio, bin, xml, entryName, validationDocuments, idCorrelazione);
                            continue;
                        }
                        throw new ProtocolException("Elemento [" + entryName + "] non atteso");
                    }
                    if (entryName.startsWith(rootDir + "attributeAuthority" + File.separatorChar)) {
                        xml = placeholder.replace(content);
                        if (entryName.contains(File.separatorChar + "retrieve" + File.separatorChar)) {
                            bin = new ByteArrayInputStream(xml);
                            this.readAttributeAuthority(archivio, bin, xml, entryName, validationDocuments, idCorrelazione);
                            continue;
                        }
                        throw new ProtocolException("Elemento [" + entryName + "] non atteso");
                    }
                    if (entryName.startsWith(rootDir + "plugins" + File.separatorChar)) {
                        xml = placeholder.replace(content);
                        if (entryName.contains(File.separatorChar + "classi" + File.separatorChar)) {
                            bin = new ByteArrayInputStream(xml);
                            this.readPluginClasse(archivio, bin, xml, entryName, validationDocuments, idCorrelazione);
                            continue;
                        }
                        if (entryName.contains(File.separatorChar + "archivi" + File.separatorChar)) {
                            bin = new ByteArrayInputStream(xml);
                            this.readPluginArchivio(archivio, bin, xml, entryName, validationDocuments, idCorrelazione);
                            continue;
                        }
                        throw new ProtocolException("Elemento [" + entryName + "] non atteso");
                    }
                    if (entryName.startsWith(rootDir + "porteDominio" + File.separatorChar)) {
                        xml = placeholder.replace(content);
                        bin = new ByteArrayInputStream(xml);
                        this.readPortaDominio(archivio, bin, xml, entryName, validationDocuments, idCorrelazione);
                        continue;
                    }
                    if (entryName.startsWith(rootDir + "gruppi" + File.separatorChar)) {
                        xml = placeholder.replace(content);
                        bin = new ByteArrayInputStream(xml);
                        this.readGruppo(archivio, bin, xml, entryName, validationDocuments, idCorrelazione);
                        continue;
                    }
                    if (entryName.startsWith(rootDir + "ruoli" + File.separatorChar)) {
                        xml = placeholder.replace(content);
                        bin = new ByteArrayInputStream(xml);
                        this.readRuolo(archivio, bin, xml, entryName, validationDocuments, idCorrelazione);
                        continue;
                    }
                    if (entryName.startsWith(rootDir + "scope" + File.separatorChar)) {
                        xml = placeholder.replace(content);
                        bin = new ByteArrayInputStream(xml);
                        this.readScope(archivio, bin, xml, entryName, validationDocuments, idCorrelazione);
                        continue;
                    }
                    if (entryName.equals(rootDir + "informationMissing.xml")) {
                        xml = placeholder.replace(content);
                        bin = new ByteArrayInputStream(xml);
                        this.readInformationMissing(archivio, bin, xml, entryName, validationDocuments);
                        continue;
                    }
                    if (entryName.startsWith(rootDir + "soggetti" + File.separatorChar)) {
                        String key;
                        String key2;
                        String nomeFile;
                        IDSoggetto id;
                        xml = null;
                        xml = entryName.endsWith(".raw") ? content : placeholder.replace(content);
                        bin = new ByteArrayInputStream(xml);
                        String name = entryName.substring((rootDir + "soggetti" + File.separatorChar).length());
                        if (!name.contains("" + File.separatorChar)) {
                            throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [soggetti] deve essere presenta una ulteriore directory contenente la struttura <tipo>_<nome> che descrive il soggetto e ulteriori file e/o directory che definiscono gli elementi del soggetto");
                        }
                        String tipoNomeSoggetto = name.substring(0, name.indexOf(File.separatorChar));
                        if (tipoNomeSoggetto == null || "".equals(tipoNomeSoggetto) || !tipoNomeSoggetto.contains("_")) {
                            throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [soggetti] deve essere presenta una ulteriore directory contenente la struttura <tipo>_<nome> che descrive il soggetto. Il nome utilizzato per la directory non e' conforme alla struttura attesa <tipo>_<nome>");
                        }
                        tipoNomeSoggetto = tipoNomeSoggetto.trim();
                        String tipoSoggetto = null;
                        String nomeSoggetto = null;
                        if (!tipoNomeSoggetto.equals("_")) {
                            if (tipoNomeSoggetto.startsWith("_")) {
                                nomeSoggetto = tipoNomeSoggetto.substring(1);
                            } else if (tipoNomeSoggetto.endsWith("_")) {
                                tipoSoggetto = tipoNomeSoggetto.substring(0, tipoNomeSoggetto.length() - 1);
                            } else {
                                tipoSoggetto = tipoNomeSoggetto.split("_")[0];
                                nomeSoggetto = tipoNomeSoggetto.split("_")[1];
                                if (tipoSoggetto == null || "".equals(tipoSoggetto)) {
                                    throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [soggetti] deve essere presenta una ulteriore directory contenente la struttura <tipo>_<nome> che descrive il soggetto. Il nome utilizzato per la directory non e' conforme alla struttura attesa <tipo>_<nome>: tipo non identificato");
                                }
                                if (nomeSoggetto == null || "".equals(nomeSoggetto)) {
                                    throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [soggetti] deve essere presenta una ulteriore directory contenente la struttura <tipo>_<nome> che descrive il soggetto. Il nome utilizzato per la directory non e' conforme alla struttura attesa <tipo>_<nome>: nome non identificato");
                                }
                            }
                        }
                        if (mapKeySoggetti.containsKey(tipoNomeSoggetto) && (id = (IDSoggetto)mapKeySoggetti.get(tipoNomeSoggetto)) != null) {
                            tipoSoggetto = id.getTipo();
                            nomeSoggetto = id.getNome();
                        }
                        if ((nomeFile = name.substring(tipoNomeSoggetto.length() + 1, name.length())) == null) {
                            throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [soggetti] deve essere presenta una ulteriore directory contenente la struttura <tipo>_<nome> che descrive il soggetto e ulteriori file e/o directory che definiscono gli elementi del soggetto: non sono stati trovati ulteriori file");
                        }
                        if (!nomeFile.contains("" + File.separatorChar)) {
                            if ("_datiIdentificativiSoggetto.id".equals(nomeFile)) {
                                String s = null;
                                try {
                                    s = new String(xml);
                                    if (s.endsWith("\n") && s.length() > 1) {
                                        s = s.substring(0, s.length() - 1);
                                    }
                                    IDSoggetto idSoggetto = IDSoggetto.toIDSoggetto((String)s);
                                    mapKeySoggetti.put(tipoNomeSoggetto, idSoggetto);
                                    continue;
                                }
                                catch (Exception e) {
                                    throw new ProtocolException("Elemento [" + entryName + "] contiene degli identificativi del soggetto (" + s + ") non validi rispetto al pattern atteso (tipo/nome): " + e.getMessage(), e);
                                }
                            }
                            this.readSoggetto(archivio, bin, xml, entryName, tipoSoggetto, nomeSoggetto, validationDocuments, idCorrelazione);
                            continue;
                        }
                        if (nomeFile.startsWith("proprietaProtocollo" + File.separatorChar)) {
                            org.openspcoop2.core.registry.Soggetto soggettoRegistroServizi = null;
                            key2 = ArchiveSoggetto.buildKey(tipoSoggetto, nomeSoggetto);
                            if (!archivio.getSoggetti().containsKey(key2)) {
                                throw new ProtocolException("Elemento [" + entryName + "] errato. Non risulta la definizione del soggetto [" + tipoSoggetto + "/" + nomeSoggetto + "]");
                            }
                            soggettoRegistroServizi = ((ArchiveSoggetto)archivio.getSoggetti().get(key2)).getSoggettoRegistro();
                            ArrayList<ProtocolProperty> listPP = new ArrayList<ProtocolProperty>();
                            if (soggettoRegistroServizi.sizeProtocolPropertyList() > 0) {
                                for (ProtocolProperty protocolProperty : soggettoRegistroServizi.getProtocolPropertyList()) {
                                    if (protocolProperty.getTipoProprietario() == null) {
                                        protocolProperty.setTipoProprietario(ProprietariProtocolProperty.SOGGETTO.name());
                                    }
                                    listPP.add(protocolProperty);
                                }
                            }
                            this.processProtocolProperty(nomeFile, archiveVersion, entryName, xml, ProprietarioProprietaProtocollo.SOGGETTO, tipoSoggetto, nomeSoggetto, null, null, null, null, mapKeyProtocolProperties, listPP, null);
                            continue;
                        }
                        if (nomeFile.startsWith("serviziApplicativi" + File.separatorChar)) {
                            String nomeFileServizioApplicativo = nomeFile.substring(("serviziApplicativi" + File.separatorChar).length());
                            if (!nomeFileServizioApplicativo.contains("" + File.separatorChar)) {
                                ServizioApplicativo sa = this.readServizioApplicativo(archivio, bin, xml, entryName, tipoSoggetto, nomeSoggetto, validationDocuments, idCorrelazione);
                                IdentificativoServizioApplicativo identificativoServizioApplicativo = new IdentificativoServizioApplicativo();
                                identificativoServizioApplicativo.nome = sa.getNome();
                                identificativoServizioApplicativo.tipoSoggetto = tipoSoggetto;
                                identificativoServizioApplicativo.nomeSoggetto = nomeSoggetto;
                                String nomeFileServizioApplicativoSenzaEstensioni = nomeFileServizioApplicativo.substring(0, nomeFileServizioApplicativo.indexOf(".xml"));
                                mapKeyServiziApplicativi.put(nomeFileServizioApplicativoSenzaEstensioni, identificativoServizioApplicativo);
                                continue;
                            }
                            String nomeFileServizioApplicativoSenzaEstensioni = nomeFileServizioApplicativo.substring(0, nomeFileServizioApplicativo.indexOf("" + File.separatorChar));
                            String nomeServizioApplicativo = null;
                            if (!mapKeyServiziApplicativi.containsKey(nomeFileServizioApplicativoSenzaEstensioni)) {
                                throw new ProtocolException("Elemento [" + entryName + "] errato. Non risulta la definizione dell'applicativo con nome file '" + nomeFileServizioApplicativoSenzaEstensioni + "' (soggetto " + tipoSoggetto + "/" + nomeSoggetto + ")");
                            }
                            nomeServizioApplicativo = ((IdentificativoServizioApplicativo)mapKeyServiziApplicativi.get((Object)nomeFileServizioApplicativoSenzaEstensioni)).nome;
                            String nomeFileSenzaServizioApplicativo = nomeFileServizioApplicativo.substring(nomeFileServizioApplicativo.indexOf(File.separatorChar) + 1);
                            this.readProprietaServizioApplicativo(archivio, content, entryName, tipoSoggetto, nomeSoggetto, nomeServizioApplicativo, nomeFileSenzaServizioApplicativo, archiveVersion, mapKeyProtocolProperties);
                            continue;
                        }
                        if (nomeFile.startsWith("porteDelegate" + File.separatorChar)) {
                            if (nomeFile.contains(File.separatorChar + "extended" + File.separatorChar)) {
                                key = this.getKeyPortaForExtendedInfo(tipoNomeSoggetto, nomeFile);
                                PortaDelegata pd = (PortaDelegata)mapKeyForExtendedInfoPortaDelegata.get(key);
                                this.readPortaDelegataExtended(pd, bin, xml, entryName, validationDocuments, extendedInfoManager);
                                continue;
                            }
                            PortaDelegata pd = this.readPortaDelegata(archivio, bin, xml, entryName, tipoSoggetto, nomeSoggetto, validationDocuments, idCorrelazione);
                            if (!existsExtendsConfigForPortaDelegata) continue;
                            key2 = this.getKeyPortaForExtendedInfo(tipoNomeSoggetto, nomeFile);
                            mapKeyForExtendedInfoPortaDelegata.put(key2, pd);
                            continue;
                        }
                        if (nomeFile.startsWith("porteApplicative" + File.separatorChar)) {
                            if (nomeFile.contains(File.separatorChar + "extended" + File.separatorChar)) {
                                key = this.getKeyPortaForExtendedInfo(tipoNomeSoggetto, nomeFile);
                                PortaApplicativa pa = (PortaApplicativa)mapKeyForExtendedInfoPortaApplicativa.get(key);
                                this.readPortaApplicativaExtended(pa, bin, xml, entryName, validationDocuments, extendedInfoManager);
                                continue;
                            }
                            PortaApplicativa pa = this.readPortaApplicativa(archivio, bin, xml, entryName, tipoSoggetto, nomeSoggetto, validationDocuments, idCorrelazione);
                            if (!existsExtendsConfigForPortaApplicativa) continue;
                            key2 = this.getKeyPortaForExtendedInfo(tipoNomeSoggetto, nomeFile);
                            mapKeyForExtendedInfoPortaApplicativa.put(key2, pa);
                            continue;
                        }
                        if (nomeFile.startsWith("accordiServizioParteComune" + File.separatorChar) || nomeFile.startsWith("accordiServizioComposto" + File.separatorChar) || nomeFile.startsWith("accordiServizioParteSpecifica" + File.separatorChar) || nomeFile.startsWith("accordiCooperazione" + File.separatorChar)) {
                            String nomeFileAccordo = null;
                            String directoryAccordo = null;
                            if (nomeFile.startsWith("accordiServizioParteComune" + File.separatorChar)) {
                                directoryAccordo = "accordiServizioParteComune";
                            } else if (nomeFile.startsWith("accordiServizioComposto" + File.separatorChar)) {
                                directoryAccordo = "accordiServizioComposto";
                            } else if (nomeFile.startsWith("accordiServizioParteSpecifica" + File.separatorChar)) {
                                directoryAccordo = "accordiServizioParteSpecifica";
                            } else if (nomeFile.startsWith("accordiCooperazione" + File.separatorChar)) {
                                directoryAccordo = "accordiCooperazione";
                            }
                            nomeFileAccordo = nomeFile.substring((directoryAccordo + File.separatorChar).length());
                            if (!nomeFileAccordo.contains("" + File.separatorChar)) {
                                throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [" + directoryAccordo + "] deve essere presenta una ulteriore directory contenente la struttura <nome>[_<versione>] che descrive l'accordo e ulteriori file e/o directory che definiscono gli elementi dell'accordo");
                            }
                            String nomeVersioneAccordo = nomeFileAccordo.substring(0, nomeFileAccordo.indexOf(File.separatorChar));
                            if (nomeVersioneAccordo == null || "".equals(nomeVersioneAccordo) || "_".equals(nomeVersioneAccordo) || nomeVersioneAccordo.startsWith("_") || nomeVersioneAccordo.endsWith("_")) {
                                throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [" + directoryAccordo + "] deve essere presenta una ulteriore directory contenente la struttura <nome>[_<versione>] che descrive l'accordo. Il nome utilizzato per la directory non e' conforme alla struttura attesa <nome>[_<versione>]");
                            }
                            String nomeFileSenzaAccordo = nomeFileAccordo.substring((nomeVersioneAccordo = nomeVersioneAccordo.trim()).length() + 1, nomeFileAccordo.length());
                            if (nomeFileSenzaAccordo == null) {
                                throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [" + directoryAccordo + "] deve essere presenta una ulteriore directory contenente la struttura <nome>[_<versione> che descrive l'accordo e ulteriori file e/o directory che definiscono gli elementi dell'accordo: non sono stati trovati ulteriori file");
                            }
                            if (nomeFile.startsWith("accordiServizioParteComune" + File.separatorChar) || nomeFile.startsWith("accordiServizioComposto" + File.separatorChar) || nomeFile.startsWith("accordiCooperazione" + File.separatorChar)) {
                                String versioneAccordo = null;
                                String nomeAccordo = null;
                                boolean findIdAccordo = false;
                                if (ArchiveVersion.V_UNDEFINED.equals((Object)archiveVersion)) {
                                    if (nomeVersioneAccordo.contains("_")) {
                                        nomeAccordo = nomeVersioneAccordo.split("_")[0];
                                        versioneAccordo = nomeVersioneAccordo.split("_")[1];
                                        if (versioneAccordo == null || "".equals(versioneAccordo)) {
                                            throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [" + directoryAccordo + "] deve essere presenta una ulteriore directory contenente la struttura <nome>[_<versione>] che descrive l'accordo. Il nome utilizzato per la directory non e' conforme alla struttura attesa <nome>[_<versione>]: versione non identificata");
                                        }
                                    } else {
                                        nomeAccordo = nomeVersioneAccordo;
                                    }
                                    if (nomeAccordo == null || "".equals(nomeAccordo)) {
                                        throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [" + directoryAccordo + "] deve essere presenta una ulteriore directory contenente la struttura <nome>[_<versione>] che descrive l'accordo. Il nome utilizzato per la directory non e' conforme alla struttura attesa <nome>[_<versione>]: nome non identificato");
                                    }
                                } else {
                                    IdentificativoAccordo idAccordo = null;
                                    String keyAccordo = this.getKeyAccordo(tipoSoggetto, nomeSoggetto, nomeVersioneAccordo, nomeFile);
                                    if (nomeFileSenzaAccordo.equals("accordo.id")) {
                                        String identificativo = this.readLineId(xml);
                                        if (identificativo.contains(" ")) {
                                            nomeAccordo = identificativo.split(" ")[0];
                                            versioneAccordo = identificativo.split(" ")[1];
                                            if (versioneAccordo == null || "".equals(versioneAccordo)) {
                                                throw new ProtocolException("Elemento [" + entryName + "] errato. Il Contenuto [" + identificativo + "] non \u00e8 corretto, deve essere presente una struttura '<nome> <versione>' che descrive l'identificativo dell'accordo: versione non identificata");
                                            }
                                        } else {
                                            nomeAccordo = identificativo;
                                        }
                                        if (nomeAccordo == null || "".equals(nomeAccordo)) {
                                            throw new ProtocolException("Elemento [" + entryName + "] errato. Il Contenuto [" + identificativo + "] non \u00e8 corretto, deve essere presenta una struttura '<nome>[ <versione>]' che descrive identificativo dell'accordo: nome non identificato");
                                        }
                                        idAccordo = new IdentificativoAccordo();
                                        idAccordo.nome = nomeAccordo;
                                        idAccordo.versione = versioneAccordo;
                                        mapKeyAccordi.put(keyAccordo, idAccordo);
                                        findIdAccordo = true;
                                    } else {
                                        idAccordo = (IdentificativoAccordo)mapKeyAccordi.get(keyAccordo);
                                        if (idAccordo == null) {
                                            throw new ProtocolException("Elemento [" + entryName + "] errato. Non \u00e8 stato trovato precedentemente il file [accordo.id] contenente l'identificativo dell'accordo");
                                        }
                                        nomeAccordo = idAccordo.nome;
                                        versioneAccordo = idAccordo.versione;
                                    }
                                }
                                if (findIdAccordo) continue;
                                if (nomeFile.startsWith("accordiServizioParteComune" + File.separatorChar)) {
                                    this.readAccordoServizioParteComune(archivio, bin, xml, entryName, tipoSoggetto, nomeSoggetto, nomeFileSenzaAccordo, nomeAccordo, versioneAccordo, false, validationDocuments, idCorrelazione, archiveVersion, mapKeyDocumenti, mapKeyProtocolProperties);
                                    continue;
                                }
                                if (nomeFile.startsWith("accordiServizioComposto" + File.separatorChar)) {
                                    this.readAccordoServizioParteComune(archivio, bin, xml, entryName, tipoSoggetto, nomeSoggetto, nomeFileSenzaAccordo, nomeAccordo, versioneAccordo, true, validationDocuments, idCorrelazione, archiveVersion, mapKeyDocumenti, mapKeyProtocolProperties);
                                    continue;
                                }
                                if (!nomeFile.startsWith("accordiCooperazione" + File.separatorChar)) continue;
                                this.readAccordoCooperazione(archivio, bin, xml, entryName, tipoSoggetto, nomeSoggetto, nomeFileSenzaAccordo, nomeAccordo, versioneAccordo, validationDocuments, idCorrelazione, archiveVersion, mapKeyDocumenti, mapKeyProtocolProperties);
                                continue;
                            }
                            if (!nomeFile.startsWith("accordiServizioParteSpecifica" + File.separatorChar)) continue;
                            String versioneServizio = null;
                            String nomeServizio = null;
                            String tipoServizio = null;
                            boolean findIdAccordo = false;
                            if (ArchiveVersion.V_UNDEFINED.equals((Object)archiveVersion)) {
                                if (!nomeVersioneAccordo.contains("_")) {
                                    throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [" + directoryAccordo + "] deve essere presenta una ulteriore directory contenente la struttura tipo_nome[_versione] che descrive l'accordo. Il nome utilizzato per la directory non e' conforme alla struttura attesa tipo_nome[_versione]");
                                }
                                int indexType = nomeVersioneAccordo.indexOf("_");
                                if (indexType <= 0) {
                                    throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [" + directoryAccordo + "] deve essere presenta una ulteriore directory contenente la struttura tipo_nome[_versione] che descrive l'accordo. Il nome utilizzato per la directory non e' conforme alla struttura attesa tipo_nome[_versione]: tipo non trovato (index:" + indexType + ")");
                                }
                                tipoServizio = nomeVersioneAccordo.substring(0, indexType);
                                if (indexType == nomeVersioneAccordo.length()) {
                                    throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [" + directoryAccordo + "] deve essere presenta una ulteriore directory contenente la struttura tipo_nome[_versione] che descrive l'accordo. Il nome utilizzato per la directory non e' conforme alla struttura attesa tipo_nome[_versione]: nome e versione non trovati");
                                }
                                String _nomeVersione = nomeVersioneAccordo.substring(indexType, nomeVersioneAccordo.length());
                                if (_nomeVersione == null) {
                                    throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [" + directoryAccordo + "] deve essere presenta una ulteriore directory contenente la struttura tipo_nome[_versione] che descrive l'accordo. Il nome utilizzato per la directory non e' conforme alla struttura attesa tipo_nome[_versione]: nome e versione non trovati");
                                }
                                if (!_nomeVersione.contains("_")) {
                                    nomeServizio = _nomeVersione;
                                } else {
                                    int indexVersione = _nomeVersione.lastIndexOf("_");
                                    if (indexVersione <= 0) {
                                        throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [" + directoryAccordo + "] deve essere presenta una ulteriore directory contenente la struttura tipo_nome[_versione] che descrive l'accordo. Il nome utilizzato per la directory non e' conforme alla struttura attesa tipo_nome[_versione]: versione non trovata (index:" + indexVersione + ")");
                                    }
                                    nomeServizio = _nomeVersione.substring(0, indexVersione);
                                    if (indexVersione == _nomeVersione.length()) {
                                        throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [" + directoryAccordo + "] deve essere presenta una ulteriore directory contenente la struttura tipo_nome[_versione] che descrive l'accordo. Il nome utilizzato per la directory non e' conforme alla struttura attesa tipo_nome[_versione]: versione non trovata dopo aver localizzato il nome");
                                    }
                                    versioneServizio = _nomeVersione.substring(indexVersione, _nomeVersione.length());
                                    if (versioneServizio == null) {
                                        throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [" + directoryAccordo + "] deve essere presenta una ulteriore directory contenente la struttura tipo_nome[_versione] che descrive l'accordo. Il nome utilizzato per la directory non e' conforme alla struttura attesa tipo_nome[_versione]: versione non trovata");
                                    }
                                }
                            } else {
                                IdentificativoAccordo idAccordo = null;
                                String keyAccordo = this.getKeyAccordo(tipoSoggetto, nomeSoggetto, nomeVersioneAccordo, nomeFile);
                                if (nomeFileSenzaAccordo.equals("accordo.id")) {
                                    String identificativo = this.readLineId(xml);
                                    if (!identificativo.contains(" ")) {
                                        throw new ProtocolException("Elemento [" + entryName + "] errato. Il Contenuto [" + identificativo + "] non \u00e8 corretto, deve essere presente una struttura '<tipo> <nome> <versione>' che descrive l'identificativo dell'accordo: ' ' non trovato");
                                    }
                                    String[] tmp = identificativo.split(" ");
                                    if (tmp.length > 2) {
                                        tipoServizio = identificativo.split(" ")[0];
                                        nomeServizio = identificativo.split(" ")[1];
                                        versioneServizio = identificativo.split(" ")[2];
                                        if (versioneServizio == null || "".equals(versioneServizio)) {
                                            throw new ProtocolException("Elemento [" + entryName + "] errato. Il Contenuto [" + identificativo + "] non \u00e8 corretto, deve essere presente una struttura '<tipo> <nome> <versione>' che descrive l'identificativo dell'accordo: versione non identificata");
                                        }
                                    } else {
                                        tipoServizio = identificativo.split(" ")[0];
                                        nomeServizio = identificativo.split(" ")[1];
                                    }
                                    if (tipoServizio == null || "".equals(tipoServizio)) {
                                        throw new ProtocolException("Elemento [" + entryName + "] errato. Il Contenuto [" + identificativo + "] non \u00e8 corretto, deve essere presenta una struttura '<tipo> <nome> [<versione>]' che descrive identificativo dell'accordo: tipo non identificato");
                                    }
                                    if (nomeServizio == null || "".equals(nomeServizio)) {
                                        throw new ProtocolException("Elemento [" + entryName + "] errato. Il Contenuto [" + identificativo + "] non \u00e8 corretto, deve essere presenta una struttura '<tipo> <nome> [<versione>]' che descrive identificativo dell'accordo: nome non identificato");
                                    }
                                    idAccordo = new IdentificativoAccordo();
                                    idAccordo.tipo = tipoServizio;
                                    idAccordo.nome = nomeServizio;
                                    idAccordo.versione = versioneServizio;
                                    mapKeyAccordi.put(keyAccordo, idAccordo);
                                    findIdAccordo = true;
                                } else {
                                    idAccordo = (IdentificativoAccordo)mapKeyAccordi.get(keyAccordo);
                                    if (idAccordo == null) {
                                        throw new ProtocolException("Elemento [" + entryName + "] errato. Non \u00e8 stato trovato precedentemente il file [accordo.id] contenente l'identificativo dell'accordo");
                                    }
                                    tipoServizio = idAccordo.tipo;
                                    nomeServizio = idAccordo.nome;
                                    versioneServizio = idAccordo.versione;
                                }
                            }
                            if (findIdAccordo) continue;
                            this.readAccordoServizioParteSpecifica(archivio, bin, xml, entryName, tipoSoggetto, nomeSoggetto, nomeFileSenzaAccordo, tipoServizio, nomeServizio, versioneServizio, validationDocuments, idCorrelazione, archiveVersion, mapKeyDocumenti, mapKeyProtocolProperties, mapKeyFruitori);
                            continue;
                        }
                        throw new ProtocolException("Elemento [" + entryName + "] non atteso");
                    }
                    bin = new ByteArrayInputStream(content);
                    this.readExternalArchive(rootDir, archivio, bin, content, entryName, validationDocuments);
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (bin == null) continue;
                        bin.close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.finalizeArchive(archivio, validationDocuments);
            return archivio;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    private String getKeyAccordo(String tipoSoggetto, String nomeSoggetto, String nomeVersioneAccordo, String nomeFile) {
        StringBuilder bf = new StringBuilder();
        bf.append(tipoSoggetto == null ? "" : tipoSoggetto);
        bf.append("_");
        bf.append(nomeSoggetto == null ? "" : nomeSoggetto);
        bf.append("_");
        bf.append(nomeVersioneAccordo == null ? "" : nomeVersioneAccordo);
        bf.append("_");
        if (nomeFile.contains("accordiServizioParteComune" + File.separatorChar)) {
            bf.append("accordiServizioParteComune");
        } else if (nomeFile.contains("accordiServizioComposto" + File.separatorChar)) {
            bf.append("accordiServizioComposto");
        } else if (nomeFile.contains("accordiServizioParteSpecifica" + File.separatorChar)) {
            bf.append("accordiServizioParteSpecifica");
        } else if (nomeFile.contains("accordiCooperazione" + File.separatorChar)) {
            bf.append("accordiCooperazione");
        }
        return bf.toString();
    }

    private String getKeyDocumento(String tipoSoggetto, String nomeSoggetto, String nomeAccordo, String versioneAccordo, String nomeFile, String nomeDocumento) {
        StringBuilder bf = new StringBuilder();
        bf.append(this.getKeyAccordo(tipoSoggetto, nomeSoggetto, (nomeAccordo == null ? "" : nomeAccordo) + (versioneAccordo == null ? "" : versioneAccordo), nomeFile));
        bf.append("_");
        if (nomeFile.contains("allegati" + File.separatorChar)) {
            bf.append("allegati");
        } else if (nomeFile.contains("specificheSemiformali" + File.separatorChar)) {
            bf.append("specificheSemiformali");
        } else if (nomeFile.contains("specificheLivelliServizio" + File.separatorChar)) {
            bf.append("specificheLivelliServizio");
        } else if (nomeFile.contains("specificheSicurezza" + File.separatorChar)) {
            bf.append("specificheSicurezza");
        } else if (nomeFile.contains("specificheCoordinamento" + File.separatorChar)) {
            bf.append("specificheCoordinamento");
        }
        bf.append("_");
        bf.append(nomeDocumento);
        return bf.toString();
    }

    private String getKeyProtocolProperty(String tipoSoggetto, String nomeSoggetto, String nomeAccordo, String versioneAccordo, String tipoSoggettoFruitore, String nomeSoggettoFruitore, ProprietarioProprietaProtocollo proprietario, String nomeDocumento) {
        StringBuilder bf = new StringBuilder();
        bf.append(proprietario.name());
        bf.append("_");
        if (ProprietarioProprietaProtocollo.ACCORDO_COOPERAZIONE.equals((Object)proprietario) || ProprietarioProprietaProtocollo.ACCORDO_SERVIZIO_PARTE_COMUNE.equals((Object)proprietario) || ProprietarioProprietaProtocollo.ACCORDO_SERVIZIO_PARTE_SPECIFICA.equals((Object)proprietario) || ProprietarioProprietaProtocollo.FRUITORE.equals((Object)proprietario)) {
            bf.append(tipoSoggetto == null ? "" : tipoSoggetto);
            bf.append("_");
            bf.append(nomeSoggetto == null ? "" : nomeSoggetto);
            bf.append("_");
            String nomeVersioneAccordo = (nomeAccordo == null ? "" : nomeAccordo) + (versioneAccordo == null ? "" : versioneAccordo);
            bf.append(nomeVersioneAccordo);
        } else if (ProprietarioProprietaProtocollo.SOGGETTO.equals((Object)proprietario) || ProprietarioProprietaProtocollo.SERVIZIO_APPLICATIVO.equals((Object)proprietario)) {
            bf.append(tipoSoggetto == null ? "" : tipoSoggetto);
            bf.append("_");
            bf.append(nomeSoggetto == null ? "" : nomeSoggetto);
        }
        bf.append("_");
        if (ProprietarioProprietaProtocollo.FRUITORE.equals((Object)proprietario)) {
            bf.append(tipoSoggetto == null ? "" : tipoSoggettoFruitore);
            bf.append("_");
            bf.append(nomeSoggetto == null ? "" : nomeSoggettoFruitore);
            bf.append("_");
        }
        if (ProprietarioProprietaProtocollo.SERVIZIO_APPLICATIVO.equals((Object)proprietario)) {
            bf.append(nomeAccordo == null ? "" : nomeAccordo);
            bf.append("_");
        }
        bf.append("_");
        bf.append(nomeDocumento);
        return bf.toString();
    }

    private String getKeyPortaForExtendedInfo(String tipoNomeSoggetto, String nomeFile) {
        String nomePortaSuFileSystem = nomeFile.substring(nomeFile.lastIndexOf(File.separatorChar));
        if (nomePortaSuFileSystem.endsWith(".xml")) {
            nomePortaSuFileSystem = nomePortaSuFileSystem.substring(0, nomePortaSuFileSystem.length() - 4);
        } else if (nomePortaSuFileSystem.endsWith(".bin") && (nomePortaSuFileSystem = nomeFile.substring(0, nomeFile.lastIndexOf(File.separatorChar))).contains("" + File.separatorChar)) {
            nomePortaSuFileSystem = nomePortaSuFileSystem.substring(nomePortaSuFileSystem.lastIndexOf(File.separatorChar));
        }
        String key = tipoNomeSoggetto + nomePortaSuFileSystem;
        return key;
    }

    public void finalizeArchive(Archive archivio, boolean validationDocuments) throws ProtocolException {
        Object deserializer;
        if (this.csvErogazioni != null) {
            deserializer = new Deserializer(validationDocuments, this.log);
            for (byte[] erogazioneCsv : this.csvErogazioni) {
                this.erogazioni.addAll(((Deserializer)deserializer).toErogazione(this.csvTemplateErogazione, this.csvFormatErogazione, this.csvMappingErogazione, erogazioneCsv));
            }
        }
        if (this.erogazioni != null) {
            for (Erogazione erogazione : this.erogazioni) {
                this.getErogazioneConverter().fillArchive(archivio, erogazione, this.templateErogazione, this.registryReader, this.configIntegrationReader, validationDocuments);
            }
        }
        if (this.csvFruizioni != null) {
            deserializer = new Deserializer(validationDocuments, this.log);
            for (byte[] fruizioneCsv : this.csvFruizioni) {
                this.fruizioni.addAll(((Deserializer)deserializer).toFruizione(this.csvTemplateFruizione, this.csvFormatFruizione, this.csvMappingFruizione, fruizioneCsv));
            }
        }
        if (this.fruizioni != null) {
            for (Fruizione fruizione : this.fruizioni) {
                this.getFruizioneConverter().fillArchive(archivio, fruizione, this.templateFruizione, this.registryReader, this.configIntegrationReader, validationDocuments);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readExternalArchive(String rootDir, Archive archivio, InputStream bin, byte[] xml, String entryName, boolean validationDocuments) throws ProtocolException {
        if (entryName.startsWith(rootDir + "erogazioni" + File.separatorChar)) {
            String name = entryName.substring((rootDir + "erogazioni" + File.separatorChar).length());
            if (name.contains("" + File.separatorChar)) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [erogazioni] non devono essere presenti ulteriori directory");
            }
            if (this.templateErogazione == null) {
                this.initializeErogazioni();
            }
            if (name.equals("templates.zip")) {
                this.templateErogazione.updateTemplates(xml);
                return;
            } else if (name.equals("csvFormat.properties")) {
                this.csvFormatErogazione = xml;
                return;
            } else if (name.equals("csvMapping.properties")) {
                this.csvMappingErogazione = xml;
                return;
            } else if (name.equals("csvTemplate.ftl")) {
                this.csvTemplateErogazione = xml;
                return;
            } else if (name.endsWith("xml")) {
                try {
                    if (validationDocuments) {
                        org.openspcoop2.protocol.abstraction.utils.XSDValidator.getXSDValidator(this.log).valida(bin);
                    }
                    Erogazione erogazione = this.jaxbAbstractionDeserializer.readErogazione(xml);
                    this.erogazioni.add(erogazione);
                    return;
                }
                catch (Exception eDeserializer) {
                    String xmlString = this.toStringXmlElementForErrorMessage(xml);
                    throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (erogazione) non valida rispetto allo schema (Abstraction): " + eDeserializer.getMessage(), eDeserializer);
                }
            } else {
                if (!name.endsWith("csv")) throw new ProtocolException("Elemento [" + entryName + "] non atteso. Sono supportati solamente i formati 'xml' e 'csv' oltre a poter fornire i seguente files: 'templates.zip','csvFormat.properties','csvMapping.properties','csvTemplate.ftl'");
                this.csvErogazioni.add(xml);
            }
            return;
        } else {
            if (!entryName.startsWith(rootDir + "fruizioni" + File.separatorChar)) throw new ProtocolException("Elemento [" + entryName + "] non atteso");
            String name = entryName.substring((rootDir + "fruizioni" + File.separatorChar).length());
            if (name.contains("" + File.separatorChar)) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [fruizioni] non devono essere presenti ulteriori directory");
            }
            if (this.templateFruizione == null) {
                this.initializeFruizioni();
            }
            if (name.equals("templates.zip")) {
                this.templateFruizione.updateTemplates(xml);
                return;
            } else if (name.equals("csvFormat.properties")) {
                this.csvFormatFruizione = xml;
                return;
            } else if (name.equals("csvMapping.properties")) {
                this.csvMappingFruizione = xml;
                return;
            } else if (name.equals("csvTemplate.ftl")) {
                this.csvTemplateFruizione = xml;
                return;
            } else if (name.endsWith("xml")) {
                try {
                    if (validationDocuments) {
                        org.openspcoop2.protocol.abstraction.utils.XSDValidator.getXSDValidator(this.log).valida(bin);
                    }
                    Fruizione fruizione = this.jaxbAbstractionDeserializer.readFruizione(xml);
                    this.fruizioni.add(fruizione);
                    return;
                }
                catch (Exception eDeserializer) {
                    String xmlString = this.toStringXmlElementForErrorMessage(xml);
                    throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (fruizione) non valida rispetto allo schema (Abstraction): " + eDeserializer.getMessage(), eDeserializer);
                }
            } else {
                if (!name.endsWith("csv")) throw new ProtocolException("Elemento [" + entryName + "] non atteso. Sono supportati solamente i formati 'xml' e 'csv' oltre a poter fornire i seguenti files: 'templates.zip','csvFormat.properties','csvMapping.properties','csvTemplate.ftl'");
                this.csvFruizioni.add(xml);
            }
        }
    }

    public void readConfigurazione(Archive archivio, InputStream bin, byte[] xml, String entryName, boolean validationDocuments) throws ProtocolException {
        try {
            if (validationDocuments) {
                org.openspcoop2.core.config.utils.XSDValidator.getXSDValidator((Logger)this.log).valida(bin);
            }
            Configurazione configurazione = this.jaxbConfigDeserializer.readConfigurazione(xml);
            if (archivio.getConfigurazionePdD() != null) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di una configurazione della pdd");
            }
            archivio.setConfigurazionePdD(configurazione);
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (configurazione) non valida rispetto allo schema (ConfigurazionePdD): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readConfigurazioneExtended(Archive archivio, InputStream bin, byte[] xml, String entryName, boolean validationDocuments, ExtendedInfoManager extendedInfoManager) throws ProtocolException {
        try {
            if (archivio.getConfigurazionePdD() == null) {
                archivio.setConfigurazionePdD(new Configurazione());
            }
            Object o = extendedInfoManager.newInstanceExtendedInfoConfigurazione().deserialize(this.log, (Object)archivio.getConfigurazionePdD(), xml);
            archivio.getConfigurazionePdD().addExtendedInfo(o);
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (configurazione-extended) non valida: " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readControlloTraffico_configurazione(Archive archivio, InputStream bin, byte[] xml, String entryName, boolean validationDocuments) throws ProtocolException {
        try {
            if (validationDocuments) {
                org.openspcoop2.core.controllo_traffico.utils.XSDValidator.getXSDValidator((Logger)this.log).valida(bin);
            }
            ConfigurazioneGenerale configurazione = this.jaxbControlloTrafficoDeserializer.readConfigurazioneGenerale(xml);
            if (archivio.getControlloTraffico_configurazione() != null) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di una configurazione di controllo del traffico");
            }
            archivio.setControlloTraffico_configurazione(configurazione);
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (configurazione) non valida rispetto allo schema (ControlloTraffico): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readControlloTraffico_configurazionePolicy(Archive archivio, InputStream bin, byte[] xml, String entryName, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        try {
            if (validationDocuments) {
                org.openspcoop2.core.controllo_traffico.utils.XSDValidator.getXSDValidator((Logger)this.log).valida(bin);
            }
            ConfigurazionePolicy policy = this.jaxbControlloTrafficoDeserializer.readConfigurazionePolicy(xml);
            String key = ArchiveConfigurationPolicy.buildKey(policy.getIdPolicy());
            if (archivio.getControlloTraffico_configurationPolicies().containsKey(key)) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di una configurazione di policy con key [" + key + "]");
            }
            archivio.getControlloTraffico_configurationPolicies().add(key, new ArchiveConfigurationPolicy(policy, idCorrelazione));
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (configurazione-policy) non valida rispetto allo schema (ControlloTraffico): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readControlloTraffico_attivazionePolicy(Archive archivio, InputStream bin, byte[] xml, String entryName, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        try {
            if (validationDocuments) {
                org.openspcoop2.core.controllo_traffico.utils.XSDValidator.getXSDValidator((Logger)this.log).valida(bin);
            }
            AttivazionePolicy policy = this.jaxbControlloTrafficoDeserializer.readAttivazionePolicy(xml);
            RuoloPolicy ruoloPorta = null;
            String nomePorta = null;
            if (policy != null && policy.getFiltro() != null) {
                ruoloPorta = policy.getFiltro().getRuoloPorta();
                nomePorta = policy.getFiltro().getNomePorta();
            }
            if (policy == null) {
                throw new ProtocolException("Policy is null");
            }
            String key = ArchiveActivePolicy.buildKey(ruoloPorta, nomePorta, policy.getAlias());
            if (archivio.getControlloTraffico_activePolicies().containsKey(key)) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere pi\u00f9 di un'attivazione di policy con key [" + key + "]");
            }
            archivio.getControlloTraffico_activePolicies().add(key, new ArchiveActivePolicy(policy, idCorrelazione));
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (attivazione-policy) non valida rispetto allo schema (ControlloTraffico): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readAllarme(Archive archivio, InputStream bin, byte[] xml, String entryName, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        try {
            if (validationDocuments) {
                org.openspcoop2.core.allarmi.utils.XSDValidator.getXSDValidator((Logger)this.log).valida(bin);
            }
            Allarme allarme = this.jaxbAllarmeDeserializer.readAllarme(xml);
            RuoloPorta ruoloPorta = null;
            String nomePorta = null;
            if (allarme != null && allarme.getFiltro() != null) {
                ruoloPorta = allarme.getFiltro().getRuoloPorta();
                nomePorta = allarme.getFiltro().getNomePorta();
            }
            if (allarme == null) {
                throw new ProtocolException("Allarme is null");
            }
            String key = ArchiveAllarme.buildKey(ruoloPorta, nomePorta, allarme.getAlias());
            if (archivio.getAllarmi().containsKey(key)) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere pi\u00f9 di un'allarme con key [" + key + "]");
            }
            archivio.getAllarmi().add(key, new ArchiveAllarme(allarme, idCorrelazione));
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (allarme) non valida rispetto allo schema (Allarmi): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readTokenValidationPolicy(Archive archivio, InputStream bin, byte[] xml, String entryName, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        try {
            if (validationDocuments) {
                org.openspcoop2.core.config.utils.XSDValidator.getXSDValidator((Logger)this.log).valida(bin);
            }
            GenericProperties policy = this.jaxbConfigDeserializer.readGenericProperties(xml);
            String key = ArchiveTokenPolicy.buildKey(policy.getTipo(), policy.getNome());
            if (archivio.getToken_validation_policies().containsKey(key)) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di una policy di token validation con key [" + key + "]");
            }
            archivio.getToken_validation_policies().add(key, new ArchiveTokenPolicy(policy, idCorrelazione));
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (token-policy) non valida rispetto allo schema (ConfigurazionePdD): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readTokenRetrievePolicy(Archive archivio, InputStream bin, byte[] xml, String entryName, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        try {
            if (validationDocuments) {
                org.openspcoop2.core.config.utils.XSDValidator.getXSDValidator((Logger)this.log).valida(bin);
            }
            GenericProperties policy = this.jaxbConfigDeserializer.readGenericProperties(xml);
            String key = ArchiveTokenPolicy.buildKey(policy.getTipo(), policy.getNome());
            if (archivio.getToken_retrieve_policies().containsKey(key)) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di una policy di token retrieve con key [" + key + "]");
            }
            archivio.getToken_retrieve_policies().add(key, new ArchiveTokenPolicy(policy, idCorrelazione));
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (token-policy) non valida rispetto allo schema (ConfigurazionePdD): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readAttributeAuthority(Archive archivio, InputStream bin, byte[] xml, String entryName, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        try {
            if (validationDocuments) {
                org.openspcoop2.core.config.utils.XSDValidator.getXSDValidator((Logger)this.log).valida(bin);
            }
            GenericProperties policy = this.jaxbConfigDeserializer.readGenericProperties(xml);
            String key = ArchiveAttributeAuthority.buildKey(policy.getTipo(), policy.getNome());
            if (archivio.getAttributeAuthorities().containsKey(key)) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di una attribute authority con key [" + key + "]");
            }
            archivio.getAttributeAuthorities().add(key, new ArchiveAttributeAuthority(policy, idCorrelazione));
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (attribute authority) non valida rispetto allo schema (ConfigurazionePdD): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readPluginClasse(Archive archivio, InputStream bin, byte[] xml, String entryName, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        try {
            if (validationDocuments) {
                XSDValidator.getXSDValidator((Logger)this.log).valida(bin);
            }
            Plugin plugin = this.jaxbPluginDeserializer.readPlugin(xml);
            String key = ArchivePluginClasse.buildKey(plugin.getTipoPlugin(), plugin.getTipo());
            if (archivio.getPlugin_classi().containsKey(key)) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di un plugin con key [" + key + "]");
            }
            archivio.getPlugin_classi().add(key, new ArchivePluginClasse(plugin, idCorrelazione));
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (plugin-classe) non valida rispetto allo schema (Plugins): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readPluginArchivio(Archive archivio, InputStream bin, byte[] xml, String entryName, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        try {
            if (validationDocuments) {
                org.openspcoop2.core.config.utils.XSDValidator.getXSDValidator((Logger)this.log).valida(bin);
            }
            RegistroPlugin plugin = this.jaxbConfigDeserializer.readRegistroPlugin(xml);
            String key = ArchivePluginArchivio.buildKey(plugin.getNome());
            if (archivio.getPlugin_archivi().containsKey(key)) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di un archivio plugin con key [" + key + "]");
            }
            archivio.getPlugin_archivi().add(key, new ArchivePluginArchivio(plugin, idCorrelazione));
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (plugin-archivio) non valida rispetto allo schema (ConfigurazionePdD): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readUrlInvocazioneRegola(Archive archivio, InputStream bin, byte[] xml, String entryName, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        try {
            if (validationDocuments) {
                org.openspcoop2.core.config.utils.XSDValidator.getXSDValidator((Logger)this.log).valida(bin);
            }
            ConfigurazioneUrlInvocazioneRegola regola = this.jaxbConfigDeserializer.readConfigurazioneUrlInvocazioneRegola(xml);
            String key = ArchiveUrlInvocazioneRegola.buildKey(regola.getNome());
            if (archivio.getConfigurazionePdD_urlInvocazione_regole().containsKey(key)) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di una regola proxy pass con key [" + key + "]");
            }
            archivio.getConfigurazionePdD_urlInvocazione_regole().add(key, new ArchiveUrlInvocazioneRegola(regola, idCorrelazione));
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (regola proxy-pass) non valida rispetto allo schema (ConfigurazionePdD): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readUrlInvocazione(Archive archivio, InputStream bin, byte[] xml, String entryName, boolean validationDocuments) throws ProtocolException {
        try {
            if (validationDocuments) {
                org.openspcoop2.core.config.utils.XSDValidator.getXSDValidator((Logger)this.log).valida(bin);
            }
            ConfigurazioneUrlInvocazione configurazioneUrlInvocazione = this.jaxbConfigDeserializer.readConfigurazioneUrlInvocazione(xml);
            if (archivio.getConfigurazionePdD_urlInvocazione() != null) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di una configurazione della url di invocazione");
            }
            archivio.setConfigurazionePdD_urlInvocazione(configurazioneUrlInvocazione);
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (configurazione url invocazione) non valida rispetto allo schema (ConfigurazionePdD): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readPortaDominio(Archive archivio, InputStream bin, byte[] xml, String entryName, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        try {
            if (validationDocuments) {
                org.openspcoop2.core.registry.utils.XSDValidator.getXSDValidator((Logger)this.log).valida(bin);
            }
            PortaDominio pdd = this.jaxbRegistryDeserializer.readPortaDominio(xml);
            String key = ArchivePdd.buildKey(pdd.getNome());
            if (archivio.getPdd().containsKey(key)) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di una pdd con key [" + key + "]");
            }
            archivio.getPdd().add(key, new ArchivePdd(pdd, idCorrelazione));
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (porta-dominio) non valida rispetto allo schema (RegistroServizi): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readGruppo(Archive archivio, InputStream bin, byte[] xml, String entryName, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        try {
            if (validationDocuments) {
                org.openspcoop2.core.registry.utils.XSDValidator.getXSDValidator((Logger)this.log).valida(bin);
            }
            Gruppo gruppo = this.jaxbRegistryDeserializer.readGruppo(xml);
            String key = ArchiveGruppo.buildKey(gruppo.getNome());
            if (archivio.getGruppi().containsKey(key)) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di un gruppo con key [" + key + "]");
            }
            archivio.getGruppi().add(key, new ArchiveGruppo(gruppo, idCorrelazione));
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (gruppo) non valida rispetto allo schema (RegistroServizi): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readRuolo(Archive archivio, InputStream bin, byte[] xml, String entryName, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        try {
            if (validationDocuments) {
                org.openspcoop2.core.registry.utils.XSDValidator.getXSDValidator((Logger)this.log).valida(bin);
            }
            Ruolo ruolo = this.jaxbRegistryDeserializer.readRuolo(xml);
            String key = ArchiveRuolo.buildKey(ruolo.getNome());
            if (archivio.getRuoli().containsKey(key)) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di un ruolo con key [" + key + "]");
            }
            archivio.getRuoli().add(key, new ArchiveRuolo(ruolo, idCorrelazione));
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (ruolo) non valida rispetto allo schema (RegistroServizi): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readScope(Archive archivio, InputStream bin, byte[] xml, String entryName, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        try {
            if (validationDocuments) {
                org.openspcoop2.core.registry.utils.XSDValidator.getXSDValidator((Logger)this.log).valida(bin);
            }
            Scope scope = this.jaxbRegistryDeserializer.readScope(xml);
            String key = ArchiveScope.buildKey(scope.getNome());
            if (archivio.getScope().containsKey(key)) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di uno scope con key [" + key + "]");
            }
            archivio.getScope().add(key, new ArchiveScope(scope, idCorrelazione));
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (scope) non valida rispetto allo schema (RegistroServizi): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readInformationMissing(Archive archivio, InputStream bin, byte[] xml, String entryName, boolean validationDocuments) throws ProtocolException {
        try {
            Openspcoop2 informationMissingOp2 = null;
            if (archivio.getInformationMissing() != null) {
                informationMissingOp2 = archivio.getInformationMissing();
            }
            if (informationMissingOp2 != null) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Una definizione xml di informationMissing e' presente piu' di una volta");
            }
            if (validationDocuments) {
                org.openspcoop2.protocol.information_missing.utils.XSDValidator.getXSDValidator(this.log).valida(bin);
            }
            informationMissingOp2 = this.jaxbInformationMissingDeserializer.readOpenspcoop2(xml);
            archivio.setInformationMissing(informationMissingOp2);
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (informationMissing) non valida rispetto allo schema informationMissing.xsd: " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readSoggetto(Archive archivio, InputStream bin, byte[] xml, String entryName, String tipoSoggetto, String nomeSoggetto, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        boolean registro = false;
        String schema = null;
        if (RegistroServiziUtils.isRegistroServizi((byte[])xml, (String)"soggetto")) {
            registro = true;
            schema = "RegistroServizi";
        } else if (ConfigurazionePdDUtils.isConfigurazionePdD((byte[])xml, (String)"soggetto")) {
            registro = false;
            schema = "ConfigurazionePdD";
        } else {
            throw new ProtocolException("Elemento [" + entryName + "] errato. Attesa una definizione del soggetto che contenga informazioni di registro (namespace: http://www.openspcoop2.org/core/registry) o di configurazione (http://www.openspcoop2.org/core/config)");
        }
        try {
            if (tipoSoggetto == null || nomeSoggetto == null) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Non \u00e8 possibile fornire una definizione di soggetto all'interna di una directory che non definisce il tipo o il nome del soggetto");
            }
            org.openspcoop2.core.registry.Soggetto soggettoRegistroServizi = null;
            Soggetto soggettoConfigurazione = null;
            String key = ArchiveSoggetto.buildKey(tipoSoggetto, nomeSoggetto);
            if (archivio.getSoggetti().containsKey(key)) {
                ArchiveSoggetto archiveSoggetto = (ArchiveSoggetto)archivio.getSoggetti().remove(key);
                soggettoRegistroServizi = archiveSoggetto.getSoggettoRegistro();
                soggettoConfigurazione = archiveSoggetto.getSoggettoConfigurazione();
            }
            if (registro) {
                if (soggettoRegistroServizi != null) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. Una definizione xml del soggetto con tipologia (" + schema + ") e' presente piu' di una volta");
                }
                if (validationDocuments) {
                    org.openspcoop2.core.registry.utils.XSDValidator.getXSDValidator((Logger)this.log).valida(bin);
                }
                if (!tipoSoggetto.equals((soggettoRegistroServizi = this.jaxbRegistryDeserializer.readSoggetto(xml)).getTipo())) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml del soggetto (" + schema + ") contiene un tipo [" + soggettoRegistroServizi.getTipo() + "] differente da quello indicato [" + tipoSoggetto + "] nella directory che contiene la definizione");
                }
                if (!nomeSoggetto.equals(soggettoRegistroServizi.getNome())) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml del soggetto (" + schema + ") contiene un nome [" + soggettoRegistroServizi.getNome() + "] differente da quello indicato [" + nomeSoggetto + "] nella directory che contiene la definizione");
                }
            } else {
                if (soggettoConfigurazione != null) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. Una definizione xml del soggetto con tipologia (" + schema + ") e' presente piu' di una volta");
                }
                if (validationDocuments) {
                    org.openspcoop2.core.config.utils.XSDValidator.getXSDValidator((Logger)this.log).valida(bin);
                }
                if (!tipoSoggetto.equals((soggettoConfigurazione = this.jaxbConfigDeserializer.readSoggetto(xml)).getTipo())) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml del soggetto (" + schema + ") contiene un tipo [" + soggettoConfigurazione.getTipo() + "] differente da quello indicato [" + tipoSoggetto + "] nella directory che contiene la definizione");
                }
                if (!nomeSoggetto.equals(soggettoConfigurazione.getNome())) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml del soggetto (" + schema + ") contiene un nome [" + soggettoConfigurazione.getNome() + "] differente da quello indicato [" + nomeSoggetto + "] nella directory che contiene la definizione");
                }
            }
            if (soggettoConfigurazione != null && soggettoRegistroServizi != null) {
                archivio.getSoggetti().add(key, new ArchiveSoggetto(soggettoConfigurazione, soggettoRegistroServizi, idCorrelazione));
            } else if (soggettoConfigurazione != null) {
                archivio.getSoggetti().add(key, new ArchiveSoggetto(soggettoConfigurazione, idCorrelazione));
            } else {
                archivio.getSoggetti().add(key, new ArchiveSoggetto(soggettoRegistroServizi, idCorrelazione));
            }
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (soggetto) non valida rispetto allo schema (" + schema + "): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public ServizioApplicativo readServizioApplicativo(Archive archivio, InputStream bin, byte[] xml, String entryName, String tipoSoggetto, String nomeSoggetto, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        try {
            if (validationDocuments) {
                org.openspcoop2.core.config.utils.XSDValidator.getXSDValidator((Logger)this.log).valida(bin);
            }
            ServizioApplicativo sa = this.jaxbConfigDeserializer.readServizioApplicativo(xml);
            sa.setTipoSoggettoProprietario(tipoSoggetto);
            sa.setNomeSoggettoProprietario(nomeSoggetto);
            String tipoSoggettoKey = tipoSoggetto != null ? tipoSoggetto : "";
            String nomeSoggettoKey = nomeSoggetto != null ? nomeSoggetto : "";
            String key = ArchiveServizioApplicativo.buildKey(tipoSoggettoKey, nomeSoggettoKey, sa.getNome());
            if (archivio.getServiziApplicativi().containsKey(key)) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di un servizio applicativo con key [" + key + "]");
            }
            archivio.getServiziApplicativi().add(key, new ArchiveServizioApplicativo(sa, idCorrelazione, true));
            return sa;
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (servizio-applicativo) non valida rispetto allo schema (ConfigurazionePdD): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readProprietaServizioApplicativo(Archive archivio, byte[] content, String entryName, String tipoSoggetto, String nomeSoggetto, String nomeSA, String nomeFileSenzaServizioApplicativo, ArchiveVersion archiveVersion, Map<String, IdentificativoProprietaProtocollo> mapKeyProtocolProperties) throws ProtocolException {
        ServizioApplicativo servizioApplicativo = null;
        String key = ArchiveServizioApplicativo.buildKey(tipoSoggetto, nomeSoggetto, nomeSA);
        if (!archivio.getServiziApplicativi().containsKey(key)) {
            throw new ProtocolException("Elemento [" + entryName + "] errato. Non risulta la definizione dell'applicativo [" + tipoSoggetto + "/" + nomeSoggetto + " " + nomeSA + "]");
        }
        servizioApplicativo = ((ArchiveServizioApplicativo)archivio.getServiziApplicativi().get(key)).getServizioApplicativo();
        ArrayList<org.openspcoop2.core.config.ProtocolProperty> listPP = new ArrayList<org.openspcoop2.core.config.ProtocolProperty>();
        if (servizioApplicativo.sizeProtocolPropertyList() > 0) {
            for (org.openspcoop2.core.config.ProtocolProperty protocolProperty : servizioApplicativo.getProtocolPropertyList()) {
                if (protocolProperty.getTipoProprietario() == null) {
                    protocolProperty.setTipoProprietario(ProprietariProtocolProperty.SERVIZIO_APPLICATIVO.name());
                }
                listPP.add(protocolProperty);
            }
        }
        this.processProtocolPropertyConfig(nomeFileSenzaServizioApplicativo, archiveVersion, entryName, content, ProprietarioProprietaProtocollo.SERVIZIO_APPLICATIVO, tipoSoggetto, nomeSoggetto, nomeSA, mapKeyProtocolProperties, listPP, null);
    }

    public PortaDelegata readPortaDelegata(Archive archivio, InputStream bin, byte[] xml, String entryName, String tipoSoggetto, String nomeSoggetto, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        try {
            PortaDelegata pd;
            if (validationDocuments) {
                org.openspcoop2.core.config.utils.XSDValidator.getXSDValidator((Logger)this.log).valida(bin);
            }
            if ("openspcoop".equals((pd = this.jaxbConfigDeserializer.readPortaDelegata(xml)).getAutorizzazione())) {
                pd.setAutorizzazione(TipoAutorizzazione.AUTHENTICATED.getValue());
            }
            pd.setTipoSoggettoProprietario(tipoSoggetto);
            pd.setNomeSoggettoProprietario(nomeSoggetto);
            String nome = pd.getNome();
            String tipoSoggettoKey = tipoSoggetto != null ? tipoSoggetto : "";
            String nomeSoggettoKey = nomeSoggetto != null ? nomeSoggetto : "";
            String key = ArchivePortaDelegata.buildKey(tipoSoggettoKey, nomeSoggettoKey, nome);
            if (archivio.getPorteDelegate().containsKey(key)) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di una porta con key [" + key + "]");
            }
            archivio.getPorteDelegate().add(key, new ArchivePortaDelegata(pd, idCorrelazione, true));
            return pd;
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (porta-delegata) non valida rispetto allo schema (ConfigurazionePdD): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readPortaDelegataExtended(PortaDelegata pd, InputStream bin, byte[] xml, String entryName, boolean validationDocuments, ExtendedInfoManager extendedInfoManager) throws ProtocolException {
        try {
            if (pd == null) {
                throw new ProtocolException("Non \u00e8 possibile indicare una configurazione estesa senza indicare anche la definizione della porta delegata");
            }
            Object o = extendedInfoManager.newInstanceExtendedInfoPortaDelegata().deserialize(this.log, (Object)pd, xml);
            pd.addExtendedInfo(o);
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (porta-delegata-extended) non valida: " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public PortaApplicativa readPortaApplicativa(Archive archivio, InputStream bin, byte[] xml, String entryName, String tipoSoggetto, String nomeSoggetto, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        try {
            if (validationDocuments) {
                org.openspcoop2.core.config.utils.XSDValidator.getXSDValidator((Logger)this.log).valida(bin);
            }
            PortaApplicativa pa = this.jaxbConfigDeserializer.readPortaApplicativa(xml);
            pa.setTipoSoggettoProprietario(tipoSoggetto);
            pa.setNomeSoggettoProprietario(nomeSoggetto);
            String tipoSoggettoKey = tipoSoggetto != null ? tipoSoggetto : "";
            String nomeSoggettoKey = nomeSoggetto != null ? nomeSoggetto : "";
            String key = ArchivePortaApplicativa.buildKey(tipoSoggettoKey, nomeSoggettoKey, pa.getNome());
            if (archivio.getPorteApplicative().containsKey(key)) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di una porta con key [" + key + "]");
            }
            archivio.getPorteApplicative().add(key, new ArchivePortaApplicativa(pa, idCorrelazione, true));
            return pa;
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (porta-applicativa) non valida rispetto allo schema (ConfigurazionePdD): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readPortaApplicativaExtended(PortaApplicativa pa, InputStream bin, byte[] xml, String entryName, boolean validationDocuments, ExtendedInfoManager extendedInfoManager) throws ProtocolException {
        try {
            if (pa == null) {
                throw new ProtocolException("Non \u00e8 possibile indicare una configurazione estesa senza indicare anche la definizione della porta applicativa");
            }
            Object o = extendedInfoManager.newInstanceExtendedInfoPortaApplicativa().deserialize(this.log, (Object)pa, xml);
            pa.addExtendedInfo(o);
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (porta-applicativa-extended) non valida: " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readAccordoServizioParteComune(Archive archivio, InputStream bin, byte[] xml, String entryName, String tipoSoggetto, String nomeSoggetto, String nomeFileSenzaAccordo, String nomeAccordo, String versioneAccordo, boolean servizioComposto, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione, ArchiveVersion archiveVersion, Map<String, IdentificativoDocumento> mapKeyDocumenti, Map<String, IdentificativoProprietaProtocollo> mapKeyProtocolProperties) throws ProtocolException {
        Integer versioneAccordoInt = null;
        try {
            if (versioneAccordo != null && !USE_VERSION_XML_BEAN.equals(versioneAccordo)) {
                versioneAccordoInt = Integer.parseInt(versioneAccordo);
            }
        }
        catch (Exception e) {
            throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) nel path contiene una versione errata: " + e.getMessage());
        }
        String key = null;
        String tipoSoggettoKey = tipoSoggetto != null ? tipoSoggetto : "";
        String nomeSoggettoKey = nomeSoggetto != null ? nomeSoggetto : "";
        Integer versioneKey = versioneAccordoInt != null ? versioneAccordoInt : -1;
        key = servizioComposto ? ArchiveAccordoServizioComposto.buildKey(tipoSoggettoKey, nomeSoggettoKey, nomeAccordo, versioneKey) : ArchiveAccordoServizioParteComune.buildKey(tipoSoggettoKey, nomeSoggettoKey, nomeAccordo, versioneKey);
        if (!nomeFileSenzaAccordo.contains("" + File.separatorChar)) {
            try {
                AccordoServizioParteComune aspc;
                if (validationDocuments) {
                    org.openspcoop2.core.registry.utils.XSDValidator.getXSDValidator((Logger)this.log).valida(bin);
                }
                if ((aspc = this.jaxbRegistryDeserializer.readAccordoServizioParteComune(xml)).getSoggettoReferente() == null) {
                    aspc.setSoggettoReferente(new IdSoggetto());
                }
                if (tipoSoggetto != null && aspc.getSoggettoReferente().getTipo() != null && !aspc.getSoggettoReferente().getTipo().equals(tipoSoggetto)) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene un soggetto referente con tipo [" + aspc.getSoggettoReferente().getTipo() + "] differente da quello indicato [" + tipoSoggetto + "] nella directory che contiene la definizione");
                }
                if (nomeSoggetto != null && aspc.getSoggettoReferente().getNome() != null && !aspc.getSoggettoReferente().getNome().equals(nomeSoggetto)) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene un soggetto referente con nome [" + aspc.getSoggettoReferente().getNome() + "] differente da quello indicato [" + nomeSoggetto + "] nella directory che contiene la definizione");
                }
                aspc.getSoggettoReferente().setTipo(tipoSoggetto);
                aspc.getSoggettoReferente().setNome(nomeSoggetto);
                if (ArchiveVersion.V_UNDEFINED.equals((Object)archiveVersion)) {
                    String convertName = ZIPUtils.oldMethod_convertCharNonPermessiQualsiasiSistemaOperativo(aspc.getNome(), false);
                    if (!convertName.equals(nomeAccordo)) {
                        throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene un nome [" + aspc.getNome() + "] (fileSystemName:" + convertName + ") differente da quello indicato [" + nomeAccordo + "] nella directory che contiene la definizione");
                    }
                    if (!USE_VERSION_XML_BEAN.equals(versioneAccordo) && versioneAccordoInt != null) {
                        if (aspc.getVersione() != null && aspc.getVersione().intValue() != versioneAccordoInt.intValue()) {
                            throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene una versione [" + aspc.getVersione() + "] (fileSystemName:" + versioneAccordo + ") differente da quella indicato [" + versioneAccordoInt + "] nella directory che contiene la definizione");
                        }
                        aspc.setVersione(versioneAccordoInt);
                    }
                } else {
                    if (!aspc.getNome().equals(nomeAccordo)) {
                        throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene un nome [" + aspc.getNome() + "] differente da quello indicato [" + nomeAccordo + "] nel file [accordo.id]");
                    }
                    if (!USE_VERSION_XML_BEAN.equals(versioneAccordo)) {
                        if (versioneAccordoInt != null && aspc.getVersione() != null && aspc.getVersione().intValue() != versioneAccordoInt.intValue()) {
                            throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene una versione [" + aspc.getVersione() + "] differente da quella indicata [" + versioneAccordoInt + "] nel file [accordo.id]");
                        }
                        aspc.setVersione(versioneAccordoInt);
                    }
                }
                if (servizioComposto) {
                    if (aspc.getServizioComposto() == null) {
                        throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) non contiene le informazioni obbligatorie in un servizio composto");
                    }
                    if (archivio.getAccordiServizioComposto().containsKey(key)) {
                        throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di un accordo con key [" + key + "]");
                    }
                    archivio.getAccordiServizioComposto().add(key, new ArchiveAccordoServizioComposto(aspc, idCorrelazione, true));
                }
                if (aspc.getServizioComposto() != null) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene le informazioni per un servizio composto, ma l'accordo e' stato definito tra gli accordi di servizio parte comune");
                }
                if (archivio.getAccordiServizioParteComune().containsKey(key)) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di un accordo con key [" + key + "]");
                }
                archivio.getAccordiServizioParteComune().add(key, new ArchiveAccordoServizioParteComune(aspc, idCorrelazione, true));
            }
            catch (Exception eDeserializer) {
                String xmlString = this.toStringXmlElementForErrorMessage(xml);
                throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (accordo-servizio-parte-comune) non valida rispetto allo schema (RegistroServizi): " + eDeserializer.getMessage(), eDeserializer);
            }
        } else {
            AccordoServizioParteComune as = null;
            if (servizioComposto) {
                if (!archivio.getAccordiServizioComposto().containsKey(key)) {
                    throw new ProtocolException("Elemento [" + entryName + "] non atteso. Non \u00e8 possibile fornire dei documenti di un accordo senza fornire la definizione xml dell'accordo");
                }
                as = ((ArchiveAccordoServizioComposto)archivio.getAccordiServizioComposto().get(key)).getAccordoServizioParteComune();
            } else {
                if (!archivio.getAccordiServizioParteComune().containsKey(key)) {
                    throw new ProtocolException("Elemento [" + entryName + "] non atteso. Non \u00e8 possibile fornire dei documenti di un accordo senza fornire la definizione xml dell'accordo");
                }
                as = ((ArchiveAccordoServizioParteComune)archivio.getAccordiServizioParteComune().get(key)).getAccordoServizioParteComune();
            }
            if (nomeFileSenzaAccordo.startsWith("wsdl" + File.separatorChar)) {
                if (nomeFileSenzaAccordo.equalsIgnoreCase("wsdl" + File.separatorChar + "InterfacciaDefinitoria.xsd")) {
                    as.setByteWsdlDefinitorio(xml);
                } else if (nomeFileSenzaAccordo.equalsIgnoreCase("wsdl" + File.separatorChar + "InterfacciaConcettuale.wsdl")) {
                    as.setByteWsdlConcettuale(xml);
                } else if (nomeFileSenzaAccordo.equalsIgnoreCase("wsdl" + File.separatorChar + "InterfacciaLogicaErogatore.wsdl")) {
                    as.setByteWsdlLogicoErogatore(xml);
                } else if (nomeFileSenzaAccordo.equalsIgnoreCase("wsdl" + File.separatorChar + "InterfacciaLogicaFruitore.wsdl")) {
                    as.setByteWsdlLogicoFruitore(xml);
                }
            } else if (nomeFileSenzaAccordo.startsWith("specificheConversazioni" + File.separatorChar)) {
                if (nomeFileSenzaAccordo.equalsIgnoreCase("wsdl" + File.separatorChar + "ConversazioneConcettuale.xml")) {
                    as.setByteSpecificaConversazioneConcettuale(xml);
                } else if (nomeFileSenzaAccordo.equalsIgnoreCase("wsdl" + File.separatorChar + "ConversazioneLogicaErogatore.xml")) {
                    as.setByteSpecificaConversazioneErogatore(xml);
                } else if (nomeFileSenzaAccordo.equalsIgnoreCase("wsdl" + File.separatorChar + "ConversazioneLogicaFruitore.xml")) {
                    as.setByteSpecificaConversazioneFruitore(xml);
                }
            } else if (nomeFileSenzaAccordo.startsWith("allegati" + File.separatorChar)) {
                this.processDocument(nomeFileSenzaAccordo, "allegati", archiveVersion, entryName, xml, tipoSoggetto, nomeSoggetto, nomeAccordo, versioneAccordo, mapKeyDocumenti, as.getAllegatoList());
            } else if (nomeFileSenzaAccordo.startsWith("specificheSemiformali" + File.separatorChar)) {
                this.processDocument(nomeFileSenzaAccordo, "specificheSemiformali", archiveVersion, entryName, xml, tipoSoggetto, nomeSoggetto, nomeAccordo, versioneAccordo, mapKeyDocumenti, as.getSpecificaSemiformaleList());
            } else if (nomeFileSenzaAccordo.startsWith("specificheCoordinamento" + File.separatorChar)) {
                if (!servizioComposto) {
                    throw new ProtocolException("Elemento [" + entryName + "] non atteso. Non \u00e8 possibile fornire dei documenti di specifica di coordinamento per un accordo non registrato come servizio composto");
                }
                this.processDocument(nomeFileSenzaAccordo, "specificheCoordinamento", archiveVersion, entryName, xml, tipoSoggetto, nomeSoggetto, nomeAccordo, versioneAccordo, mapKeyDocumenti, as.getServizioComposto().getSpecificaCoordinamentoList());
            } else if (nomeFileSenzaAccordo.startsWith("proprietaProtocollo" + File.separatorChar)) {
                ArrayList<ProtocolProperty> listPP = new ArrayList<ProtocolProperty>();
                HashMap<String, Long> mapIdToLong = new HashMap<String, Long>();
                this._updateListProtocolProperties(as, listPP, mapIdToLong);
                this.processProtocolProperty(nomeFileSenzaAccordo, archiveVersion, entryName, xml, ProprietarioProprietaProtocollo.ACCORDO_SERVIZIO_PARTE_COMUNE, tipoSoggetto, nomeSoggetto, nomeAccordo, versioneAccordo, null, null, mapKeyProtocolProperties, listPP, mapIdToLong);
            }
        }
    }

    private void _updateListProtocolProperties(AccordoServizioParteComune as, List<ProtocolProperty> listPP, HashMap<String, Long> mapIdToLong) {
        Long idLong;
        Object key;
        long idLongForMap = 1L;
        if (as.sizeProtocolPropertyList() > 0) {
            for (ProtocolProperty protocolProperty : as.getProtocolPropertyList()) {
                if (protocolProperty.getTipoProprietario() == null) {
                    protocolProperty.setTipoProprietario(ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_COMUNE.name());
                }
                listPP.add(protocolProperty);
            }
        }
        if (as.sizeAzioneList() > 0) {
            for (Azione az : as.getAzioneList()) {
                if (az.sizeProtocolPropertyList() <= 0) continue;
                key = this.buildKeyPPAccordoParteComuneItem(ProprietariProtocolProperty.AZIONE_ACCORDO, az.getNome());
                idLong = idLongForMap++;
                mapIdToLong.put((String)key, idLong);
                for (ProtocolProperty protocolProperty : az.getProtocolPropertyList()) {
                    if (protocolProperty.getTipoProprietario() == null) {
                        protocolProperty.setTipoProprietario(ProprietariProtocolProperty.AZIONE_ACCORDO.name());
                    }
                    protocolProperty.setIdProprietario(idLong);
                    listPP.add(protocolProperty);
                }
            }
        }
        if (as.sizePortTypeList() > 0) {
            for (PortType pt : as.getPortTypeList()) {
                if (pt.sizeProtocolPropertyList() > 0) {
                    key = this.buildKeyPPAccordoParteComuneItem(ProprietariProtocolProperty.PORT_TYPE, pt.getNome());
                    idLong = idLongForMap++;
                    mapIdToLong.put((String)key, idLong);
                    for (ProtocolProperty protocolProperty : pt.getProtocolPropertyList()) {
                        if (protocolProperty.getTipoProprietario() == null) {
                            protocolProperty.setTipoProprietario(ProprietariProtocolProperty.PORT_TYPE.name());
                        }
                        protocolProperty.setIdProprietario(idLong);
                        listPP.add(protocolProperty);
                    }
                }
                if (pt.sizeAzioneList() <= 0) continue;
                for (Operation op : pt.getAzioneList()) {
                    if (op.sizeProtocolPropertyList() <= 0) continue;
                    String key2 = this.buildKeyPPAccordoParteComuneItem(ProprietariProtocolProperty.OPERATION, op.getNome());
                    Long idLong2 = idLongForMap++;
                    mapIdToLong.put(key2, idLong2);
                    for (ProtocolProperty protocolProperty : op.getProtocolPropertyList()) {
                        if (protocolProperty.getTipoProprietario() == null) {
                            protocolProperty.setTipoProprietario(ProprietariProtocolProperty.OPERATION.name());
                        }
                        protocolProperty.setIdProprietario(idLong2);
                        listPP.add(protocolProperty);
                    }
                }
            }
        }
        if (as.sizeResourceList() > 0) {
            for (Resource resource : as.getResourceList()) {
                if (resource.sizeProtocolPropertyList() <= 0) continue;
                key = this.buildKeyPPAccordoParteComuneItem(ProprietariProtocolProperty.RESOURCE, resource.getNome());
                idLong = idLongForMap++;
                mapIdToLong.put((String)key, idLong);
                for (ProtocolProperty protocolProperty : resource.getProtocolPropertyList()) {
                    if (protocolProperty.getTipoProprietario() == null) {
                        protocolProperty.setTipoProprietario(ProprietariProtocolProperty.RESOURCE.name());
                    }
                    protocolProperty.setIdProprietario(idLong);
                    listPP.add(protocolProperty);
                }
            }
        }
    }

    public void readAccordoServizioParteSpecifica(Archive archivio, InputStream bin, byte[] xml, String entryName, String tipoSoggetto, String nomeSoggetto, String nomeFileSenzaAccordo, String tipoServizio, String nomeServizio, String versioneServizio, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione, ArchiveVersion archiveVersion, Map<String, IdentificativoDocumento> mapKeyDocumenti, Map<String, IdentificativoProprietaProtocollo> mapKeyProtocolProperties, Map<String, IDSoggetto> mapKeyFruitori) throws ProtocolException {
        Integer versioneServizioInt = null;
        try {
            if (versioneServizio != null && !USE_VERSION_XML_BEAN.equals(versioneServizio)) {
                versioneServizioInt = Integer.parseInt(versioneServizio);
            }
        }
        catch (Exception e) {
            throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) nel path contiene una versione errata: " + e.getMessage());
        }
        String tipoSoggettoKey = tipoSoggetto != null ? tipoSoggetto : "";
        String nomeSoggettoKey = nomeSoggetto != null ? nomeSoggetto : "";
        Integer versioneKey = versioneServizioInt != null ? versioneServizioInt : -1;
        String key = ArchiveAccordoServizioParteSpecifica.buildKey(tipoSoggettoKey, nomeSoggettoKey, tipoServizio, nomeServizio, versioneKey);
        if (!nomeFileSenzaAccordo.contains("" + File.separatorChar)) {
            try {
                if (validationDocuments) {
                    org.openspcoop2.core.registry.utils.XSDValidator.getXSDValidator((Logger)this.log).valida(bin);
                }
                AccordoServizioParteSpecifica asps = this.jaxbRegistryDeserializer.readAccordoServizioParteSpecifica(xml);
                asps.setTipoSoggettoErogatore(tipoSoggetto);
                asps.setNomeSoggettoErogatore(nomeSoggetto);
                if (ArchiveVersion.V_UNDEFINED.equals((Object)archiveVersion)) {
                    String convertName = ZIPUtils.oldMethod_convertCharNonPermessiQualsiasiSistemaOperativo(asps.getNome(), false);
                    if (!convertName.equals(nomeServizio)) {
                        throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene un nome [" + asps.getNome() + "] (fileSystemName:" + convertName + ") differente da quello indicato [" + nomeServizio + "] nella directory che contiene la definizione");
                    }
                    String convertTipo = ZIPUtils.oldMethod_convertCharNonPermessiQualsiasiSistemaOperativo(asps.getTipo(), false);
                    if (!convertTipo.equals(tipoServizio)) {
                        throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene un tipo [" + asps.getTipo() + "] (fileSystemName:" + convertTipo + ") differente da quello indicato [" + tipoServizio + "] nella directory che contiene la definizione");
                    }
                    if (!USE_VERSION_XML_BEAN.equals(versioneServizio) && versioneServizioInt != null) {
                        if (asps.getVersione() != null && asps.getVersione().intValue() != versioneServizioInt.intValue()) {
                            throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene una versione [" + asps.getVersione() + "] (fileSystemName:" + versioneServizio + ") differente da quella indicato [" + versioneServizioInt + "] nella directory che contiene la definizione");
                        }
                        asps.setVersione(versioneServizioInt);
                    }
                } else {
                    if (!asps.getNome().equals(nomeServizio)) {
                        throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene un nome [" + asps.getNome() + "] differente da quello indicato [" + nomeServizio + "] nel file [accordo.id]");
                    }
                    if (!asps.getTipo().equals(tipoServizio)) {
                        throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene un tipo [" + asps.getNome() + "] differente da quello indicato [" + tipoServizio + "] nel file [accordo.id]");
                    }
                    if (!USE_VERSION_XML_BEAN.equals(versioneServizio)) {
                        if (versioneServizioInt != null && asps.getVersione() != null && asps.getVersione().intValue() != versioneServizioInt.intValue()) {
                            throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene una versione [" + asps.getVersione() + "] differente da quella indicata [" + versioneServizio + "] nel file [accordo.id]");
                        }
                        asps.setVersione(versioneServizioInt);
                    }
                }
                if (asps.sizeFruitoreList() > 0) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) non deve contenere fruizioni (eventuali fruizioni devono essere configurate nella struttura apposita)");
                }
                if (archivio.getAccordiServizioParteSpecifica().containsKey(key)) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di un accordo con key [" + key + "]");
                }
                archivio.getAccordiServizioParteSpecifica().add(key, new ArchiveAccordoServizioParteSpecifica(asps, idCorrelazione, true));
            }
            catch (Exception eDeserializer) {
                String xmlString = this.toStringXmlElementForErrorMessage(xml);
                throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (accordo-servizio-parte-specifica) non valida rispetto allo schema (RegistroServizi): " + eDeserializer.getMessage(), eDeserializer);
            }
        } else {
            ArchiveAccordoServizioParteSpecifica archiveASPS = null;
            AccordoServizioParteSpecifica as = null;
            if (!nomeFileSenzaAccordo.startsWith("fruitori" + File.separatorChar)) {
                if (!archivio.getAccordiServizioParteSpecifica().containsKey(key)) {
                    throw new ProtocolException("Elemento [" + entryName + "] non atteso. Non \u00e8 possibile fornire dei documenti di un accordo senza fornire la definizione xml dell'accordo");
                }
                archiveASPS = (ArchiveAccordoServizioParteSpecifica)archivio.getAccordiServizioParteSpecifica().get(key);
                as = archiveASPS.getAccordoServizioParteSpecifica();
            }
            if (nomeFileSenzaAccordo.startsWith("mapping" + File.separatorChar) && nomeFileSenzaAccordo.endsWith("_mappingErogazionePA.id")) {
                this.readAccordoServizioParteSpecifica_PortaApplicativaAssociata(archiveASPS, bin, xml, entryName);
            } else if (nomeFileSenzaAccordo.startsWith("wsdl" + File.separatorChar)) {
                if (as != null) {
                    if (nomeFileSenzaAccordo.equalsIgnoreCase("wsdl" + File.separatorChar + "InterfacciaImplementativaErogatore.wsdl")) {
                        as.setByteWsdlImplementativoErogatore(xml);
                    } else if (nomeFileSenzaAccordo.equalsIgnoreCase("wsdl" + File.separatorChar + "InterfacciaImplementativaFruitore.wsdl")) {
                        as.setByteWsdlImplementativoFruitore(xml);
                    }
                }
            } else if (nomeFileSenzaAccordo.startsWith("allegati" + File.separatorChar)) {
                if (as != null) {
                    this.processDocument(nomeFileSenzaAccordo, "allegati", archiveVersion, entryName, xml, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, versioneServizio, mapKeyDocumenti, as.getAllegatoList());
                }
            } else if (nomeFileSenzaAccordo.startsWith("specificheSemiformali" + File.separatorChar)) {
                if (as != null) {
                    this.processDocument(nomeFileSenzaAccordo, "specificheSemiformali", archiveVersion, entryName, xml, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, versioneServizio, mapKeyDocumenti, as.getSpecificaSemiformaleList());
                }
            } else if (nomeFileSenzaAccordo.startsWith("specificheLivelliServizio" + File.separatorChar)) {
                if (as != null) {
                    this.processDocument(nomeFileSenzaAccordo, "specificheLivelliServizio", archiveVersion, entryName, xml, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, versioneServizio, mapKeyDocumenti, as.getSpecificaLivelloServizioList());
                }
            } else if (nomeFileSenzaAccordo.startsWith("specificheSicurezza" + File.separatorChar)) {
                if (as != null) {
                    this.processDocument(nomeFileSenzaAccordo, "specificheSicurezza", archiveVersion, entryName, xml, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, versioneServizio, mapKeyDocumenti, as.getSpecificaSicurezzaList());
                }
            } else if (nomeFileSenzaAccordo.startsWith("proprietaProtocollo" + File.separatorChar)) {
                ArrayList<ProtocolProperty> listPP = new ArrayList<ProtocolProperty>();
                if (as != null && as.sizeProtocolPropertyList() > 0) {
                    for (ProtocolProperty protocolProperty : as.getProtocolPropertyList()) {
                        if (protocolProperty.getTipoProprietario() == null) {
                            protocolProperty.setTipoProprietario(ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_SPECIFICA.name());
                        }
                        listPP.add(protocolProperty);
                    }
                }
                this.processProtocolProperty(nomeFileSenzaAccordo, archiveVersion, entryName, xml, ProprietarioProprietaProtocollo.ACCORDO_SERVIZIO_PARTE_SPECIFICA, tipoSoggetto, nomeSoggetto, tipoServizio + "/" + nomeServizio, versioneServizio, null, null, mapKeyProtocolProperties, listPP, null);
            } else if (!nomeFileSenzaAccordo.startsWith("fruitori" + File.separatorChar) || !nomeFileSenzaAccordo.endsWith("serviziApplicativiAutorizzati.csv")) {
                if (nomeFileSenzaAccordo.startsWith("fruitori" + File.separatorChar) && nomeFileSenzaAccordo.endsWith("_mappingFruizionePD.id")) {
                    this.readAccordoServizioParteSpecifica_Fruitore_PortaDelegataAssociata(archivio, bin, xml, entryName, nomeFileSenzaAccordo, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, versioneServizio, validationDocuments, idCorrelazione, mapKeyFruitori);
                } else if (nomeFileSenzaAccordo.startsWith("fruitori" + File.separatorChar)) {
                    this.readAccordoServizioParteSpecifica_Fruitore(archivio, bin, xml, entryName, nomeFileSenzaAccordo.substring(("fruitori" + File.separatorChar).length()), tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, versioneServizio, validationDocuments, idCorrelazione, archiveVersion, mapKeyProtocolProperties, mapKeyFruitori);
                }
            }
        }
    }

    public void readAccordoServizioParteSpecifica_PortaApplicativaAssociata(ArchiveAccordoServizioParteSpecifica archiveASPS, InputStream bin, byte[] xml, String entryName) throws ProtocolException {
        try {
            String[] tmp;
            if (archiveASPS == null) {
                throw new ProtocolException("Elemento [" + entryName + "] non atteso. Non \u00e8 possibile fornire il mapping con la PA senza fornire la definizione xml dell'accordo di servizio parte specifica");
            }
            String idLine = this.readLineId(xml);
            if (idLine == null || "".equals(idLine)) {
                throw new ProtocolException("id non contiene valori");
            }
            if (idLine.endsWith("\n")) {
                idLine = idLine.substring(0, idLine.length() - 1);
            }
            if ((tmp = idLine.split(" ")).length < 3) {
                throw new ProtocolException("Attesi almeno tre valori separati da spazio (nomeRegola nomePorta isDefault [descrizione])");
            }
            String nomeRegola = tmp[0];
            String nomePorta = tmp[1];
            boolean isDefault = false;
            try {
                isDefault = Boolean.parseBoolean(tmp[2]);
            }
            catch (Exception e) {
                throw new ProtocolException("Attesi tre valori separati da spazio (nomeRegola nomePorta isDefault) in cui l'ultimo valore di tipo booleano: " + e.getMessage(), e);
            }
            String descrizione = null;
            if (tmp.length > 3) {
                String primeTreInfo = nomeRegola + " " + nomePorta + " " + isDefault + " ";
                descrizione = idLine.substring(primeTreInfo.length());
            }
            MappingErogazionePortaApplicativa mapping = new MappingErogazionePortaApplicativa();
            mapping.setNome(nomeRegola);
            mapping.setIdServizio(IDServizioFactory.getInstance().getIDServizioFromAccordo(archiveASPS.getAccordoServizioParteSpecifica()));
            IDPortaApplicativa idPA = new IDPortaApplicativa();
            idPA.setNome(nomePorta);
            mapping.setIdPortaApplicativa(idPA);
            mapping.setDefault(isDefault);
            mapping.setDescrizione(descrizione);
            if (archiveASPS.getMappingPorteApplicativeAssociate() == null) {
                archiveASPS.setMappingPorteApplicativeAssociate(new ArrayList<MappingErogazionePortaApplicativa>());
            }
            archiveASPS.getMappingPorteApplicativeAssociate().add(mapping);
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura id (mapping asps-pa) non valida: " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readAccordoServizioParteSpecifica_Fruitore(Archive archivio, InputStream bin, byte[] xml, String entryName, String nomeFileSenzaAccordo, String tipoSoggetto, String nomeSoggetto, String tipoServizio, String nomeServizio, String versioneServizio, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione, ArchiveVersion archiveVersion, Map<String, IdentificativoProprietaProtocollo> mapKeyProtocolProperties, Map<String, IDSoggetto> mapKeyFruitori) throws ProtocolException {
        Integer versioneServizioInt = null;
        try {
            if (versioneServizio != null && !USE_VERSION_XML_BEAN.equals(versioneServizio)) {
                versioneServizioInt = Integer.parseInt(versioneServizio);
            }
        }
        catch (Exception e) {
            throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) nel path contiene una versione errata: " + e.getMessage());
        }
        String tipoSoggettoKey = tipoSoggetto != null ? tipoSoggetto : "";
        String nomeSoggettoKey = nomeSoggetto != null ? nomeSoggetto : "";
        Integer versioneKey = versioneServizioInt != null ? versioneServizioInt : -1;
        if (!nomeFileSenzaAccordo.contains("" + File.separatorChar)) {
            if (entryName.endsWith(".id")) {
                String s = null;
                try {
                    String tipoNomeSoggettoFruitore = nomeFileSenzaAccordo.substring(nomeFileSenzaAccordo.indexOf(File.separatorChar) + 1, nomeFileSenzaAccordo.length() - ".id".length());
                    if (tipoNomeSoggettoFruitore == null || "".equals(tipoNomeSoggettoFruitore) || !tipoNomeSoggettoFruitore.contains("_")) {
                        throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [fruitori] deve essere presenta una ulteriore directory contenente la struttura <tipo>_<nome> che descrive il soggetto. Il nome utilizzato per la directory non e' conforme alla struttura attesa <tipo>_<nome>");
                    }
                    s = new String(xml);
                    if (s.endsWith("\n") && s.length() > 1) {
                        s = s.substring(0, s.length() - 1);
                    }
                    IDSoggetto idSoggetto = IDSoggetto.toIDSoggetto((String)s);
                    mapKeyFruitori.put(tipoNomeSoggettoFruitore, idSoggetto);
                }
                catch (Exception e) {
                    throw new ProtocolException("Elemento [" + entryName + "] contiene degli identificativi del frutore (" + s + ") non validi rispetto al pattern atteso (tipo/nome): " + e.getMessage(), e);
                }
            } else {
                try {
                    if (validationDocuments) {
                        org.openspcoop2.core.registry.utils.XSDValidator.getXSDValidator((Logger)this.log).valida(bin);
                    }
                    if (USE_VERSION_XML_BEAN.equals(versioneServizio)) {
                        String keyAccordo = ArchiveAccordoServizioParteSpecifica.buildKey(tipoSoggettoKey, nomeSoggettoKey, nomeServizio, tipoServizio, versioneKey);
                        versioneServizioInt = versioneKey = ((ArchiveAccordoServizioParteSpecifica)archivio.getAccordiServizioParteSpecifica().get(keyAccordo)).getAccordoServizioParteSpecifica().getVersione();
                    }
                    Fruitore fruitore = this.jaxbRegistryDeserializer.readFruitore(xml);
                    String keyFruitore = ArchiveFruitore.buildKey(fruitore.getTipo(), fruitore.getNome(), tipoSoggettoKey, nomeSoggettoKey, tipoServizio, nomeServizio, versioneServizioInt);
                    if (archivio.getAccordiFruitori().containsKey(keyFruitore)) {
                        throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di un fruitore con key [" + keyFruitore + "]");
                    }
                    IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(tipoServizio, nomeServizio, tipoSoggetto, nomeSoggetto, versioneServizioInt.intValue());
                    archivio.getAccordiFruitori().add(keyFruitore, new ArchiveFruitore(idServizio, fruitore, idCorrelazione, true));
                }
                catch (Exception eDeserializer) {
                    String xmlString = this.toStringXmlElementForErrorMessage(xml);
                    throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (fruitore) non valida rispetto allo schema (RegistroServizi): " + eDeserializer.getMessage(), eDeserializer);
                }
            }
        } else {
            IDSoggetto id;
            String tipoNomeSoggettoFruitore = nomeFileSenzaAccordo.substring(0, nomeFileSenzaAccordo.indexOf(File.separatorChar));
            if (tipoNomeSoggettoFruitore == null || "".equals(tipoNomeSoggettoFruitore) || !tipoNomeSoggettoFruitore.contains("_")) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [fruitori] deve essere presenta una ulteriore directory contenente la struttura <tipo>_<nome> che descrive il soggetto. Il nome utilizzato per la directory non e' conforme alla struttura attesa <tipo>_<nome>");
            }
            tipoNomeSoggettoFruitore = tipoNomeSoggettoFruitore.trim();
            String tipoSoggettoFruitore = null;
            String nomeSoggettoFruitore = null;
            if (!tipoNomeSoggettoFruitore.equals("_")) {
                if (tipoNomeSoggettoFruitore.startsWith("_")) {
                    nomeSoggettoFruitore = tipoNomeSoggettoFruitore.substring(1);
                } else if (tipoNomeSoggettoFruitore.endsWith("_")) {
                    tipoSoggettoFruitore = tipoNomeSoggettoFruitore.substring(0, tipoNomeSoggettoFruitore.length() - 1);
                } else {
                    tipoSoggettoFruitore = tipoNomeSoggettoFruitore.split("_")[0];
                    nomeSoggettoFruitore = tipoNomeSoggettoFruitore.split("_")[1];
                    if (tipoSoggettoFruitore == null || "".equals(tipoSoggettoFruitore)) {
                        throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [fruitori] deve essere presenta una ulteriore directory contenente la struttura <tipo>_<nome> che descrive il soggetto. Il nome utilizzato per la directory non e' conforme alla struttura attesa <tipo>_<nome>: tipo non identificato");
                    }
                    if (nomeSoggettoFruitore == null || "".equals(nomeSoggettoFruitore)) {
                        throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [fruitori] deve essere presenta una ulteriore directory contenente la struttura <tipo>_<nome> che descrive il soggetto. Il nome utilizzato per la directory non e' conforme alla struttura attesa <tipo>_<nome>: nome non identificato");
                    }
                }
            }
            if (mapKeyFruitori != null && mapKeyFruitori.containsKey(tipoNomeSoggettoFruitore) && (id = mapKeyFruitori.get(tipoNomeSoggettoFruitore)) != null) {
                tipoSoggettoFruitore = id.getTipo();
                nomeSoggettoFruitore = id.getNome();
            }
            String keyFruitore = ArchiveFruitore.buildKey(tipoSoggettoFruitore, nomeSoggettoFruitore, tipoSoggettoKey, nomeSoggettoKey, tipoServizio, nomeServizio, versioneServizioInt);
            ArchiveFruitore archiveFruitore = null;
            Fruitore fruitore = null;
            if (!archivio.getAccordiFruitori().containsKey(keyFruitore)) {
                throw new ProtocolException("Elemento [" + entryName + "] non atteso. Non \u00e8 possibile fornire delle propriet\u00e0 di protocollo di un fruitore senza fornire la definizione xml del fruitore");
            }
            archiveFruitore = (ArchiveFruitore)archivio.getAccordiFruitori().get(keyFruitore);
            fruitore = archiveFruitore.getFruitore();
            if ((nomeFileSenzaAccordo = nomeFileSenzaAccordo.substring((tipoNomeSoggettoFruitore + File.separatorChar).length())).startsWith("proprietaProtocollo" + File.separatorChar)) {
                ArrayList<ProtocolProperty> listPP = new ArrayList<ProtocolProperty>();
                if (fruitore.sizeProtocolPropertyList() > 0) {
                    for (ProtocolProperty protocolProperty : fruitore.getProtocolPropertyList()) {
                        if (protocolProperty.getTipoProprietario() == null) {
                            protocolProperty.setTipoProprietario(ProprietariProtocolProperty.FRUITORE.name());
                        }
                        listPP.add(protocolProperty);
                    }
                }
                this.processProtocolProperty(nomeFileSenzaAccordo, archiveVersion, entryName, xml, ProprietarioProprietaProtocollo.FRUITORE, tipoSoggetto, nomeSoggetto, tipoServizio + "/" + nomeServizio, versioneServizio, tipoSoggettoFruitore, nomeSoggettoFruitore, mapKeyProtocolProperties, listPP, null);
            }
        }
    }

    public void readAccordoServizioParteSpecifica_Fruitore_PortaDelegataAssociata(Archive archivio, InputStream bin, byte[] xml, String entryName, String nomeFileSenzaAccordo, String tipoSoggetto, String nomeSoggetto, String tipoServizio, String nomeServizio, String versioneServizio, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione, Map<String, IDSoggetto> mapKeyFruitori) throws ProtocolException {
        IDSoggetto id;
        String prefixError = "Elemento [" + entryName + "] errato. Dopo la directory [fruitori] il file che termina con [_mappingFruizionePD.id] deve essere contenuto in una directory definita tramite la struttura <tipo>_<nome> che descrive il soggetto fruitore.";
        String nomeServizioMappingPD = nomeFileSenzaAccordo.substring(nomeFileSenzaAccordo.lastIndexOf(File.separatorChar), nomeFileSenzaAccordo.length());
        String tipoNomeSoggettoFruitore = nomeFileSenzaAccordo.substring(("fruitori" + File.separatorChar).length(), nomeFileSenzaAccordo.length() - nomeServizioMappingPD.length());
        if (tipoNomeSoggettoFruitore == null || "".equals(tipoNomeSoggettoFruitore) || !tipoNomeSoggettoFruitore.contains("_")) {
            throw new ProtocolException(prefixError + " Il nome utilizzato per la directory non e' conforme alla struttura attesa <tipo>_<nome>");
        }
        tipoNomeSoggettoFruitore = tipoNomeSoggettoFruitore.trim();
        String tipoSoggettoFruitore = null;
        String nomeSoggettoFruitore = null;
        if (!tipoNomeSoggettoFruitore.equals("_")) {
            if (tipoNomeSoggettoFruitore.startsWith("_")) {
                nomeSoggettoFruitore = tipoNomeSoggettoFruitore.substring(1);
            } else if (tipoNomeSoggettoFruitore.endsWith("_")) {
                tipoSoggettoFruitore = tipoNomeSoggettoFruitore.substring(0, tipoNomeSoggettoFruitore.length() - 1);
            } else {
                tipoSoggettoFruitore = tipoNomeSoggettoFruitore.split("_")[0];
                nomeSoggettoFruitore = tipoNomeSoggettoFruitore.split("_")[1];
                if (tipoSoggettoFruitore == null || "".equals(tipoSoggettoFruitore)) {
                    throw new ProtocolException(prefixError + " Il nome utilizzato per la directory non e' conforme alla struttura attesa <tipo>_<nome>: tipo non identificato");
                }
                if (nomeSoggettoFruitore == null || "".equals(nomeSoggettoFruitore)) {
                    throw new ProtocolException(prefixError + " Il nome utilizzato per la directory non e' conforme alla struttura attesa <tipo>_<nome>: nome non identificato");
                }
            }
        }
        if (mapKeyFruitori != null && mapKeyFruitori.containsKey(tipoNomeSoggettoFruitore) && (id = mapKeyFruitori.get(tipoNomeSoggettoFruitore)) != null) {
            tipoSoggettoFruitore = id.getTipo();
            nomeSoggettoFruitore = id.getNome();
        }
        Integer versioneServizioInt = null;
        try {
            if (versioneServizio != null && !USE_VERSION_XML_BEAN.equals(versioneServizio)) {
                versioneServizioInt = Integer.parseInt(versioneServizio);
            }
        }
        catch (Exception e) {
            throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) nel path contiene una versione errata: " + e.getMessage());
        }
        String tipoSoggettoFruitoreKey = tipoSoggettoFruitore != null ? tipoSoggettoFruitore : "";
        String nomeSoggettoFruitoreKey = nomeSoggettoFruitore != null ? nomeSoggettoFruitore : "";
        String tipoSoggettoKey = tipoSoggetto != null ? tipoSoggetto : "";
        String nomeSoggettoKey = nomeSoggetto != null ? nomeSoggetto : "";
        Integer versioneKey = versioneServizioInt != null ? versioneServizioInt : -1;
        try {
            String[] tmp;
            String idLine = this.readLineId(xml);
            if (idLine == null || "".equals(idLine)) {
                throw new ProtocolException("id non contiene valori");
            }
            if (idLine.endsWith("\n")) {
                idLine = idLine.substring(0, idLine.length() - 1);
            }
            if ((tmp = idLine.split(" ")).length < 3) {
                throw new ProtocolException("Attesi almeno tre valori separati da spazio (nomeRegola nomePorta isDefault [descrizione])");
            }
            String nomeRegola = tmp[0];
            String nomePorta = tmp[1];
            boolean isDefault = false;
            try {
                isDefault = Boolean.parseBoolean(tmp[2]);
            }
            catch (Exception e) {
                throw new ProtocolException("Attesi tre valori separati da spazio (nomeRegola nomePorta isDefault) in cui l'ultimo valore di tipo booleano: " + e.getMessage(), e);
            }
            String descrizione = null;
            if (tmp.length > 3) {
                String primeTreInfo = nomeRegola + " " + nomePorta + " " + isDefault + " ";
                descrizione = idLine.substring(primeTreInfo.length());
            }
            String keyFruitore = ArchiveFruitore.buildKey(tipoSoggettoFruitoreKey, nomeSoggettoFruitoreKey, tipoSoggettoKey, nomeSoggettoKey, tipoServizio, nomeServizio, versioneKey);
            if (!archivio.getAccordiFruitori().containsKey(keyFruitore)) {
                throw new ProtocolException("Elemento [" + entryName + "] non atteso. Non \u00e8 possibile fornire un mapping con la porta delegata senza fornire la definizione xml della fruizione");
            }
            ArchiveFruitore archiveFruitore = (ArchiveFruitore)archivio.getAccordiFruitori().get(keyFruitore);
            MappingFruizionePortaDelegata mapping = new MappingFruizionePortaDelegata();
            mapping.setNome(nomeRegola);
            mapping.setIdServizio(archiveFruitore.getIdAccordoServizioParteSpecifica());
            mapping.setIdFruitore(archiveFruitore.getIdSoggettoFruitore());
            IDPortaDelegata idPD = new IDPortaDelegata();
            idPD.setNome(nomePorta);
            mapping.setIdPortaDelegata(idPD);
            mapping.setDefault(isDefault);
            mapping.setDescrizione(descrizione);
            if (archiveFruitore.getMappingPorteDelegateAssociate() == null) {
                archiveFruitore.setMappingPorteDelegateAssociate(new ArrayList<MappingFruizionePortaDelegata>());
            }
            archiveFruitore.getMappingPorteDelegateAssociate().add(mapping);
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura csv (mapping fruizione-pd) non valida: " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readAccordoCooperazione(Archive archivio, InputStream bin, byte[] xml, String entryName, String tipoSoggetto, String nomeSoggetto, String nomeFileSenzaAccordo, String nomeAccordo, String versioneAccordo, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione, ArchiveVersion archiveVersion, Map<String, IdentificativoDocumento> mapKeyDocumenti, Map<String, IdentificativoProprietaProtocollo> mapKeyProtocolProperties) throws ProtocolException {
        Integer versioneAccordoInt = null;
        try {
            if (versioneAccordo != null && !USE_VERSION_XML_BEAN.equals(versioneAccordo)) {
                versioneAccordoInt = Integer.parseInt(versioneAccordo);
            }
        }
        catch (Exception e) {
            throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) nel path contiene una versione errata: " + e.getMessage());
        }
        String tipoSoggettoKey = tipoSoggetto != null ? tipoSoggetto : "";
        String nomeSoggettoKey = nomeSoggetto != null ? nomeSoggetto : "";
        Integer versioneKey = versioneAccordoInt != null ? versioneAccordoInt : -1;
        String key = ArchiveAccordoCooperazione.buildKey(tipoSoggettoKey, nomeSoggettoKey, nomeAccordo, versioneKey);
        if (!nomeFileSenzaAccordo.contains("" + File.separatorChar)) {
            try {
                AccordoCooperazione ac;
                if (validationDocuments) {
                    org.openspcoop2.core.registry.utils.XSDValidator.getXSDValidator((Logger)this.log).valida(bin);
                }
                if ((ac = this.jaxbRegistryDeserializer.readAccordoCooperazione(xml)).getSoggettoReferente() == null) {
                    ac.setSoggettoReferente(new IdSoggetto());
                }
                if (tipoSoggetto != null && ac.getSoggettoReferente().getTipo() != null && !ac.getSoggettoReferente().getTipo().equals(tipoSoggetto)) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene un soggetto referente con tipo [" + ac.getSoggettoReferente().getTipo() + "] differente da quello indicato [" + tipoSoggetto + "] nella directory che contiene la definizione");
                }
                if (nomeSoggetto != null && ac.getSoggettoReferente().getNome() != null && !ac.getSoggettoReferente().getNome().equals(nomeSoggetto)) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene un soggetto referente con nome [" + ac.getSoggettoReferente().getNome() + "] differente da quello indicato [" + nomeSoggetto + "] nella directory che contiene la definizione");
                }
                ac.getSoggettoReferente().setTipo(tipoSoggetto);
                ac.getSoggettoReferente().setNome(nomeSoggetto);
                if (ArchiveVersion.V_UNDEFINED.equals((Object)archiveVersion)) {
                    String convertName = ZIPUtils.oldMethod_convertCharNonPermessiQualsiasiSistemaOperativo(ac.getNome(), false);
                    if (!convertName.equals(nomeAccordo)) {
                        throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene un nome [" + ac.getNome() + "] (fileSystemName:" + convertName + ") differente da quello indicato [" + nomeAccordo + "] nella directory che contiene la definizione");
                    }
                    if (!USE_VERSION_XML_BEAN.equals(versioneAccordo) && versioneAccordoInt != null) {
                        if (ac.getVersione() != null && ac.getVersione().intValue() != versioneAccordoInt.intValue()) {
                            throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene una versione [" + ac.getVersione() + "] (fileSystemName:" + versioneAccordo + ") differente da quella indicato [" + versioneAccordoInt + "] nella directory che contiene la definizione");
                        }
                        ac.setVersione(versioneAccordoInt);
                    }
                } else {
                    if (!ac.getNome().equals(nomeAccordo)) {
                        throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene un nome [" + ac.getNome() + "] differente da quello indicato [" + nomeAccordo + "] nel file [accordo.id]");
                    }
                    if (!USE_VERSION_XML_BEAN.equals(versioneAccordo)) {
                        if (versioneAccordoInt != null && ac.getVersione() != null && ac.getVersione().intValue() != versioneAccordoInt.intValue()) {
                            throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene una versione [" + ac.getVersione() + "] differente da quella indicata [" + versioneAccordo + "] nel file [accordo.id]");
                        }
                        ac.setVersione(versioneAccordoInt);
                    }
                }
                if (archivio.getAccordiCooperazione().containsKey(key)) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di un accordo con key [" + key + "]");
                }
                archivio.getAccordiCooperazione().add(key, new ArchiveAccordoCooperazione(ac, idCorrelazione, true));
            }
            catch (Exception eDeserializer) {
                String xmlString = this.toStringXmlElementForErrorMessage(xml);
                throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (accordo-cooperazione) non valida rispetto allo schema (RegistroServizi): " + eDeserializer.getMessage(), eDeserializer);
            }
        } else {
            AccordoCooperazione ac = null;
            if (!archivio.getAccordiCooperazione().containsKey(key)) {
                throw new ProtocolException("Elemento [" + entryName + "] non atteso. Non \u00e8 possibile fornire dei documenti di un accordo senza fornire la definizione xml dell'accordo");
            }
            ac = ((ArchiveAccordoCooperazione)archivio.getAccordiCooperazione().get(key)).getAccordoCooperazione();
            if (nomeFileSenzaAccordo.startsWith("allegati" + File.separatorChar)) {
                this.processDocument(nomeFileSenzaAccordo, "allegati", archiveVersion, entryName, xml, tipoSoggetto, nomeSoggetto, nomeAccordo, versioneAccordo, mapKeyDocumenti, ac.getAllegatoList());
            } else if (nomeFileSenzaAccordo.startsWith("specificheSemiformali" + File.separatorChar)) {
                this.processDocument(nomeFileSenzaAccordo, "specificheSemiformali", archiveVersion, entryName, xml, tipoSoggetto, nomeSoggetto, nomeAccordo, versioneAccordo, mapKeyDocumenti, ac.getSpecificaSemiformaleList());
            } else if (nomeFileSenzaAccordo.startsWith("proprietaProtocollo" + File.separatorChar)) {
                ArrayList<ProtocolProperty> listPP = new ArrayList<ProtocolProperty>();
                if (ac.sizeProtocolPropertyList() > 0) {
                    for (ProtocolProperty protocolProperty : ac.getProtocolPropertyList()) {
                        if (protocolProperty.getTipoProprietario() == null) {
                            protocolProperty.setTipoProprietario(ProprietariProtocolProperty.ACCORDO_COOPERAZIONE.name());
                        }
                        listPP.add(protocolProperty);
                    }
                }
                this.processProtocolProperty(nomeFileSenzaAccordo, archiveVersion, entryName, xml, ProprietarioProprietaProtocollo.ACCORDO_COOPERAZIONE, tipoSoggetto, nomeSoggetto, nomeAccordo, versioneAccordo, null, null, mapKeyProtocolProperties, listPP, null);
            }
        }
    }

    private void processDocument(String nomeFileSenzaAccordo, String tipoDir, ArchiveVersion archiveVersion, String entryName, byte[] xml, String tipoSoggetto, String nomeSoggetto, String tipoServizio, String nomeServizio, String versioneServizio, Map<String, IdentificativoDocumento> mapKeyDocumenti, List<Documento> documenti) throws ProtocolException {
        this.processDocument(nomeFileSenzaAccordo, tipoDir, archiveVersion, entryName, xml, tipoSoggetto, nomeSoggetto, tipoServizio + nomeServizio, versioneServizio, mapKeyDocumenti, documenti);
    }

    private void processDocument(String nomeFileSenzaAccordo, String tipoDir, ArchiveVersion archiveVersion, String entryName, byte[] xml, String tipoSoggetto, String nomeSoggetto, String nomeAccordo, String versioneAccordo, Map<String, IdentificativoDocumento> mapKeyDocumenti, List<Documento> documenti) throws ProtocolException {
        String nomeDocumento = nomeFileSenzaAccordo.substring((tipoDir + File.separatorChar).length());
        if (ArchiveVersion.V_UNDEFINED.equals((Object)archiveVersion)) {
            this.getDocument(documenti, nomeDocumento, null, entryName, archiveVersion).setByteContenuto(xml);
        } else {
            String nomeDocumentoSenzaEstensione = nomeDocumento;
            if (!nomeDocumento.contains(".")) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Per i documenti \u00e8 attesa una estensione");
            }
            nomeDocumentoSenzaEstensione = nomeDocumento.substring(0, nomeDocumento.lastIndexOf("."));
            String keyDocumento = this.getKeyDocumento(tipoSoggetto, nomeSoggetto, nomeAccordo, versioneAccordo, entryName, nomeDocumentoSenzaEstensione);
            if (nomeFileSenzaAccordo.endsWith(".id")) {
                String tmp = new String(xml);
                IdentificativoDocumento identificativoDocumento = new IdentificativoDocumento();
                identificativoDocumento.tipo = tmp.split("###")[0];
                identificativoDocumento.nome = tmp.substring(identificativoDocumento.tipo.length() + "###".length());
                identificativoDocumento.tipo = identificativoDocumento.tipo.trim();
                identificativoDocumento.nome = identificativoDocumento.nome.trim();
                if (identificativoDocumento.nome.endsWith("\n") && identificativoDocumento.nome.length() > 1) {
                    identificativoDocumento.nome = identificativoDocumento.nome.substring(0, identificativoDocumento.nome.length() - 1);
                }
                mapKeyDocumenti.put(keyDocumento, identificativoDocumento);
            } else if (nomeFileSenzaAccordo.endsWith(".raw")) {
                IdentificativoDocumento identificativoDocumento = mapKeyDocumenti.get(keyDocumento);
                if (identificativoDocumento == null) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. Non \u00e8 stato rilevato precedentemente il corrispettivo file contenente l'identificativo (con estensione '.id')");
                }
                this.getDocument(documenti, identificativoDocumento.nome, identificativoDocumento.tipo, entryName, archiveVersion).setByteContenuto(xml);
            } else {
                throw new ProtocolException("Elemento [" + entryName + "] non atteso.");
            }
        }
    }

    private Documento getDocument(List<Documento> documenti, String nome, String tipo, String entryName, ArchiveVersion archiveVersion) throws ProtocolException {
        ArrayList<Character> permitPoint = new ArrayList<Character>();
        permitPoint.add(Character.valueOf('.'));
        for (Documento documento : documenti) {
            String fileName = documento.getFile();
            if (ArchiveVersion.V_UNDEFINED.equals((Object)archiveVersion)) {
                fileName = ZIPUtils.oldMethod_convertCharNonPermessiQualsiasiSistemaOperativo(fileName, true, permitPoint);
            }
            if (!nome.equals(fileName)) continue;
            if (ArchiveVersion.V_UNDEFINED.equals((Object)archiveVersion)) {
                return documento;
            }
            if (!tipo.equals(documento.getTipo())) continue;
            return documento;
        }
        throw new ProtocolException("Elemento [" + entryName + "] non atteso. Non \u00e8 possibile fornire un documento di un accordo senza definirlo anche all'interno della definizione xml dell'accordo");
    }

    private void processProtocolProperty(String nomeFileSenzaAccordo, ArchiveVersion archiveVersion, String entryName, byte[] xml, ProprietarioProprietaProtocollo proprietario, String tipoSoggetto, String nomeSoggetto, String nomeAccordo, String versioneAccordo, String tipoSoggettoFruitore, String nomeSoggettoFruitore, Map<String, IdentificativoProprietaProtocollo> mapKeyProtocolProperties, List<ProtocolProperty> protocolProperties, HashMap<String, Long> mapIdToLong) throws ProtocolException {
        String nomePP;
        String nomePPSenzaEstensione = nomePP = nomeFileSenzaAccordo.substring(("proprietaProtocollo" + File.separatorChar).length());
        if (!nomePP.contains(".")) {
            throw new ProtocolException("Elemento [" + entryName + "] errato. Per le protocol properties \u00e8 attesa una estensione");
        }
        nomePPSenzaEstensione = nomePP.substring(0, nomePP.lastIndexOf("."));
        String keyProtocolProperty = this.getKeyProtocolProperty(tipoSoggetto, nomeSoggetto, nomeAccordo, versioneAccordo, tipoSoggettoFruitore, nomeSoggettoFruitore, proprietario, nomePPSenzaEstensione);
        if (nomeFileSenzaAccordo.endsWith(".id")) {
            String tmp = new String(xml);
            IdentificativoProprietaProtocollo identificativoPP = new IdentificativoProprietaProtocollo();
            identificativoPP.tipo = ProprietariProtocolProperty.valueOf((String)tmp.split("###")[0]);
            int prefixLength = identificativoPP.tipo.name().length() + "###".length();
            if (ProprietariProtocolProperty.AZIONE_ACCORDO.equals((Object)identificativoPP.tipo) || ProprietariProtocolProperty.PORT_TYPE.equals((Object)identificativoPP.tipo) || ProprietariProtocolProperty.OPERATION.equals((Object)identificativoPP.tipo) || ProprietariProtocolProperty.RESOURCE.equals((Object)identificativoPP.tipo)) {
                identificativoPP.idProprietario = tmp.split("###")[1];
                prefixLength += identificativoPP.idProprietario.length() + "###".length();
            }
            identificativoPP.nome = tmp.substring(prefixLength);
            mapKeyProtocolProperties.put(keyProtocolProperty, identificativoPP);
        } else if (nomeFileSenzaAccordo.endsWith(".raw")) {
            IdentificativoProprietaProtocollo identificativoPP = mapKeyProtocolProperties.get(keyProtocolProperty);
            if (identificativoPP == null) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Non \u00e8 stato rilevato precedentemente il corrispettivo file contenente l'identificativo (con estensione '.id')");
            }
            this.getProtocolProperty(proprietario, protocolProperties, identificativoPP.nome, identificativoPP.tipo, identificativoPP.idProprietario, mapIdToLong, entryName).setByteFile(xml);
        } else {
            throw new ProtocolException("Elemento [" + entryName + "] non atteso.");
        }
    }

    private String buildKeyPPAccordoParteComuneItem(ProprietariProtocolProperty tipo, String idProprietario) {
        return tipo.name() + "_" + idProprietario;
    }

    private ProtocolProperty getProtocolProperty(ProprietarioProprietaProtocollo proprietario, List<ProtocolProperty> protocolProperties, String nome, ProprietariProtocolProperty tipo, String idProprietario, HashMap<String, Long> mapIdToLong, String entryName) throws ProtocolException {
        for (ProtocolProperty pp : protocolProperties) {
            if (!pp.getTipoProprietario().equals(tipo.name()) || !pp.getName().equals(nome)) continue;
            if (mapIdToLong == null || ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_COMUNE.equals((Object)tipo)) {
                return pp;
            }
            String key = this.buildKeyPPAccordoParteComuneItem(tipo, idProprietario);
            Long l = mapIdToLong.get(key);
            if (l.longValue() != pp.getIdProprietario().longValue()) continue;
            return pp;
        }
        throw new ProtocolException("Elemento [" + entryName + "] non atteso. Non \u00e8 possibile fornire una propriet\u00e0 di protocollo senza definirlo anche all'interno della definizione xml (" + proprietario.name() + ")");
    }

    private void processProtocolPropertyConfig(String nomeFileSenzaId, ArchiveVersion archiveVersion, String entryName, byte[] xml, ProprietarioProprietaProtocollo proprietario, String tipoSoggetto, String nomeSoggetto, String nome, Map<String, IdentificativoProprietaProtocollo> mapKeyProtocolProperties, List<org.openspcoop2.core.config.ProtocolProperty> protocolProperties, HashMap<String, Long> mapIdToLong) throws ProtocolException {
        String nomePP;
        String nomePPSenzaEstensione = nomePP = nomeFileSenzaId.substring(("proprietaProtocollo" + File.separatorChar).length());
        if (!nomePP.contains(".")) {
            throw new ProtocolException("Elemento [" + entryName + "] errato. Per le protocol properties \u00e8 attesa una estensione");
        }
        nomePPSenzaEstensione = nomePP.substring(0, nomePP.lastIndexOf("."));
        String keyProtocolProperty = this.getKeyProtocolProperty(tipoSoggetto, nomeSoggetto, nome, null, null, null, proprietario, nomePPSenzaEstensione);
        if (nomeFileSenzaId.endsWith(".id")) {
            String tmp = new String(xml);
            IdentificativoProprietaProtocollo identificativoPP = new IdentificativoProprietaProtocollo();
            identificativoPP.tipo = ProprietariProtocolProperty.valueOf((String)tmp.split("###")[0]);
            int prefixLength = identificativoPP.tipo.name().length() + "###".length();
            identificativoPP.nome = tmp.substring(prefixLength);
            mapKeyProtocolProperties.put(keyProtocolProperty, identificativoPP);
        } else if (nomeFileSenzaId.endsWith(".raw")) {
            IdentificativoProprietaProtocollo identificativoPP = mapKeyProtocolProperties.get(keyProtocolProperty);
            if (identificativoPP == null) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Non \u00e8 stato rilevato precedentemente il corrispettivo file contenente l'identificativo (con estensione '.id')");
            }
            this.getProtocolPropertyConfig(proprietario, protocolProperties, identificativoPP.nome, identificativoPP.tipo, identificativoPP.idProprietario, mapIdToLong, entryName).setByteFile(xml);
        } else {
            throw new ProtocolException("Elemento [" + entryName + "] non atteso.");
        }
    }

    private org.openspcoop2.core.config.ProtocolProperty getProtocolPropertyConfig(ProprietarioProprietaProtocollo proprietario, List<org.openspcoop2.core.config.ProtocolProperty> protocolProperties, String nome, ProprietariProtocolProperty tipo, String idProprietario, HashMap<String, Long> mapIdToLong, String entryName) throws ProtocolException {
        for (org.openspcoop2.core.config.ProtocolProperty pp : protocolProperties) {
            if (!pp.getTipoProprietario().equals(tipo.name()) || !pp.getName().equals(nome)) continue;
            return pp;
        }
        throw new ProtocolException("Elemento [" + entryName + "] non atteso. Non \u00e8 possibile fornire una propriet\u00e0 di protocollo senza definirlo anche all'interno della definizione xml (" + proprietario.name() + ")");
    }

    protected String toStringXmlElementForErrorMessage(byte[] xml) {
        return xml != null ? "Xml: [" + new String(xml) + "] \n" : "Xml Undefined. \n";
    }

    private String readLineId(byte[] xml) throws IOException {
        StringReader sr = new StringReader(new String(xml));
        BufferedReader br = new BufferedReader(sr);
        String identificativo = br.readLine();
        br.close();
        sr.close();
        return identificativo;
    }
}

