/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.abstraction.template;

import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openspcoop2.protocol.abstraction.template.TemplateCore;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.resources.TemplateUtils;

public class TemplateErogazione
extends TemplateCore {
    private List<byte[]> accordiParteSpecifica = new ArrayList<byte[]>();
    private List<byte[]> serviziApplicativi = new ArrayList<byte[]>();
    private List<byte[]> porteApplicative = new ArrayList<byte[]>();

    public TemplateErogazione() throws ProtocolException {
        super(true);
        try {
            String baseUrl = "/templates/erogazione.zip";
            InputStream is = TemplateErogazione.class.getResourceAsStream(baseUrl);
            if (is == null) {
                throw new ProtocolException("Resource with url [" + baseUrl + "] not found");
            }
            byte[] zipFile = Utilities.getAsByteArray((InputStream)is);
            is.close();
            this.updateTemplates(zipFile);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public List<byte[]> getAccordiParteSpecifica() {
        return this.accordiParteSpecifica;
    }

    public void setAccordiParteSpecifica(List<byte[]> accordiParteSpecifica) {
        this.accordiParteSpecifica = accordiParteSpecifica;
    }

    public List<Template> getTemplateAccordiParteSpecifica() throws IOException {
        ArrayList<Template> templates = new ArrayList<Template>();
        for (int i = 0; i < this.accordiParteSpecifica.size(); ++i) {
            templates.add(TemplateUtils.buildTemplate((String)"asps_i", (byte[])this.accordiParteSpecifica.get(i)));
        }
        return templates;
    }

    public List<byte[]> getServiziApplicativi() {
        return this.serviziApplicativi;
    }

    public void setServiziApplicativi(List<byte[]> serviziApplicativi) {
        this.serviziApplicativi = serviziApplicativi;
    }

    public List<Template> getTemplateServiziApplicativi() throws IOException {
        ArrayList<Template> templates = new ArrayList<Template>();
        for (int i = 0; i < this.serviziApplicativi.size(); ++i) {
            templates.add(TemplateUtils.buildTemplate((String)"sa_i", (byte[])this.serviziApplicativi.get(i)));
        }
        return templates;
    }

    public List<byte[]> getPorteApplicative() {
        return this.porteApplicative;
    }

    public void setPorteApplicative(List<byte[]> porteApplicative) {
        this.porteApplicative = porteApplicative;
    }

    public List<Template> getTemplatePorteApplicative() throws IOException {
        ArrayList<Template> templates = new ArrayList<Template>();
        for (int i = 0; i < this.porteApplicative.size(); ++i) {
            templates.add(TemplateUtils.buildTemplate((String)"pa_i", (byte[])this.porteApplicative.get(i)));
        }
        return templates;
    }

    @Override
    public void updateOtherResource(String entryName, InputStream inputStream, byte[] xml, Map<String, Boolean> mapFound) throws ProtocolException {
        String rootDirNameExpected = this.getRootDirName() + File.separatorChar;
        if (entryName.startsWith(rootDirNameExpected + "asps" + File.separatorChar)) {
            if (!mapFound.containsKey("asps") || !mapFound.get("asps").booleanValue()) {
                this.getAccordiParteSpecifica().clear();
            }
            this.getAccordiParteSpecifica().add(xml);
            mapFound.put("asps", true);
        } else if (entryName.startsWith(rootDirNameExpected + "pa" + File.separatorChar)) {
            if (!mapFound.containsKey("pa") || !mapFound.get("pa").booleanValue()) {
                this.getPorteApplicative().clear();
            }
            this.getPorteApplicative().add(xml);
            mapFound.put("pa", true);
        } else if (entryName.startsWith(rootDirNameExpected + "sa" + File.separatorChar)) {
            if (!mapFound.containsKey("sa") || !mapFound.get("sa").booleanValue()) {
                this.getServiziApplicativi().clear();
            }
            this.getServiziApplicativi().add(xml);
            mapFound.put("sa", true);
        } else {
            throw new ProtocolException("Elemento [" + entryName + "] non atteso");
        }
    }
}

