/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.mbean;

import java.util.ArrayList;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.utils.beans.BlackListElement;
import org.openspcoop2.web.monitor.core.utils.BeanUtils;

public class EccezioneBean
extends Eccezione {
    private static final long serialVersionUID = 1L;
    private transient IProtocolFactory<?> protocolFactory;
    private transient ITraduttore traduttore;

    public EccezioneBean(Eccezione eccezione, IProtocolFactory<?> protocolFactory) {
        this.protocolFactory = protocolFactory;
        try {
            this.traduttore = this.protocolFactory.createTraduttore();
        }
        catch (ProtocolException protocolException) {
            // empty catch block
        }
        ArrayList<BlackListElement> metodiEsclusi = new ArrayList<BlackListElement>(0);
        metodiEsclusi.add(new BlackListElement("setProtocolFactory", new Class[]{IProtocolFactory.class}));
        metodiEsclusi.add(new BlackListElement("setCodiceEccezioneValue", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setContestoCodificaValue", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setRilevanzaValue", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setDescrizione", new Class[]{String.class}));
        BeanUtils.copy((Object)((Object)this), (Object)eccezione, metodiEsclusi);
        this.setCodiceEccezione(eccezione.getCodiceEccezione());
        this.setContestoCodifica(eccezione.getContestoCodifica());
        this.setRilevanza(eccezione.getRilevanza());
        try {
            if (this.getCodiceEccezione() != null) {
                this.setCodiceEccezioneValue(eccezione.getCodiceEccezioneValue(this.protocolFactory));
            }
            if (this.getContestoCodifica() != null) {
                this.setContestoCodificaValue(eccezione.getContestoCodificaValue(this.protocolFactory));
            }
            if (this.getRilevanza() != null) {
                this.setRilevanzaValue(eccezione.getRilevanzaValue(this.protocolFactory));
            }
            this.setDescrizione(eccezione.getDescrizione(this.protocolFactory));
        }
        catch (ProtocolException protocolException) {
            // empty catch block
        }
    }

    public String getCodiceEccezioneRicavato() {
        if (this.getCodiceEccezioneValue() != null) {
            return this.getCodiceEccezioneValue();
        }
        if (this.getCodiceEccezione() != null) {
            return this.getCodiceEccezione().name();
        }
        return null;
    }

    public String getContestoCodificaRicavato() {
        if (this.getContestoCodificaValue() != null) {
            return this.getContestoCodificaValue();
        }
        if (this.getContestoCodifica() != null) {
            return this.getContestoCodifica().getEngineValue();
        }
        return null;
    }

    public String getRilevanzaRicavato() {
        if (this.getRilevanzaValue() != null) {
            return this.getRilevanzaValue();
        }
        if (this.getRilevanza() != null) {
            return this.getRilevanza().getEngineValue();
        }
        return null;
    }

    public String getCodiceEccezioneValue() {
        if (this.traduttore != null) {
            try {
                return super.getCodiceEccezioneValue(this.protocolFactory) == null ? this.traduttore.toString(this.getCodiceEccezione()) : super.getCodiceEccezioneValue(this.protocolFactory);
            }
            catch (Exception e) {
                if (this.protocolFactory != null && this.protocolFactory.getLogger() != null) {
                    this.protocolFactory.getLogger().error(e.getMessage(), (Throwable)e);
                } else {
                    e.printStackTrace(System.err);
                }
                return null;
            }
        }
        return null;
    }

    public String getContestoCodificaValue() {
        if (this.traduttore != null) {
            try {
                return super.getContestoCodificaValue(this.protocolFactory) == null ? this.traduttore.toString(this.getContestoCodifica()) : super.getContestoCodificaValue(this.protocolFactory);
            }
            catch (Exception e) {
                if (this.protocolFactory != null && this.protocolFactory.getLogger() != null) {
                    this.protocolFactory.getLogger().error(e.getMessage(), (Throwable)e);
                } else {
                    e.printStackTrace(System.err);
                }
                return null;
            }
        }
        return null;
    }

    public String getRilevanzaValue() {
        if (this.traduttore != null) {
            try {
                return super.getRilevanzaValue(this.protocolFactory) == null ? this.traduttore.toString(this.getRilevanza()) : super.getRilevanzaValue(this.protocolFactory);
            }
            catch (Exception e) {
                if (this.protocolFactory != null && this.protocolFactory.getLogger() != null) {
                    this.protocolFactory.getLogger().error(e.getMessage(), (Throwable)e);
                } else {
                    e.printStackTrace(System.err);
                }
                return null;
            }
        }
        return null;
    }

    public String getDescrizioneValue() {
        if (this.protocolFactory != null) {
            try {
                return this.getDescrizione(this.protocolFactory);
            }
            catch (ProtocolException e) {
                return null;
            }
            catch (NullPointerException e) {
                return null;
            }
        }
        return null;
    }
}

