/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.mbean;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.faces.context.FacesContext;
import org.openspcoop2.core.transazioni.DumpHeaderTrasporto;
import org.openspcoop2.core.transazioni.DumpMessaggio;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.core.transazioni.dao.jdbc.JDBCDumpMessaggioStream;
import org.openspcoop2.core.transazioni.utils.DumpUtils;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.utils.DumpAttachment;
import org.openspcoop2.utils.CopyStream;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.web.monitor.core.core.Utils;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.mbean.PdDBaseBean;
import org.openspcoop2.web.monitor.core.utils.MessageUtils;
import org.openspcoop2.web.monitor.core.utils.MimeTypeUtils;
import org.openspcoop2.web.monitor.transazioni.bean.DumpAttachmentBean;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioniSearchForm;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniService;
import org.openspcoop2.web.monitor.transazioni.utils.DumpMessaggioUtils;
import org.slf4j.Logger;

public class DettagliDumpMultipart
extends PdDBaseBean<Transazione, String, ITransazioniService> {
    private static final long serialVersionUID = 1L;
    private transient Logger log = LoggerManager.getPddMonitorCoreLogger();
    private String idTransazione;
    private String servizioApplicativoErogatore;
    private String protocollo = null;
    private TipoMessaggio tipoMessaggio;
    private Date dataConsegnaErogatore = null;
    private Date ultimaConsegna = null;
    private org.openspcoop2.message.utils.DumpMessaggio dumpMessaggio;
    private int dumpMessaggioLength;
    private DumpAttachmentBean selectedAttachment;
    private List<DumpAttachmentBean> attachments;
    private Boolean exportContenutiMultipart;
    private boolean base64Decode;

    public void setBase64Decode(boolean base64Decode) {
        this.base64Decode = base64Decode;
    }

    public void setSelectedAttachment(DumpAttachmentBean selectedAttachment) {
        this.selectedAttachment = selectedAttachment;
    }

    public String getIdTransazione() {
        return this.idTransazione;
    }

    public void setIdTransazione(String idTransazione) {
        this.idTransazione = idTransazione;
    }

    public String getServizioApplicativoErogatore() {
        return this.servizioApplicativoErogatore;
    }

    public void setServizioApplicativoErogatore(String servizioApplicativoErogatore) {
        this.servizioApplicativoErogatore = servizioApplicativoErogatore;
    }

    public Date getDataConsegnaErogatore() {
        return this.dataConsegnaErogatore;
    }

    public void setDataConsegnaErogatore(Date dataConsegnaErogatore) {
        this.dataConsegnaErogatore = dataConsegnaErogatore;
    }

    public String getProtocollo() {
        return this.protocollo;
    }

    public void setProtocollo(String protocollo) {
        this.protocollo = protocollo;
    }

    public boolean isVisualizzaMessaggio() {
        boolean visualizzaMessaggio = true;
        if (this.dumpMessaggio != null && this.dumpMessaggio.getBody() != null) {
            if (this.dumpMessaggio.getBody() == null) {
                return false;
            }
            StringBuilder contenutoDocumentoStringBuilder = new StringBuilder();
            String errore = Utils.getTestoVisualizzabile((byte[])this.dumpMessaggio.getBody(), (StringBuilder)contenutoDocumentoStringBuilder, (boolean)false, (int)DumpUtils.getThreshold_readInMemory());
            if (errore != null) {
                return false;
            }
        } else if (this.dumpMessaggio != null && this.dumpMessaggio.getBodyLength() > 0L) {
            return false;
        }
        return visualizzaMessaggio;
    }

    public String getPrettyEnvelop() {
        String toRet = null;
        if (this.dumpMessaggio != null && this.dumpMessaggio.getBody() != null) {
            StringBuilder contenutoDocumentoStringBuilder = new StringBuilder();
            String errore = Utils.getTestoVisualizzabile((byte[])this.dumpMessaggio.getBody(), (StringBuilder)contenutoDocumentoStringBuilder, (boolean)true, (int)DumpUtils.getThreshold_readInMemory());
            if (errore != null) {
                return "";
            }
            MessageType messageType = this.dumpMessaggio.getMessageType();
            if (messageType == null) {
                toRet = this._getPrettyUnknownType();
            } else {
                switch (messageType) {
                    case JSON: {
                        JSONUtils jsonUtils = JSONUtils.getInstance((boolean)true);
                        try {
                            toRet = jsonUtils.toString(jsonUtils.getAsNode(this.dumpMessaggio.getBody()));
                        }
                        catch (UtilsException utilsException) {}
                        break;
                    }
                    case SOAP_11: 
                    case SOAP_12: {
                        String charset = null;
                        if (this.dumpMessaggio.getMultipartInfoBody() != null && this.dumpMessaggio.getMultipartInfoBody().getContentType() != null) {
                            String contentType = this.dumpMessaggio.getMultipartInfoBody().getContentType();
                            try {
                                charset = ContentTypeUtilities.readCharsetFromContentType((String)contentType);
                            }
                            catch (Throwable throwable) {}
                        } else {
                            String contentType = this.dumpMessaggio.getContentType();
                            boolean multipart = false;
                            try {
                                multipart = ContentTypeUtilities.isMultipartType((String)contentType);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            if (multipart) break;
                            try {
                                charset = ContentTypeUtilities.readCharsetFromContentType((String)contentType);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        toRet = Utils.prettifyXml((byte[])this.dumpMessaggio.getBody(), (String)Charset.UTF_8.getValue());
                        break;
                    }
                    case XML: {
                        String charset = null;
                        if (this.dumpMessaggio.getContentType() != null) {
                            try {
                                charset = ContentTypeUtilities.readCharsetFromContentType((String)this.dumpMessaggio.getContentType());
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        toRet = Utils.prettifyXml((byte[])this.dumpMessaggio.getBody(), (String)Charset.UTF_8.getValue());
                        break;
                    }
                    case BINARY: 
                    case MIME_MULTIPART: {
                        toRet = this._getPrettyUnknownType();
                    }
                }
            }
        }
        if (toRet == null || "".equals(toRet)) {
            toRet = this.dumpMessaggio != null && this.dumpMessaggio.getBody() != null ? new String(this.dumpMessaggio.getBody()) : "";
        }
        return toRet;
    }

    private String _getPrettyUnknownType() {
        String toRet = null;
        try {
            String ext;
            String contentType = this.dumpMessaggio.getContentType();
            if (ContentTypeUtilities.isMultipartRelated((String)contentType)) {
                contentType = ContentTypeUtilities.getInternalMultipartContentType((String)contentType);
            }
            if ("json".equals(ext = MimeTypeUtils.fileExtensionForMIMEType((String)contentType)) || contentType.contains("json")) {
                JSONUtils jsonUtils = JSONUtils.getInstance((boolean)true);
                try {
                    toRet = jsonUtils.toString(jsonUtils.getAsNode(this.dumpMessaggio.getBody()));
                }
                catch (UtilsException utilsException) {}
            } else if ("xml".equals(ext) || contentType.contains("xml")) {
                toRet = Utils.prettifyXml((byte[])this.dumpMessaggio.getBody());
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return toRet;
    }

    public String getBrush() {
        String toRet = null;
        if (this.dumpMessaggio != null && this.dumpMessaggio.getBody() != null) {
            MessageType messageType = this.dumpMessaggio.getMessageType();
            if (messageType == null) {
                toRet = this._getBrushUnknownType();
            } else {
                switch (messageType) {
                    case JSON: {
                        toRet = "json";
                        break;
                    }
                    default: {
                        toRet = "xml";
                        break;
                    }
                    case BINARY: 
                    case MIME_MULTIPART: {
                        toRet = this._getBrushUnknownType();
                    }
                }
            }
        }
        return toRet != null ? toRet : "xml";
    }

    private String _getBrushUnknownType() {
        String toRet = null;
        try {
            String ext;
            String contentType = this.dumpMessaggio.getContentType();
            if (ContentTypeUtilities.isMultipartRelated((String)contentType)) {
                contentType = ContentTypeUtilities.getInternalMultipartContentType((String)contentType);
            }
            toRet = "json".equals(ext = MimeTypeUtils.fileExtensionForMIMEType((String)contentType)) || contentType.contains("json") ? "json" : "xml";
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            toRet = "xml";
        }
        return toRet;
    }

    public String getErroreVisualizzaMessaggio() {
        if (this.dumpMessaggio != null && this.dumpMessaggio.getBody() != null) {
            StringBuilder contenutoDocumentoStringBuilder = new StringBuilder();
            String errore = Utils.getTestoVisualizzabile((byte[])this.dumpMessaggio.getBody(), (StringBuilder)contenutoDocumentoStringBuilder, (boolean)false, (int)DumpUtils.getThreshold_readInMemory());
            return errore;
        }
        if (this.dumpMessaggio != null && this.dumpMessaggio.getBodyLength() > 0L) {
            String errore = Utilities.getErrorMessagePrintableTextMaxLength((int)((int)this.dumpMessaggio.getBodyLength()), (int)DumpUtils.getThreshold_readInMemory());
            return errore;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.openspcoop2.message.utils.DumpMessaggio getDumpMessaggio() {
        if (this.dumpMessaggio != null) {
            return this.dumpMessaggio;
        }
        try {
            DumpMessaggio tmp = null;
            try {
                tmp = this.ultimaConsegna == null ? ((ITransazioniService)this.service).getDumpMessaggio(this.idTransazione, this.servizioApplicativoErogatore, this.dataConsegnaErogatore, this.tipoMessaggio) : ((ITransazioniService)this.service).getDumpMessaggio(this.idTransazione, this.servizioApplicativoErogatore, this.ultimaConsegna, this.tipoMessaggio);
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            JDBCDumpMessaggioStream dumpStream = null;
            InputStream is = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                if (tmp != null && tmp.getBody() != null) {
                    byte[] contenutoBody = tmp.getBody();
                    is = new ByteArrayInputStream(contenutoBody);
                } else {
                    try {
                        dumpStream = this.ultimaConsegna == null ? ((ITransazioniService)this.service).getContentInputStream(this.idTransazione, this.servizioApplicativoErogatore, this.dataConsegnaErogatore, this.tipoMessaggio) : ((ITransazioniService)this.service).getContentInputStream(this.idTransazione, this.servizioApplicativoErogatore, this.ultimaConsegna, this.tipoMessaggio);
                        is = dumpStream.getIs();
                    }
                    catch (Exception e) {
                        this.log.error(e.getMessage(), (Throwable)e);
                    }
                }
                CopyStream.copy((InputStream)is, (OutputStream)baos);
                baos.flush();
                baos.close();
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (dumpStream != null) {
                        dumpStream.closeJdbcResources();
                    }
                }
                catch (Exception e) {}
            }
            byte[] content = baos.toByteArray();
            String contentType = tmp != null ? tmp.getContentType() : null;
            this.dumpMessaggioLength = content.length;
            this.dumpMessaggio = DumpMessaggioUtils.getFromBytes(content, contentType, tmp != null ? tmp.getFormatoMessaggio() : null);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante il download del messaggio.");
        }
        return this.dumpMessaggio;
    }

    public int getDumpMessaggioLength() {
        this.getDumpMessaggio();
        return this.dumpMessaggioLength;
    }

    public List<DumpAttachmentBean> getAllegati() {
        if (this.getDumpMessaggio() == null) {
            return null;
        }
        if (this.attachments == null) {
            List list = this.dumpMessaggio.getAttachments();
            if (list != null && list.size() > 0) {
                this.attachments = new ArrayList<DumpAttachmentBean>();
                for (DumpAttachment dumpAllegato : list) {
                    this.attachments.add(new DumpAttachmentBean(dumpAllegato));
                }
                return this.attachments;
            }
            return null;
        }
        return this.attachments;
    }

    public List<DumpHeaderTrasporto> getHeadersTrasporto() {
        if (this.getDumpMessaggio() == null) {
            return null;
        }
        if (this.getDumpMessaggio().getHeadersValues() != null && this.getDumpMessaggio().getHeadersValues().size() > 0) {
            ArrayList<DumpHeaderTrasporto> headers = new ArrayList<DumpHeaderTrasporto>();
            Map toMapSingleValue = TransportUtils.convertToMapSingleValue((Map)this.getDumpMessaggio().getHeadersValues());
            for (String key : toMapSingleValue.keySet()) {
                String value = (String)toMapSingleValue.get(key);
                DumpHeaderTrasporto header = new DumpHeaderTrasporto();
                header.setNome(key);
                header.setValore(value);
                headers.add(header);
            }
            return headers;
        }
        return null;
    }

    public String downloadMessaggio() {
        this.log.debug("downloading messaggio...");
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            response.setContentType(this.dumpMessaggio.getContentType());
            Object fileName = "messaggio";
            String ext = "bin";
            String contentType = this.dumpMessaggio.getContentType();
            try {
                if (contentType != null) {
                    // empty if block
                }
                ext = MimeTypeUtils.fileExtensionForMIMEType((String)contentType);
            }
            catch (Exception e) {
                ext = "bin";
            }
            fileName = (String)fileName + "." + ext;
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)fileName, (String)contentType);
            ByteArrayInputStream is = null;
            ServletOutputStream os = null;
            byte[] contenutoBody = this.dumpMessaggio.getBody();
            is = new ByteArrayInputStream(contenutoBody);
            os = response.getOutputStream();
            CopyStream.copy((InputStream)is, (OutputStream)os);
            os.flush();
            os.close();
            FacesContext.getCurrentInstance().responseComplete();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante il download del messaggio.");
        }
        return null;
    }

    public String download() {
        this.log.debug("downloading allegato: " + this.selectedAttachment.getContentId());
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            int read = 0;
            byte[] bytes = new byte[1024];
            response.setContentType(this.selectedAttachment.getContentType());
            Object fileName = "allegato";
            String ext = MimeTypeUtils.fileExtensionForMIMEType((String)this.selectedAttachment.getContentType());
            fileName = (String)fileName + "." + ext;
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)fileName, (String)this.selectedAttachment.getContentType());
            ByteArrayInputStream bis = null;
            ServletOutputStream os = null;
            byte[] contenutoAllegato = this.selectedAttachment.getContent();
            if (this.base64Decode) {
                try {
                    contenutoAllegato = DumpMessaggioUtils.decodeAllegatoBase64(this.selectedAttachment.getContent(), this.selectedAttachment.getContentType(), this.selectedAttachment.getContentId(), this.log);
                }
                catch (Exception e) {
                    this.log.error("IsBase64 error: " + e.getMessage(), (Throwable)e);
                }
            }
            bis = new ByteArrayInputStream(contenutoAllegato);
            os = response.getOutputStream();
            while ((read = bis.read(bytes)) != -1) {
                os.write(bytes, 0, read);
            }
            os.flush();
            os.close();
            FacesContext.getCurrentInstance().responseComplete();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante il download dell'allegato.");
        }
        return null;
    }

    public String downloadAll() {
        this.log.debug("downloading all attachments");
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            byte[] bytes = new byte[1024];
            String fileName = this.idTransazione + "-Attachments.zip";
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)fileName);
            ZipOutputStream zip = new ZipOutputStream((OutputStream)response.getOutputStream());
            ByteArrayInputStream in = null;
            int index = 1;
            for (DumpAttachment allegato : this.dumpMessaggio.getAttachments()) {
                int len;
                String allegatofileName = "allegato_" + index;
                String allegatoExt = MimeTypeUtils.fileExtensionForMIMEType((String)allegato.getContentType());
                allegatofileName = allegatofileName + "." + allegatoExt;
                zip.putNextEntry(new ZipEntry(allegatofileName));
                byte[] contenutoAllegato = allegato.getContent();
                in = new ByteArrayInputStream(contenutoAllegato);
                while ((len = in.read(bytes)) > 0) {
                    zip.write(bytes, 0, len);
                }
                zip.closeEntry();
                ((InputStream)in).close();
                try {
                    if (DumpMessaggioUtils.isAllegatoBase64(allegato.getContent(), allegato.getContentType(), allegato.getContentId(), this.log)) {
                        contenutoAllegato = DumpMessaggioUtils.decodeAllegatoBase64(allegato.getContent(), allegato.getContentType(), allegato.getContentId(), this.log);
                        allegatofileName = "allegato_" + index + ".decodeBase64";
                        allegatofileName = allegatofileName + "." + allegatoExt;
                        zip.putNextEntry(new ZipEntry(allegatofileName));
                        in = new ByteArrayInputStream(contenutoAllegato);
                        while ((len = in.read(bytes)) > 0) {
                            zip.write(bytes, 0, len);
                        }
                        zip.closeEntry();
                        ((InputStream)in).close();
                    }
                }
                catch (Throwable e) {
                    this.log.error(e.getMessage(), e);
                }
                ++index;
            }
            zip.flush();
            zip.close();
            FacesContext.getCurrentInstance().responseComplete();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante il download dell'allegato.");
        }
        return null;
    }

    public void setTipoMessaggio(String value) {
        if (value != null) {
            this.tipoMessaggio = (TipoMessaggio)TipoMessaggio.toEnumConstantFromString((String)value);
        }
    }

    public String getTipoMessaggio() {
        if (this.tipoMessaggio == null) {
            return null;
        }
        return this.tipoMessaggio.toString();
    }

    public TipoMessaggio getTipoMessaggioEnum() {
        return this.tipoMessaggio;
    }

    public void setTipoMessaggioEnum(TipoMessaggio tipoMessaggio) {
        this.tipoMessaggio = tipoMessaggio;
    }

    public String getTitoloPagina() {
        if (this.tipoMessaggio != null) {
            switch (this.tipoMessaggio) {
                case RICHIESTA_INGRESSO: {
                    return "Messaggio di Richiesta - Contenuti Ingresso";
                }
                case RICHIESTA_USCITA: {
                    return "Messaggio di Richiesta - Contenuti Uscita";
                }
                case RISPOSTA_INGRESSO: {
                    return "Messaggio di Risposta - Contenuti Ingresso";
                }
                case RISPOSTA_USCITA: {
                    return "Messaggio di Risposta - Contenuti Uscita";
                }
                case RICHIESTA_INGRESSO_DUMP_BINARIO: {
                    return "Messaggio di Richiesta - Dati Ingresso";
                }
                case RICHIESTA_USCITA_DUMP_BINARIO: {
                    return "Messaggio di Richiesta - Dati Uscita";
                }
                case RISPOSTA_INGRESSO_DUMP_BINARIO: {
                    return "Messaggio di Risposta - Dati Ingresso";
                }
                case RISPOSTA_USCITA_DUMP_BINARIO: {
                    return "Messaggio di Risposta - Dati Uscita";
                }
            }
            return "Contenuti Messaggio";
        }
        return "Contenuti Messaggio";
    }

    public Date getUltimaConsegna() {
        return this.ultimaConsegna;
    }

    public void setUltimaConsegna(Date ultimaConsegna) {
        this.ultimaConsegna = ultimaConsegna;
    }

    public Boolean getExportContenutiMultipart() {
        return this.exportContenutiMultipart;
    }

    public void setExportContenutiMultipart(Boolean exportContenutiMultipart) {
        this.exportContenutiMultipart = exportContenutiMultipart;
    }

    public boolean isVisualizzaLinkEsporta() {
        return ((TransazioniSearchForm)((ITransazioniService)this.service).getSearch()).isShowButtonEsporta();
    }
}

