/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.datamodel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.faces.context.FacesContext;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.Range;
import org.ajax4jsf.model.SequenceRange;
import org.openspcoop2.core.transazioni.TransazioneApplicativoServer;
import org.openspcoop2.web.monitor.core.datamodel.BaseDataModel;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneApplicativoServerBean;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniApplicativoServerService;
import org.openspcoop2.web.monitor.transazioni.mbean.DiagnosticiBean;
import org.slf4j.Logger;

public class TransazioniApplicativoServerDM
extends BaseDataModel<Long, TransazioneApplicativoServerBean, ITransazioniApplicativoServerService> {
    private static final long serialVersionUID = 8645779291901248165L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private DiagnosticiBean diagnosticiBean;

    public void walk(FacesContext context, DataVisitor visitor, Range range, Object argument) throws IOException {
        try {
            if (this.detached) {
                for (Long key : this.wrappedKeys) {
                    this.setRowKey(key);
                    visitor.process(context, (Object)key, argument);
                }
            } else {
                int start = ((SequenceRange)range).getFirstRow();
                int limit = ((SequenceRange)range).getRows();
                this.wrappedKeys = new ArrayList();
                List list = null;
                if (this.diagnosticiBean.isUsaInformazioniArchivio()) {
                    list = this.diagnosticiBean.getTransazioniApplicativoServer().stream().sorted(Comparator.comparing(TransazioneApplicativoServer::getDataRegistrazione).thenComparing(TransazioneApplicativoServer::getConnettoreNome)).skip(start).limit(limit).collect(Collectors.toList());
                } else {
                    ((ITransazioniApplicativoServerService)this.getDataProvider()).setProtocollo(this.diagnosticiBean.getProtocollo());
                    ((ITransazioniApplicativoServerService)this.getDataProvider()).setIdTransazione(this.diagnosticiBean.getIdTransazione());
                    list = ((ITransazioniApplicativoServerService)this.getDataProvider()).findAll(start, limit);
                }
                for (TransazioneApplicativoServerBean r : list) {
                    this.wrappedData.put(r.getId(), r);
                    this.wrappedKeys.add(r.getId());
                    visitor.process(context, (Object)r.getId(), argument);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public int getRowCount() {
        try {
            if (this.rowCount == null) {
                if (this.diagnosticiBean.isUsaInformazioniArchivio()) {
                    this.rowCount = this.diagnosticiBean.getTransazioniApplicativoServer().size();
                } else {
                    ((ITransazioniApplicativoServerService)this.getDataProvider()).setProtocollo(this.diagnosticiBean.getProtocollo());
                    ((ITransazioniApplicativoServerService)this.getDataProvider()).setIdTransazione(this.diagnosticiBean.getIdTransazione());
                    this.rowCount = ((ITransazioniApplicativoServerService)this.getDataProvider()).totalCount();
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.rowCount = 0;
        }
        return this.rowCount;
    }

    public DiagnosticiBean getDiagnosticiBean() {
        return this.diagnosticiBean;
    }

    public void setDiagnosticiBean(DiagnosticiBean diagnosticiBean) {
        this.diagnosticiBean = diagnosticiBean;
    }
}

