/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.bean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.search.AccordoServizioParteSpecifica;
import org.openspcoop2.core.commons.search.IdAccordoServizioParteComune;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.transazioni.utils.ProjectInfo;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.monitor.engine.condition.EsitoUtils;
import org.openspcoop2.monitor.engine.config.ricerche.ConfigurazioneRicerca;
import org.openspcoop2.monitor.engine.dynamic.DynamicFactory;
import org.openspcoop2.monitor.engine.dynamic.IDynamicFilter;
import org.openspcoop2.monitor.engine.dynamic.IDynamicValidator;
import org.openspcoop2.monitor.sdk.condition.Context;
import org.openspcoop2.monitor.sdk.condition.IFilter;
import org.openspcoop2.monitor.sdk.constants.CRUDType;
import org.openspcoop2.monitor.sdk.constants.SearchType;
import org.openspcoop2.monitor.sdk.exceptions.SearchException;
import org.openspcoop2.monitor.sdk.exceptions.ValidationException;
import org.openspcoop2.monitor.sdk.parameters.Parameter;
import org.openspcoop2.protocol.sdk.builder.EsitoTransazione;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.web.monitor.core.bean.AbstractDateSearchForm;
import org.openspcoop2.web.monitor.core.bean.ApplicationBean;
import org.openspcoop2.web.monitor.core.bean.BaseSearchForm;
import org.openspcoop2.web.monitor.core.constants.CaseSensitiveMatch;
import org.openspcoop2.web.monitor.core.constants.Costanti;
import org.openspcoop2.web.monitor.core.constants.ModalitaRicercaTransazioni;
import org.openspcoop2.web.monitor.core.constants.TipoMatch;
import org.openspcoop2.web.monitor.core.constants.TipologiaRicerca;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.dynamic.Ricerche;
import org.openspcoop2.web.monitor.core.dynamic.components.BaseComponent;
import org.openspcoop2.web.monitor.core.filters.BrowserFilter;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.ricerche.ModuloRicerca;
import org.openspcoop2.web.monitor.core.utils.BrowserInfo;
import org.openspcoop2.web.monitor.core.utils.MessageManager;
import org.openspcoop2.web.monitor.core.utils.MessageUtils;
import org.openspcoop2.web.monitor.transazioni.bean.ArchivioZipFileUploadBean;
import org.openspcoop2.web.monitor.transazioni.constants.TransazioniCostanti;
import org.openspcoop2.web.monitor.transazioni.core.ArchivioZipManager;
import org.openspcoop2.web.monitor.transazioni.core.exception.ArchivioZipException;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniService;
import org.richfaces.model.Ordering;
import org.slf4j.Logger;

public class TransazioniSearchForm
extends BaseSearchForm
implements Context,
Cloneable {
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private boolean ricercaPerIdApplicativo = false;
    private ITransazioniService transazioniService;
    private String nomeStato;
    private String nomeRisorsa;
    private String valoreRisorsa;
    private String evento;
    private String codiceRisposta;
    private TipoMatch ricercaLiberaMatchingType = TipoMatch.LIKE;
    private CaseSensitiveMatch ricercaLiberaCaseSensitiveType = CaseSensitiveMatch.INSENSITIVE;
    private String ricercaLiberaSoggettoLocale;
    private String ricercaLiberaSoggettoRemoto;
    private String ricercaLiberaGruppo;
    private String ricercaLiberaApi;
    private String ricercaLiberaServizio;
    private String ricercaLiberaAzione;
    private String ricercaLiberaApplicativo;
    private String ricercaLiberaIdentificativoAutenticato;
    private String ricercaLiberaIndirizzoIP;
    private String ricercaLiberaApplicativoToken;
    private String ricercaLiberaTokenIssuer;
    private String ricercaLiberaTokenSubject;
    private String ricercaLiberaTokenClientID;
    private String ricercaLiberaTokenUsername;
    private String ricercaLiberaTokenEmail;
    private String ricercaLiberaPdndOrganization;
    private String ricercaLiberaIdApplicativo;
    private Map<String, Ricerche> tabellaRicerchePersonalizzate = new HashMap<String, Ricerche>();
    private List<Parameter<?>> ricercaSelezionataParameters = new ArrayList();
    private static String default_modalitaRicercaStorico = ModalitaRicercaTransazioni.ANDAMENTO_TEMPORALE.getValue();
    private String modalitaRicercaStorico = default_modalitaRicercaStorico;
    private int livelloRicerca = ModalitaRicercaTransazioni.getLivello((String)this.modalitaRicercaStorico);
    private boolean backRicerca = false;
    private boolean integrationManagerEnabled = false;
    private boolean visualizzaStoricoCustomEnabled = false;
    private boolean visualizzaStoricoCustomColonnaRuoloTransazioneEnabled = false;
    private boolean visualizzaLiveCustomEnabled = false;
    private boolean visualizzaLiveCustomColonnaRuoloTransazioneEnabled = false;
    private boolean visualizzaConsegneMultipleCustomEnabled = false;
    private ArchivioZipFileUploadBean archivioZip = null;
    private String idFiles = null;
    private ArchivioZipManager archivioZipManager = new ArchivioZipManager();
    private static List<String> elencoFieldsRicercaDaIgnorare = new ArrayList<String>();
    private TipoMatch correlazioneApplicativaMatchingType = TipoMatch.EQUALS;
    private CaseSensitiveMatch correlazioneApplicativaCaseSensitiveType = CaseSensitiveMatch.SENSITIVE;
    private String oldNomeStato;
    private String oldNomeRisorsa;

    public TransazioniSearchForm() {
        try {
            PddMonitorProperties pddMonitorProperties = PddMonitorProperties.getInstance((Logger)log);
            this.initIdClusterAndCanali(pddMonitorProperties);
            this.getSortOrders().put("dataIngressoRichiesta", Ordering.DESCENDING);
            this.getSortOrders().put("latenzaTotale", Ordering.UNSORTED);
            this.getSortOrders().put("latenzaServizio", Ordering.UNSORTED);
            this.setUseCount(pddMonitorProperties.isAttivoUtilizzaCountStoricoTransazioni());
            this.modalitaRicercaStorico = default_modalitaRicercaStorico;
            this.setLivelloRicerca(ModalitaRicercaTransazioni.getLivello((String)this.modalitaRicercaStorico));
            this.integrationManagerEnabled = pddMonitorProperties.isAttivoTransazioniIntegrationManager();
            BrowserInfo browserInfo = ApplicationBean.getInstance().getBrowserInfo();
            this.visualizzaStoricoCustomEnabled = pddMonitorProperties.isAttivoUtilizzaVisualizzazioneCustomTransazioni() && BrowserFilter.abilitaVisualizzazioneTransazioniCustom((BrowserInfo)browserInfo);
            this.visualizzaStoricoCustomColonnaRuoloTransazioneEnabled = this.visualizzaStoricoCustomEnabled && pddMonitorProperties.isAttivoVisualizzaColonnaRuoloTransazioneVisualizzazioneCustomTransazioni();
            this.visualizzaLiveCustomEnabled = pddMonitorProperties.isAttivoUtilizzaVisualizzazioneCustomLive() && BrowserFilter.abilitaVisualizzazioneTransazioniCustom((BrowserInfo)browserInfo);
            this.visualizzaLiveCustomColonnaRuoloTransazioneEnabled = this.visualizzaLiveCustomEnabled && pddMonitorProperties.isAttivoVisualizzaColonnaRuoloTransazioneVisualizzazioneCustomLive();
            this.visualizzaConsegneMultipleCustomEnabled = pddMonitorProperties.isAttivoUtilizzaVisualizzazioneCustomConsegneMultiple() && BrowserFilter.abilitaVisualizzazioneTransazioniCustom((BrowserInfo)browserInfo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public TransazioniSearchForm(boolean useInBatch) {
        super(useInBatch);
        try {
            PddMonitorProperties pddMonitorProperties = PddMonitorProperties.getInstance((Logger)log);
            this.initIdClusterAndCanali(pddMonitorProperties);
            this.getSortOrders().put("dataIngressoRichiesta", Ordering.DESCENDING);
            this.getSortOrders().put("latenzaTotale", Ordering.UNSORTED);
            this.getSortOrders().put("latenzaServizio", Ordering.UNSORTED);
            this.setUseCount(pddMonitorProperties.isAttivoUtilizzaCountStoricoTransazioni());
            this.modalitaRicercaStorico = default_modalitaRicercaStorico;
            this.setLivelloRicerca(ModalitaRicercaTransazioni.getLivello((String)this.modalitaRicercaStorico));
            this.integrationManagerEnabled = pddMonitorProperties.isAttivoTransazioniIntegrationManager();
            BrowserInfo browserInfo = ApplicationBean.getInstance().getBrowserInfo();
            this.visualizzaStoricoCustomEnabled = pddMonitorProperties.isAttivoUtilizzaVisualizzazioneCustomTransazioni() && BrowserFilter.abilitaVisualizzazioneTransazioniCustom((BrowserInfo)browserInfo);
            this.visualizzaStoricoCustomColonnaRuoloTransazioneEnabled = this.visualizzaStoricoCustomEnabled && pddMonitorProperties.isAttivoVisualizzaColonnaRuoloTransazioneVisualizzazioneCustomTransazioni();
            this.visualizzaLiveCustomEnabled = pddMonitorProperties.isAttivoUtilizzaVisualizzazioneCustomLive() && BrowserFilter.abilitaVisualizzazioneTransazioniCustom((BrowserInfo)browserInfo);
            this.visualizzaLiveCustomColonnaRuoloTransazioneEnabled = this.visualizzaLiveCustomEnabled && pddMonitorProperties.isAttivoVisualizzaColonnaRuoloTransazioneVisualizzazioneCustomLive();
            this.visualizzaConsegneMultipleCustomEnabled = pddMonitorProperties.isAttivoUtilizzaVisualizzazioneCustomConsegneMultiple() && BrowserFilter.abilitaVisualizzazioneTransazioniCustom((BrowserInfo)browserInfo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public List<SelectItem> getProtocolli() throws Exception {
        if (ModalitaRicercaTransazioni.RICERCA_LIBERA.getValue().equals(this.modalitaRicercaStorico)) {
            List lista = super.getProtocolli();
            if (lista.size() > 1) {
                this.protocolli = new ArrayList();
                this.protocolli.add(new SelectItem((Object)"qualsiasi", "Tutti"));
                this.protocolli.addAll(lista);
                return this.protocolli;
            }
            return lista;
        }
        return super.getProtocolli();
    }

    public List<SelectItem> getEsitiDettaglio() {
        return super.getEsitiDettaglio(false);
    }

    public List<SelectItem> getEsitiDettagliPersonalizzati() {
        return super.getEsitiDettagliPersonalizzati(false);
    }

    public boolean isIntegrationManagerEnabled() {
        return this.integrationManagerEnabled;
    }

    public void setTransazioniService(ITransazioniService transazioniService) {
        this.transazioniService = transazioniService;
    }

    public boolean isLive() {
        return "Live".equals(this.periodo);
    }

    public String getPrintPeriodo() {
        if (this.isLive()) {
            try {
                PddMonitorProperties monitorProperties = PddMonitorProperties.getInstance((Logger)log);
                Integer liveUltimiGiorni = monitorProperties.getTransazioniLiveUltimiGiorni();
                Date inizio = null;
                if (liveUltimiGiorni != null && liveUltimiGiorni != 0) {
                    int numeroGiorni = liveUltimiGiorni;
                    if (numeroGiorni > 0) {
                        numeroGiorni *= -1;
                    }
                    Calendar c = Calendar.getInstance();
                    c.set(11, 0);
                    c.set(12, 0);
                    c.set(13, 0);
                    c.set(14, 0);
                    c.add(5, numeroGiorni);
                    inizio = c.getTime();
                }
                Date fine = null;
                return AbstractDateSearchForm.printPeriodo(inizio, fine);
            }
            catch (Exception e) {
                log.error("Errore durante il calcolo dell'intervallo: " + e.getMessage(), (Throwable)e);
                return "";
            }
        }
        return super.getPrintPeriodo();
    }

    protected String ripulisciValori() {
        String oldModalita = this.getModalitaRicercaStorico();
        String oldRiconoscimento = this.getRiconoscimento();
        boolean oldIsLive = this.isLive();
        this.initSearchListener(null);
        if (oldModalita != null && !"".equals(oldModalita)) {
            this.setModalitaRicercaStorico(oldModalita);
        }
        if (oldModalita != null && !"".equals(oldModalita) && !oldIsLive) {
            this.setRiconoscimento(oldRiconoscimento);
        }
        if (!oldIsLive && TipologiaRicerca.all.equals((Object)this.getDefaultTipologiaRicercaEnum())) {
            this.setTipologiaRicerca("--");
        }
        this.setBackRicerca(false);
        this.archivioZip.clear();
        this.archivioZipManager.clear();
        return null;
    }

    public void ripulisciLive() {
        this.ripulisci();
        this.periodo = "Live";
        this.setTipologiaRicerca("--");
    }

    public void setPeriodo(String periodo) {
        super.setPeriodo(periodo);
        if (this.isLive()) {
            this.setTipologiaRicerca("--");
        }
    }

    public void initSearchListener(ActionEvent ae) {
        super.initSearchListener(ae);
        this.modalitaRicercaStorico = default_modalitaRicercaStorico;
        this.getSortOrders().put("dataIngressoRichiesta", Ordering.DESCENDING);
        this.getSortOrders().put("latenzaTotale", Ordering.UNSORTED);
        this.getSortOrders().put("latenzaServizio", Ordering.UNSORTED);
        this.setPeriodoDefault("Ultima ora");
        this.setPeriodo("Ultima ora");
        this._setPeriodo();
        this.initSearchForm();
        this.correlazioneApplicativaMatchingType = TipoMatch.EQUALS;
        this.correlazioneApplicativaCaseSensitiveType = CaseSensitiveMatch.SENSITIVE;
        this.ricercaLiberaMatchingType = TipoMatch.LIKE;
        this.ricercaLiberaCaseSensitiveType = CaseSensitiveMatch.INSENSITIVE;
        this.ricercaLiberaSoggettoLocale = null;
        this.ricercaLiberaSoggettoRemoto = null;
        this.ricercaLiberaGruppo = null;
        this.ricercaLiberaApi = null;
        this.ricercaLiberaServizio = null;
        this.ricercaLiberaAzione = null;
        this.ricercaLiberaApplicativo = null;
        this.ricercaLiberaIdentificativoAutenticato = null;
        this.ricercaLiberaIndirizzoIP = null;
        this.ricercaLiberaApplicativoToken = null;
        this.ricercaLiberaTokenIssuer = null;
        this.ricercaLiberaTokenSubject = null;
        this.ricercaLiberaTokenClientID = null;
        this.ricercaLiberaTokenUsername = null;
        this.ricercaLiberaTokenEmail = null;
        this.ricercaLiberaPdndOrganization = null;
        this.ricercaLiberaIdApplicativo = null;
        this.executeQuery = false;
        this.archivioZip.clear();
        this.archivioZipManager.clear();
    }

    public String getModalitaRicercaStorico() {
        if (this.modalitaRicercaStorico == null || "".equals(this.modalitaRicercaStorico)) {
            this.modalitaRicercaStorico = default_modalitaRicercaStorico;
        }
        return this.modalitaRicercaStorico;
    }

    public void setModalitaRicercaStorico(String modalitaRicercaStorico) {
        this.modalitaRicercaStorico = modalitaRicercaStorico;
        if (ModalitaRicercaTransazioni.RICERCA_LIBERA.getValue().equals(this.modalitaRicercaStorico) && this.isShowListaProtocolli()) {
            this.setProtocollo("qualsiasi");
        }
        this.setLivelloRicerca(ModalitaRicercaTransazioni.getLivello((String)this.modalitaRicercaStorico));
    }

    public boolean isRicercaLiberaTuttiProfili() {
        return ModalitaRicercaTransazioni.RICERCA_LIBERA.getValue().equals(this.modalitaRicercaStorico) && this.isAllProtocol();
    }

    public String getTipoStoricoLabel() {
        if (this.getModalitaRicercaStorico() != null) {
            ModalitaRicercaTransazioni t = ModalitaRicercaTransazioni.getFromString((String)this.getModalitaRicercaStorico());
            switch (t) {
                case ANDAMENTO_TEMPORALE: {
                    return MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.temporale.ricercaTemporale.breadcrumb");
                }
                case RICERCA_LIBERA: {
                    return MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.temporale.ricercaLibera.breadcrumb");
                }
                case ESAMINA_ARCHIVIO_ZIP: {
                    return MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.temporale.esaminaArchivioZip.breadcrumb");
                }
                case MITTENTE_TOKEN_INFO: {
                    return MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.mittente.ricercaTokenInfo.breadcrumb");
                }
                case MITTENTE_SOGGETTO: {
                    return MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.mittente.ricercaSoggetto.breadcrumb");
                }
                case MITTENTE_APPLICATIVO: {
                    return MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.mittente.ricercaApplicativo.breadcrumb");
                }
                case MITTENTE_IDENTIFICATIVO_AUTENTICATO: {
                    return MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.mittente.ricercaIdentificativoAutenticato.breadcrumb");
                }
                case MITTENTE_INDIRIZZO_IP: {
                    return MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.mittente.ricercaIndirizzoIP.breadcrumb");
                }
                case ID_APPLICATIVO_BASE: {
                    return MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.id.ricercaIdentificativoApplicativo.lvl2.ricercaBase.breadcrumb");
                }
                case ID_APPLICATIVO_AVANZATA: {
                    return MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.id.ricercaIdentificativoApplicativo.lvl2.ricercaLibera.breadcrumb");
                }
                case ID_MESSAGGIO: {
                    return MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.id.ricercaIdentificativoMessaggio.breadcrumb");
                }
                case ID_TOKEN: {
                    return MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.id.ricercaIdentificativoToken.breadcrumb");
                }
                case PURPOSE_ID: {
                    return MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.id.ricercaPurposeId.breadcrumb");
                }
            }
            return MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.id.ricercaIdentificativoTransazione.breadcrumb");
        }
        return "Visualizza Transazioni";
    }

    public String getTipoStoricoLivello2Label() {
        if (this.getModalitaRicercaStorico() != null) {
            ModalitaRicercaTransazioni t = ModalitaRicercaTransazioni.getFromString((String)this.getModalitaRicercaStorico());
            switch (t) {
                case ID_APPLICATIVO_BASE: 
                case ID_APPLICATIVO_AVANZATA: {
                    return MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.id.ricercaIdentificativoApplicativo.breadcrumb");
                }
            }
            return MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.id.ricercaIdentificativoTransazione.breadcrumb");
        }
        return "Visualizza Transazioni";
    }

    public boolean isShowRicercaPanel() {
        if (this.getModalitaRicercaStorico() != null) {
            ModalitaRicercaTransazioni t = ModalitaRicercaTransazioni.getFromString((String)this.getModalitaRicercaStorico());
            switch (t) {
                case ANDAMENTO_TEMPORALE: 
                case RICERCA_LIBERA: 
                case MITTENTE_TOKEN_INFO: 
                case MITTENTE_SOGGETTO: 
                case MITTENTE_APPLICATIVO: 
                case MITTENTE_IDENTIFICATIVO_AUTENTICATO: 
                case MITTENTE_INDIRIZZO_IP: 
                case ID_APPLICATIVO_AVANZATA: {
                    return true;
                }
                case ESAMINA_ARCHIVIO_ZIP: 
                case ID_APPLICATIVO_BASE: 
                case ID_MESSAGGIO: 
                case ID_TOKEN: 
                case PURPOSE_ID: 
                case ID_TRANSAZIONE: 
                case LIVE: {
                    return false;
                }
            }
        }
        return false;
    }

    public boolean isShowButtonNuovaRicerca() {
        if (!this.isLive() && this.getModalitaRicercaStorico() != null) {
            ModalitaRicercaTransazioni t = ModalitaRicercaTransazioni.getFromString((String)this.getModalitaRicercaStorico());
            switch (t) {
                case ANDAMENTO_TEMPORALE: 
                case RICERCA_LIBERA: 
                case ESAMINA_ARCHIVIO_ZIP: 
                case MITTENTE_TOKEN_INFO: 
                case MITTENTE_SOGGETTO: 
                case MITTENTE_APPLICATIVO: 
                case MITTENTE_IDENTIFICATIVO_AUTENTICATO: 
                case MITTENTE_INDIRIZZO_IP: 
                case ID_APPLICATIVO_AVANZATA: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isShowMittentePanel() {
        if (this.getModalitaRicercaStorico() != null) {
            ModalitaRicercaTransazioni t = ModalitaRicercaTransazioni.getFromString((String)this.getModalitaRicercaStorico());
            switch (t) {
                case ANDAMENTO_TEMPORALE: 
                case RICERCA_LIBERA: 
                case ESAMINA_ARCHIVIO_ZIP: {
                    return false;
                }
                case MITTENTE_TOKEN_INFO: 
                case MITTENTE_SOGGETTO: 
                case MITTENTE_APPLICATIVO: 
                case MITTENTE_IDENTIFICATIVO_AUTENTICATO: 
                case MITTENTE_INDIRIZZO_IP: {
                    return true;
                }
                case ID_APPLICATIVO_BASE: 
                case ID_APPLICATIVO_AVANZATA: 
                case ID_MESSAGGIO: 
                case ID_TOKEN: 
                case PURPOSE_ID: 
                case ID_TRANSAZIONE: 
                case LIVE: {
                    return false;
                }
            }
        }
        return false;
    }

    protected boolean isTipologiaRicercaEntrambiEnabled() {
        if (this.isLive()) {
            return true;
        }
        if (this.getModalitaRicercaStorico() != null) {
            ModalitaRicercaTransazioni t = ModalitaRicercaTransazioni.getFromString((String)this.getModalitaRicercaStorico());
            switch (t) {
                case ANDAMENTO_TEMPORALE: 
                case RICERCA_LIBERA: 
                case MITTENTE_IDENTIFICATIVO_AUTENTICATO: 
                case MITTENTE_INDIRIZZO_IP: 
                case ID_APPLICATIVO_AVANZATA: 
                case LIVE: {
                    return true;
                }
                case MITTENTE_TOKEN_INFO: 
                case MITTENTE_SOGGETTO: 
                case MITTENTE_APPLICATIVO: {
                    return super.isTipologiaRicercaEntrambiEnabled();
                }
                case ID_APPLICATIVO_BASE: 
                case ID_MESSAGGIO: 
                case ID_TOKEN: 
                case PURPOSE_ID: 
                case ID_TRANSAZIONE: {
                    return super.isTipologiaRicercaEntrambiEnabled();
                }
                case ESAMINA_ARCHIVIO_ZIP: {
                    return false;
                }
            }
        }
        return super.isTipologiaRicercaEntrambiEnabled();
    }

    public boolean isShowDatiTransazionePanel() {
        if (this.getModalitaRicercaStorico() != null) {
            ModalitaRicercaTransazioni t = ModalitaRicercaTransazioni.getFromString((String)this.getModalitaRicercaStorico());
            switch (t) {
                case ANDAMENTO_TEMPORALE: 
                case RICERCA_LIBERA: 
                case ESAMINA_ARCHIVIO_ZIP: 
                case MITTENTE_TOKEN_INFO: 
                case MITTENTE_SOGGETTO: 
                case MITTENTE_APPLICATIVO: 
                case MITTENTE_IDENTIFICATIVO_AUTENTICATO: 
                case MITTENTE_INDIRIZZO_IP: 
                case ID_APPLICATIVO_AVANZATA: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public List<SelectItem> getTipologieRicerca() {
        if (this.isLive()) {
            return super.getTipologieRicerca();
        }
        if (this.getModalitaRicercaStorico() == null) {
            return super.getTipologieRicerca();
        }
        ModalitaRicercaTransazioni t = ModalitaRicercaTransazioni.getFromString((String)this.getModalitaRicercaStorico());
        if (!ModalitaRicercaTransazioni.MITTENTE_SOGGETTO.equals((Object)t)) {
            return super.getTipologieRicerca();
        }
        ArrayList<SelectItem> listaTipologie = new ArrayList<SelectItem>();
        listaTipologie.add(new SelectItem((Object)TipologiaRicerca.ingresso.toString(), "Erogazione"));
        return listaTipologie;
    }

    public void setRicercaPerIdApplicativo(boolean ricercaPerIdApplicativo) {
        this.ricercaPerIdApplicativo = ricercaPerIdApplicativo;
    }

    public boolean getRicercaPerIdApplicativo() {
        return this.ricercaPerIdApplicativo;
    }

    public void ricercaPerIDApplicativoSelected(ActionEvent ae) {
        super.setIdCorrelazioneApplicativa(null);
    }

    private Map<String, Ricerche> leggiRicerche() {
        try {
            if (this.tabellaRicerchePersonalizzate != null && this.tabellaRicerchePersonalizzate.size() > 0) {
                return this.tabellaRicerchePersonalizzate;
            }
            IDServizio idServizio = Utility.parseServizioSoggetto((String)this.getNomeServizio());
            String nomeServizio = idServizio.getNome();
            AccordoServizioParteSpecifica aspsFromValues = this.getAspsFromNomeServizio(idServizio);
            IdAccordoServizioParteComune idAccordoServizioParteComune = aspsFromValues.getIdAccordoServizioParteComune();
            Integer ver = idAccordoServizioParteComune.getVersione();
            String nomeSoggettoReferente = null;
            String tipoSoggettoReferente = null;
            if (idAccordoServizioParteComune.getIdSoggetto() != null) {
                nomeSoggettoReferente = idAccordoServizioParteComune.getIdSoggetto().getNome();
                tipoSoggettoReferente = idAccordoServizioParteComune.getIdSoggetto().getTipo();
            }
            String nomeAS = idAccordoServizioParteComune.getNome();
            IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromValues(nomeAS, tipoSoggettoReferente, nomeSoggettoReferente, ver);
            String nomeServizioKey = aspsFromValues.getPortType() != null ? aspsFromValues.getPortType() : nomeServizio;
            List<ConfigurazioneRicerca> l = this.transazioniService.getRicercheByValues(idAccordo, nomeServizioKey, this.getNomeAzione());
            Ricerche ricerche = new Ricerche();
            if (l != null && l.size() > 0) {
                for (ConfigurazioneRicerca r : l) {
                    ricerche.addRicerca(r);
                }
                this.tabellaRicerchePersonalizzate.put(nomeServizioKey, ricerche);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return this.tabellaRicerchePersonalizzate;
    }

    public void validateSelectedPlugin(FacesContext context, UIComponent component, Object value) {
        if (value != null) {
            String nomeRicerca = (String)value;
            ConfigurazioneRicerca r = this.getRicerchePersonalizzate().getRicercaByLabel(nomeRicerca);
            try {
                if (r != null) {
                    DynamicFactory.getInstance().newDynamicLoader(r.getPlugin().getTipoPlugin(), r.getPlugin().getTipo(), r.getPlugin().getClassName(), log);
                }
            }
            catch (SearchException e) {
                String msg = "Impossibile selezionare la ricerca (" + nomeRicerca + "). La classe indicata [" + r.getPlugin().getClassName() + "] non esiste.";
                ((UIInput)component).setValid(false);
                context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, null));
            }
        }
    }

    public List<Parameter<?>> getRicercaSelezionataParameters() {
        if (this.ricercaSelezionataParameters != null && this.ricercaSelezionataParameters.size() > 0) {
            return this.ricercaSelezionataParameters;
        }
        try {
            if (this.getRicercaSelezionata() != null) {
                ConfigurazioneRicerca r = this.getRicercaSelezionata();
                this.ricercaSelezionataParameters = this.transazioniService.instanceParameters(r, this);
                if (this.ricercaSelezionataParameters != null) {
                    for (Parameter<?> searchParam : this.ricercaSelezionataParameters) {
                        ((BaseComponent)searchParam).setContext((Context)this);
                    }
                }
            }
        }
        catch (SearchException e) {
            MessageUtils.addErrorMsg((String)e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return this.ricercaSelezionataParameters;
    }

    public boolean isRicercaSelezionataParametersRequired() {
        if (this.ricercaSelezionataParameters != null && this.ricercaSelezionataParameters.size() > 0) {
            try {
                for (Parameter<?> searchParam : this.ricercaSelezionataParameters) {
                    if (!searchParam.getRendering().isRequired()) continue;
                    return true;
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public void initSearchForm() {
        this.tabellaRicerchePersonalizzate = new HashMap<String, Ricerche>();
        this.ricercaSelezionataParameters = new ArrayList();
        this.setRicerchePersonalizzate(null);
        this.setRicercaSelezionata(null);
        this.setFiltro(null);
        this.setNomeRicercaPersonalizzata(null);
        this.nomeRisorsa = null;
        this.valoreRisorsa = null;
        this.nomeStato = null;
        this.evento = null;
        this.codiceRisposta = null;
        this.clusterId = null;
        this.canale = null;
    }

    public void tipologiaRicercaListener(ActionEvent ae) {
        super.tipologiaRicercaListener(ae);
        this.setRicerchePersonalizzate(null);
        this.setNomeRicercaPersonalizzata(null);
        this.setFiltro(null);
        this.nomeStato = null;
        this.nomeRisorsa = null;
        this.valoreRisorsa = null;
        this.evento = null;
        this.codiceRisposta = null;
        if (!this.isLive()) {
            this.updateRiconoscimentoByModalitaRicercaStorico();
        }
    }

    public void updateRiconoscimentoByModalitaRicercaStorico() {
        ModalitaRicercaTransazioni t = ModalitaRicercaTransazioni.getFromString((String)this.getModalitaRicercaStorico());
        switch (t) {
            case MITTENTE_TOKEN_INFO: {
                this.setRiconoscimento("tokenInfo");
                break;
            }
            case MITTENTE_SOGGETTO: {
                this.setRiconoscimento("soggetto");
                break;
            }
            case MITTENTE_APPLICATIVO: {
                this.setRiconoscimento("applicativo");
                break;
            }
            case MITTENTE_IDENTIFICATIVO_AUTENTICATO: {
                this.setRiconoscimento("identificativoAutenticato");
                break;
            }
            case MITTENTE_INDIRIZZO_IP: {
                this.setRiconoscimento("ip");
                break;
            }
        }
    }

    public void periodoListener(ActionEvent ae) {
        super.periodoListener(ae);
    }

    public void servizioSelected(ActionEvent ae) {
        try {
            super.servizioSelected(ae);
            this.nomeRisorsa = null;
            this.valoreRisorsa = null;
            this.nomeStato = null;
            this.tabellaRicerchePersonalizzate = new HashMap<String, Ricerche>();
            if (this.isRicerchePersonalizzateAttive()) {
                this.ricercaSelezionataParameters = new ArrayList();
                this.setRicercaSelezionata(null);
                this.setRicerchePersonalizzate(null);
                this.setFiltro(null);
                IDServizio idServizio = Utility.parseServizioSoggetto((String)this.getNomeServizio());
                String nomeServizio = idServizio.getNome();
                AccordoServizioParteSpecifica aspsFromValues = this.getAspsFromNomeServizio(idServizio);
                String nomeServizioKey = aspsFromValues.getPortType() != null ? aspsFromValues.getPortType() : nomeServizio;
                Ricerche r = this.leggiRicerche().get(nomeServizioKey);
                if (r != null) {
                    List ricerche = r.getRicerche();
                    for (ConfigurazioneRicerca ricerca : ricerche) {
                        List<Parameter<?>> params = null;
                        try {
                            params = this.transazioniService.instanceParameters(ricerca, this);
                            if (params == null || params.size() <= 0) continue;
                            for (Parameter<?> searchParam : params) {
                                ((BaseComponent)searchParam).setContext((Context)this);
                            }
                        }
                        catch (SearchException e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
                this.setRicerchePersonalizzate(r);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void azioneSelected(ActionEvent ae) {
        super.azioneSelected(ae);
        this.nomeRisorsa = null;
        this.valoreRisorsa = null;
        this.nomeStato = null;
        this.tabellaRicerchePersonalizzate = new HashMap<String, Ricerche>();
        try {
            if (this.isRicerchePersonalizzateAttive()) {
                IDServizio idServizio = Utility.parseServizioSoggetto((String)this.getNomeServizio());
                String nomeServizio = idServizio.getNome();
                AccordoServizioParteSpecifica aspsFromValues = this.getAspsFromNomeServizio(idServizio);
                String nomeServizioKey = aspsFromValues.getPortType() != null ? aspsFromValues.getPortType() : nomeServizio;
                Ricerche r = this.leggiRicerche().get(nomeServizioKey);
                if (r != null) {
                    List ricerche = r.getRicerche();
                    for (ConfigurazioneRicerca ricerca : ricerche) {
                        List<Parameter<?>> params = null;
                        try {
                            params = this.transazioniService.instanceParameters(ricerca, this);
                            if (params == null || params.size() <= 0) continue;
                            for (Parameter<?> searchParam : params) {
                                ((BaseComponent)searchParam).setContext((Context)this);
                            }
                        }
                        catch (SearchException e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
                this.setRicerchePersonalizzate(r);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void statoSelected(ActionEvent ae) {
        if (this.nomeStato != null) {
            if (this.oldNomeStato != null) {
                if (!this.nomeStato.equals(this.oldNomeStato)) {
                    this.nomeRisorsa = null;
                    this.valoreRisorsa = null;
                    this.oldNomeStato = this.nomeStato;
                }
            } else {
                this.nomeRisorsa = null;
                this.valoreRisorsa = null;
                this.oldNomeStato = this.nomeStato;
            }
        } else if (this.oldNomeStato != null) {
            this.nomeRisorsa = null;
            this.valoreRisorsa = null;
            this.oldNomeStato = this.nomeStato;
        }
    }

    public void risorsaSelected(ActionEvent ae) {
        if (this.nomeRisorsa != null) {
            if (this.oldNomeRisorsa != null) {
                if (!this.nomeRisorsa.equals(this.oldNomeRisorsa)) {
                    this.valoreRisorsa = null;
                    this.oldNomeRisorsa = this.nomeRisorsa;
                }
            } else {
                this.oldNomeRisorsa = this.nomeRisorsa;
            }
        }
    }

    protected String eseguiAggiorna() {
        this.setAggiornamentoDatiAbilitato(true);
        return this._filtra(true);
    }

    protected String eseguiFiltra() {
        this.setAggiornamentoDatiAbilitato(true);
        return this._filtra(false);
    }

    private String _filtra(boolean mantieniDataRicerca) {
        try {
            boolean sezioneDatiMittente;
            ModalitaRicercaTransazioni ricerca;
            this.getSortOrders().put("dataIngressoRichiesta", Ordering.DESCENDING);
            this.getSortOrders().put("latenzaTotale", Ordering.UNSORTED);
            this.getSortOrders().put("latenzaServizio", Ordering.UNSORTED);
            if (this.getPeriodo().equals("Personalizzato")) {
                if (this.getDataInizio() == null) {
                    MessageUtils.addErrorMsg((String)"Selezionare Data Inizio");
                    return null;
                }
                if (this.getDataFine() == null) {
                    MessageUtils.addErrorMsg((String)"Selezionare Data Fine");
                    return null;
                }
            }
            this.setBackRicerca(false);
            if (!this.isLive() && (ricerca = ModalitaRicercaTransazioni.getFromString((String)this.getModalitaRicercaStorico())) != null) {
                switch (ricerca) {
                    case ID_APPLICATIVO_AVANZATA: {
                        if (!StringUtils.isEmpty((CharSequence)this.getIdCorrelazioneApplicativa())) break;
                        MessageUtils.addErrorMsg((String)"Indicare un identificativo applicativo");
                        return null;
                    }
                    case ID_APPLICATIVO_BASE: {
                        if (!StringUtils.isEmpty((CharSequence)this.getIdCorrelazioneApplicativa())) break;
                        MessageUtils.addErrorMsg((String)"Indicare un identificativo applicativo");
                        return null;
                    }
                    case ID_MESSAGGIO: {
                        if (!StringUtils.isEmpty((CharSequence)this.getIdEgov())) break;
                        MessageUtils.addErrorMsg((String)"Indicare un identificativo messaggio");
                        return null;
                    }
                    case ID_TRANSAZIONE: {
                        if (!StringUtils.isEmpty((CharSequence)this.getIdTransazione())) break;
                        MessageUtils.addErrorMsg((String)"Indicare un identificativo transazione");
                        return null;
                    }
                    case ESAMINA_ARCHIVIO_ZIP: {
                        try {
                            this.archivioZipManager.leggiArchivio(this.archivioZip);
                            break;
                        }
                        catch (ArchivioZipException e) {
                            MessageUtils.addErrorMsg((String)e.getMessage());
                            return null;
                        }
                    }
                    case ID_TOKEN: {
                        if (!StringUtils.isEmpty((CharSequence)this.getIdToken())) break;
                        MessageUtils.addErrorMsg((String)"Indicare un identificativo token");
                        return null;
                    }
                    case PURPOSE_ID: {
                        if (!StringUtils.isEmpty((CharSequence)this.getPurposeId())) break;
                        MessageUtils.addErrorMsg((String)"Indicare la finalita della transazione");
                        return null;
                    }
                }
            }
            if (!(sezioneDatiMittente = this.validaSezioneDatiMittente())) {
                return null;
            }
            if (this.getEsitoGruppo() != null && EsitoUtils.ALL_PERSONALIZZATO_VALUE.intValue() == this.getEsitoGruppo().intValue() && (this.getEsitoDettaglioPersonalizzato() == null || this.getEsitoDettaglioPersonalizzato().length <= 0)) {
                MessageUtils.addErrorMsg((String)"Selezionare almeno un esito di dettaglio");
                return null;
            }
            if (!mantieniDataRicerca) {
                this.aggiornaNuovaDataRicerca();
                this._setPeriodo();
            } else {
                this.congelaDataRicerca();
            }
            if (StringUtils.isNotEmpty((CharSequence)this.nomeRisorsa) && StringUtils.isEmpty((CharSequence)this.valoreRisorsa)) {
                MessageUtils.addErrorMsg((String)("Indicare un valore per la risorsa '" + this.nomeRisorsa + "'"));
                return null;
            }
            if (this.getRicercaSelezionata() == null) {
                return null;
            }
            IDynamicValidator bv = DynamicFactory.getInstance().newDynamicValidator(this.getRicercaSelezionata().getPlugin().getTipoPlugin(), this.getRicercaSelezionata().getPlugin().getTipo(), this.getRicercaSelezionata().getPlugin().getClassName(), log);
            bv.validate((Context)this);
            IDynamicFilter bf = DynamicFactory.getInstance().newDynamicFilter(this.getRicercaSelezionata().getPlugin().getTipoPlugin(), this.getRicercaSelezionata().getPlugin().getTipo(), this.getRicercaSelezionata().getPlugin().getClassName(), log);
            IFilter f = bf.createConditionFilter((Context)this);
            if (f != null) {
                this.setFiltro(f);
            }
        }
        catch (SearchException re) {
            MessageUtils.addErrorMsg((String)re.getMessage());
            return null;
        }
        catch (ValidationException e) {
            MessageUtils.addErrorMsg((String)e.getMessage());
            Map errors = e.getErrors();
            if (errors != null) {
                Set keys = errors.keySet();
                for (String key : keys) {
                    Parameter<?> sp = this.getParameter(key);
                    String errorMsg = (String)errors.get(key);
                    String label = sp != null ? sp.getRendering().getLabel() : key;
                    MessageUtils.addErrorMsg((String)(label + ": " + errorMsg));
                }
            }
            return null;
        }
        return null;
    }

    public String getAzione() {
        return this.getNomeAzione();
    }

    public String getInterfaccia() {
        return null;
    }

    public TipoPdD getRuolo() {
        return null;
    }

    public EsitoTransazione getEsitoTransazione() {
        Integer esitoDettaglio = this.getEsitoDettaglio();
        if (esitoDettaglio != null && EsitoUtils.ALL_VALUE.intValue() != esitoDettaglio.intValue()) {
            try {
                return EsitiProperties.getInstanceFromProtocolName((Logger)this.getLogger(), (String)this.getProtocollo()).convertToEsitoTransazione(this.getEsitoDettaglio(), this.getEsitoContesto());
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return null;
    }

    public Date getIntervalloInferiore() {
        return this.getDataInizio();
    }

    public Date getIntervalloSuperiore() {
        return this.getDataFine();
    }

    public Parameter<?> getParameter(String paramID) {
        return this.getParameters().get(paramID);
    }

    public Map<String, Parameter<?>> getParameters() {
        TreeMap map = new TreeMap();
        if (this.getRicercaSelezionataParameters() != null) {
            for (Parameter<?> param : this.getRicercaSelezionataParameters()) {
                map.put(param.getId(), param);
            }
        }
        return map;
    }

    public String getTipoServizio() {
        return this.estraiTipoServizioDalServizio();
    }

    public String getServizio() {
        return this.estraiNomeServizioDalServizio();
    }

    public Integer getVersioneServizio() {
        return this.estraiVersioneServizioDalServizio();
    }

    public String getTipoSoggettoDestinatario() {
        return this.getTipoDestinatario();
    }

    public String getSoggettoDestinatario() {
        return this.getNomeDestinatario();
    }

    public String getTipoSoggettoMittente() {
        return this.getTipoMittente();
    }

    public String getSoggettoMittente() {
        return this.getNomeMittente();
    }

    public SearchType getTipoRicerca() {
        if (this.getTipologiaRicercaEnum() != null) {
            switch (this.getTipologiaRicercaEnum()) {
                case ingresso: {
                    return SearchType.EROGAZIONE;
                }
                case uscita: {
                    return SearchType.FRUIZIONE;
                }
            }
            return SearchType.ALL;
        }
        return SearchType.ALL;
    }

    public String getNomeStato() {
        return this.nomeStato;
    }

    public String getNomeRisorsa() {
        return this.nomeRisorsa;
    }

    public void setNomeStato(String nomeStato) {
        if (nomeStato != null && "--".equals(nomeStato)) {
            nomeStato = null;
        }
        this.nomeStato = nomeStato;
    }

    public void setNomeRisorsa(String nomeRisorsa) {
        if (nomeRisorsa != null && "--".equals(nomeRisorsa)) {
            nomeRisorsa = null;
        }
        this.nomeRisorsa = nomeRisorsa;
    }

    public String getValoreRisorsa() {
        return this.valoreRisorsa;
    }

    public void setValoreRisorsa(String valoreRisorsa) {
        this.valoreRisorsa = valoreRisorsa;
    }

    public void ricercaSelezionataListener(ActionEvent ae) {
        super.ricercaSelezionataListener(ae);
        this.ricercaSelezionataParameters = new ArrayList();
        this.setFiltro(null);
    }

    public String getCorrelazioneApplicativaMatchingType() {
        if (this.correlazioneApplicativaMatchingType != null) {
            return this.correlazioneApplicativaMatchingType.name();
        }
        return null;
    }

    public void setCorrelazioneApplicativaMatchingType(String correlazioneApplicativaMatchingType) {
        if (correlazioneApplicativaMatchingType != null) {
            this.correlazioneApplicativaMatchingType = TipoMatch.valueOf((String)correlazioneApplicativaMatchingType);
        }
    }

    public String getCorrelazioneApplicativaCaseSensitiveType() {
        if (this.correlazioneApplicativaCaseSensitiveType != null) {
            return this.correlazioneApplicativaCaseSensitiveType.name();
        }
        return null;
    }

    public void setCorrelazioneApplicativaCaseSensitiveType(String correlazioneApplicativaCaseSensitiveType) {
        if (correlazioneApplicativaCaseSensitiveType != null) {
            this.correlazioneApplicativaCaseSensitiveType = CaseSensitiveMatch.valueOf((String)correlazioneApplicativaCaseSensitiveType);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getEvento() {
        return this.evento;
    }

    public void setEvento(String evento) {
        this.evento = evento;
    }

    public String getCodiceRisposta() {
        return this.codiceRisposta;
    }

    public void setCodiceRisposta(String codiceRisposta) {
        this.codiceRisposta = codiceRisposta;
    }

    public TipiDatabase getDatabaseType() {
        return this._getTipoDatabase((IProjectInfo)ProjectInfo.getInstance());
    }

    public Logger getLogger() {
        return LoggerManager.getPddMonitorCoreLogger();
    }

    public DAOFactory getDAOFactory() {
        try {
            return DAOFactory.getInstance((Logger)LoggerManager.getPddMonitorSqlLogger());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public CRUDType getTipoOperazione() {
        return CRUDType.SEARCH;
    }

    public String getRicercaLiberaMatchingType() {
        if (this.ricercaLiberaMatchingType != null) {
            return this.ricercaLiberaMatchingType.name();
        }
        return null;
    }

    public void setRicercaLiberaMatchingType(String ricercaLiberaMatchingType) {
        if (ricercaLiberaMatchingType != null) {
            this.ricercaLiberaMatchingType = TipoMatch.valueOf((String)ricercaLiberaMatchingType);
        }
    }

    public String getRicercaLiberaCaseSensitiveType() {
        if (this.ricercaLiberaCaseSensitiveType != null) {
            return this.ricercaLiberaCaseSensitiveType.name();
        }
        return null;
    }

    public void setRicercaLiberaCaseSensitiveType(String ricercaLiberaCaseSensitiveType) {
        if (ricercaLiberaCaseSensitiveType != null) {
            this.ricercaLiberaCaseSensitiveType = CaseSensitiveMatch.valueOf((String)ricercaLiberaCaseSensitiveType);
        }
    }

    public String getRicercaLiberaSoggettoLocale() {
        return this.ricercaLiberaSoggettoLocale;
    }

    public void setRicercaLiberaSoggettoLocale(String ricercaLiberaSoggettoLocale) {
        this.ricercaLiberaSoggettoLocale = ricercaLiberaSoggettoLocale;
    }

    public String getRicercaLiberaSoggettoRemoto() {
        return this.ricercaLiberaSoggettoRemoto;
    }

    public void setRicercaLiberaSoggettoRemoto(String ricercaLiberaSoggettoRemoto) {
        this.ricercaLiberaSoggettoRemoto = ricercaLiberaSoggettoRemoto;
    }

    public String getRicercaLiberaGruppo() {
        return this.ricercaLiberaGruppo;
    }

    public void setRicercaLiberaGruppo(String ricercaLiberaGruppo) {
        this.ricercaLiberaGruppo = ricercaLiberaGruppo;
    }

    public String getRicercaLiberaApi() {
        return this.ricercaLiberaApi;
    }

    public void setRicercaLiberaApi(String ricercaLiberaApi) {
        this.ricercaLiberaApi = ricercaLiberaApi;
    }

    public String getRicercaLiberaServizio() {
        return this.ricercaLiberaServizio;
    }

    public void setRicercaLiberaServizio(String ricercaLiberaServizio) {
        this.ricercaLiberaServizio = ricercaLiberaServizio;
    }

    public String getRicercaLiberaAzione() {
        return this.ricercaLiberaAzione;
    }

    public void setRicercaLiberaAzione(String ricercaLiberaAzione) {
        this.ricercaLiberaAzione = ricercaLiberaAzione;
    }

    public String getRicercaLiberaApplicativo() {
        return this.ricercaLiberaApplicativo;
    }

    public void setRicercaLiberaApplicativo(String ricercaLiberaApplicativo) {
        this.ricercaLiberaApplicativo = ricercaLiberaApplicativo;
    }

    public String getRicercaLiberaIdentificativoAutenticato() {
        return this.ricercaLiberaIdentificativoAutenticato;
    }

    public void setRicercaLiberaIdentificativoAutenticato(String ricercaLiberaIdentificativoAutenticato) {
        this.ricercaLiberaIdentificativoAutenticato = ricercaLiberaIdentificativoAutenticato;
    }

    public String getRicercaLiberaIndirizzoIP() {
        return this.ricercaLiberaIndirizzoIP;
    }

    public void setRicercaLiberaIndirizzoIP(String ricercaLiberaIndirizzoIP) {
        this.ricercaLiberaIndirizzoIP = ricercaLiberaIndirizzoIP;
    }

    public String getRicercaLiberaApplicativoToken() {
        return this.ricercaLiberaApplicativoToken;
    }

    public void setRicercaLiberaApplicativoToken(String ricercaLiberaApplicativoToken) {
        this.ricercaLiberaApplicativoToken = ricercaLiberaApplicativoToken;
    }

    public String getRicercaLiberaTokenIssuer() {
        return this.ricercaLiberaTokenIssuer;
    }

    public void setRicercaLiberaTokenIssuer(String ricercaLiberaTokenIssuer) {
        this.ricercaLiberaTokenIssuer = ricercaLiberaTokenIssuer;
    }

    public String getRicercaLiberaTokenSubject() {
        return this.ricercaLiberaTokenSubject;
    }

    public void setRicercaLiberaTokenSubject(String ricercaLiberaTokenSubject) {
        this.ricercaLiberaTokenSubject = ricercaLiberaTokenSubject;
    }

    public String getRicercaLiberaTokenClientID() {
        return this.ricercaLiberaTokenClientID;
    }

    public void setRicercaLiberaTokenClientID(String ricercaLiberaTokenClientID) {
        this.ricercaLiberaTokenClientID = ricercaLiberaTokenClientID;
    }

    public String getRicercaLiberaTokenUsername() {
        return this.ricercaLiberaTokenUsername;
    }

    public void setRicercaLiberaTokenUsername(String ricercaLiberaTokenUsername) {
        this.ricercaLiberaTokenUsername = ricercaLiberaTokenUsername;
    }

    public String getRicercaLiberaTokenEmail() {
        return this.ricercaLiberaTokenEmail;
    }

    public void setRicercaLiberaTokenEmail(String ricercaLiberaTokenEmail) {
        this.ricercaLiberaTokenEmail = ricercaLiberaTokenEmail;
    }

    public String getRicercaLiberaPdndOrganization() {
        return this.ricercaLiberaPdndOrganization;
    }

    public void setRicercaLiberaPdndOrganization(String ricercaLiberaPdndOrganization) {
        this.ricercaLiberaPdndOrganization = ricercaLiberaPdndOrganization;
    }

    public String getRicercaLiberaIdApplicativo() {
        return this.ricercaLiberaIdApplicativo;
    }

    public void setRicercaLiberaIdApplicativo(String ricercaLiberaIdApplicativo) {
        this.ricercaLiberaIdApplicativo = ricercaLiberaIdApplicativo;
    }

    public boolean isVisualizzaStoricoCustomEnabled() {
        return this.visualizzaStoricoCustomEnabled;
    }

    public void setVisualizzaStoricoCustomEnabled(boolean visualizzaStoricoCustomEnabled) {
        this.visualizzaStoricoCustomEnabled = visualizzaStoricoCustomEnabled;
    }

    public boolean isVisualizzaLiveCustomEnabled() {
        return this.visualizzaLiveCustomEnabled;
    }

    public void setVisualizzaLiveCustomEnabled(boolean visualizzaLiveCustomEnabled) {
        this.visualizzaLiveCustomEnabled = visualizzaLiveCustomEnabled;
    }

    public boolean isVisualizzaConsegneMultipleCustomEnabled() {
        return this.visualizzaConsegneMultipleCustomEnabled;
    }

    public void setVisualizzaConsegneMultipleCustomEnabled(boolean visualizzaConsegneMultipleCustomEnabled) {
        this.visualizzaConsegneMultipleCustomEnabled = visualizzaConsegneMultipleCustomEnabled;
    }

    public boolean isVisualizzaStoricoCustomColonnaRuoloTransazioneEnabled() {
        return this.visualizzaStoricoCustomColonnaRuoloTransazioneEnabled;
    }

    public void setVisualizzaStoricoCustomColonnaRuoloTransazioneEnabled(boolean visualizzaStoricoCustomColonnaRuoloTransazioneEnabled) {
        this.visualizzaStoricoCustomColonnaRuoloTransazioneEnabled = visualizzaStoricoCustomColonnaRuoloTransazioneEnabled;
    }

    public boolean isVisualizzaLiveCustomColonnaRuoloTransazioneEnabled() {
        return this.visualizzaLiveCustomColonnaRuoloTransazioneEnabled;
    }

    public void setVisualizzaLiveCustomColonnaRuoloTransazioneEnabled(boolean visualizzaLiveCustomColonnaRuoloTransazioneEnabled) {
        this.visualizzaLiveCustomColonnaRuoloTransazioneEnabled = visualizzaLiveCustomColonnaRuoloTransazioneEnabled;
    }

    protected void initStatoFiltroRicerca() {
        if (this.isLive()) {
            this.setVisualizzaFiltroAperto(false);
        } else {
            super.initStatoFiltroRicerca();
        }
    }

    public int getLivelloRicerca() {
        return this.livelloRicerca;
    }

    public void setLivelloRicerca(int livelloRicerca) {
        this.livelloRicerca = livelloRicerca;
    }

    public boolean isBackRicerca() {
        return this.backRicerca;
    }

    public void setBackRicerca(boolean backRicerca) {
        this.backRicerca = backRicerca;
    }

    public List<SelectItem> getEsitiContesto() {
        return this.getEsitiContesto(true);
    }

    public ModuloRicerca getModulo() {
        return ModuloRicerca.TRANSAZIONI;
    }

    public String getModalitaRicerca() {
        if ("Live".equals(this.getPeriodo())) {
            return "Live";
        }
        return this.getModalitaRicercaStorico();
    }

    public boolean isShowFiltroRicercheUtente() {
        boolean ricerchePresenti = super.isShowFiltroRicercheUtente();
        return ricerchePresenti && !ModalitaRicercaTransazioni.ID_TRANSAZIONE.getValue().equals(this.getModalitaRicercaStorico()) && !ModalitaRicercaTransazioni.ID_MESSAGGIO.getValue().equals(this.getModalitaRicercaStorico()) && !ModalitaRicercaTransazioni.ID_APPLICATIVO_BASE.getValue().equals(this.getModalitaRicercaStorico()) && !ModalitaRicercaTransazioni.ESAMINA_ARCHIVIO_ZIP.getValue().equals(this.getModalitaRicercaStorico());
    }

    public boolean isVisualizzaComandoSalvaRicerca() {
        return !ModalitaRicercaTransazioni.ID_TRANSAZIONE.getValue().equals(this.getModalitaRicercaStorico()) && !ModalitaRicercaTransazioni.ID_MESSAGGIO.getValue().equals(this.getModalitaRicercaStorico()) && !ModalitaRicercaTransazioni.ID_APPLICATIVO_BASE.getValue().equals(this.getModalitaRicercaStorico()) && !ModalitaRicercaTransazioni.ESAMINA_ARCHIVIO_ZIP.getValue().equals(this.getModalitaRicercaStorico());
    }

    public List<String> getElencoFieldRicercaDaIgnorare() {
        return elencoFieldsRicercaDaIgnorare;
    }

    public boolean isVisualizzaFiltroAzioni() {
        return !"im".equals(this.getTipoRicercaSPCoop()) && super.isVisualizzaFiltroAzioni();
    }

    public ArchivioZipFileUploadBean getArchivioZip() {
        return this.archivioZip;
    }

    public void setArchivioZip(ArchivioZipFileUploadBean archivioZip) {
        this.archivioZip = archivioZip;
        this.archivioZip.setSearch(this);
    }

    public String getIdFiles() {
        return this.idFiles;
    }

    public void setIdFiles(String idFiles) {
        this.idFiles = idFiles;
    }

    public void clearIdFiles() {
        this.setIdFiles("");
        this.archivioZipManager.clear();
    }

    public String getButtonFiltraLabel() {
        if (ModalitaRicercaTransazioni.ESAMINA_ARCHIVIO_ZIP.getValue().equals(this.getModalitaRicercaStorico())) {
            return MessageManager.getInstance().getMessageFromResourceBundle("commons.search.button.analizzaArchivio.label");
        }
        if (this.isAggiornamentoDatiAbilitato() && this.isShowButtonNuovaRicerca()) {
            return MessageManager.getInstance().getMessageFromResourceBundle("commons.search.button.nuovaRicerca.label");
        }
        return MessageManager.getInstance().getMessageFromResourceBundle("commons.search.button.cerca.label");
    }

    public ArchivioZipManager getArchivioZipManager() {
        return this.archivioZipManager;
    }

    public void setArchivioZipManager(ArchivioZipManager archivioZipManager) {
        this.archivioZipManager = archivioZipManager;
    }

    public boolean isRicercaArchivioZip() {
        if (!this.isLive() && StringUtils.isNotEmpty((CharSequence)this.getModalitaRicercaStorico())) {
            ModalitaRicercaTransazioni t = ModalitaRicercaTransazioni.getFromString((String)this.getModalitaRicercaStorico());
            return ModalitaRicercaTransazioni.ESAMINA_ARCHIVIO_ZIP.equals((Object)t);
        }
        return false;
    }

    public boolean isShowButtonAggiorna() {
        if (ModalitaRicercaTransazioni.ESAMINA_ARCHIVIO_ZIP.getValue().equals(this.getModalitaRicercaStorico())) {
            return false;
        }
        return !this.isLive() && this.isAggiornamentoDatiAbilitato() && this.isShowButtonNuovaRicerca();
    }

    public boolean isShowButtonEsporta() {
        return !this.isRicercaArchivioZip();
    }

    static {
        elencoFieldsRicercaDaIgnorare.addAll(Arrays.asList(Costanti.SEARCH_FORM_FIELDS_DA_NON_SALVARE));
        elencoFieldsRicercaDaIgnorare.addAll(Arrays.asList(TransazioniCostanti.SEARCH_FORM_FIELDS_DA_NON_SALVARE));
    }
}

