/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.bean;

import java.util.ArrayList;
import java.util.Date;
import org.openspcoop2.core.transazioni.TransazioneApplicativoServer;
import org.openspcoop2.web.monitor.core.utils.BeanUtils;
import org.openspcoop2.web.monitor.core.utils.MessageManager;
import org.openspcoop2.web.monitor.transazioni.utils.FormatoFaultUtils;
import org.openspcoop2.web.monitor.transazioni.utils.TransazioniEsitiUtils;

public class TransazioneApplicativoServerBean
extends TransazioneApplicativoServer {
    private static final long serialVersionUID = 1L;
    private int lunghezzaErrore = 200;
    private int tipoApi = -1;

    public TransazioneApplicativoServerBean() {
    }

    public TransazioneApplicativoServerBean(TransazioneApplicativoServer transazioneApplicativoServer) {
        ArrayList metodiEsclusi = new ArrayList(0);
        BeanUtils.copy((Object)((Object)this), (Object)transazioneApplicativoServer, metodiEsclusi);
    }

    public Long getLatenzaConsegna() {
        if (this.isInCodaConsegnaApplicativoZeroTentativi() || this.isInCodaOttenibileImZeroPrelievi() || this.isInCodaConsegnaApplicativoImZeroTentativi()) {
            return null;
        }
        if (this.isInCodaConsegnaApplicativoPiuTentativi() || this.isTerminataConsegnaApplicativo()) {
            if (this.dataUscitaRichiesta != null && this.dataIngressoRisposta != null) {
                return this.dataIngressoRisposta.getTime() - this.dataUscitaRichiesta.getTime();
            }
            return -1L;
        }
        if (this.isInCodaOttenibileImPiuPrelievi() || this.isTerminataGestioneIm()) {
            return null;
        }
        if (this.isInCodaConsegnaApplicativoImPiuPrelievi()) {
            if (this.dataUscitaRichiesta != null && this.dataIngressoRisposta != null) {
                return this.dataIngressoRisposta.getTime() - this.dataUscitaRichiesta.getTime();
            }
            return null;
        }
        if (this.isTerminataConsegnaApplicativoIm()) {
            if (this.dataEliminazioneIm == null) {
                if (this.dataUscitaRichiesta != null && this.dataIngressoRisposta != null) {
                    return this.dataIngressoRisposta.getTime() - this.dataUscitaRichiesta.getTime();
                }
                return -1L;
            }
            return null;
        }
        if (this.isMessaggioScaduto()) {
            if (this.isInCodaConsegnaApplicativoZeroTentativi() || this.isInCodaOttenibileImZeroPrelievi() || this.isInCodaConsegnaApplicativoImZeroTentativi()) {
                return null;
            }
            if (this.isInCodaOttenibileImPiuPrelievi()) {
                return null;
            }
            if (this.isInCodaConsegnaApplicativoImPiuPrelievi()) {
                if (this.dataUscitaRichiesta != null && this.dataIngressoRisposta != null) {
                    return this.dataIngressoRisposta.getTime() - this.dataUscitaRichiesta.getTime();
                }
                return null;
            }
        }
        return null;
    }

    public Long getLatenzaGestioneMessageBox() {
        if (this.dataRegistrazione != null && this.consegnaIntegrationManager) {
            if (this.dataPrimoPrelievoIm != null) {
                return this.dataPrimoPrelievoIm.getTime() - this.dataRegistrazione.getTime();
            }
            if (this.dataPrelievoIm != null) {
                return this.dataPrelievoIm.getTime() - this.dataRegistrazione.getTime();
            }
            return null;
        }
        return null;
    }

    public boolean isConsegnaApplicativo() {
        return this.consegnaTrasparente && !this.consegnaIntegrationManager;
    }

    public boolean isPrelievoIM() {
        return !this.consegnaTrasparente && this.consegnaIntegrationManager;
    }

    public boolean isConsegnaApplicativoIM() {
        return this.consegnaTrasparente && this.consegnaIntegrationManager;
    }

    public boolean isInCodaConsegnaApplicativoZeroTentativi() {
        return this.dataMessaggioScaduto == null && !this.consegnaTerminata && this.isConsegnaApplicativo() && this.numeroTentativi == 0;
    }

    public boolean isInCodaOttenibileImZeroPrelievi() {
        return this.dataMessaggioScaduto == null && !this.consegnaTerminata && this.isPrelievoIM() && this.numeroPrelieviIm == 0;
    }

    public boolean isInCodaConsegnaApplicativoImZeroTentativi() {
        return this.dataMessaggioScaduto == null && !this.consegnaTerminata && this.isConsegnaApplicativoIM() && this.numeroTentativi == 0 && this.numeroPrelieviIm == 0;
    }

    public boolean isInCodaConsegnaApplicativoPiuTentativi() {
        return this.dataMessaggioScaduto == null && !this.consegnaTerminata && this.isConsegnaApplicativo() && this.numeroTentativi > 0;
    }

    public boolean isInCodaOttenibileImPiuPrelievi() {
        return this.dataMessaggioScaduto == null && !this.consegnaTerminata && this.isPrelievoIM() && this.numeroPrelieviIm > 0;
    }

    public boolean isInCodaConsegnaApplicativoImPiuPrelievi() {
        return this.dataMessaggioScaduto == null && !this.consegnaTerminata && this.isConsegnaApplicativoIM() && (this.numeroTentativi > 0 || this.numeroPrelieviIm > 0);
    }

    public boolean isTerminataConsegnaApplicativo() {
        return this.dataMessaggioScaduto == null && this.consegnaTerminata && this.isConsegnaApplicativo();
    }

    public boolean isTerminataGestioneIm() {
        return this.dataMessaggioScaduto == null && this.consegnaTerminata && this.isPrelievoIM();
    }

    public boolean isTerminataConsegnaApplicativoIm() {
        return this.dataMessaggioScaduto == null && this.consegnaTerminata && this.isConsegnaApplicativoIM();
    }

    public boolean isMessaggioScaduto() {
        return this.dataMessaggioScaduto != null;
    }

    public String getIconaColonnaSX() {
        if (this.isInCodaConsegnaApplicativoZeroTentativi()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.applicativo.inCoda.zeroTentativi.icon");
        }
        if (this.isInCodaOttenibileImZeroPrelievi()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.im.inCoda.zeroPrelievi.icon");
        }
        if (this.isInCodaConsegnaApplicativoImZeroTentativi()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.applicativoIm.inCoda.zeroTentativi.icon");
        }
        if (this.isInCodaConsegnaApplicativoPiuTentativi()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.applicativo.inCoda.piuTentativi.icon");
        }
        if (this.isInCodaOttenibileImPiuPrelievi()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.im.inCoda.piuPrelievi.icon");
        }
        if (this.isInCodaConsegnaApplicativoImPiuPrelievi()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.applicativoIm.inCoda.piuTentativi.icon");
        }
        if (this.isTerminataConsegnaApplicativo()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.applicativo.terminataConsegna.icon");
        }
        if (this.isTerminataGestioneIm()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.im.terminataGestione.icon");
        }
        if (this.isTerminataConsegnaApplicativoIm()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.applicativoIm.terminataConsegna.icon");
        }
        if (this.isMessaggioScaduto()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.messaggioScaduto.icon");
        }
        return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.applicativo.inCoda.zeroTentativi.icon");
    }

    public String getTooltipIconaColonnaSX() {
        if (this.isInCodaConsegnaApplicativoZeroTentativi()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.applicativo.inCoda.zeroTentativi.label");
        }
        if (this.isInCodaOttenibileImZeroPrelievi()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.im.inCoda.zeroPrelievi.label");
        }
        if (this.isInCodaConsegnaApplicativoImZeroTentativi()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.applicativoIm.inCoda.zeroTentativi.label");
        }
        if (this.isInCodaConsegnaApplicativoPiuTentativi()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.applicativo.inCoda.piuTentativi.label");
        }
        if (this.isInCodaOttenibileImPiuPrelievi()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.im.inCoda.piuPrelievi.label");
        }
        if (this.isInCodaConsegnaApplicativoImPiuPrelievi()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.applicativoIm.inCoda.piuTentativi.label");
        }
        if (this.isTerminataConsegnaApplicativo()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.applicativo.terminataConsegna.label");
        }
        if (this.isTerminataGestioneIm()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.im.terminataGestione.label");
        }
        if (this.isTerminataConsegnaApplicativoIm()) {
            if (this.dataEliminazioneIm == null) {
                return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.applicativoIm.terminataConsegna.label");
            }
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.applicativoIm.terminataConsegna.im.label");
        }
        if (this.isMessaggioScaduto()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.messaggioScaduto.label");
        }
        return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.applicativo.inCoda.zeroTentativi.label");
    }

    public String getTitoloSX() {
        return this.connettoreNome;
    }

    public boolean isVisualizzaIconConsegnaApplicativo() {
        return this.isConsegnaApplicativo() || this.isConsegnaApplicativoIM();
    }

    public boolean isVisualizzaIconPrelievoIM() {
        return this.isPrelievoIM() || this.isConsegnaApplicativoIM();
    }

    public String getTitoloDX() {
        if (this.isConsegnaApplicativo() || this.isConsegnaApplicativoIM()) {
            return this.locationConnettore;
        }
        if (this.isPrelievoIM()) {
            if (this.dataEliminazioneIm == null) {
                return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.im.titolo.inProgress.label");
            }
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.im.titolo.completato.label");
        }
        return "";
    }

    public String getLabelDataSX() {
        if (this.isInCodaConsegnaApplicativoZeroTentativi() || this.isInCodaOttenibileImZeroPrelievi() || this.isInCodaConsegnaApplicativoImZeroTentativi()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.data.inCoda.label");
        }
        if (this.isInCodaConsegnaApplicativoPiuTentativi() || this.isInCodaConsegnaApplicativoImPiuPrelievi() || this.isTerminataConsegnaApplicativo()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.data.ultimaConsegna.label");
        }
        if (this.isInCodaOttenibileImPiuPrelievi()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.data.ultimoPrelievo.label");
        }
        if (this.isTerminataGestioneIm()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.data.eliminazione.label");
        }
        if (this.isTerminataConsegnaApplicativoIm()) {
            if (this.dataEliminazioneIm != null) {
                return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.data.eliminazione.label");
            }
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.data.ultimaConsegna.label");
        }
        if (this.isMessaggioScaduto()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.data.scaduto.label");
        }
        return null;
    }

    public Date getDataSX() {
        if (this.isInCodaConsegnaApplicativoZeroTentativi() || this.isInCodaOttenibileImZeroPrelievi() || this.isInCodaConsegnaApplicativoImZeroTentativi()) {
            return this.dataRegistrazione;
        }
        if (this.isInCodaConsegnaApplicativoPiuTentativi()) {
            return this.getDataUltimaConsegna();
        }
        if (this.isInCodaOttenibileImPiuPrelievi()) {
            return this.dataPrelievoIm;
        }
        if (this.isInCodaConsegnaApplicativoImPiuPrelievi()) {
            return this.getDataUltimaConsegna();
        }
        if (this.isTerminataConsegnaApplicativo()) {
            return this.getDataUltimaConsegna();
        }
        if (this.isTerminataGestioneIm()) {
            return this.dataEliminazioneIm;
        }
        if (this.isTerminataConsegnaApplicativoIm()) {
            if (this.dataEliminazioneIm != null) {
                return this.dataEliminazioneIm;
            }
            return this.getDataUltimaConsegna();
        }
        if (this.isMessaggioScaduto()) {
            return this.dataMessaggioScaduto;
        }
        return null;
    }

    public String getLabelData2SX() {
        if (this.isTerminataGestioneIm()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.data.ultimoPrelievo.label");
        }
        if (this.isTerminataConsegnaApplicativoIm()) {
            if (this.dataEliminazioneIm != null) {
                return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.data.ultimoPrelievo.label");
            }
            return null;
        }
        if (this.isMessaggioScaduto()) {
            if (this.isInCodaConsegnaApplicativoZeroTentativi() || this.isInCodaOttenibileImZeroPrelievi() || this.isInCodaConsegnaApplicativoImZeroTentativi()) {
                return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.data.inCoda.label");
            }
            if (this.isInCodaConsegnaApplicativoPiuTentativi() || this.isInCodaConsegnaApplicativoImPiuPrelievi()) {
                return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.data.ultimaConsegna.label");
            }
            if (this.isInCodaOttenibileImPiuPrelievi()) {
                return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.data.ultimoPrelievo.label");
            }
        }
        return null;
    }

    public Date getData2SX() {
        if (this.isTerminataGestioneIm()) {
            return this.dataPrelievoIm;
        }
        if (this.isTerminataConsegnaApplicativoIm()) {
            if (this.dataEliminazioneIm != null) {
                return this.dataPrelievoIm;
            }
            return this.getDataUltimaConsegna();
        }
        if (this.isMessaggioScaduto()) {
            if (this.isInCodaConsegnaApplicativoZeroTentativi() || this.isInCodaOttenibileImZeroPrelievi() || this.isInCodaConsegnaApplicativoImZeroTentativi()) {
                return this.dataRegistrazione;
            }
            if (this.isInCodaConsegnaApplicativoPiuTentativi() || this.isInCodaConsegnaApplicativoImPiuPrelievi()) {
                return this.getDataUltimaConsegna();
            }
            if (this.isInCodaOttenibileImPiuPrelievi()) {
                return this.dataPrelievoIm;
            }
        }
        return null;
    }

    public Date getDataUltimaConsegna() {
        if (this.dataUscitaRichiesta == null) {
            return this.dataAccettazioneRichiesta;
        }
        return this.dataUscitaRichiesta;
    }

    public String getEsitoStyleClass() {
        return TransazioniEsitiUtils.getEsitoStyleClass(this.getDettaglioEsito(), this.getProtocollo());
    }

    public boolean isEsitoOk() {
        return TransazioniEsitiUtils.isEsitoOk(this.dettaglioEsito, this.getProtocollo());
    }

    public boolean isEsitoFaultApplicativo() {
        return TransazioniEsitiUtils.isEsitoFaultApplicativo(this.dettaglioEsito, this.getProtocollo());
    }

    public boolean isEsitoKo() {
        return TransazioniEsitiUtils.isEsitoKo(this.dettaglioEsito, this.getProtocollo());
    }

    public String getEsitoLabel() {
        return TransazioniEsitiUtils.getEsitoLabel(this.dettaglioEsito, this.getProtocollo());
    }

    public String getEsitoLabelSyntetic() {
        Integer httpStatus = null;
        if (this.codiceRisposta != null && !"".equals(this.codiceRisposta)) {
            try {
                httpStatus = Integer.valueOf(this.codiceRisposta);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return TransazioniEsitiUtils.getEsitoLabelSyntetic(this.dettaglioEsito, this.getProtocollo(), httpStatus, this.tipoApi);
    }

    public String getEsitoLabelDescription() {
        Integer httpStatus = null;
        if (this.codiceRisposta != null && !"".equals(this.codiceRisposta)) {
            try {
                httpStatus = Integer.valueOf(this.codiceRisposta);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return TransazioniEsitiUtils.getEsitoLabelDescription(this.dettaglioEsito, this.getProtocollo(), httpStatus, null, this.tipoApi);
    }

    public String getEsitoUltimoErroreLabelDescription() {
        Integer httpStatus = null;
        if (this.codiceRispostaUltimoErrore != null && !"".equals(this.codiceRispostaUltimoErrore)) {
            try {
                httpStatus = Integer.valueOf(this.codiceRispostaUltimoErrore);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return TransazioniEsitiUtils.getEsitoLabelDescription(this.dettaglioEsitoUltimoErrore, this.getProtocollo(), httpStatus, null, this.tipoApi);
    }

    public String getIconaUltimoErroreConsegna() {
        if (TransazioniEsitiUtils.isEsitoOk(this.dettaglioEsitoUltimoErrore, this.getProtocollo())) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.ok.icon");
        }
        if (TransazioniEsitiUtils.isEsitoFaultApplicativo(this.dettaglioEsitoUltimoErrore, this.getProtocollo())) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.error.icon");
        }
        if (TransazioniEsitiUtils.isEsitoKo(this.dettaglioEsitoUltimoErrore, this.getProtocollo())) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.warning.icon");
        }
        return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.warning.icon");
    }

    public String getEsitoSyntetic() {
        if (this.isInCodaConsegnaApplicativoZeroTentativi()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.applicativo.inCoda.zeroTentativi.label");
        }
        if (this.isInCodaOttenibileImZeroPrelievi()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.im.inCoda.zeroPrelievi.label");
        }
        if (this.isInCodaConsegnaApplicativoImZeroTentativi()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.applicativoIm.inCoda.zeroTentativi.label");
        }
        if (this.isInCodaConsegnaApplicativoPiuTentativi()) {
            return this.getEsitoLabelSyntetic();
        }
        if (this.isInCodaOttenibileImPiuPrelievi()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.im.inCoda.piuPrelievi.label");
        }
        if (this.isInCodaConsegnaApplicativoImPiuPrelievi()) {
            if (this.dataUscitaRichiesta != null && this.dataIngressoRisposta != null) {
                return this.getEsitoLabelSyntetic();
            }
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.applicativoIm.terminataConsegna.im.label");
        }
        if (this.isTerminataConsegnaApplicativo()) {
            return this.getEsitoLabelSyntetic();
        }
        if (this.isTerminataGestioneIm()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.im.terminataGestione.label");
        }
        if (this.isTerminataConsegnaApplicativoIm()) {
            if (this.dataEliminazioneIm != null) {
                return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.applicativoIm.terminataConsegna.im.label");
            }
            if (this.dataUscitaRichiesta != null && this.dataIngressoRisposta != null) {
                return this.getEsitoLabelSyntetic();
            }
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.applicativo.inCoda.zeroTentativi.label");
        }
        if (this.isMessaggioScaduto()) {
            if (this.isInCodaConsegnaApplicativoZeroTentativi()) {
                return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.applicativo.inCoda.zeroTentativi.label");
            }
            if (this.isInCodaOttenibileImZeroPrelievi()) {
                return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.im.inCoda.zeroPrelievi.label");
            }
            if (this.isInCodaConsegnaApplicativoImZeroTentativi()) {
                return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.applicativoIm.inCoda.zeroTentativi.label");
            }
            if (this.isInCodaConsegnaApplicativoPiuTentativi()) {
                return this.getEsitoLabelSyntetic();
            }
            if (this.isInCodaOttenibileImPiuPrelievi()) {
                return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.im.inCoda.piuPrelievi.label");
            }
            if (this.isInCodaConsegnaApplicativoImPiuPrelievi()) {
                if (this.dataUscitaRichiesta != null && this.dataIngressoRisposta != null) {
                    return this.getEsitoLabelSyntetic();
                }
                return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.applicativo.inCoda.zeroTentativi.label");
            }
        }
        return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.applicativo.inCoda.zeroTentativi.label");
    }

    public String getEsitoDescription() {
        if (this.isInCodaConsegnaApplicativoZeroTentativi()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.applicativo.inCoda.zeroTentativi.tooltip");
        }
        if (this.isInCodaOttenibileImZeroPrelievi()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.im.inCoda.zeroPrelievi.tooltip");
        }
        if (this.isInCodaConsegnaApplicativoImZeroTentativi()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.applicativoIm.inCoda.zeroTentativi.tooltip");
        }
        if (this.isInCodaConsegnaApplicativoPiuTentativi()) {
            return this.getEsitoLabelDescription();
        }
        if (this.isInCodaOttenibileImPiuPrelievi()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.im.inCoda.piuPrelievi.tooltip");
        }
        if (this.isInCodaConsegnaApplicativoImPiuPrelievi()) {
            if (this.dataUscitaRichiesta != null && this.dataIngressoRisposta != null) {
                return this.getEsitoLabelDescription();
            }
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.applicativoIm.terminataConsegna.im.tooltip");
        }
        if (this.isTerminataConsegnaApplicativo()) {
            return this.getEsitoLabelDescription();
        }
        if (this.isTerminataGestioneIm()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.im.terminataGestione.tooltip");
        }
        if (this.isTerminataConsegnaApplicativoIm()) {
            if (this.dataEliminazioneIm != null) {
                return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.applicativoIm.terminataConsegna.im.tooltip");
            }
            if (this.dataUscitaRichiesta != null && this.dataIngressoRisposta != null) {
                return this.getEsitoLabelDescription();
            }
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.applicativo.inCoda.zeroTentativi.tooltip");
        }
        if (this.isMessaggioScaduto()) {
            if (this.isInCodaConsegnaApplicativoZeroTentativi()) {
                return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.applicativo.inCoda.zeroTentativi.tooltip");
            }
            if (this.isInCodaOttenibileImZeroPrelievi()) {
                return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.im.inCoda.zeroPrelievi.tooltip");
            }
            if (this.isInCodaConsegnaApplicativoImZeroTentativi()) {
                return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.applicativoIm.inCoda.zeroTentativi.tooltip");
            }
            if (this.isInCodaConsegnaApplicativoPiuTentativi()) {
                return this.getEsitoLabelDescription();
            }
            if (this.isInCodaOttenibileImPiuPrelievi()) {
                return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.im.inCoda.piuPrelievi.tooltip");
            }
            if (this.isInCodaConsegnaApplicativoImPiuPrelievi()) {
                if (this.dataUscitaRichiesta != null && this.dataIngressoRisposta != null) {
                    return this.getEsitoLabelDescription();
                }
                return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.applicativo.inCoda.zeroTentativi.tooltip");
            }
        }
        return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.applicativo.inCoda.zeroTentativi.tooltip");
    }

    public String getIconaColonnaEsito() {
        if (this.isInCodaConsegnaApplicativoZeroTentativi() || this.isInCodaOttenibileImZeroPrelievi() || this.isInCodaConsegnaApplicativoImZeroTentativi()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.inCorso.icon");
        }
        if (this.isInCodaConsegnaApplicativoPiuTentativi()) {
            return this.getIconaFromEsitoConsegna();
        }
        if (this.isInCodaOttenibileImPiuPrelievi()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.inCorso.icon");
        }
        if (this.isInCodaConsegnaApplicativoImPiuPrelievi()) {
            if (this.dataUscitaRichiesta != null && this.dataIngressoRisposta != null) {
                return this.getIconaFromEsitoConsegna();
            }
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.inCorso.icon");
        }
        if (this.isTerminataConsegnaApplicativo()) {
            return this.getIconaFromEsitoConsegna();
        }
        if (this.isTerminataGestioneIm()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.im.done.icon");
        }
        if (this.isTerminataConsegnaApplicativoIm()) {
            if (this.dataEliminazioneIm != null) {
                return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.im.done.icon");
            }
            if (this.dataUscitaRichiesta != null && this.dataIngressoRisposta != null) {
                return this.getIconaFromEsitoConsegna();
            }
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.inCorso.icon");
        }
        if (this.isMessaggioScaduto()) {
            if (this.isInCodaConsegnaApplicativoZeroTentativi() || this.isInCodaOttenibileImZeroPrelievi() || this.isInCodaConsegnaApplicativoImZeroTentativi()) {
                return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.inCorso.icon");
            }
            if (this.isInCodaConsegnaApplicativoPiuTentativi()) {
                return this.getIconaFromEsitoConsegna();
            }
            if (this.isInCodaOttenibileImPiuPrelievi()) {
                return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.inCorso.icon");
            }
            if (this.isInCodaConsegnaApplicativoImPiuPrelievi()) {
                if (this.dataUscitaRichiesta != null && this.dataIngressoRisposta != null) {
                    return this.getIconaFromEsitoConsegna();
                }
                return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.inCorso.icon");
            }
        }
        return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.inCorso.icon");
    }

    public String getBackgroundColonnaEsito() {
        if (this.isInCodaConsegnaApplicativoZeroTentativi() || this.isInCodaOttenibileImZeroPrelievi() || this.isInCodaConsegnaApplicativoImZeroTentativi()) {
            return "col-esito-ok";
        }
        if (this.isInCodaConsegnaApplicativoPiuTentativi()) {
            return this.getCssColonnaEsito();
        }
        if (this.isInCodaOttenibileImPiuPrelievi()) {
            return "col-esito-ok";
        }
        if (this.isInCodaConsegnaApplicativoImPiuPrelievi()) {
            if (this.dataUscitaRichiesta != null && this.dataIngressoRisposta != null) {
                return this.getCssColonnaEsito();
            }
            return "col-esito-ok";
        }
        if (this.isTerminataConsegnaApplicativo()) {
            return this.getCssColonnaEsito();
        }
        if (this.isTerminataGestioneIm()) {
            return "col-esito-ok";
        }
        if (this.isTerminataConsegnaApplicativoIm()) {
            if (this.dataEliminazioneIm != null) {
                return "col-esito-ok";
            }
            if (this.dataUscitaRichiesta != null && this.dataIngressoRisposta != null) {
                return this.getCssColonnaEsito();
            }
            return "col-esito-ok";
        }
        if (this.isMessaggioScaduto()) {
            if (this.isInCodaConsegnaApplicativoZeroTentativi() || this.isInCodaOttenibileImZeroPrelievi() || this.isInCodaConsegnaApplicativoImZeroTentativi()) {
                return "col-esito-ok";
            }
            if (this.isInCodaConsegnaApplicativoPiuTentativi()) {
                return this.getCssColonnaEsito();
            }
            if (this.isInCodaOttenibileImPiuPrelievi()) {
                return "col-esito-ok";
            }
            if (this.isInCodaConsegnaApplicativoImPiuPrelievi()) {
                if (this.dataUscitaRichiesta != null && this.dataIngressoRisposta != null) {
                    return this.getCssColonnaEsito();
                }
                return "col-esito-ok";
            }
        }
        return "col-esito-ok";
    }

    public String getIconaFromEsitoConsegna() {
        if (this.isEsitoOk()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.ok.icon");
        }
        if (this.isEsitoFaultApplicativo()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.error.icon");
        }
        if (this.isEsitoKo()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.warning.icon");
        }
        return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.esito.warning.icon");
    }

    public String getCssColonnaEsito() {
        if (this.isEsitoOk()) {
            return "col-esito-ok";
        }
        if (this.isEsitoFaultApplicativo()) {
            return "col-esito-fault";
        }
        if (this.isEsitoKo()) {
            return "col-esito-errore";
        }
        return "col-esito-errore";
    }

    public String getCssColonnaLatenza() {
        return "col-latenza-ok";
    }

    public String getClusterId() {
        if (this.isInCodaConsegnaApplicativoZeroTentativi() || this.isInCodaOttenibileImZeroPrelievi() || this.isInCodaConsegnaApplicativoImZeroTentativi()) {
            return this.clusterIdPresaInCarico;
        }
        if (this.isInCodaConsegnaApplicativoPiuTentativi()) {
            return this.clusterIdConsegna;
        }
        if (this.isInCodaOttenibileImPiuPrelievi()) {
            return this.clusterIdPrelievoIm;
        }
        if (this.isInCodaConsegnaApplicativoImPiuPrelievi()) {
            return this.clusterIdConsegna;
        }
        if (this.isTerminataConsegnaApplicativo()) {
            return this.clusterIdConsegna;
        }
        if (this.isTerminataGestioneIm()) {
            return this.clusterIdEliminazioneIm;
        }
        if (this.isTerminataConsegnaApplicativoIm()) {
            if (this.dataEliminazioneIm != null) {
                return this.clusterIdEliminazioneIm;
            }
            return this.clusterIdConsegna;
        }
        if (this.isMessaggioScaduto()) {
            if (this.isInCodaConsegnaApplicativoZeroTentativi() || this.isInCodaOttenibileImZeroPrelievi() || this.isInCodaConsegnaApplicativoImZeroTentativi()) {
                return this.clusterIdPresaInCarico;
            }
            if (this.isInCodaConsegnaApplicativoPiuTentativi()) {
                return this.clusterIdConsegna;
            }
            if (this.isInCodaOttenibileImPiuPrelievi()) {
                return this.clusterIdPrelievoIm;
            }
            if (this.isInCodaConsegnaApplicativoImPiuPrelievi()) {
                return this.clusterIdConsegna;
            }
        }
        return null;
    }

    public String getNumeroTentativiLabel() {
        if (this.isInCodaConsegnaApplicativoZeroTentativi() || this.isInCodaOttenibileImZeroPrelievi() || this.isInCodaConsegnaApplicativoImZeroTentativi()) {
            return null;
        }
        if (this.isInCodaConsegnaApplicativoPiuTentativi() || this.isInCodaConsegnaApplicativoImPiuPrelievi() || this.isTerminataConsegnaApplicativo()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.numeroTentativi.label");
        }
        if (this.isInCodaOttenibileImPiuPrelievi() || this.isTerminataGestioneIm()) {
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.numeroPrelievi.label");
        }
        if (this.isTerminataConsegnaApplicativoIm()) {
            if (this.dataEliminazioneIm != null) {
                return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.numeroPrelievi.label");
            }
            return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.numeroTentativi.label");
        }
        if (this.isMessaggioScaduto()) {
            if (this.isInCodaConsegnaApplicativoZeroTentativi() || this.isInCodaOttenibileImZeroPrelievi() || this.isInCodaConsegnaApplicativoImZeroTentativi()) {
                return null;
            }
            if (this.isInCodaConsegnaApplicativoPiuTentativi() || this.isInCodaConsegnaApplicativoImPiuPrelievi()) {
                return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.numeroTentativi.label");
            }
            if (this.isInCodaOttenibileImPiuPrelievi()) {
                return MessageManager.getInstance().getMessage("transazioniApplicativoServer.elenco.numeroPrelievi.label");
            }
        }
        return null;
    }

    public Integer getNumeroTentativiValue() {
        if (this.isInCodaConsegnaApplicativoZeroTentativi() || this.isInCodaOttenibileImZeroPrelievi() || this.isInCodaConsegnaApplicativoImZeroTentativi()) {
            return null;
        }
        if (this.isInCodaConsegnaApplicativoPiuTentativi() || this.isInCodaConsegnaApplicativoImPiuPrelievi() || this.isTerminataConsegnaApplicativo()) {
            return this.numeroTentativi;
        }
        if (this.isInCodaOttenibileImPiuPrelievi() || this.isTerminataGestioneIm()) {
            return this.numeroPrelieviIm;
        }
        if (this.isTerminataConsegnaApplicativoIm()) {
            if (this.dataEliminazioneIm != null) {
                return this.numeroPrelieviIm;
            }
            return this.numeroTentativi;
        }
        if (this.isMessaggioScaduto()) {
            if (this.isInCodaConsegnaApplicativoZeroTentativi() || this.isInCodaOttenibileImZeroPrelievi() || this.isInCodaConsegnaApplicativoImZeroTentativi()) {
                return null;
            }
            if (this.isInCodaConsegnaApplicativoPiuTentativi() || this.isInCodaConsegnaApplicativoImPiuPrelievi()) {
                return this.numeroTentativi;
            }
            if (this.isInCodaOttenibileImPiuPrelievi()) {
                return this.numeroPrelieviIm;
            }
        }
        return null;
    }

    public String getErrore() {
        String errore = null;
        if (this.isInCodaConsegnaApplicativoZeroTentativi() || this.isInCodaOttenibileImZeroPrelievi() || this.isInCodaConsegnaApplicativoImZeroTentativi()) {
            return null;
        }
        if (this.isInCodaConsegnaApplicativoPiuTentativi() || this.isInCodaConsegnaApplicativoImPiuPrelievi() || this.isTerminataConsegnaApplicativo()) {
            errore = this.ultimoErrore;
        }
        if (this.isInCodaOttenibileImPiuPrelievi() || this.isTerminataGestioneIm()) {
            return null;
        }
        if (this.isTerminataConsegnaApplicativoIm()) {
            if (this.dataEliminazioneIm != null) {
                return null;
            }
            errore = this.ultimoErrore;
        }
        if (this.isMessaggioScaduto()) {
            if (this.isInCodaConsegnaApplicativoZeroTentativi() || this.isInCodaOttenibileImZeroPrelievi() || this.isInCodaConsegnaApplicativoImZeroTentativi()) {
                return null;
            }
            if (this.isInCodaConsegnaApplicativoPiuTentativi() || this.isInCodaConsegnaApplicativoImPiuPrelievi()) {
                errore = this.ultimoErrore;
            }
            if (this.isInCodaOttenibileImPiuPrelievi()) {
                return null;
            }
        }
        if (errore != null && errore.length() > this.lunghezzaErrore) {
            return errore.substring(0, this.lunghezzaErrore - 4) + "...";
        }
        return null;
    }

    public String getErroreTooltip() {
        if (this.isInCodaConsegnaApplicativoZeroTentativi() || this.isInCodaOttenibileImZeroPrelievi() || this.isInCodaConsegnaApplicativoImZeroTentativi()) {
            return null;
        }
        if (this.isInCodaConsegnaApplicativoPiuTentativi() || this.isInCodaConsegnaApplicativoImPiuPrelievi() || this.isTerminataConsegnaApplicativo()) {
            return this.ultimoErrore;
        }
        if (this.isInCodaOttenibileImPiuPrelievi() || this.isTerminataGestioneIm()) {
            return null;
        }
        if (this.isTerminataConsegnaApplicativoIm()) {
            if (this.dataEliminazioneIm != null) {
                return null;
            }
            return this.ultimoErrore;
        }
        if (this.isMessaggioScaduto()) {
            if (this.isInCodaConsegnaApplicativoZeroTentativi() || this.isInCodaOttenibileImZeroPrelievi() || this.isInCodaConsegnaApplicativoImZeroTentativi()) {
                return null;
            }
            if (this.isInCodaConsegnaApplicativoPiuTentativi() || this.isInCodaConsegnaApplicativoImPiuPrelievi()) {
                return this.ultimoErrore;
            }
            if (this.isInCodaOttenibileImPiuPrelievi()) {
                return null;
            }
        }
        return null;
    }

    public String getNomeServizioApplicativoErogatore() {
        return this.servizioApplicativoErogatore;
    }

    public String getFaultPretty() {
        return FormatoFaultUtils.getFaultPretty(super.getFault(), super.getFormatoFault());
    }

    public boolean isVisualizzaFault() {
        return FormatoFaultUtils.isVisualizzaFault(super.getFault());
    }

    public String getBrushFault() {
        return FormatoFaultUtils.getBrushFault(super.getFault(), super.getFormatoFault());
    }

    public String getErroreVisualizzaFault() {
        return FormatoFaultUtils.getErroreVisualizzaFault(super.getFault());
    }

    public String getFaultPrettyUltimoErrore() {
        return FormatoFaultUtils.getFaultPretty(super.getFaultUltimoErrore(), super.getFormatoFaultUltimoErrore());
    }

    public boolean isVisualizzaFaultUltimoErrore() {
        return FormatoFaultUtils.isVisualizzaFault(super.getFaultUltimoErrore());
    }

    public String getBrushFaultUltimoErrore() {
        return FormatoFaultUtils.getBrushFault(super.getFaultUltimoErrore(), super.getFormatoFaultUltimoErrore());
    }

    public String getErroreVisualizzaFaultUltimoErrore() {
        return FormatoFaultUtils.getErroreVisualizzaFault(super.getFaultUltimoErrore());
    }

    public String getNomeConnettoreDirectoryInArchivioZip() {
        return this.getConnettoreNome() != null ? this.getConnettoreNome() : "Default";
    }
}

