/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.utils;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.CanaleConfigurazione;
import org.openspcoop2.core.controllo_traffico.IdPolicy;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDGenericProperties;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.id.IDPortType;
import org.openspcoop2.core.id.IDPortTypeAzione;
import org.openspcoop2.core.id.IDResource;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDScope;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.plugins.IdPlugin;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.costanti.InUsoType;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.erogazioni.ErogazioniDetailsUtilities;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviCore;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ExporterUtils;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.gruppi.GruppiCore;
import org.openspcoop2.web.ctrlstat.servlet.ruoli.RuoliCore;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiCore;
import org.openspcoop2.web.ctrlstat.servlet.scope.ScopeCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.ctrlstat.servlet.utils.UtilsHelper;
import org.openspcoop2.web.lib.mvc.PageData;

public class InformazioniUtilizzoOggettoRegistro
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)req.getInputStream(), (OutputStream)baos);
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore durante la ricerca delle informazioni oggetto: " + e.getMessage(), e);
            return;
        }
        this.processRequest(req, resp);
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) {
        block44: {
            try (ByteArrayOutputStream baosPayload = new ByteArrayOutputStream();){
                HttpRequestMethod httpRequestMethod = HttpRequestMethod.valueOf((String)request.getMethod().toUpperCase());
                if (httpRequestMethod.equals((Object)HttpRequestMethod.POST)) {
                    IOUtils.copy((InputStream)request.getInputStream(), (OutputStream)baosPayload);
                }
                HttpSession session = request.getSession(true);
                PageData pd = new PageData();
                UtilsHelper registroHelper = new UtilsHelper(request, pd, session);
                ArchiviCore archiviCore = new ArchiviCore();
                AccordiServizioParteComuneCore apcCore = new AccordiServizioParteComuneCore(archiviCore);
                SoggettiCore soggettiCore = new SoggettiCore(archiviCore);
                ServiziApplicativiCore saCore = new ServiziApplicativiCore(archiviCore);
                RuoliCore ruoliCore = new RuoliCore(archiviCore);
                ScopeCore scopeCore = new ScopeCore(archiviCore);
                ConfigurazioneCore confCore = new ConfigurazioneCore(archiviCore);
                GruppiCore gruppiCore = new GruppiCore(archiviCore);
                String identificativoOggetto = registroHelper.getParameter("idOggetto");
                String tipoOggetto = registroHelper.getParameter("tipoOggetto");
                String tipoRisposta = registroHelper.getParameter("tipoRisposta");
                InUsoType inUsoType = InUsoType.valueOf(tipoOggetto);
                ExporterUtils exporterUtils = new ExporterUtils(archiviCore);
                List<IDAccordo> identificativi = null;
                ArrayList<String> risultatiRicerca = new ArrayList<String>();
                switch (inUsoType) {
                    case ACCORDO_SERVIZIO_PARTE_COMUNE: {
                        identificativi = exporterUtils.getIdsAccordiServizioParteComune(identificativoOggetto);
                        Iterator<IDAccordo> iterator = identificativi.iterator();
                        while (iterator.hasNext()) {
                            IDAccordo object;
                            IDAccordo idAccordo = object = iterator.next();
                            risultatiRicerca.add(apcCore.getDettagliAccordoInUso(idAccordo));
                        }
                        break;
                    }
                    case RISORSA: {
                        identificativi = exporterUtils.getIdsAccordiServizioParteComuneRisorsa(identificativoOggetto);
                        for (IDAccordo object : identificativi) {
                            IDResource idRisorsa = (IDResource)object;
                            risultatiRicerca.add(apcCore.getDettagliRisorsaInUso(idRisorsa));
                        }
                        break;
                    }
                    case PORT_TYPE: {
                        identificativi = exporterUtils.getIdsAccordiServizioParteComunePortType(identificativoOggetto);
                        for (IDAccordo object : identificativi) {
                            IDPortType idPT = (IDPortType)object;
                            risultatiRicerca.add(apcCore.getDettagliPortTypeInUso(idPT));
                        }
                        break;
                    }
                    case OPERAZIONE: {
                        identificativi = exporterUtils.getIdsAccordiServizioParteComuneOperazione(identificativoOggetto);
                        for (IDAccordo object : identificativi) {
                            IDPortTypeAzione idOperazione = (IDPortTypeAzione)object;
                            risultatiRicerca.add(apcCore.getDettagliOperazioneInUso(idOperazione));
                        }
                        break;
                    }
                    case SERVIZIO_APPLICATIVO: {
                        identificativi = exporterUtils.getIdsServiziApplicativi(identificativoOggetto);
                        for (IDAccordo object : identificativi) {
                            IDServizioApplicativo idServizioApplicativo = (IDServizioApplicativo)object;
                            boolean verificaRuoli = true;
                            risultatiRicerca.add(saCore.getDettagliServizioApplicativoInUso(idServizioApplicativo, verificaRuoli));
                        }
                        break;
                    }
                    case SOGGETTO: {
                        identificativi = exporterUtils.getIdsSoggetti(identificativoOggetto);
                        for (IDAccordo object : identificativi) {
                            IDSoggetto idSoggetto = (IDSoggetto)object;
                            Soggetto soggetto = new Soggetto();
                            soggetto.setTipo(idSoggetto.getTipo());
                            soggetto.setNome(idSoggetto.getNome());
                            soggetto.setIdentificativoPorta(idSoggetto.getCodicePorta());
                            boolean verificaRuoli = true;
                            risultatiRicerca.add(soggettiCore.getDettagliSoggettoInUso(soggetto, verificaRuoli));
                        }
                        break;
                    }
                    case RUOLO: {
                        identificativi = exporterUtils.getIdsRuoli(identificativoOggetto);
                        for (IDAccordo object : identificativi) {
                            IDRuolo idRuolo = (IDRuolo)object;
                            risultatiRicerca.add(ruoliCore.getDettagliRuoloInUso(idRuolo));
                        }
                        break;
                    }
                    case SCOPE: {
                        identificativi = exporterUtils.getIdsScope(identificativoOggetto);
                        for (IDAccordo object : identificativi) {
                            IDScope idScope = (IDScope)object;
                            risultatiRicerca.add(scopeCore.getDettagliScopeInUso(idScope));
                        }
                        break;
                    }
                    case CANALE: {
                        identificativi = exporterUtils.getIdsCanali(identificativoOggetto);
                        for (IDAccordo object : identificativi) {
                            CanaleConfigurazione canale = (CanaleConfigurazione)object;
                            risultatiRicerca.add(confCore.getDettagliCanaleInUso(canale));
                        }
                        break;
                    }
                    case GRUPPO: {
                        identificativi = exporterUtils.getIdsGruppi(identificativoOggetto);
                        for (IDAccordo object : identificativi) {
                            IDGruppo idGruppo = (IDGruppo)object;
                            risultatiRicerca.add(gruppiCore.getDettagliGruppoInUso(idGruppo));
                        }
                        break;
                    }
                    case TOKEN_POLICY: {
                        IDGenericProperties idGP;
                        identificativi = exporterUtils.getIdsTokenPolicy(identificativoOggetto);
                        for (IDAccordo object : identificativi) {
                            idGP = (IDGenericProperties)object;
                            risultatiRicerca.add(confCore.getDettagliTokenPolicyInUso(idGP));
                        }
                        break;
                    }
                    case ATTRIBUTE_AUTHORITY: {
                        IDGenericProperties idGP;
                        identificativi = exporterUtils.getIdsAttributeAuthority(identificativoOggetto);
                        for (IDAccordo object : identificativi) {
                            idGP = (IDGenericProperties)object;
                            risultatiRicerca.add(confCore.getDettagliTokenPolicyInUso(idGP));
                        }
                        break;
                    }
                    case RATE_LIMITING_POLICY: {
                        identificativi = exporterUtils.getIdsControlloTrafficoConfigPolicy(identificativoOggetto);
                        for (IDAccordo object : identificativi) {
                            IdPolicy idRP = (IdPolicy)object;
                            risultatiRicerca.add(confCore.getDettagliRateLimitingPolicyInUso(idRP));
                        }
                        break;
                    }
                    case PLUGIN_CLASSE: {
                        identificativi = exporterUtils.getIdsPluginClassi(identificativoOggetto);
                        for (IDAccordo object : identificativi) {
                            IdPlugin idPlugin = (IdPlugin)object;
                            risultatiRicerca.add(confCore.getDettagliPluginClasseInUso(idPlugin));
                        }
                        break;
                    }
                    case EROGAZIONE_INFO: {
                        String uriAPSerogata = identificativoOggetto;
                        IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromUri(uriAPSerogata);
                        risultatiRicerca.add(ErogazioniDetailsUtilities.getDetailsErogazione(idServizio, soggettiCore, registroHelper));
                        break;
                    }
                    case FRUIZIONE_INFO: {
                        String uriAPSfruita = identificativoOggetto;
                        if (uriAPSfruita.contains("@")) {
                            String tipoNomeFruitore = uriAPSfruita.split("@")[1];
                            uriAPSfruita = uriAPSfruita.split("@")[0];
                            IDSoggetto idSoggettoFruitore = new IDSoggetto(tipoNomeFruitore.split("/")[0], tipoNomeFruitore.split("/")[1]);
                            IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromUri(uriAPSfruita);
                            risultatiRicerca.add(ErogazioniDetailsUtilities.getDetailsFruizione(idServizio, idSoggettoFruitore, soggettiCore, registroHelper));
                            break;
                        }
                        risultatiRicerca.add("Internal Error: informazione fruitore non presente");
                        break;
                    }
                    case ACCORDO_COOPERAZIONE: 
                    case ACCORDO_SERVIZIO_COMPOSTO: 
                    case ACCORDO_SERVIZIO_PARTE_SPECIFICA: 
                    case EROGAZIONE: 
                    case FRUITORE: 
                    case FRUIZIONE: 
                    case PDD: 
                    case PORTA_APPLICATIVA: 
                    case PORTA_DELEGATA: {
                        throw new CoreException("TipoOggetto non gestito.");
                    }
                }
                ServletOutputStream outputStream = response.getOutputStream();
                if (tipoRisposta.equalsIgnoreCase("json")) {
                    response.setContentType("application/json");
                    JSONUtils jsonUtils = JSONUtils.getInstance((boolean)true);
                    HashMap<String, ArrayList<String>> mapResult = new HashMap<String, ArrayList<String>>();
                    mapResult.put("uso", risultatiRicerca);
                    jsonUtils.writeTo(mapResult, (OutputStream)outputStream);
                    break block44;
                }
                if (tipoRisposta.equalsIgnoreCase("text")) {
                    response.setContentType("text/plain");
                    outputStream.write(StringUtils.join((Object[])risultatiRicerca.toArray(new String[1])).getBytes());
                    break block44;
                }
                throw new CoreException("TipoRiposta non gestito.");
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la ricerca delle informazioni oggetto: " + e.getMessage(), e);
            }
        }
    }
}

