/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.utenti;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.ctrlstat.servlet.utenti.UtentiCore;
import org.openspcoop2.web.ctrlstat.servlet.utenti.UtentiHelper;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.users.dao.Permessi;
import org.openspcoop2.web.lib.users.dao.User;
import org.openspcoop2.web.lib.users.dao.UserObjects;
import org.slf4j.Logger;

public final class UtentiDel
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            UtentiHelper utentiHelper = new UtentiHelper(request, pd, session);
            utentiHelper.makeMenu();
            String objToRemove = utentiHelper.getParameter("obj");
            String singleSuServizi = utentiHelper.getParameter("singleSuS");
            String singleSuAccordiCooperazione = utentiHelper.getParameter("singleSuAC");
            String actionConfirm = utentiHelper.getParameter("actionConfirm");
            UtentiCore utentiCore = new UtentiCore();
            SoggettiCore soggettiCore = new SoggettiCore(utentiCore);
            StringTokenizer objTok = new StringTokenizer(objToRemove, ",");
            int[] idToRemove = new int[objTok.countTokens()];
            ArrayList<User> utentiDaRimuovere = new ArrayList<User>();
            ArrayList<String> nomiUtentiDaRimuovere = new ArrayList<String>();
            ArrayList<String> idsUtentiDaEliminare = new ArrayList<String>();
            int k = 0;
            while (objTok.hasMoreElements()) {
                String id = objTok.nextToken();
                idToRemove[k++] = Integer.parseInt(id);
                User user = utentiCore.getUser(Long.parseLong(id));
                utentiDaRimuovere.add(user);
                nomiUtentiDaRimuovere.add(user.getLogin());
                idsUtentiDaEliminare.add(id);
            }
            String msgErroreModalita = null;
            ArrayList<String> utentiDaNonEliminare = new ArrayList<String>();
            for (User user : utentiDaRimuovere) {
                if (user.hasOnlyPermessiUtenti()) continue;
                utentiHelper.controlloModalitaUtenteDaEliminare(nomiUtentiDaRimuovere, utentiDaNonEliminare, user);
            }
            if (!utentiDaNonEliminare.isEmpty()) {
                if (utentiDaNonEliminare.size() > 1) {
                    StringBuilder sbUL = new StringBuilder();
                    for (String userL : utentiDaNonEliminare) {
                        if (sbUL.length() > 0) {
                            sbUL.append(", ");
                        }
                        sbUL.append(userL);
                    }
                    msgErroreModalita = "Gli utenti " + sbUL.toString() + " non sono stati eliminati poich&egrave; sono stati rilevati oggetti, appartenenti a dei " + Costanti.LABEL_PARAMETRO_PROTOCOLLI_DI_HTML_ESCAPE + ", non assegnabili a nessun altro utente";
                } else {
                    msgErroreModalita = "L'utente " + (String)utentiDaNonEliminare.get(0) + " non &egrave; stato eliminato poich&egrave; sono stati rilevati oggetti, appartenenti a dei " + Costanti.LABEL_PARAMETRO_PROTOCOLLI_DI_HTML_ESCAPE + ", non assegnabili a nessun altro utente";
                }
                ArrayList<String> newList = new ArrayList<String>();
                for (String uDE : nomiUtentiDaRimuovere) {
                    if (utentiDaNonEliminare.contains(uDE)) continue;
                    newList.add(uDE);
                }
                if (newList.isEmpty()) {
                    ArrayList<DataElement> arrayList = new ArrayList<DataElement>();
                    arrayList.add(ServletUtils.getDataElementForEditModeFinished());
                    pd.disableEditMode();
                    pd.setDati(arrayList);
                    pd.setMessage(msgErroreModalita);
                    ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                    return ServletUtils.getStrutsForwardGeneralError((ActionMapping)mapping, (String)"utenti", (ForwardParams)ForwardParams.DEL());
                }
                nomiUtentiDaRimuovere = newList;
            }
            List<String> usersWithU = utentiCore.getUsersWithType(Permessi.UTENTI.toString());
            List<String> list = utentiCore.getUsersWithType(Permessi.SERVIZI.toString());
            String[] uws = null;
            if (list != null && !list.isEmpty()) {
                ArrayList<String> usersWithPermessoS = new ArrayList<String>();
                for (String singleUWS : list) {
                    String user;
                    if (nomiUtentiDaRimuovere.contains(singleUWS)) continue;
                    boolean compatibile = true;
                    Iterator iterator = nomiUtentiDaRimuovere.iterator();
                    while (iterator.hasNext() && (compatibile = utentiHelper.checkUsersModalitaGatewayCompatibili(user = (String)iterator.next(), singleUWS))) {
                    }
                    if (!compatibile) continue;
                    usersWithPermessoS.add(singleUWS);
                }
                if (!usersWithPermessoS.isEmpty()) {
                    uws = new String[1];
                    uws = usersWithPermessoS.toArray(uws);
                }
            }
            List<String> usersWithP = utentiCore.getUsersWithType(Permessi.ACCORDI_COOPERAZIONE.toString());
            String[] uwp = null;
            if (usersWithP != null && !usersWithP.isEmpty()) {
                ArrayList<String> usersWithPermessoP = new ArrayList<String>();
                for (String singleUWP : usersWithP) {
                    String user;
                    if (nomiUtentiDaRimuovere.contains(singleUWP)) continue;
                    boolean compatibile = true;
                    Iterator iterator = nomiUtentiDaRimuovere.iterator();
                    while (iterator.hasNext() && (compatibile = utentiHelper.checkUsersModalitaGatewayCompatibili(user = (String)iterator.next(), singleUWP))) {
                    }
                    if (!compatibile) continue;
                    usersWithPermessoP.add(singleUWP);
                }
                if (!usersWithPermessoP.isEmpty()) {
                    uwp = new String[1];
                    uwp = usersWithPermessoP.toArray(uwp);
                }
            }
            String nomesu = "";
            Object msgServizi = "";
            boolean paginaSuServizi = false;
            if (!utentiCore.isVisioneOggettiGlobaleIndipendenteUtente()) {
                if (singleSuServizi != null) {
                    for (int i = 0; i < nomiUtentiDaRimuovere.size(); ++i) {
                        nomesu = (String)nomiUtentiDaRimuovere.get(i);
                        if (!nomesu.equals(singleSuServizi)) continue;
                        paginaSuServizi = true;
                        msgServizi = "Scegliere un utente che non &egrave; stato chiesto di eliminare<br>";
                        break;
                    }
                } else {
                    for (int i = 0; i < nomiUtentiDaRimuovere.size(); ++i) {
                        nomesu = (String)nomiUtentiDaRimuovere.get(i);
                        if (!list.contains(nomesu)) continue;
                        if (uws == null) {
                            ArrayList<DataElement> dati = new ArrayList<DataElement>();
                            dati.add(ServletUtils.getDataElementForEditModeFinished());
                            pd.disableEditMode();
                            pd.setDati(dati);
                            pd.setMessage("Non \u00e8 possibile eliminare l'utente '" + nomesu + "', poich\u00e8 non esistono altri utenti con il permesso per la gestione dei 'Servizi'");
                            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                            return ServletUtils.getStrutsForwardGeneralError((ActionMapping)mapping, (String)"utenti", (ForwardParams)ForwardParams.DEL());
                        }
                        paginaSuServizi = true;
                        if (nomiUtentiDaRimuovere.size() == 1) {
                            msgServizi = "Scegliere un utente a cui verranno assegnati tutti gli oggetti con permessi 'Servizi' appartenenti all'utente '" + (String)nomiUtentiDaRimuovere.get(0) + "'<br>";
                        } else {
                            StringBuilder bf = new StringBuilder();
                            for (int j = 0; j < nomiUtentiDaRimuovere.size(); ++j) {
                                if (j > 0) {
                                    bf.append("','");
                                }
                                bf.append((String)nomiUtentiDaRimuovere.get(j));
                            }
                            msgServizi = "Scegliere un utente a cui verranno assegnati tutti gli oggetti con permessi 'Servizi' appartenenti agli utenti '" + bf.toString() + "'<br>";
                        }
                        break;
                    }
                }
            }
            Object msgAccordi = "";
            boolean paginaSuAccordi = false;
            boolean checkOggettiAccordi = false;
            if (!utentiCore.isVisioneOggettiGlobaleIndipendenteUtente()) {
                if (singleSuAccordiCooperazione != null) {
                    for (i = 0; i < nomiUtentiDaRimuovere.size(); ++i) {
                        nomesu = (String)nomiUtentiDaRimuovere.get(i);
                        if (!nomesu.equals(singleSuAccordiCooperazione)) continue;
                        paginaSuAccordi = true;
                        msgAccordi = "Scegliere un utente che non &egrave; stato chiesto di eliminare<br>";
                        break;
                    }
                } else {
                    for (i = 0; i < nomiUtentiDaRimuovere.size(); ++i) {
                        nomesu = (String)nomiUtentiDaRimuovere.get(i);
                        if (!usersWithP.contains(nomesu)) continue;
                        if (uwp == null) {
                            checkOggettiAccordi = true;
                            continue;
                        }
                        paginaSuAccordi = true;
                        if (nomiUtentiDaRimuovere.size() == 1) {
                            msgAccordi = "Scegliere un utente a cui verranno assegnati tutti gli oggetti con permessi 'Accordi Cooperazione' appartenenti all'utente '" + (String)nomiUtentiDaRimuovere.get(0) + "'<br>";
                        } else {
                            StringBuilder bf = new StringBuilder();
                            for (int j = 0; j < nomiUtentiDaRimuovere.size(); ++j) {
                                if (j > 0) {
                                    bf.append("','");
                                }
                                bf.append((String)nomiUtentiDaRimuovere.get(j));
                            }
                            msgAccordi = "Scegliere un utente a cui verranno assegnati tutti gli oggetti con permessi 'Accordi Cooperazione' appartenenti agli utenti '" + bf.toString() + "'<br>";
                        }
                        break;
                    }
                }
            }
            ArrayList<String> utentiConRicercheDaNonEliminare = new ArrayList<String>();
            ArrayList<Long> idUtentiEliminati = new ArrayList<Long>();
            boolean paginaSu = paginaSuAccordi || paginaSuServizi;
            String msg = (String)msgServizi + (String)msgAccordi;
            if (paginaSu) {
                utentiHelper.makeMenu();
                ServletUtils.setPageDataTitle((PageData)pd, (Parameter[])new Parameter[]{new Parameter("Utenti", "utentiList.do"), new Parameter("Elimina", null)});
                ArrayList<DataElement> dati = new ArrayList<DataElement>();
                utentiHelper.addChooseUtenteForPermessiSToDati(dati, objToRemove, paginaSuServizi, uws, paginaSuAccordi, uwp);
                pd.setDati(dati);
                pd.setMessage(msg, org.openspcoop2.web.lib.mvc.Costanti.MESSAGE_TYPE_INFO);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForward((ActionMapping)mapping, (String)"utenti", (ForwardParams)ForwardParams.DEL(), (String)"Info");
            }
            boolean forceDeleteUtenteConRicerche = false;
            if (actionConfirm != null) {
                if (actionConfirm.equals("ok")) {
                    forceDeleteUtenteConRicerche = true;
                }
                pd.setIdsDaVisualizzareSelezionati(idsUtentiDaEliminare);
            }
            for (int i = 0; i < nomiUtentiDaRimuovere.size(); ++i) {
                UserObjects results;
                nomesu = (String)nomiUtentiDaRimuovere.get(i);
                if (nomesu.equals(userLogin)) {
                    msg = msg + "Non \u00e8 possibile rimuovere l'utente (" + nomesu + ") con cui si \u00e8 collegati all'interfaccia<br>";
                    continue;
                }
                if (usersWithU.size() == 1 && usersWithU.get(0).equals(nomesu)) {
                    msg = msg + nomesu + " non rimosso perch&egrave; deve esistere almeno un utente con permesso 'Utenti'<br><br>";
                    continue;
                }
                User mySU = utentiCore.getUser(nomesu);
                ArrayList<User> oggetti = new ArrayList<User>();
                ArrayList<Integer> tipoModifica = new ArrayList<Integer>();
                if (soggettiCore.isRegistroServiziLocale() && singleSuServizi != null && !singleSuServizi.equals("")) {
                    results = utentiCore.updateUserServizi(nomesu, singleSuServizi);
                    ControlStationCore.logInfo("Modificata utenza [" + nomesu + "]->[" + singleSuServizi + "] per permesso relativo ai servizi (L'utenza '" + nomesu + "' verr\u00e0 eliminata). Risultati modifica: " + results.toString(false));
                }
                if (soggettiCore.isRegistroServiziLocale() && (singleSuAccordiCooperazione != null && !singleSuAccordiCooperazione.equals("") || checkOggettiAccordi)) {
                    if (checkOggettiAccordi) {
                        results = utentiCore.countUserCooperazione(nomesu);
                        if (results.accordi_accoperazione > 0 || results.accordi_parte_comune > 0) {
                            ArrayList<DataElement> dati = new ArrayList<DataElement>();
                            dati.add(ServletUtils.getDataElementForEditModeFinished());
                            pd.disableEditMode();
                            pd.setDati(dati);
                            pd.setMessage("Non \u00e8 possibile eliminare il permesso 'Accordi Cooperazione', poich\u00e8 non esistono altri utenti con tale permesso");
                            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                            return ServletUtils.getStrutsForwardGeneralError((ActionMapping)mapping, (String)"utenti", (ForwardParams)ForwardParams.CHANGE());
                        }
                    }
                    results = utentiCore.updateUserCooperazione(nomesu, singleSuAccordiCooperazione);
                    ControlStationCore.logInfo("Modificata utenza [" + nomesu + "]->[" + singleSuAccordiCooperazione + "] per permesso relativo agli accordi di cooperazione (L'utenza '" + nomesu + "' verr\u00e0 eliminata). Risultati modifica: " + results.toString(true));
                }
                if (utentiHelper.hasRicerchePubbliche(mySU) && !forceDeleteUtenteConRicerche) {
                    utentiConRicercheDaNonEliminare.add(nomesu);
                    continue;
                }
                idUtentiEliminati.add(mySU.getId());
                oggetti.add(mySU);
                tipoModifica.add(2);
                int[] operationTypes = new int[tipoModifica.size()];
                for (int cO = 0; cO < tipoModifica.size(); ++cO) {
                    operationTypes[cO] = (Integer)tipoModifica.get(cO);
                }
                utentiCore.performOperationMultiTypes(userLogin, utentiHelper.smista(), operationTypes, oggetti.toArray());
                if (!usersWithU.contains(nomesu)) continue;
                usersWithU.remove(nomesu);
            }
            if (!utentiConRicercheDaNonEliminare.isEmpty() && actionConfirm == null) {
                utentiHelper.makeMenu();
                ArrayList<Long> idUtentiNonEliminati = new ArrayList<Long>();
                objTok = new StringTokenizer(objToRemove, ",");
                while (objTok.hasMoreElements()) {
                    String id = objTok.nextToken();
                    long l = Long.parseLong(id);
                    if (idUtentiEliminati.contains(l)) continue;
                    idUtentiNonEliminati.add(l);
                }
                String objToRemoveRimasti = StringUtils.join(idUtentiNonEliminati, (String)",");
                Parameter pObjToRemoveRimasti = new Parameter("obj", objToRemoveRimasti);
                request.setAttribute("params", (Object)pObjToRemoveRimasti.toString());
                pd.setIdsDaVisualizzareSelezionati(idsUtentiDaEliminare);
                String msgPre = "Attenzione: <br><br>";
                String msgErroreRicerche = "";
                msgErroreRicerche = utentiConRicercheDaNonEliminare.size() == 1 ? MessageFormat.format("La rimozione dell''utente {0} comporter&agrave; l''eliminazione delle sue ricerche pubbliche. <br><br>", utentiConRicercheDaNonEliminare.get(0)) : MessageFormat.format("La rimozione dell''utente {0} comporter&agrave; l''eliminazione delle loro ricerche pubbliche. <br><br>", StringUtils.join(utentiConRicercheDaNonEliminare, (String)", "));
                String msgPost = "Confermi l'eliminazione?";
                String pre = "<p class=\"contenutoModal\"><span>";
                String post = "</span></p>";
                pd.setMessage(pre + msgPre + msgErroreRicerche + msgPost + post, org.openspcoop2.web.lib.mvc.Costanti.MESSAGE_TYPE_CONFIRM);
                String[][] bottoni = new String[][]{{"Annulla", "AnnullaConferma()"}, {"Conferma", "EseguiConferma()"}};
                pd.setBottoni(bottoni);
                ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
                int idLista = Liste.SU;
                ricerca = utentiHelper.checkSearchParameters(idLista, ricerca);
                List<User> lista = utentiCore.userList((ISearch)ricerca);
                utentiHelper.prepareUtentiList((ISearch)ricerca, lista, utentiCore.isSinglePdD());
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForward((ActionMapping)mapping, (String)"utenti", (ForwardParams)ForwardParams.DEL());
            }
            if (msgErroreModalita != null) {
                if (!msg.equals("")) {
                    msg = msg + "<br>";
                    msg = msg + msgErroreModalita;
                } else {
                    msg = msgErroreModalita;
                }
            }
            if (!msg.equals("")) {
                pd.setMessage(msg);
            }
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.SU;
            ricerca = utentiHelper.checkSearchParameters(idLista, ricerca);
            List<User> lista = utentiCore.userList((ISearch)ricerca);
            utentiHelper.prepareUtentiList((ISearch)ricerca, lista, utentiCore.isSinglePdD());
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForward((ActionMapping)mapping, (String)"utenti", (ForwardParams)ForwardParams.DEL());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"utenti", (ForwardParams)ForwardParams.DEL());
        }
    }
}

