/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.utenti;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.utils.crypt.PasswordVerifier;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.OggettoDialogEnum;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoriCostanti;
import org.openspcoop2.web.ctrlstat.servlet.utenti.UtentiCore;
import org.openspcoop2.web.ctrlstat.servlet.utenti.UtentiHelper;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.MessageType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.openspcoop2.web.lib.users.dao.InterfaceType;
import org.openspcoop2.web.lib.users.dao.Permessi;
import org.openspcoop2.web.lib.users.dao.PermessiUtente;
import org.openspcoop2.web.lib.users.dao.Stato;
import org.openspcoop2.web.lib.users.dao.User;
import org.slf4j.Logger;

public final class UtentiAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            PasswordVerifier passwordVerifier;
            UtentiHelper utentiHelper = new UtentiHelper(request, pd, session);
            utentiHelper.makeMenu();
            UtentiCore utentiCore = new UtentiCore();
            boolean loginApplication = utentiCore.isLoginApplication();
            String nomesu = utentiHelper.getParameter("nomesu");
            String pwsu = utentiHelper.getParameter("pwsu");
            String tipoGui = utentiHelper.getParameter("tipo_gui");
            String tipoModalitaConsoleGestione = utentiHelper.getParameter("tipo_mod");
            String idSoggettoConsoleGestione = utentiHelper.getParameter("id_sog");
            String tipoModalitaConsoleMonitoraggio = utentiHelper.getParameter("tipo_mod_mon");
            String idSoggettoConsoleMonitoraggio = utentiHelper.getParameter("id_sog_mon");
            String homePageMonitoraggio = utentiHelper.getParameter("hp_mon");
            String intervalloTemporaleHomePageConsoleMonitoraggio = utentiHelper.getParameter("int_temp_mon");
            InterfaceType interfaceType = null;
            interfaceType = tipoGui == null ? InterfaceType.STANDARD : InterfaceType.convert((String)tipoGui, (boolean)true);
            if (tipoModalitaConsoleGestione == null) {
                tipoModalitaConsoleGestione = "all";
            }
            if (idSoggettoConsoleGestione == null) {
                idSoggettoConsoleGestione = "all";
            }
            if (tipoModalitaConsoleMonitoraggio == null) {
                tipoModalitaConsoleMonitoraggio = "all";
            }
            if (idSoggettoConsoleMonitoraggio == null) {
                idSoggettoConsoleMonitoraggio = "all";
            }
            if (homePageMonitoraggio == null) {
                homePageMonitoraggio = "transazioni";
            }
            if (intervalloTemporaleHomePageConsoleMonitoraggio == null) {
                intervalloTemporaleHomePageConsoleMonitoraggio = "Ultimi 7 giorni";
            }
            String isServizi = utentiHelper.getParameter("isServizi");
            String isDiagnostica = utentiHelper.getParameter("isDiagnostica");
            String isReportistica = utentiHelper.getParameter("isReportistica");
            String isSistema = utentiHelper.getParameter("isSistema");
            String isMessaggi = utentiHelper.getParameter("isMessaggi");
            String isUtenti = utentiHelper.getParameter("isUtenti");
            String isAuditing = utentiHelper.getParameter("isAuditing");
            String isAccordiCooperazione = utentiHelper.getParameter("isAccordiCooperazione");
            String isSoggettiAll = utentiHelper.getParameter("isSoggettiAll");
            String isServiziAll = utentiHelper.getParameter("isServiziAll");
            String scadenza = utentiHelper.getParameter("scadenza");
            Boolean singlePdD = ServletUtils.getBooleanAttributeFromSession((String)"singlePdD", (HttpSession)session, (HttpServletRequest)request).getValue();
            List<String> protocolliRegistratiConsole = utentiCore.getProtocolli();
            String[] modalitaScelte = new String[protocolliRegistratiConsole.size()];
            for (int i = 0; i < protocolliRegistratiConsole.size(); ++i) {
                String protocolloName = protocolliRegistratiConsole.get(i);
                modalitaScelte[i] = utentiHelper.getParameter("mod_" + protocolloName);
            }
            String postBackElementName = utentiHelper.getPostBackElementName();
            if (postBackElementName != null) {
                if (postBackElementName.startsWith("mod_")) {
                    tipoModalitaConsoleGestione = "all";
                    idSoggettoConsoleGestione = "all";
                    tipoModalitaConsoleMonitoraggio = "all";
                    idSoggettoConsoleMonitoraggio = "all";
                }
                if (postBackElementName.equals("tipo_mod")) {
                    idSoggettoConsoleGestione = "all";
                }
                if (postBackElementName.equals("tipo_mod_mon")) {
                    idSoggettoConsoleMonitoraggio = "all";
                }
                if (postBackElementName.equals("hp_mon")) {
                    intervalloTemporaleHomePageConsoleMonitoraggio = "Ultimi 7 giorni";
                }
            }
            if (utentiHelper.isEditModeInProgress()) {
                ServletUtils.setPageDataTitle((PageData)pd, (Parameter[])new Parameter[]{new Parameter("Utenti", "utentiList.do"), ServletUtils.getParameterAggiungi()});
                ArrayList<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                if (nomesu == null) {
                    nomesu = "";
                }
                if (pwsu == null) {
                    pwsu = "";
                }
                utentiHelper.addUtentiToDati(dati, TipoOperazione.ADD, singlePdD, nomesu, pwsu, interfaceType, isServizi, isDiagnostica, isReportistica, isSistema, isMessaggi, isUtenti, isAuditing, isAccordiCooperazione, null, modalitaScelte, isSoggettiAll, isServiziAll, null, scadenza, null, false, tipoModalitaConsoleGestione, idSoggettoConsoleGestione, tipoModalitaConsoleMonitoraggio, idSoggettoConsoleMonitoraggio, homePageMonitoraggio, intervalloTemporaleHomePageConsoleMonitoraggio);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"utenti", (ForwardParams)ForwardParams.ADD());
            }
            boolean isOk = utentiHelper.utentiCheckData(TipoOperazione.ADD, singlePdD, null, false);
            if (!isOk) {
                ServletUtils.setPageDataTitle((PageData)pd, (Parameter[])new Parameter[]{new Parameter("Utenti", "utentiList.do"), ServletUtils.getParameterAggiungi()});
                ArrayList<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                utentiHelper.addUtentiToDati(dati, TipoOperazione.ADD, singlePdD, nomesu, pwsu, interfaceType, isServizi, isDiagnostica, isReportistica, isSistema, isMessaggi, isUtenti, isAuditing, isAccordiCooperazione, null, modalitaScelte, isSoggettiAll, isServiziAll, null, scadenza, null, false, tipoModalitaConsoleGestione, idSoggettoConsoleGestione, tipoModalitaConsoleMonitoraggio, idSoggettoConsoleMonitoraggio, homePageMonitoraggio, intervalloTemporaleHomePageConsoleMonitoraggio);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"utenti", (ForwardParams)ForwardParams.ADD());
            }
            boolean secret = false;
            String secretPassword = pwsu;
            String secretUser = nomesu;
            boolean secretAppId = false;
            boolean noLoginApplication = "".equals(pwsu);
            if (utentiCore.isUtenzePasswordEncryptEnabled()) {
                secret = true;
                pwsu = utentiCore.getUtenzePasswordManager().crypt(pwsu);
            }
            User newU = new User();
            newU.setLogin(nomesu);
            newU.setPassword(pwsu);
            newU.setInterfaceType(interfaceType);
            newU.setProtocolloSelezionatoPddConsole(!tipoModalitaConsoleGestione.equals("all") ? tipoModalitaConsoleGestione : null);
            newU.setSoggettoSelezionatoPddConsole(!idSoggettoConsoleGestione.equals("all") ? idSoggettoConsoleGestione : null);
            newU.setProtocolloSelezionatoPddMonitor(!tipoModalitaConsoleMonitoraggio.equals("all") ? tipoModalitaConsoleMonitoraggio : null);
            newU.setSoggettoSelezionatoPddMonitor(!idSoggettoConsoleMonitoraggio.equals("all") ? idSoggettoConsoleMonitoraggio : null);
            Object puString = "";
            if (ServletUtils.isCheckBoxEnabled((String)isServizi)) {
                puString = Permessi.SERVIZI.toString();
            }
            if (ServletUtils.isCheckBoxEnabled((String)isDiagnostica)) {
                puString = ((String)puString).equals("") ? Permessi.DIAGNOSTICA.toString() : (String)puString + "," + Permessi.DIAGNOSTICA.toString();
            }
            if (ServletUtils.isCheckBoxEnabled((String)isReportistica)) {
                puString = ((String)puString).equals("") ? Permessi.REPORTISTICA.toString() : (String)puString + "," + Permessi.REPORTISTICA.toString();
            }
            if (ServletUtils.isCheckBoxEnabled((String)isSistema)) {
                puString = ((String)puString).equals("") ? Permessi.SISTEMA.toString() : (String)puString + "," + Permessi.SISTEMA.toString();
            }
            if (ServletUtils.isCheckBoxEnabled((String)isMessaggi)) {
                puString = ((String)puString).equals("") ? Permessi.CODE_MESSAGGI.toString() : (String)puString + "," + Permessi.CODE_MESSAGGI.toString();
            }
            if (ServletUtils.isCheckBoxEnabled((String)isUtenti)) {
                puString = ((String)puString).equals("") ? Permessi.UTENTI.toString() : (String)puString + "," + Permessi.UTENTI.toString();
            }
            if (ServletUtils.isCheckBoxEnabled((String)isAuditing)) {
                puString = ((String)puString).equals("") ? Permessi.AUDITING.toString() : (String)puString + "," + Permessi.AUDITING.toString();
            }
            if (ServletUtils.isCheckBoxEnabled((String)isAccordiCooperazione)) {
                puString = ((String)puString).equals("") ? Permessi.ACCORDI_COOPERAZIONE.toString() : (String)puString + "," + Permessi.ACCORDI_COOPERAZIONE.toString();
            }
            newU.setPermessi(PermessiUtente.toPermessiUtente((String)puString));
            newU.clearProtocolliSupportati();
            for (int i = 0; i < protocolliRegistratiConsole.size(); ++i) {
                String protocolloName = protocolliRegistratiConsole.get(i);
                if (!ServletUtils.isCheckBoxEnabled((String)modalitaScelte[i])) continue;
                newU.addProtocolloSupportato(protocolloName);
            }
            if (ServletUtils.isCheckBoxEnabled((String)isDiagnostica) || ServletUtils.isCheckBoxEnabled((String)isReportistica)) {
                if (utentiCore.isMultitenant()) {
                    newU.setPermitAllSoggetti(ServletUtils.isCheckBoxEnabled((String)isSoggettiAll));
                } else {
                    newU.setPermitAllSoggetti(true);
                }
                newU.setPermitAllServizi(ServletUtils.isCheckBoxEnabled((String)isServiziAll));
                Stato statoHomePage = new Stato();
                statoHomePage.setOggetto("HOME_PAGE");
                statoHomePage.setStato(utentiHelper.incapsulaValoreStato(homePageMonitoraggio));
                newU.getStati().add(statoHomePage);
                Stato statoIntevalloTemporaleHomePage = new Stato();
                statoIntevalloTemporaleHomePage.setOggetto("WELCOME_SCREEN");
                statoIntevalloTemporaleHomePage.setStato(utentiHelper.incapsulaValoreStato(intervalloTemporaleHomePageConsoleMonitoraggio));
                newU.getStati().add(statoIntevalloTemporaleHomePage);
            }
            if (utentiCore.isCheckPasswordExpire(passwordVerifier = utentiCore.getUtenzePasswordVerifier())) {
                newU.setCheckLastUpdatePassword(ServletUtils.isCheckBoxEnabled((String)scadenza));
            } else {
                newU.setCheckLastUpdatePassword(false);
            }
            newU.setLastUpdatePassword(new Date());
            utentiCore.performCreateOperation(userLogin, utentiHelper.smista(), newU);
            if (loginApplication && secret && !noLoginApplication) {
                utentiHelper.setSecretPleaseCopy(secretPassword, secretUser, secretAppId, ConnettoriCostanti.AUTENTICAZIONE_TIPO_BASIC, OggettoDialogEnum.UTENTE, nomesu);
            }
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.SU;
            ricerca = utentiHelper.checkSearchParameters(idLista, ricerca);
            List<User> lista = utentiCore.userList((ISearch)ricerca);
            utentiHelper.prepareUtentiList((ISearch)ricerca, lista, singlePdD);
            if (!newU.isConfigurazioneValidaSoggettiAbilitati()) {
                pd.setMessage("Attenzione: procedere con la registrazione dei soggetti visibili tramite govwayMonitor per l'utente appena creato", MessageType.INFO);
            } else if (!newU.isConfigurazioneValidaServiziAbilitati()) {
                pd.setMessage("Attenzione: procedere con la registrazione delle API visibili tramite govwayMonitor per l'utente appena creato", MessageType.INFO);
            }
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"utenti", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"utenti", (ForwardParams)ForwardParams.ADD());
        }
    }
}

