/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.sa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.config.InvocazioneServizio;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddCore;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiCore;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiGeneralInfo;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiHelper;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiUpdateUtilities;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCostanti;

public class ServiziApplicativiUtilities {
    public static List<Object> getOggettiDaAggiornare(ServiziApplicativiCore saCore, IDServizioApplicativo oldIdServizioApplicativo, ServizioApplicativo sa) throws Exception {
        ServiziApplicativiUpdateUtilities saUpdateUtilities = new ServiziApplicativiUpdateUtilities(saCore, oldIdServizioApplicativo, sa);
        saUpdateUtilities.addServizioApplicativo();
        saUpdateUtilities.checkRateLimiting();
        return saUpdateUtilities.getOggettiDaAggiornare();
    }

    public static boolean deleteServizioApplicativo(ServizioApplicativo sa, String userLogin, ServiziApplicativiCore saCore, ServiziApplicativiHelper saHelper, StringBuilder inUsoMessage, String newLine) throws Exception {
        IDServizioApplicativo idServizioApplicativo = new IDServizioApplicativo();
        idServizioApplicativo.setNome(sa.getNome());
        idServizioApplicativo.setIdSoggettoProprietario(new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
        HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
        boolean normalizeObjectIds = !saHelper.isModalitaCompleta();
        boolean verificaRuoli = false;
        boolean saInUso = saCore.isServizioApplicativoInUso(idServizioApplicativo, whereIsInUso, saCore.isRegistroServiziLocale(), normalizeObjectIds, verificaRuoli);
        if (!saInUso) {
            saCore.performDeleteOperation(userLogin, saHelper.smista(), sa);
            return true;
        }
        inUsoMessage.append(DBOggettiInUsoUtils.toString((IDServizioApplicativo)idServizioApplicativo, whereIsInUso, (boolean)true, (String)newLine, (boolean)normalizeObjectIds));
        inUsoMessage.append(newLine);
        return false;
    }

    public static ServiziApplicativiGeneralInfo getGeneralInfo(boolean useIdSogg, String provider, List<String> listaTipiProtocollo, ServiziApplicativiCore saCore, ServiziApplicativiHelper saHelper, String superUser, boolean singlePdD, String soggettoMultitenantSelezionato, String dominio) throws Exception {
        SoggettiCore soggettiCore = new SoggettiCore(saCore);
        PddCore pddCore = new PddCore(saCore);
        String[] soggettiList = null;
        String[] soggettiListLabel = null;
        String tipoProtocollo = null;
        String tipoENomeSoggetto = "";
        IDSoggetto idSoggetto = null;
        if (useIdSogg) {
            org.openspcoop2.core.config.Soggetto soggetto = soggettiCore.getSoggetto(Long.parseLong((String)provider));
            if (tipoProtocollo == null) {
                tipoProtocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(soggetto.getTipo());
            }
            tipoENomeSoggetto = saHelper.getLabelNomeSoggetto(tipoProtocollo, soggetto.getTipo(), soggetto.getNome());
            idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
            soggettiList = new String[]{soggetto.getId().toString()};
            soggettiListLabel = new String[]{saHelper.getLabelNomeSoggetto(tipoProtocollo, soggetto.getTipo(), soggetto.getNome())};
        } else {
            long idProvider = -1L;
            try {
                if (provider != null) {
                    idProvider = Long.parseLong((String)provider);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            tipoProtocollo = saHelper.getParameter("protocollo");
            if (tipoProtocollo == null) {
                tipoProtocollo = saCore.getProtocolloDefault(saHelper.getRequest(), saHelper.getSession(), listaTipiProtocollo);
            }
            boolean filtraSoggettiEsterni = false;
            boolean isSupportatoAutenticazioneApplicativiEsterni = saCore.isSupportatoAutenticazioneApplicativiEsterniErogazione(tipoProtocollo);
            if (isSupportatoAutenticazioneApplicativiEsterni) {
                filtraSoggettiEsterni = SoggettiCostanti.SOGGETTO_DOMINIO_ESTERNO_VALUE.equals(dominio);
            }
            List<String> tipiSoggettiCompatibiliGestitiProtocollo = soggettiCore.getTipiSoggettiGestitiProtocollo(tipoProtocollo);
            long providerTmp = -1L;
            ConsoleSearch searchSoggetti = new ConsoleSearch(true);
            saHelper.setFilterSelectedProtocol((ISearch)searchSoggetti, Liste.SOGGETTI);
            if (saCore.isRegistroServiziLocale()) {
                List<Soggetto> list = null;
                if (!filtraSoggettiEsterni && soggettoMultitenantSelezionato != null && !"".equals(soggettoMultitenantSelezionato)) {
                    IDSoggetto idSoggettoSelezionato = soggettiCore.convertSoggettoSelezionatoToID(soggettoMultitenantSelezionato);
                    list = new ArrayList<Soggetto>();
                    try {
                        list.add(soggettiCore.getSoggettoRegistro(idSoggettoSelezionato));
                    }
                    catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {}
                } else {
                    list = saCore.isVisioneOggettiGlobale(superUser) ? soggettiCore.soggettiRegistroList(null, (ISearch)searchSoggetti) : soggettiCore.soggettiRegistroList(superUser, (ISearch)searchSoggetti);
                }
                if (singlePdD) {
                    ArrayList<Soggetto> listFiltrata = new ArrayList<Soggetto>();
                    for (Soggetto soggetto : list) {
                        boolean pddEsterna = pddCore.isPddEsterna(soggetto.getPortaDominio());
                        if (filtraSoggettiEsterni) {
                            if (!pddEsterna) continue;
                            listFiltrata.add(soggetto);
                            if (soggetto.getId() != idProvider) continue;
                            providerTmp = idProvider;
                            continue;
                        }
                        if (pddEsterna) continue;
                        listFiltrata.add(soggetto);
                        if (soggetto.getId() != idProvider) continue;
                        providerTmp = idProvider;
                    }
                    list = listFiltrata;
                }
                if (list.size() > 0) {
                    ArrayList<Soggetto> listFiltrataCompatibileProtocollo = new ArrayList<Soggetto>();
                    for (Soggetto soggetto : list) {
                        if (!tipiSoggettiCompatibiliGestitiProtocollo.contains(soggetto.getTipo())) continue;
                        listFiltrataCompatibileProtocollo.add(soggetto);
                        if (providerTmp >= 0L && providerTmp != soggetto.getId()) continue;
                        providerTmp = soggetto.getId();
                        idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
                    }
                    if (listFiltrataCompatibileProtocollo.size() > 0) {
                        soggettiList = new String[listFiltrataCompatibileProtocollo.size()];
                        soggettiListLabel = new String[listFiltrataCompatibileProtocollo.size()];
                        int i = 0;
                        for (Soggetto soggetto : listFiltrataCompatibileProtocollo) {
                            soggettiList[i] = soggetto.getId().toString();
                            soggettiListLabel[i] = saHelper.getLabelNomeSoggetto(tipoProtocollo, soggetto.getTipo(), soggetto.getNome());
                            ++i;
                        }
                    }
                }
            } else {
                List<org.openspcoop2.core.config.Soggetto> list = null;
                if (soggettoMultitenantSelezionato != null && !"".equals(soggettoMultitenantSelezionato)) {
                    IDSoggetto idSoggettoSelezionato = soggettiCore.convertSoggettoSelezionatoToID(soggettoMultitenantSelezionato);
                    list = new ArrayList<org.openspcoop2.core.config.Soggetto>();
                    try {
                        list.add(soggettiCore.getSoggetto(idSoggettoSelezionato));
                    }
                    catch (DriverConfigurazioneNotFound i) {}
                } else {
                    list = saCore.isVisioneOggettiGlobale(superUser) ? soggettiCore.soggettiList(null, (ISearch)searchSoggetti) : soggettiCore.soggettiList(superUser, (ISearch)searchSoggetti);
                }
                ArrayList<org.openspcoop2.core.config.Soggetto> listFiltrataCompatibileProtocollo = new ArrayList<org.openspcoop2.core.config.Soggetto>();
                for (org.openspcoop2.core.config.Soggetto soggetto : list) {
                    if (!tipiSoggettiCompatibiliGestitiProtocollo.contains(soggetto.getTipo())) continue;
                    listFiltrataCompatibileProtocollo.add(soggetto);
                    if (providerTmp >= 0L) continue;
                    providerTmp = soggetto.getId();
                    idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
                }
                if (listFiltrataCompatibileProtocollo.size() > 0) {
                    soggettiList = new String[listFiltrataCompatibileProtocollo.size()];
                    soggettiListLabel = new String[listFiltrataCompatibileProtocollo.size()];
                    int i = 0;
                    for (org.openspcoop2.core.config.Soggetto soggetto : listFiltrataCompatibileProtocollo) {
                        soggettiList[i] = soggetto.getId().toString();
                        soggettiListLabel[i] = saHelper.getLabelNomeSoggetto(tipoProtocollo, soggetto.getTipo(), soggetto.getNome());
                        ++i;
                    }
                }
            }
            if (provider == null) {
                provider = "" + providerTmp;
            }
        }
        ServiziApplicativiGeneralInfo saGeneralInfo = new ServiziApplicativiGeneralInfo();
        saGeneralInfo.setSoggettiList(soggettiList);
        saGeneralInfo.setSoggettiListLabel(soggettiListLabel);
        saGeneralInfo.setTipoENomeSoggetto(tipoENomeSoggetto);
        saGeneralInfo.setTipoProtocollo(tipoProtocollo);
        saGeneralInfo.setProvider((String)provider);
        saGeneralInfo.setIdSoggetto(idSoggetto);
        return saGeneralInfo;
    }

    public static void checkStatoConnettore(ServiziApplicativiCore saCore, ServizioApplicativo sa, Connettore connis, StringBuilder inUsoMessage, String newLine) throws DriverConfigurazioneException {
        HashMap<ErrorsHandlerCostant, String> whereIsInUso;
        StatoFunzionalita getMessage;
        InvocazioneServizio invServizio = sa.getInvocazioneServizio();
        StatoFunzionalita statoFunzionalita = getMessage = invServizio != null ? invServizio.getGetMessage() : null;
        if (TipiConnettore.DISABILITATO.getNome().equals(connis.getTipo()) && CostantiConfigurazione.DISABILITATO.equals((Object)getMessage) && saCore.isServizioApplicativoInUsoComeErogatore(sa, whereIsInUso = new HashMap<ErrorsHandlerCostant, String>()) && whereIsInUso.containsKey(ErrorsHandlerCostant.IN_USO_IN_PORTE_APPLICATIVE)) {
            inUsoMessage.append("Impossibile disabilitare il GetMessage o il Connettore in quanto il Servizio Applicativo [" + sa.getNome() + "]" + newLine + " \u00e8 in uso in Porta Applicative " + (String)whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_PORTE_APPLICATIVE));
            return;
        }
    }
}

