/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.sa;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.Utilities;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiCore;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiHelper;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiUtilities;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;

public final class ServiziApplicativiDel
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            ServiziApplicativiHelper saHelper = new ServiziApplicativiHelper(request, pd, session);
            saHelper.makeMenu();
            Integer parentSA = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)session, (HttpServletRequest)request);
            if (parentSA == null) {
                parentSA = 0;
            }
            Boolean useIdSogg = parentSA == 1;
            String provider = saHelper.getParametroLong("provider");
            long soggLong = -1L;
            if (useIdSogg.booleanValue() && provider != null && !provider.equals("")) {
                soggLong = Long.parseLong(provider);
            }
            String objToRemove = saHelper.getParameter("obj");
            ArrayList<String> idsToRemove = Utilities.parseIdsToRemove(objToRemove);
            ServiziApplicativiCore saCore = new ServiziApplicativiCore();
            String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
            StringBuilder inUsoMessage = new StringBuilder();
            boolean deleteAlmostOneApplicativo = false;
            for (int i = 0; i < idsToRemove.size(); ++i) {
                ServizioApplicativo sa = saCore.getServizioApplicativo(Long.parseLong(idsToRemove.get(i)));
                boolean deleted = ServiziApplicativiUtilities.deleteServizioApplicativo(sa, userLogin, saCore, saHelper, inUsoMessage, "<br/>");
                if (!deleted) continue;
                deleteAlmostOneApplicativo = true;
            }
            int idLista = -1;
            idLista = useIdSogg == false ? Liste.SERVIZIO_APPLICATIVO : Liste.SERVIZI_APPLICATIVI_BY_SOGGETTO;
            if (deleteAlmostOneApplicativo) {
                ServletUtils.removeRisultatiRicercaFromSession((HttpServletRequest)request, (HttpSession)session, (int)idLista);
            }
            if (inUsoMessage.length() > 0) {
                pd.setMessage(inUsoMessage.toString());
            }
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            List<ServizioApplicativo> lista = null;
            if (!useIdSogg.booleanValue()) {
                List<String> protocolli;
                ricerca = saHelper.checkSearchParameters(idLista, ricerca);
                boolean filtroSoggetto = false;
                if (saHelper.isSoggettoMultitenantSelezionato() && (protocolli = saCore.getProtocolli(request, session, false)) != null && protocolli.size() == 1) {
                    String protocollo = protocolli.get(0);
                    boolean bl = filtroSoggetto = !saCore.isSupportatoAutenticazioneApplicativiEsterniErogazione(protocollo);
                }
                if (filtroSoggetto) {
                    ricerca.addFilter(idLista, "filtroSoggetto", saHelper.getSoggettoMultitenantSelezionato());
                }
                lista = saCore.isVisioneOggettiGlobale(userLogin) ? saCore.soggettiServizioApplicativoList(null, (ISearch)ricerca) : saCore.soggettiServizioApplicativoList(userLogin, (ISearch)ricerca);
            } else {
                ricerca = saHelper.checkSearchParameters(idLista, ricerca);
                lista = saCore.soggettiServizioApplicativoList((ISearch)ricerca, soggLong);
            }
            saHelper.prepareServizioApplicativoList((ISearch)ricerca, lista, useIdSogg);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForward((ActionMapping)mapping, (String)"serviziApplicativi", (ForwardParams)ForwardParams.DEL());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"serviziApplicativi", (ForwardParams)ForwardParams.DEL());
        }
    }
}

