/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.sa;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.Utilities;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiCore;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiHelper;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiUtilities;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;

public final class ServiziApplicativiCredenzialiDel
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            ServiziApplicativiHelper saHelper = new ServiziApplicativiHelper(request, pd, session);
            saHelper.makeMenu();
            Integer parentSA = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)session, (HttpServletRequest)request);
            if (parentSA == null) {
                parentSA = 0;
            }
            String id = saHelper.getParametroLong("id");
            int idServizioApplicativo = Integer.parseInt(id);
            String objToRemove = saHelper.getParameter("obj");
            ArrayList<String> idsToRemove = Utilities.parseIdsToRemove(objToRemove);
            ServiziApplicativiCore saCore = new ServiziApplicativiCore();
            ServizioApplicativo sa = saCore.getServizioApplicativo(idServizioApplicativo);
            String oldNome = sa.getNome();
            IDSoggetto oldIdSoggetto = new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario());
            IDServizioApplicativo oldIdServizioApplicativo = new IDServizioApplicativo();
            oldIdServizioApplicativo.setIdSoggettoProprietario(oldIdSoggetto);
            oldIdServizioApplicativo.setNome(oldNome);
            String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
            boolean isPrincipale = false;
            for (int i = idsToRemove.size() - 1; i >= 0; --i) {
                int idEliminare = Integer.parseInt(idsToRemove.get(i));
                if (idEliminare != 0) {
                    sa.getInvocazionePorta().removeCredenziali(Integer.parseInt(idsToRemove.get(i)));
                    continue;
                }
                isPrincipale = true;
            }
            List<Object> listOggettiDaAggiornare = ServiziApplicativiUtilities.getOggettiDaAggiornare(saCore, oldIdServizioApplicativo, sa);
            saCore.performUpdateOperation(userLogin, saHelper.smista(), listOggettiDaAggiornare.toArray());
            sa = saCore.getServizioApplicativo(idServizioApplicativo);
            saHelper.prepareServizioApplicativoCredenzialiList(sa, id);
            if (isPrincipale) {
                pd.setMessage("Certificato Principale non eliminabile");
            }
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForward((ActionMapping)mapping, (String)"serviziApplicativiCredenziali", (ForwardParams)ForwardParams.DEL());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"serviziApplicativiCredenziali", (ForwardParams)ForwardParams.DEL());
        }
    }
}

